////////////////////////////////////////////////////////////////////////////////
/// @brief High-Performance Database Framework made by triagens
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Frank Celler
/// @author Copyright 2008-2010, triAGENS GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#include "Hpdf/Table.h"

#include <Hpdf/TableVisitor.h>

using namespace triagens::hpdf;

// -----------------------------------------------------------------------------
// helper functions
// -----------------------------------------------------------------------------

namespace {
  class AnyVisitor : public TableVisitor {
    public:
      AnyVisitor (Row const** ptr) : ptr(ptr) {
      }

    public:
      void visit (Row const* row, size_t) {
        *ptr = row;
      }

    private:
      Row const** ptr;
  };
}

namespace triagens {
  namespace hpdf {

    // -----------------------------------------------------------------------------
    // public methods
    // -----------------------------------------------------------------------------

    Row const* Table::any() const {
      hpdf::Row const* row = 0;
      AnyVisitor visitor(&row);
      forany(&visitor);

      return row;
    }

    bool Table::addRecovery(const char* data, const size_t dataLength) {
      cout << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << endl;
      throw "internal error";
    }

    bool Table::modRecovery(const char* data, const size_t dataLength) {
      cout << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << endl;
      throw "internal error";
    }

    bool Table::remRecovery(const char* data, const size_t dataLength) {
      cout << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << endl;
      throw "internal error";
    }

    size_t Table::getRowSize() const {
      cout << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << endl;
      throw "internal error";
    }

    bool Table::tableSnapShotBegin(const size_t snapShotID) {
      cout << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << endl;
      throw "internal error";
    }

    bool Table::tableSnapShotDo() {
      cout << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << endl;
      throw "internal error";
    }

    bool Table::tableSnapShotEnd() {
      cout << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << endl;
      throw "internal error";
    }





    bool Table::tableRestoreSnapShot (ifstream& inputFile, const size_t numRows) {
      cout << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << endl;
      throw "internal error";
    }

    void Table::dumpTableRow(void const* row, char*& data, size_t& dataLength) {
      cout << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << endl;
      throw "internal error";
    }

    void Table::dumpTableRow(const void* startRow, const void* endRow) {
      cout << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << endl;
      throw "internal error";
    }


    bool Table::restoreTableRow(void* row, const char* data, size_t dataLength) {
      cout << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << endl;
      throw "internal error";
    }

    bool Table::setRecoveryStructure(Table::RecoveryStructure* recover) {
      cout << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << endl;
      throw "internal error";
    }

    bool Table::setRecoveryTableId(uint32_t id) {
      cout << __FILE__ << ":" << __LINE__ << ":" << __FUNCTION__ << endl;
      throw "internal error";
    }


  }
}
