////////////////////////////////////////////////////////////////////////////////
/// @brief High-Performance Database Framework made by triagens
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Frank Celler
/// @author Copyright 2008-2010, triAGENS GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#ifndef TRIAGENS_HPDF_SORTED_CONDITION_H
#define TRIAGENS_HPDF_SORTED_CONDITION_H 1

#include <Hpdf/Common.h>


namespace triagens {
  namespace hpdf {

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief SortedCondition
    ////////////////////////////////////////////////////////////////////////////////

    struct SortedCondition : public DynamicSort {
      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief Constructor
        ////////////////////////////////////////////////////////////////////////////////

        SortedCondition () {
        };

      private:

        ////////////////////////////////////////////////////////////////////////////////
        // @brief a private copy constructor so that you are aware of the member
        // deDEUTF8Compare - this object is only created once and has a static counter
        ////////////////////////////////////////////////////////////////////////////////

        // cannot make the copy constructor private since the standard library sort routine
        // makes a copy of the function object
        // SortedCondition (const SortedCondition& source) {
        // };

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief compare two attributes (non-string attributes)
        ////////////////////////////////////////////////////////////////////////////////

        template<typename N>
        inline static int CMP (N left, N right) {
          if (left < right) {
            return -1;
          }
          else if (left == right) {
            return 0;
          }
          else {
            return 1;
          }
        }

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief compare two string attributes
        ////////////////////////////////////////////////////////////////////////////////

        inline static int CMP (char* left, char* right) {
          return (::strcmp(left, right));
        }


    };
  }
}

#endif

