////////////////////////////////////////////////////////////////////////////////
/// @brief High-Performance Database Framework made by triagens
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Frank Celler
/// @author Dr. Oreste Costa-Panaia
/// @author Copyright 2008-2010, triAGENS GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#include "HpdfFilterTree.h"

#include <Hpdf/FilterParser.h>

namespace triagens {
  namespace hpdf {

    // -----------------------------------------------------------------------------
    // constructors and destructors
    // -----------------------------------------------------------------------------

    HpdfFilterTree::HpdfFilterTree (string const& parseString, AttributeDescriptor* desc)
      : validFilterTree(false),
        rootNode(0),
        evaluationNodeArray(0),
        maxNodeArrayHeight(0),
        maxNodeArrayWidth(0),
        parseString(parseString) {

      FilterParser filterParser(parseString, this, desc);
      filterParser.parse();
      filterParser.evaluateTree();
    }



    HpdfFilterTree::~HpdfFilterTree() {

      // call the destructor implicitly for the rootNode
      if (rootNode != 0) {
        delete rootNode;
      }

      // remove any memory allocated on the heap for our evaluation array
      // Note: we are not deleting the objects just the storage used for the
      // two-dimensional array of pointers

      if (evaluationNodeArray != 0) {
        for (int i = 0; i <= maxNodeArrayHeight; ++i) {
          delete[] evaluationNodeArray[i];
        }

        delete[] evaluationNodeArray;
      }
    }
  }
}
