////////////////////////////////////////////////////////////////////////////////
/// @brief High-Performance Database Framework made by triagens
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Frank Celler
/// @author Dr. Oreste Costa-Panaia
/// @author Copyright 2008-2010, triAGENS GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#ifndef TRIAGENS_HPDF_DYNAMIC_SORT_H
#define TRIAGENS_HPDF_DYNAMIC_SORT_H 1

#include <Hpdf/Common.h>


namespace triagens {
  namespace hpdf {
    struct AttributeDescriptor;

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief dynmaic sort
    ////////////////////////////////////////////////////////////////////////////////

    class DynamicSort {
      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief DynmaicSort
        ////////////////////////////////////////////////////////////////////////////////

        typedef vector<int> DynamicSortDescription;

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief byte commands for sorting
        ////////////////////////////////////////////////////////////////////////////////

        enum {
          DL_INT16         =  1,
          DL_INT32         =  2,
          DL_INT64         =  3,
          DL_UINT16        =  4,
          DL_UINT32        =  5,
          DL_UINT64        =  6,
          DL_FLOAT         =  7,
          DL_DOUBLE        =  8,
          DL_STRING        =  9,
          DL_STRING_POOL   = 10,
          DL_STRING_SHARED = 11
        };

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief less descriptor handling
        ////////////////////////////////////////////////////////////////////////////////

        static DynamicSortDescription lessDescriptor (string const& definiton, AttributeDescriptor const* desc);

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief checks if blob is less than a second
        ////////////////////////////////////////////////////////////////////////////////

        static bool dynamicLess (DynamicSortDescription const& desc, void const* left, void const* right);

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief compares two blobs
        ////////////////////////////////////////////////////////////////////////////////

        int dynamicCompare (DynamicSortDescription const & desc, void const * left, void const * right);


    };
  }
}

#endif


