#!/bin/bash

HOST=localhost
PORT=8008
PRG="curl"
OPTIONS="-s -o - -D -"


HOST_PORT=http://$HOST:$PORT

echo "SimpleVoc: $HOST_PORT"

function post()
{
  # $1 path
  # $2 data
  echo Anfrage: $PRG $OPTIONS --request POST --data-binary "$2" "$HOST_PORT/$1"
  echo ---------------------------------------------------------
  $PRG $OPTIONS --request POST --data-binary "$2" "$HOST_PORT/$1"
  echo
  echo ---------------------------------------------------------
  echo
}

function put()
{
  # $1 path
  # $2 data

  EXP_OPTION=""
  EXP_VALUE=""
  if [ "$3" != "" ];  then
    EXP_OPTION=-H
    EXP_VALUE="X-VOC-Expires: $3"
  fi

  echo Anfrage: $PRG $OPTIONS $EXP_OPTION "$EXP_VALUE" --request PUT --data-binary "$2" "$HOST_PORT/$1"
  echo ---------------------------------------------------------
  $PRG $OPTIONS $EXP $EXP_OPTION "$EXP_VALUE" --request PUT --data-binary "$2" "$HOST_PORT/$1"
  echo
  echo ---------------------------------------------------------
  echo
}

function get()
{
  # $1 path
  echo Anfrage: $PRG $OPTIONS "$HOST_PORT/$1"
  echo ---------------------------------------------------------
  $PRG $OPTIONS "$HOST_PORT/$1"
  echo
  echo ---------------------------------------------------------
  echo
}

function put()
{
  # $1 path
  # $2 data
  # $3 expire
  echo Anfrage: $PRG $OPTIONS -H "X-VOC-Expires: $3" --request PUT --data-binary "$2" "$HOST_PORT/$1"
  echo ---------------------------------------------------------
  $PRG $OPTIONS -H "X-VOC-Expires: $3" --request PUT --data-binary "$2" "$HOST_PORT/$1"
  echo
  echo ---------------------------------------------------------
  echo
}


echo
echo "*** Version abfragen ***"
get "version"

echo
echo "*** Schlüssel/Wert anlegen ***"
post "value/key1" "value 1"
post "value/key2" "value 2"

echo
echo "*** Schlüssel/Wert erneut anlegen (wirft einen Fehler) ***"
post "value/key1" "value 1"


echo
echo "*** Schlüssel/Wert ändern ***"
put "value/key1" "value 1a"
put "value/key2" "value 2a"


echo
echo "*** Schlüssel/Wert anlegen oder ändern ***"
put "value/key3?create=1" "value 3"
put "value/key3?create=1" "value 3b"

echo
echo "*** Alle Schlüssel, die mit 'k' anfangen, abfragen ***"
get "keys/k"

echo
echo "*** Werte abfragen ***"
get "value/key1"
get "value/key2"
get "value/key3"

echo
echo "*** Werte mit Expire-Zeit anlegen ***"
EXP=$(date -u +"%Y-%m-%dT%H:%M:%SZ" --date "10 seconds")
put "value/key4?create=1" "value 4" $EXP
echo "*** Werte mit Expire-Zeit anzeigen ***"
get "value/key4"

echo
echo "*** 11 Sekunden warten ***"
sleep 11
echo "*** Werte mit Expire-Zeit anzeigen ***"
get "value/key4"


echo
echo "*** Alles wieder löschen ***"
get "flush"

