////////////////////////////////////////////////////////////////////////////////
/// @brief variant class for two-dimensional matrices
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Frank Celler
/// @author Achim Brandt
/// @author Copyright 2009-2010, triAGENS GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#ifndef TRIAGENS_BASICS_VARIANT_MATRIX2_H
#define TRIAGENS_BASICS_VARIANT_MATRIX2_H 1

#include <Basics/VariantObject.h>

namespace triagens {
  namespace basics {

    ////////////////////////////////////////////////////////////////////////////////
    /// @ingroup Variants
    /// @brief variant class for two-dimensional matrices
    ////////////////////////////////////////////////////////////////////////////////

    class VariantMatrix2 : public VariantObject {
      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief type of VariantObject
        ////////////////////////////////////////////////////////////////////////////////

        static ObjectType const TYPE = VARIANT_MATRIX2;

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief constructs a new matrix2
        ////////////////////////////////////////////////////////////////////////////////

        VariantMatrix2 ();

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief constructs a new matrix2
        ////////////////////////////////////////////////////////////////////////////////

        ~VariantMatrix2 ();

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        ObjectType type () const {
          return TYPE;
        }

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        VariantObject* clone () const;

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        void print (StringBuffer&, size_t indent) const;

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief returns the dimensions
        ////////////////////////////////////////////////////////////////////////////////

        vector<string> const& getDimension (size_t n) const;

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief returns the values
        ////////////////////////////////////////////////////////////////////////////////

        vector< vector<VariantObject*> > const& getValues () const {
          return values;
        }

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief returns the values
        ////////////////////////////////////////////////////////////////////////////////

        VariantObject* getValue (size_t x, size_t y) const;

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief set a value
        ////////////////////////////////////////////////////////////////////////////////

        void setValue (size_t x, size_t y, VariantObject*);

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief adds a dimension element
        ////////////////////////////////////////////////////////////////////////////////

        size_t addDimension (size_t n, string const& name);

      private:
        vector<string> dimensions[2];
        vector< vector<VariantObject*> > values;
    };
  }
}

#endif
