////////////////////////////////////////////////////////////////////////////////
/// @brief Mutex Locker
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Frank Celler
/// @author Achim Brandt
/// @author Copyright 2008-2010, triAGENS GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#include "MutexLocker.h"

#include <Basics/Exceptions.h>
#include <Basics/StringUtils.h>

namespace triagens {
  namespace basics {

    // -----------------------------------------------------------------------------
    // constructors and destructors
    // -----------------------------------------------------------------------------

    MutexLocker::MutexLocker (Mutex* mutex)
      : _mutex(mutex), _file(0), _line(0) {
      bool ok = _mutex->lock();

      if (! ok) {
        THROW_INTERNAL_ERROR("mutex lock failed");
      }
    }



    MutexLocker::MutexLocker (Mutex* mutex, char const* file, int line)
      : _mutex(mutex), _file(file), _line(line) {
      bool ok = _mutex->lock();

      if (! ok) {
        if (_file != 0) {
          THROW_INTERNAL_ERROR_L("mutex lock failed", _file, _line);
        }
        else {
          THROW_INTERNAL_ERROR("mutex lock failed");
        }
      }
    }



    MutexLocker::~MutexLocker () {
      bool ok = _mutex->unlock();

      if (! ok) {
        if (_file != 0) {
          THROW_INTERNAL_ERROR_L("mutex unlock failed", _file, _line);
        }
        else {
          THROW_INTERNAL_ERROR("mutex unlock failed");
        }
      }
    }
  }
}
