////////////////////////////////////////////////////////////////////////////////
/// @brief implementation of a crc32 hash
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Oreste Costa-Panaia
/// @author Wikipedia
/// @author Copyright 2009-2010, triAGENS GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#ifndef TRIAGENS_BASICS_CRC32HASH_H
#define TRIAGENS_BASICS_CRC32HASH_H 1

#include <Basics/Common.h>

namespace triagens {
  namespace basics {

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief implementation of a crc32 hash
    ////////////////////////////////////////////////////////////////////////////////

    namespace Crc32Hash {

      ////////////////////////////////////////////////////////////////////////////////
      /// @ingroup Utilities
      /// @brief initialise value
      ////////////////////////////////////////////////////////////////////////////////

      uint32_t initialiseValue ();

      ////////////////////////////////////////////////////////////////////////////////
      /// @ingroup Utilities
      /// @brief finalise value
      ////////////////////////////////////////////////////////////////////////////////

      uint32_t finaliseValue (uint32_t value);

      ////////////////////////////////////////////////////////////////////////////////
      /// @ingroup Utilities
      /// @brief returns a CRC Value based upon the input data
      ////////////////////////////////////////////////////////////////////////////////

      uint32_t crcValue (uint32_t value, const unsigned char* data, uint64_t length);

      ////////////////////////////////////////////////////////////////////////////////
      /// @ingroup Utilities
      /// @brief returns a CRC Value based upon the input data
      ////////////////////////////////////////////////////////////////////////////////

      uint32_t crcValue (uint32_t value, unsigned char const* data);

      ////////////////////////////////////////////////////////////////////////////////
      /// @ingroup Utilities
      /// @brief returns a CRC Value based upon the input data
      ////////////////////////////////////////////////////////////////////////////////

      uint32_t crcValue (uint32_t value, string const& data);
    }
  }
}

#endif
