////////////////////////////////////////////////////////////////////////////////
/// @brief application server scheduler implementation
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Frank Celler
/// @author Copyright 2009-2010, triAGENS GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#ifndef FYN_APPLICATIONSERVER_APPLICATION_SERVER_SCHEDULER_IMPL_H
#define FYN_APPLICATIONSERVER_APPLICATION_SERVER_SCHEDULER_IMPL_H 1

#include "ApplicationServer/ApplicationServerImpl.h"

#include <Basics/ConditionVariable.h>

namespace triagens {
  namespace rest {
    class Task;

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief application server scheduler implementation
    ////////////////////////////////////////////////////////////////////////////////

    class ApplicationServerSchedulerImpl : public ApplicationServerImpl {
      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief constructor
        ////////////////////////////////////////////////////////////////////////////////

        ApplicationServerSchedulerImpl (string const& description, string const& version);

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief destructor
        ////////////////////////////////////////////////////////////////////////////////

        ~ApplicationServerSchedulerImpl ();

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        void allowMultiScheduler (bool value = true) {
          multiSchedulerAllowed = value;
        }

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        Scheduler* scheduler () const {
          return schedulerValue;
        }

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        void buildScheduler ();

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        void buildSchedulerReporter ();

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        void buildControlCHandler ();

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        bool addressReuseAllowed () {
          return reuseAddress;
        }

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        void start ();

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        void wait ();

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        void beginShutdown ();

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        void shutdown ();

      protected:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief register a new task
        ////////////////////////////////////////////////////////////////////////////////

        void registerTask (Task*);

      protected:

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        void setupOptions (section_e, basics::ProgramOptionsDescription&);

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        bool parsePhase1 ();

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        bool parsePhase2 ();

      protected:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief intervall for reports
        ////////////////////////////////////////////////////////////////////////////////

        double reportIntervall;

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief is a multi-threaded scheduler allowed
        ////////////////////////////////////////////////////////////////////////////////

        bool multiSchedulerAllowed;

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief number of scheduler threads
        ////////////////////////////////////////////////////////////////////////////////

        uint32_t nrSchedulerThreads;

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief scheduler backend
        ////////////////////////////////////////////////////////////////////////////////

        uint32_t backend;

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief allow port to be reused
        ////////////////////////////////////////////////////////////////////////////////

        bool reuseAddress;

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief minimum number of file descriptors
        ////////////////////////////////////////////////////////////////////////////////

        uint32_t descriptorMinimum;


      private:
        void adjustFileDescriptors ();

      private:
        Scheduler* schedulerValue;
        basics::ConditionVariable schedulerCond;
        bool shutdownInProgress;

        vector<Task*> tasks;
    };
  }
}

#endif

