////////////////////////////////////////////////////////////////////////////////
/// @brief application server implementation
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Frank Celler
/// @author Copyright 2009-2010, triAGENS GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#ifndef FYN_APPLICATIONSERVER_APPLICATION_SERVER_IMPL_H
#define FYN_APPLICATIONSERVER_APPLICATION_SERVER_IMPL_H 1

#include <Basics/Common.h>

#include <Basics/ProgramOptions.h>
#include <Basics/ProgramOptionsDescription.h>
#include <Rest/ApplicationServer.h>

namespace triagens {
  namespace rest {

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief application server implementation
    ////////////////////////////////////////////////////////////////////////////////

    class ApplicationServerImpl : virtual public ApplicationServer {
      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief constructor
        ////////////////////////////////////////////////////////////////////////////////

        ApplicationServerImpl (string const& description, string const& version);

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief destructor
        ////////////////////////////////////////////////////////////////////////////////

        ~ApplicationServerImpl ();

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        void addFeature (ApplicationFeature*);

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        void setSystemConfigFile (string const& name) {
          systemConfigFile = name;
        }

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        void setUserConfigFile (string const& name) {
          userConfigFile = name;
        }

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        basics::ProgramOptions& programOptions () {
          return options;
        }

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        vector<string> programArguments () {
          return arguments;
        }

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        bool parse (int argc, char* argv[], map<section_e, basics::ProgramOptionsDescription>&);

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        void start ();

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        void wait ();

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        void beginShutdown ();

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        void shutdown ();

      protected:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief add options to description
        ////////////////////////////////////////////////////////////////////////////////

        virtual void setupOptions (section_e, basics::ProgramOptionsDescription&);

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief parsing phase 1, before config file
        ////////////////////////////////////////////////////////////////////////////////

        virtual bool parsePhase1 ();

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief parsing phase 2, after config file
        ////////////////////////////////////////////////////////////////////////////////

        virtual bool parsePhase2 ();

      protected:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief program options
        ////////////////////////////////////////////////////////////////////////////////

        basics::ProgramOptions options;

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief defined features
        ////////////////////////////////////////////////////////////////////////////////

        vector<ApplicationFeature*> features;

      private:
        void setupLogging ();
        bool readConfigurationFile ();
        void dropPriviliges ();

      private:
        string title;
        string version;

        string initFile;
        string userConfigFile;
        string systemConfigFile;

        string uid;
        string gid;

        string logApplicationName;
        string logHostName;
        string logFacility;
        string logLevel;
        string logFormat;
        string logSeverity;
        string logFile;
        string logPrefix;
        string logSyslog;
        bool logThreadId;

        uint32_t randomGenerator;

        basics::ProgramOptionsDescription description;
        basics::ProgramOptionsDescription descriptionFile;

        vector<string> arguments;
    };
  }
}

#endif
