////////////////////////////////////////////////////////////////////////////////
/// @brief application server line server implementation
///
/// @file
///
/// DISCLAIMER
///
/// Copyright 2010-2011 triagens GmbH, Cologne, Germany
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///     http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// Copyright holder is triAGENS GmbH, Cologne, Germany
///
/// @author Dr. Frank Celler
/// @author Copyright 2009-2010, triAGENS GmbH, Cologne, Germany
////////////////////////////////////////////////////////////////////////////////

#ifndef FYN_APPLICATIONSERVER_APPLICATION_LINE_SERVER_IMPL_H
#define FYN_APPLICATIONSERVER_APPLICATION_LINE_SERVER_IMPL_H 1

#include <Rest/ApplicationLineServer.h>

namespace triagens {
  namespace rest {

    ////////////////////////////////////////////////////////////////////////////////
    /// @brief application server scheduler implementation
    ////////////////////////////////////////////////////////////////////////////////

    class ApplicationLineServerImpl : public ApplicationLineServer {
      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief constructor
        ////////////////////////////////////////////////////////////////////////////////

        ApplicationLineServerImpl (ApplicationServer*);

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief destructor
        ////////////////////////////////////////////////////////////////////////////////

        ~ApplicationLineServerImpl ();

      public:

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        void setupOptions (ApplicationServer::section_e, basics::ProgramOptionsDescription&);

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        bool parsePhase2 (basics::ProgramOptions&);

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        void showPortOptions (bool value) {
          showPort = value;
        }

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        AddressPort addPort (string const&);

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        LineServer* buildServer (LineHandlerFactory*);

        ////////////////////////////////////////////////////////////////////////////////
        /// {@inheritDoc}
        ////////////////////////////////////////////////////////////////////////////////

        LineServer* buildServer (LineHandlerFactory*, vector<AddressPort> const&);

      protected:

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief application server
        ////////////////////////////////////////////////////////////////////////////////

        ApplicationServer* applicationServer;

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief show port options
        ////////////////////////////////////////////////////////////////////////////////

        bool showPort;

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief all constructed line servers
        ////////////////////////////////////////////////////////////////////////////////

        vector<LineServer*> lineServers;

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief all default ports
        ////////////////////////////////////////////////////////////////////////////////

        vector<string> linePorts;

        ////////////////////////////////////////////////////////////////////////////////
        /// @brief all used addresses
        ////////////////////////////////////////////////////////////////////////////////

        vector<AddressPort> lineAddressPorts;
    };
  }
}

#endif
