#!/usr/bin/env python
# -*- coding: utf-8 -*-
# vim:ts=4:sw=4:softtabstop=4:smarttab:expandtab

# Copyright (c) 2022 Doug Massay
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without modification,
# are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice, this list of
# conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright notice, this list
# of conditions and the following disclaimer in the documentation and/or other materials
# provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
# SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
# TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
# OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY
# WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import os
import sys
import inspect


SCRIPT_DIRECTORY = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
e = os.environ.get('SIGIL_QT_RUNTIME_VERSION', '5.10.0')
SIGIL_QT_MAJOR_VERSION = tuple(map(int, (e.split("."))))[0]
DEBUG = 0


if SIGIL_QT_MAJOR_VERSION == 6:
    from PySide6 import QtWidgets  # noqa: F401
    # Plugins that don't use QtWebEngine shouldn't fail when external Pythons
    # don't have PySide6 installed. Bundled Pythons will always have PySide6
    # installed startting with Qt6 releases.
    try:
        from PySide6 import QtWebEngineWidgets  # noqa: F401
    except ImportError:
        pass
    else:
        if DEBUG:
            print('QtWebEngine PySide6 Python bindings found.')

elif SIGIL_QT_MAJOR_VERSION == 5:
    from PyQt5 import  QtWidgets  # noqa: F401
    # Plugins that don't use QtWebEngine shouldn't fail when external Pythons
    # Don't have PyQt5 installed. And Sigil versions before PyQtWebEngine was added (Pre-1.6)
    # should be able to run plugins that use this script, but don't use QtWebEngine.
    try:
        from PyQt5 import QtWebEngineWidgets  # noqa: F401
    except ImportError:
        pass
    else:
        if DEBUG:
            print('QtWebEngine PyQt5 Python bindings found.')
