/* sigh, a signal handling library
 * (C) 2004 Nick Welch
 *
 * Usage of the works is permitted provided that this
 * instrument is retained with the works, so that any entity
 * that uses the works is notified of this instrument.
 *
 * DISCLAIMER: THE WORKS ARE WITHOUT WARRANTY.
 *
 * [2004, Fair License; rhid.com/fair]
 */

/* this test waits for a SIGINT, prints the time it was received, then exits. */

#include <stdio.h>
#include <signal.h>

/* sleep */
#include <unistd.h>

/* gettimeofday */
#include <time.h>
#include <sys/time.h>

sig_atomic_t done = 0;

void handle(int sig)
{
    static struct timeval tv;
    gettimeofday(&tv, 0);
    fprintf(stderr, "%d.%d - received SIGINT\n", tv.tv_sec, tv.tv_usec);
    done = 1;
}

int main(void)
{
    struct sigaction act;
    act.sa_flags = 0;
    sigemptyset(&act.sa_mask);

    act.sa_handler = handle;
    sigaction(SIGINT, &act, 0);

    while(!done)
        sleep(10); /* signal delivery will interrupt */

    return 0;
}

