/* sigh, a signal handling library
 * (C) 2004 Nick Welch
 *
 * Usage of the works is permitted provided that this
 * instrument is retained with the works, so that any entity
 * that uses the works is notified of this instrument.
 *
 * DISCLAIMER: THE WORKS ARE WITHOUT WARRANTY.
 *
 * [2004, Fair License; rhid.com/fair]
 */

/* this test waits for a SIGINT, prints the time it was received, then exits. */

#include <sigh/sigh.h>

#include <stdio.h>
#include <signal.h>

/* gettimeofday */
#include <time.h>
#include <sys/time.h>

int main(void)
{
    int sig = 0;
    sigset_t sigs = sigh_make_sigset(SIGINT, 0);
    struct timeval tv;

    sig = sigh_watch(&sigs);

    while(sig != SIGINT)
        sig = sigh_wait(&sigs, 10000000);

    gettimeofday(&tv, 0);
    fprintf(stderr, "%d.%d - received SIGINT\n", tv.tv_sec, tv.tv_usec);
    return 0;
}

