/*
 * Copyright (c) 2002-2005 The TenDRA Project <http://www.tendra.org/>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of The TenDRA Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific, prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: output.c 1222 2007-05-31 13:32:35Z kate $
 */
/*
    		 Crown Copyright (c) 1997

    This TenDRA(r) Computer Program is subject to Copyright
    owned by the United Kingdom Secretary of State for Defence
    acting through the Defence Evaluation and Research Agency
    (DERA).  It is made available to Recipients with a
    royalty-free licence for its use, reproduction, transfer
    to other parties and amendment for any purpose not excluding
    product development provided that any such use et cetera
    shall be deemed to be acceptance of the following conditions:-

        (1) Its Recipients shall ensure that this Notice is
        reproduced upon any copies or amended versions of it;

        (2) Any amended version of it shall be clearly marked to
        show both the nature of and the organisation responsible
        for the relevant amendment or amendments;

        (3) Its onward transfer from a recipient to another
        party shall be deemed to be that party's acceptance of
        these conditions;

        (4) DERA gives no warranty or assurance as to its
        quality or suitability for any purpose and DERA accepts
        no liability whatsoever in relation to any use to which
        it may be put.
*/

/*
 * output.c - Target independent output routines.
 *
 * This file implements some generic output routines.
 */

#include <stddef.h>

#include "output.h"

void
out_info_init(OutputInfoT * info, char * prog)
{
    info->prog_name       = prog;
    info->current_ostream = NULL;
    info->istreams        = NULL;
    info->ostreams        = NULL;
    info->input_names     = NULL;
    info->output_names    = NULL;
    info->tab_width       = 8;
}

char *
out_info_get_prog_name(OutputInfoT * info)
{
    return(info->prog_name);
}

void
out_info_set_current_ostream(OutputInfoT * info, unsigned i)
{
    info->current_ostream = &(info->ostreams[i]);
}

OStreamT *
out_info_get_current_ostream(OutputInfoT * info)
{
    return(info->current_ostream);
}

void
out_info_set_num_input_files(OutputInfoT * info, unsigned size)
{
    info->istreams    = ALLOCATE_VECTOR(IStreamT, size);
    info->input_names = ALLOCATE_VECTOR(char *, size);
}

void
out_info_set_num_output_files(OutputInfoT * info, unsigned size)
{
    info->ostreams     = ALLOCATE_VECTOR(OStreamT, size);
    info->output_names = ALLOCATE_VECTOR(char *, size);
}

IStreamT *
out_info_get_istream(OutputInfoT * info, unsigned i)
{
    return(&(info->istreams[i]));
}

OStreamT *
out_info_get_ostream(OutputInfoT * info, unsigned i)
{
    return(&(info->ostreams[i]));
}

void
out_info_set_infile_name(OutputInfoT * info, unsigned i, char * name)
{
    info->input_names[i] = name;
}

char *
out_info_get_infile_name(OutputInfoT * info, unsigned i)
{
    return(info->input_names[i]);
}

void
out_info_set_outfile_name(OutputInfoT * info, unsigned i, char * name)
{
    info->output_names[i] = name;
}

char *
out_info_get_outfile_name(OutputInfoT * info, unsigned i)
{
    return(info->output_names[i]);
}

void
out_info_set_tab_width(OutputInfoT * info, unsigned width)
{
    info->tab_width = width;
}

void
output_indent(OutputInfoT * info, unsigned indent)
{
    OStreamT * ostream    = out_info_get_current_ostream(info);
    unsigned tab_width  = info->tab_width;
    unsigned num_tabs   = (indent / tab_width);
    unsigned num_spaces = (indent % tab_width);

    while (num_tabs --) {
	write_tab(ostream);
    }
    while (num_spaces --) {
	write_char(ostream, ' ');
    }
}
