
PUREDOCS_XSL = 	http://xsl.packagegrid.org/puredocs/
XSLT = 			xsltproc --xinclude 
XHTMLSTYLE =	../doctools/xsl/puredocs.xsl

XMLDIR = 		../xml/$(SUBDIR)
XHTMLDIR = 		../xhtml
RESOURCES = 	../doctools/resources/*.css ../doctools/resources/*.png
CSSFILE = 		api.css	
STYLEOPT=		--stringparam title $(TITLE)

PUREDOCS =		puredocs
FORMAT = 		rstxml
				
all: xhtml

xhtml: $(XHTMLDIR)/$(SUBDIR)/index.html 

puredocs.xml: $(XMLDIR)
	$(PUREDOCS) -i $(SOURCE) -f $(FORMAT) -d $(XMLDIR)/puredocs.xml

$(XHTMLDIR)/$(SUBDIR)/index.html: puredocs.xml resources
	$(XSLT) $(STYLEOPT) -o $(XHTMLDIR)/$(SUBDIR)/index.html $(XHTMLSTYLE) $(XMLDIR)/puredocs.xml

$(XHTMLDIR)/$(SUBDIR):
	mkdir -p $(XHTMLDIR)/$(SUBDIR)

$(XMLDIR):
	mkdir -p $(XMLDIR)

resources: $(XHTMLDIR)/$(SUBDIR)
	cp -r $(RESOURCES) $(XHTMLDIR)/$(SUBDIR)

clean: 
	rm -rf $(XHTMLDIR)/$(SUBDIR)

