/*
 * Decompiled with CFR 0.152.
 */
package errorapi;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermInt;
import aterm.ATermList;
import aterm.pure.PureFactory;
import errorapi.types.Area;
import errorapi.types.AreaAreas;
import errorapi.types.ErrorList;
import errorapi.types.Location;
import errorapi.types.NatCon;
import errorapi.types.StrChar;
import errorapi.types.StrCon;
import errorapi.types.SubjectList;
import errorapi.types.error.Error;
import errorapi.types.error.Fatal;
import errorapi.types.error.Info;
import errorapi.types.error.Warning;
import errorapi.types.location.AreaInFile;
import errorapi.types.location.File;
import errorapi.types.slice.Slice;
import errorapi.types.subject.Localized;
import errorapi.types.subject.Subject;
import errorapi.types.summary.Summary;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import shared.SharedObject;

public class Factory {
    private PureFactory factory;
    private AFun fun_StrChar_StrChar;
    private StrChar proto_StrChar_StrChar;
    private ATerm pattern_StrChar_StrChar;
    private AFun fun_StrCon_StrCon;
    private StrCon proto_StrCon_StrCon;
    private ATerm pattern_StrCon_StrCon;
    private AFun fun_NatCon_NatCon;
    private NatCon proto_NatCon_NatCon;
    private ATerm pattern_NatCon_NatCon;
    private AFun fun_Subject_Subject;
    private errorapi.types.Subject proto_Subject_Subject;
    private ATerm pattern_Subject_Subject;
    private AFun fun_Subject_Localized;
    private errorapi.types.Subject proto_Subject_Localized;
    private ATerm pattern_Subject_Localized;
    private AFun fun_Error_Info;
    private errorapi.types.Error proto_Error_Info;
    private ATerm pattern_Error_Info;
    private AFun fun_Error_Warning;
    private errorapi.types.Error proto_Error_Warning;
    private ATerm pattern_Error_Warning;
    private AFun fun_Error_Error;
    private errorapi.types.Error proto_Error_Error;
    private ATerm pattern_Error_Error;
    private AFun fun_Error_Fatal;
    private errorapi.types.Error proto_Error_Fatal;
    private ATerm pattern_Error_Fatal;
    private AFun fun_Summary_Summary;
    private errorapi.types.Summary proto_Summary_Summary;
    private ATerm pattern_Summary_Summary;
    private SubjectList proto_SubjectList;
    private ErrorList proto_ErrorList;
    private AFun fun_Location_File;
    private Location proto_Location_File;
    private ATerm pattern_Location_File;
    private AFun fun_Location_Area;
    private Location proto_Location_Area;
    private ATerm pattern_Location_Area;
    private AFun fun_Location_AreaInFile;
    private Location proto_Location_AreaInFile;
    private ATerm pattern_Location_AreaInFile;
    private AFun fun_Area_Area;
    private Area proto_Area_Area;
    private ATerm pattern_Area_Area;
    private AFun fun_Slice_Slice;
    private errorapi.types.Slice proto_Slice_Slice;
    private ATerm pattern_Slice_Slice;
    private AreaAreas proto_AreaAreas;
    private SubjectList empty_SubjectList;
    private ErrorList empty_ErrorList;
    private AreaAreas empty_AreaAreas;
    private static Factory instance = null;

    private Factory(PureFactory pureFactory) {
        this.factory = pureFactory;
    }

    public static Factory getInstance(PureFactory pureFactory) {
        if (instance == null) {
            instance = new Factory(pureFactory);
            instance.initialize();
        }
        if (Factory.instance.factory != pureFactory) {
            throw new RuntimeException("Dont create two Factory factories with differents PureFactory ");
        }
        return instance;
    }

    public PureFactory getPureFactory() {
        return this.factory;
    }

    private void initialize() {
        this.pattern_StrChar_StrChar = this.factory.parse("<str>");
        this.fun_StrChar_StrChar = this.factory.makeAFun("_StrChar_StrChar", 1, false);
        this.proto_StrChar_StrChar = new errorapi.types.strchar.StrChar(this);
        this.pattern_StrCon_StrCon = this.factory.parse("<str>");
        this.fun_StrCon_StrCon = this.factory.makeAFun("_StrCon_StrCon", 1, false);
        this.proto_StrCon_StrCon = new errorapi.types.strcon.StrCon(this);
        this.pattern_NatCon_NatCon = this.factory.parse("<str>");
        this.fun_NatCon_NatCon = this.factory.makeAFun("_NatCon_NatCon", 1, false);
        this.proto_NatCon_NatCon = new errorapi.types.natcon.NatCon(this);
        this.pattern_Subject_Subject = this.factory.parse("subject(<str>)");
        this.fun_Subject_Subject = this.factory.makeAFun("_Subject_subject", 1, false);
        this.proto_Subject_Subject = new Subject(this);
        this.pattern_Subject_Localized = this.factory.parse("localized(<str>,<term>)");
        this.fun_Subject_Localized = this.factory.makeAFun("_Subject_localized", 2, false);
        this.proto_Subject_Localized = new Localized(this);
        this.pattern_Error_Info = this.factory.parse("info(<str>,<term>)");
        this.fun_Error_Info = this.factory.makeAFun("_Error_info", 2, false);
        this.proto_Error_Info = new Info(this);
        this.pattern_Error_Warning = this.factory.parse("warning(<str>,<term>)");
        this.fun_Error_Warning = this.factory.makeAFun("_Error_warning", 2, false);
        this.proto_Error_Warning = new Warning(this);
        this.pattern_Error_Error = this.factory.parse("error(<str>,<term>)");
        this.fun_Error_Error = this.factory.makeAFun("_Error_error", 2, false);
        this.proto_Error_Error = new Error(this);
        this.pattern_Error_Fatal = this.factory.parse("fatal(<str>,<term>)");
        this.fun_Error_Fatal = this.factory.makeAFun("_Error_fatal", 2, false);
        this.proto_Error_Fatal = new Fatal(this);
        this.pattern_Summary_Summary = this.factory.parse("summary(<str>,<str>,<term>)");
        this.fun_Summary_Summary = this.factory.makeAFun("_Summary_summary", 3, false);
        this.proto_Summary_Summary = new Summary(this);
        this.proto_SubjectList = new SubjectList(this);
        this.proto_SubjectList.initHashCode(this.factory.getEmpty(), null, null);
        this.empty_SubjectList = (SubjectList)this.factory.build((SharedObject)this.proto_SubjectList);
        this.proto_ErrorList = new ErrorList(this);
        this.proto_ErrorList.initHashCode(this.factory.getEmpty(), null, null);
        this.empty_ErrorList = (ErrorList)this.factory.build((SharedObject)this.proto_ErrorList);
        this.pattern_Location_File = this.factory.parse("file(<str>)");
        this.fun_Location_File = this.factory.makeAFun("_Location_file", 1, false);
        this.proto_Location_File = new File(this);
        this.pattern_Location_Area = this.factory.parse("area(<term>)");
        this.fun_Location_Area = this.factory.makeAFun("_Location_area", 1, false);
        this.proto_Location_Area = new errorapi.types.location.Area(this);
        this.pattern_Location_AreaInFile = this.factory.parse("area-in-file(<str>,<term>)");
        this.fun_Location_AreaInFile = this.factory.makeAFun("_Location_area-in-file", 2, false);
        this.proto_Location_AreaInFile = new AreaInFile(this);
        this.pattern_Area_Area = this.factory.parse("area(<int>,<int>,<int>,<int>,<int>,<int>)");
        this.fun_Area_Area = this.factory.makeAFun("_Area_area", 6, false);
        this.proto_Area_Area = new errorapi.types.area.Area(this);
        this.pattern_Slice_Slice = this.factory.parse("slice(<str>,<term>)");
        this.fun_Slice_Slice = this.factory.makeAFun("_Slice_slice", 2, false);
        this.proto_Slice_Slice = new Slice(this);
        this.proto_AreaAreas = new AreaAreas(this);
        this.proto_AreaAreas.initHashCode(this.factory.getEmpty(), null, null);
        this.empty_AreaAreas = (AreaAreas)this.factory.build((SharedObject)this.proto_AreaAreas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public errorapi.types.strchar.StrChar makeStrChar_StrChar(AFun aFun, ATerm[] aTermArray, ATermList aTermList) {
        StrChar strChar = this.proto_StrChar_StrChar;
        synchronized (strChar) {
            this.proto_StrChar_StrChar.initHashCode(aTermList, aFun, aTermArray);
            return (errorapi.types.strchar.StrChar)this.factory.build((SharedObject)this.proto_StrChar_StrChar);
        }
    }

    public errorapi.types.strchar.StrChar makeStrChar_StrChar(String string) {
        ATerm[] aTermArray = new ATerm[]{this.factory.makeAppl(this.factory.makeAFun(string, 0, true))};
        return this.makeStrChar_StrChar(this.fun_StrChar_StrChar, aTermArray, this.factory.getEmpty());
    }

    protected StrChar StrChar_StrCharFromTerm(ATerm aTerm) {
        List list = aTerm.match(this.pattern_StrChar_StrChar);
        if (list != null) {
            return this.makeStrChar_StrChar((String)list.get(0));
        }
        return null;
    }

    public ATerm toTerm(errorapi.types.strchar.StrChar strChar) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(strChar.getString());
        return this.factory.make(this.pattern_StrChar_StrChar, linkedList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public errorapi.types.strcon.StrCon makeStrCon_StrCon(AFun aFun, ATerm[] aTermArray, ATermList aTermList) {
        StrCon strCon = this.proto_StrCon_StrCon;
        synchronized (strCon) {
            this.proto_StrCon_StrCon.initHashCode(aTermList, aFun, aTermArray);
            return (errorapi.types.strcon.StrCon)this.factory.build((SharedObject)this.proto_StrCon_StrCon);
        }
    }

    public errorapi.types.strcon.StrCon makeStrCon_StrCon(String string) {
        ATerm[] aTermArray = new ATerm[]{this.factory.makeAppl(this.factory.makeAFun(string, 0, true))};
        return this.makeStrCon_StrCon(this.fun_StrCon_StrCon, aTermArray, this.factory.getEmpty());
    }

    protected StrCon StrCon_StrConFromTerm(ATerm aTerm) {
        List list = aTerm.match(this.pattern_StrCon_StrCon);
        if (list != null) {
            return this.makeStrCon_StrCon((String)list.get(0));
        }
        return null;
    }

    public ATerm toTerm(errorapi.types.strcon.StrCon strCon) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(strCon.getString());
        return this.factory.make(this.pattern_StrCon_StrCon, linkedList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public errorapi.types.natcon.NatCon makeNatCon_NatCon(AFun aFun, ATerm[] aTermArray, ATermList aTermList) {
        NatCon natCon = this.proto_NatCon_NatCon;
        synchronized (natCon) {
            this.proto_NatCon_NatCon.initHashCode(aTermList, aFun, aTermArray);
            return (errorapi.types.natcon.NatCon)this.factory.build((SharedObject)this.proto_NatCon_NatCon);
        }
    }

    public errorapi.types.natcon.NatCon makeNatCon_NatCon(String string) {
        ATerm[] aTermArray = new ATerm[]{this.factory.makeAppl(this.factory.makeAFun(string, 0, true))};
        return this.makeNatCon_NatCon(this.fun_NatCon_NatCon, aTermArray, this.factory.getEmpty());
    }

    protected NatCon NatCon_NatConFromTerm(ATerm aTerm) {
        List list = aTerm.match(this.pattern_NatCon_NatCon);
        if (list != null) {
            return this.makeNatCon_NatCon((String)list.get(0));
        }
        return null;
    }

    public ATerm toTerm(errorapi.types.natcon.NatCon natCon) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(natCon.getString());
        return this.factory.make(this.pattern_NatCon_NatCon, linkedList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subject makeSubject_Subject(AFun aFun, ATerm[] aTermArray, ATermList aTermList) {
        errorapi.types.Subject subject = this.proto_Subject_Subject;
        synchronized (subject) {
            this.proto_Subject_Subject.initHashCode(aTermList, aFun, aTermArray);
            return (Subject)this.factory.build((SharedObject)this.proto_Subject_Subject);
        }
    }

    public Subject makeSubject_Subject(String string) {
        ATerm[] aTermArray = new ATerm[]{this.factory.makeAppl(this.factory.makeAFun(string, 0, true))};
        return this.makeSubject_Subject(this.fun_Subject_Subject, aTermArray, this.factory.getEmpty());
    }

    protected errorapi.types.Subject Subject_SubjectFromTerm(ATerm aTerm) {
        List list = aTerm.match(this.pattern_Subject_Subject);
        if (list != null) {
            return this.makeSubject_Subject((String)list.get(0));
        }
        return null;
    }

    public ATerm toTerm(Subject subject) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(subject.getDescription());
        return this.factory.make(this.pattern_Subject_Subject, linkedList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Localized makeSubject_Localized(AFun aFun, ATerm[] aTermArray, ATermList aTermList) {
        errorapi.types.Subject subject = this.proto_Subject_Localized;
        synchronized (subject) {
            this.proto_Subject_Localized.initHashCode(aTermList, aFun, aTermArray);
            return (Localized)this.factory.build((SharedObject)this.proto_Subject_Localized);
        }
    }

    public Localized makeSubject_Localized(String string, Location location) {
        ATerm[] aTermArray = new ATerm[]{this.factory.makeAppl(this.factory.makeAFun(string, 0, true)), location};
        return this.makeSubject_Localized(this.fun_Subject_Localized, aTermArray, this.factory.getEmpty());
    }

    protected errorapi.types.Subject Subject_LocalizedFromTerm(ATerm aTerm) {
        List list = aTerm.match(this.pattern_Subject_Localized);
        if (list != null) {
            return this.makeSubject_Localized((String)list.get(0), this.LocationFromTerm((ATerm)list.get(1)));
        }
        return null;
    }

    public ATerm toTerm(Localized localized) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(localized.getDescription());
        linkedList.add((String)localized.getLocation().toTerm());
        return this.factory.make(this.pattern_Subject_Localized, linkedList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Info makeError_Info(AFun aFun, ATerm[] aTermArray, ATermList aTermList) {
        errorapi.types.Error error = this.proto_Error_Info;
        synchronized (error) {
            this.proto_Error_Info.initHashCode(aTermList, aFun, aTermArray);
            return (Info)this.factory.build((SharedObject)this.proto_Error_Info);
        }
    }

    public Info makeError_Info(String string, SubjectList subjectList) {
        ATerm[] aTermArray = new ATerm[]{this.factory.makeAppl(this.factory.makeAFun(string, 0, true)), subjectList};
        return this.makeError_Info(this.fun_Error_Info, aTermArray, this.factory.getEmpty());
    }

    protected errorapi.types.Error Error_InfoFromTerm(ATerm aTerm) {
        List list = aTerm.match(this.pattern_Error_Info);
        if (list != null) {
            return this.makeError_Info((String)list.get(0), this.SubjectListFromTerm((ATerm)list.get(1)));
        }
        return null;
    }

    public ATerm toTerm(Info info) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(info.getDescription());
        linkedList.add((String)info.getList().toTerm());
        return this.factory.make(this.pattern_Error_Info, linkedList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Warning makeError_Warning(AFun aFun, ATerm[] aTermArray, ATermList aTermList) {
        errorapi.types.Error error = this.proto_Error_Warning;
        synchronized (error) {
            this.proto_Error_Warning.initHashCode(aTermList, aFun, aTermArray);
            return (Warning)this.factory.build((SharedObject)this.proto_Error_Warning);
        }
    }

    public Warning makeError_Warning(String string, SubjectList subjectList) {
        ATerm[] aTermArray = new ATerm[]{this.factory.makeAppl(this.factory.makeAFun(string, 0, true)), subjectList};
        return this.makeError_Warning(this.fun_Error_Warning, aTermArray, this.factory.getEmpty());
    }

    protected errorapi.types.Error Error_WarningFromTerm(ATerm aTerm) {
        List list = aTerm.match(this.pattern_Error_Warning);
        if (list != null) {
            return this.makeError_Warning((String)list.get(0), this.SubjectListFromTerm((ATerm)list.get(1)));
        }
        return null;
    }

    public ATerm toTerm(Warning warning) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(warning.getDescription());
        linkedList.add((String)warning.getList().toTerm());
        return this.factory.make(this.pattern_Error_Warning, linkedList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Error makeError_Error(AFun aFun, ATerm[] aTermArray, ATermList aTermList) {
        errorapi.types.Error error = this.proto_Error_Error;
        synchronized (error) {
            this.proto_Error_Error.initHashCode(aTermList, aFun, aTermArray);
            return (Error)this.factory.build((SharedObject)this.proto_Error_Error);
        }
    }

    public Error makeError_Error(String string, SubjectList subjectList) {
        ATerm[] aTermArray = new ATerm[]{this.factory.makeAppl(this.factory.makeAFun(string, 0, true)), subjectList};
        return this.makeError_Error(this.fun_Error_Error, aTermArray, this.factory.getEmpty());
    }

    protected errorapi.types.Error Error_ErrorFromTerm(ATerm aTerm) {
        List list = aTerm.match(this.pattern_Error_Error);
        if (list != null) {
            return this.makeError_Error((String)list.get(0), this.SubjectListFromTerm((ATerm)list.get(1)));
        }
        return null;
    }

    public ATerm toTerm(Error error) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(error.getDescription());
        linkedList.add((String)error.getList().toTerm());
        return this.factory.make(this.pattern_Error_Error, linkedList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Fatal makeError_Fatal(AFun aFun, ATerm[] aTermArray, ATermList aTermList) {
        errorapi.types.Error error = this.proto_Error_Fatal;
        synchronized (error) {
            this.proto_Error_Fatal.initHashCode(aTermList, aFun, aTermArray);
            return (Fatal)this.factory.build((SharedObject)this.proto_Error_Fatal);
        }
    }

    public Fatal makeError_Fatal(String string, SubjectList subjectList) {
        ATerm[] aTermArray = new ATerm[]{this.factory.makeAppl(this.factory.makeAFun(string, 0, true)), subjectList};
        return this.makeError_Fatal(this.fun_Error_Fatal, aTermArray, this.factory.getEmpty());
    }

    protected errorapi.types.Error Error_FatalFromTerm(ATerm aTerm) {
        List list = aTerm.match(this.pattern_Error_Fatal);
        if (list != null) {
            return this.makeError_Fatal((String)list.get(0), this.SubjectListFromTerm((ATerm)list.get(1)));
        }
        return null;
    }

    public ATerm toTerm(Fatal fatal) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(fatal.getDescription());
        linkedList.add((String)fatal.getList().toTerm());
        return this.factory.make(this.pattern_Error_Fatal, linkedList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Summary makeSummary_Summary(AFun aFun, ATerm[] aTermArray, ATermList aTermList) {
        errorapi.types.Summary summary = this.proto_Summary_Summary;
        synchronized (summary) {
            this.proto_Summary_Summary.initHashCode(aTermList, aFun, aTermArray);
            return (Summary)this.factory.build((SharedObject)this.proto_Summary_Summary);
        }
    }

    public Summary makeSummary_Summary(String string, String string2, ErrorList errorList) {
        ATerm[] aTermArray = new ATerm[]{this.factory.makeAppl(this.factory.makeAFun(string, 0, true)), this.factory.makeAppl(this.factory.makeAFun(string2, 0, true)), errorList};
        return this.makeSummary_Summary(this.fun_Summary_Summary, aTermArray, this.factory.getEmpty());
    }

    protected errorapi.types.Summary Summary_SummaryFromTerm(ATerm aTerm) {
        List list = aTerm.match(this.pattern_Summary_Summary);
        if (list != null) {
            return this.makeSummary_Summary((String)list.get(0), (String)list.get(1), this.ErrorListFromTerm((ATerm)list.get(2)));
        }
        return null;
    }

    public ATerm toTerm(Summary summary) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(summary.getProducer());
        linkedList.add(summary.getId());
        linkedList.add((String)summary.getList().toTerm());
        return this.factory.make(this.pattern_Summary_Summary, linkedList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File makeLocation_File(AFun aFun, ATerm[] aTermArray, ATermList aTermList) {
        Location location = this.proto_Location_File;
        synchronized (location) {
            this.proto_Location_File.initHashCode(aTermList, aFun, aTermArray);
            return (File)this.factory.build((SharedObject)this.proto_Location_File);
        }
    }

    public File makeLocation_File(String string) {
        ATerm[] aTermArray = new ATerm[]{this.factory.makeAppl(this.factory.makeAFun(string, 0, true))};
        return this.makeLocation_File(this.fun_Location_File, aTermArray, this.factory.getEmpty());
    }

    protected Location Location_FileFromTerm(ATerm aTerm) {
        List list = aTerm.match(this.pattern_Location_File);
        if (list != null) {
            return this.makeLocation_File((String)list.get(0));
        }
        return null;
    }

    public ATerm toTerm(File file) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(file.getFilename());
        return this.factory.make(this.pattern_Location_File, linkedList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public errorapi.types.location.Area makeLocation_Area(AFun aFun, ATerm[] aTermArray, ATermList aTermList) {
        Location location = this.proto_Location_Area;
        synchronized (location) {
            this.proto_Location_Area.initHashCode(aTermList, aFun, aTermArray);
            return (errorapi.types.location.Area)this.factory.build((SharedObject)this.proto_Location_Area);
        }
    }

    public errorapi.types.location.Area makeLocation_Area(Area area) {
        ATerm[] aTermArray = new ATerm[]{area};
        return this.makeLocation_Area(this.fun_Location_Area, aTermArray, this.factory.getEmpty());
    }

    protected Location Location_AreaFromTerm(ATerm aTerm) {
        List list = aTerm.match(this.pattern_Location_Area);
        if (list != null) {
            return this.makeLocation_Area(this.AreaFromTerm((ATerm)list.get(0)));
        }
        return null;
    }

    public ATerm toTerm(errorapi.types.location.Area area) {
        LinkedList<ATerm> linkedList = new LinkedList<ATerm>();
        linkedList.add(area.getArea().toTerm());
        return this.factory.make(this.pattern_Location_Area, linkedList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AreaInFile makeLocation_AreaInFile(AFun aFun, ATerm[] aTermArray, ATermList aTermList) {
        Location location = this.proto_Location_AreaInFile;
        synchronized (location) {
            this.proto_Location_AreaInFile.initHashCode(aTermList, aFun, aTermArray);
            return (AreaInFile)this.factory.build((SharedObject)this.proto_Location_AreaInFile);
        }
    }

    public AreaInFile makeLocation_AreaInFile(String string, Area area) {
        ATerm[] aTermArray = new ATerm[]{this.factory.makeAppl(this.factory.makeAFun(string, 0, true)), area};
        return this.makeLocation_AreaInFile(this.fun_Location_AreaInFile, aTermArray, this.factory.getEmpty());
    }

    protected Location Location_AreaInFileFromTerm(ATerm aTerm) {
        List list = aTerm.match(this.pattern_Location_AreaInFile);
        if (list != null) {
            return this.makeLocation_AreaInFile((String)list.get(0), this.AreaFromTerm((ATerm)list.get(1)));
        }
        return null;
    }

    public ATerm toTerm(AreaInFile areaInFile) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(areaInFile.getFilename());
        linkedList.add((String)areaInFile.getArea().toTerm());
        return this.factory.make(this.pattern_Location_AreaInFile, linkedList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public errorapi.types.area.Area makeArea_Area(AFun aFun, ATerm[] aTermArray, ATermList aTermList) {
        Area area = this.proto_Area_Area;
        synchronized (area) {
            this.proto_Area_Area.initHashCode(aTermList, aFun, aTermArray);
            return (errorapi.types.area.Area)this.factory.build((SharedObject)this.proto_Area_Area);
        }
    }

    public errorapi.types.area.Area makeArea_Area(int n, int n2, int n3, int n4, int n5, int n6) {
        ATerm[] aTermArray = new ATerm[]{this.factory.makeInt(n), this.factory.makeInt(n2), this.factory.makeInt(n3), this.factory.makeInt(n4), this.factory.makeInt(n5), this.factory.makeInt(n6)};
        return this.makeArea_Area(this.fun_Area_Area, aTermArray, this.factory.getEmpty());
    }

    protected Area Area_AreaFromTerm(ATerm aTerm) {
        List list = aTerm.match(this.pattern_Area_Area);
        if (list != null) {
            return this.makeArea_Area((Integer)list.get(0), (Integer)list.get(1), (Integer)list.get(2), (Integer)list.get(3), (Integer)list.get(4), (Integer)list.get(5));
        }
        return null;
    }

    public ATerm toTerm(errorapi.types.area.Area area) {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        linkedList.add(new Integer(area.getBeginLine()));
        linkedList.add(new Integer(area.getBeginColumn()));
        linkedList.add(new Integer(area.getEndLine()));
        linkedList.add(new Integer(area.getEndColumn()));
        linkedList.add(new Integer(area.getOffset()));
        linkedList.add(new Integer(area.getLength()));
        return this.factory.make(this.pattern_Area_Area, linkedList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Slice makeSlice_Slice(AFun aFun, ATerm[] aTermArray, ATermList aTermList) {
        errorapi.types.Slice slice = this.proto_Slice_Slice;
        synchronized (slice) {
            this.proto_Slice_Slice.initHashCode(aTermList, aFun, aTermArray);
            return (Slice)this.factory.build((SharedObject)this.proto_Slice_Slice);
        }
    }

    public Slice makeSlice_Slice(String string, AreaAreas areaAreas) {
        ATerm[] aTermArray = new ATerm[]{this.factory.makeAppl(this.factory.makeAFun(string, 0, true)), areaAreas};
        return this.makeSlice_Slice(this.fun_Slice_Slice, aTermArray, this.factory.getEmpty());
    }

    protected errorapi.types.Slice Slice_SliceFromTerm(ATerm aTerm) {
        List list = aTerm.match(this.pattern_Slice_Slice);
        if (list != null) {
            return this.makeSlice_Slice((String)list.get(0), this.AreaAreasFromTerm((ATerm)list.get(1)));
        }
        return null;
    }

    public ATerm toTerm(Slice slice) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(slice.getId());
        linkedList.add((String)slice.getAreas().toTerm());
        return this.factory.make(this.pattern_Slice_Slice, linkedList);
    }

    public SubjectList makeSubjectList() {
        return this.empty_SubjectList;
    }

    public SubjectList makeSubjectList(errorapi.types.Subject subject) {
        return this.makeSubjectList(subject, this.empty_SubjectList);
    }

    public SubjectList makeSubjectList(errorapi.types.Subject subject, SubjectList subjectList) {
        return this.makeSubjectList((ATerm)subject, (ATermList)subjectList, this.factory.getEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubjectList makeSubjectList(ATerm aTerm, ATermList aTermList, ATermList aTermList2) {
        SubjectList subjectList = this.proto_SubjectList;
        synchronized (subjectList) {
            this.proto_SubjectList.initHashCode(aTermList2, aTerm, aTermList);
            return (SubjectList)this.factory.build((SharedObject)this.proto_SubjectList);
        }
    }

    public SubjectList makeSubjectList(errorapi.types.Subject subject, errorapi.types.Subject subject2) {
        return this.makeSubjectList(subject, this.makeSubjectList(subject2));
    }

    public SubjectList makeSubjectList(errorapi.types.Subject subject, errorapi.types.Subject subject2, errorapi.types.Subject subject3) {
        return this.makeSubjectList(subject, this.makeSubjectList(subject2, subject3));
    }

    public SubjectList makeSubjectList(errorapi.types.Subject subject, errorapi.types.Subject subject2, errorapi.types.Subject subject3, errorapi.types.Subject subject4) {
        return this.makeSubjectList(subject, this.makeSubjectList(subject2, subject3, subject4));
    }

    public SubjectList makeSubjectList(errorapi.types.Subject subject, errorapi.types.Subject subject2, errorapi.types.Subject subject3, errorapi.types.Subject subject4, errorapi.types.Subject subject5) {
        return this.makeSubjectList(subject, this.makeSubjectList(subject2, subject3, subject4, subject5));
    }

    public SubjectList makeSubjectList(errorapi.types.Subject subject, errorapi.types.Subject subject2, errorapi.types.Subject subject3, errorapi.types.Subject subject4, errorapi.types.Subject subject5, errorapi.types.Subject subject6) {
        return this.makeSubjectList(subject, this.makeSubjectList(subject2, subject3, subject4, subject5, subject6));
    }

    public SubjectList reverse(SubjectList subjectList) {
        SubjectList subjectList2 = this.makeSubjectList();
        while (!subjectList.isEmpty()) {
            subjectList2 = this.makeSubjectList(subjectList.getHead(), subjectList2);
            subjectList = subjectList.getTail();
        }
        return subjectList2;
    }

    public SubjectList concat(SubjectList subjectList, SubjectList subjectList2) {
        SubjectList subjectList3 = subjectList2;
        SubjectList subjectList4 = this.reverse(subjectList);
        while (!subjectList4.isEmpty()) {
            subjectList3 = this.makeSubjectList(subjectList4.getHead(), subjectList3);
            subjectList4 = subjectList4.getTail();
        }
        return subjectList3;
    }

    public SubjectList append(SubjectList subjectList, errorapi.types.Subject subject) {
        return this.concat(subjectList, this.makeSubjectList(subject));
    }

    public ErrorList makeErrorList() {
        return this.empty_ErrorList;
    }

    public ErrorList makeErrorList(errorapi.types.Error error) {
        return this.makeErrorList(error, this.empty_ErrorList);
    }

    public ErrorList makeErrorList(errorapi.types.Error error, ErrorList errorList) {
        return this.makeErrorList((ATerm)error, (ATermList)errorList, this.factory.getEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ErrorList makeErrorList(ATerm aTerm, ATermList aTermList, ATermList aTermList2) {
        ErrorList errorList = this.proto_ErrorList;
        synchronized (errorList) {
            this.proto_ErrorList.initHashCode(aTermList2, aTerm, aTermList);
            return (ErrorList)this.factory.build((SharedObject)this.proto_ErrorList);
        }
    }

    public ErrorList makeErrorList(errorapi.types.Error error, errorapi.types.Error error2) {
        return this.makeErrorList(error, this.makeErrorList(error2));
    }

    public ErrorList makeErrorList(errorapi.types.Error error, errorapi.types.Error error2, errorapi.types.Error error3) {
        return this.makeErrorList(error, this.makeErrorList(error2, error3));
    }

    public ErrorList makeErrorList(errorapi.types.Error error, errorapi.types.Error error2, errorapi.types.Error error3, errorapi.types.Error error4) {
        return this.makeErrorList(error, this.makeErrorList(error2, error3, error4));
    }

    public ErrorList makeErrorList(errorapi.types.Error error, errorapi.types.Error error2, errorapi.types.Error error3, errorapi.types.Error error4, errorapi.types.Error error5) {
        return this.makeErrorList(error, this.makeErrorList(error2, error3, error4, error5));
    }

    public ErrorList makeErrorList(errorapi.types.Error error, errorapi.types.Error error2, errorapi.types.Error error3, errorapi.types.Error error4, errorapi.types.Error error5, errorapi.types.Error error6) {
        return this.makeErrorList(error, this.makeErrorList(error2, error3, error4, error5, error6));
    }

    public ErrorList reverse(ErrorList errorList) {
        ErrorList errorList2 = this.makeErrorList();
        while (!errorList.isEmpty()) {
            errorList2 = this.makeErrorList(errorList.getHead(), errorList2);
            errorList = errorList.getTail();
        }
        return errorList2;
    }

    public ErrorList concat(ErrorList errorList, ErrorList errorList2) {
        ErrorList errorList3 = errorList2;
        ErrorList errorList4 = this.reverse(errorList);
        while (!errorList4.isEmpty()) {
            errorList3 = this.makeErrorList(errorList4.getHead(), errorList3);
            errorList4 = errorList4.getTail();
        }
        return errorList3;
    }

    public ErrorList append(ErrorList errorList, errorapi.types.Error error) {
        return this.concat(errorList, this.makeErrorList(error));
    }

    public AreaAreas makeAreaAreas() {
        return this.empty_AreaAreas;
    }

    public AreaAreas makeAreaAreas(Area area) {
        return this.makeAreaAreas(area, this.empty_AreaAreas);
    }

    public AreaAreas makeAreaAreas(Area area, AreaAreas areaAreas) {
        return this.makeAreaAreas((ATerm)area, (ATermList)areaAreas, this.factory.getEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AreaAreas makeAreaAreas(ATerm aTerm, ATermList aTermList, ATermList aTermList2) {
        AreaAreas areaAreas = this.proto_AreaAreas;
        synchronized (areaAreas) {
            this.proto_AreaAreas.initHashCode(aTermList2, aTerm, aTermList);
            return (AreaAreas)this.factory.build((SharedObject)this.proto_AreaAreas);
        }
    }

    public AreaAreas makeAreaAreas(Area area, Area area2) {
        return this.makeAreaAreas(area, this.makeAreaAreas(area2));
    }

    public AreaAreas makeAreaAreas(Area area, Area area2, Area area3) {
        return this.makeAreaAreas(area, this.makeAreaAreas(area2, area3));
    }

    public AreaAreas makeAreaAreas(Area area, Area area2, Area area3, Area area4) {
        return this.makeAreaAreas(area, this.makeAreaAreas(area2, area3, area4));
    }

    public AreaAreas makeAreaAreas(Area area, Area area2, Area area3, Area area4, Area area5) {
        return this.makeAreaAreas(area, this.makeAreaAreas(area2, area3, area4, area5));
    }

    public AreaAreas makeAreaAreas(Area area, Area area2, Area area3, Area area4, Area area5, Area area6) {
        return this.makeAreaAreas(area, this.makeAreaAreas(area2, area3, area4, area5, area6));
    }

    public AreaAreas reverse(AreaAreas areaAreas) {
        AreaAreas areaAreas2 = this.makeAreaAreas();
        while (!areaAreas.isEmpty()) {
            areaAreas2 = this.makeAreaAreas(areaAreas.getHead(), areaAreas2);
            areaAreas = areaAreas.getTail();
        }
        return areaAreas2;
    }

    public AreaAreas concat(AreaAreas areaAreas, AreaAreas areaAreas2) {
        AreaAreas areaAreas3 = areaAreas2;
        AreaAreas areaAreas4 = this.reverse(areaAreas);
        while (!areaAreas4.isEmpty()) {
            areaAreas3 = this.makeAreaAreas(areaAreas4.getHead(), areaAreas3);
            areaAreas4 = areaAreas4.getTail();
        }
        return areaAreas3;
    }

    public AreaAreas append(AreaAreas areaAreas, Area area) {
        return this.concat(areaAreas, this.makeAreaAreas(area));
    }

    public StrChar StrCharFromTerm(ATerm aTerm) {
        StrChar strChar = this.StrChar_StrCharFromTerm(aTerm);
        if (strChar != null) {
            return strChar;
        }
        throw new IllegalArgumentException("This is not a StrChar: " + aTerm);
    }

    public StrCon StrConFromTerm(ATerm aTerm) {
        StrCon strCon = this.StrCon_StrConFromTerm(aTerm);
        if (strCon != null) {
            return strCon;
        }
        throw new IllegalArgumentException("This is not a StrCon: " + aTerm);
    }

    public NatCon NatConFromTerm(ATerm aTerm) {
        NatCon natCon = this.NatCon_NatConFromTerm(aTerm);
        if (natCon != null) {
            return natCon;
        }
        throw new IllegalArgumentException("This is not a NatCon: " + aTerm);
    }

    public errorapi.types.Subject SubjectFromTerm(ATerm aTerm) {
        errorapi.types.Subject subject = this.Subject_SubjectFromTerm(aTerm);
        if (subject != null) {
            return subject;
        }
        subject = this.Subject_LocalizedFromTerm(aTerm);
        if (subject != null) {
            return subject;
        }
        throw new IllegalArgumentException("This is not a Subject: " + aTerm);
    }

    public errorapi.types.Error ErrorFromTerm(ATerm aTerm) {
        errorapi.types.Error error = this.Error_InfoFromTerm(aTerm);
        if (error != null) {
            return error;
        }
        error = this.Error_WarningFromTerm(aTerm);
        if (error != null) {
            return error;
        }
        error = this.Error_ErrorFromTerm(aTerm);
        if (error != null) {
            return error;
        }
        error = this.Error_FatalFromTerm(aTerm);
        if (error != null) {
            return error;
        }
        throw new IllegalArgumentException("This is not a Error: " + aTerm);
    }

    public errorapi.types.Summary SummaryFromTerm(ATerm aTerm) {
        errorapi.types.Summary summary = this.Summary_SummaryFromTerm(aTerm);
        if (summary != null) {
            return summary;
        }
        throw new IllegalArgumentException("This is not a Summary: " + aTerm);
    }

    public SubjectList SubjectListFromTerm(ATerm aTerm) {
        if (aTerm instanceof ATermList) {
            ATermList aTermList = ((ATermList)aTerm).reverse();
            SubjectList subjectList = this.makeSubjectList();
            while (!aTermList.isEmpty()) {
                errorapi.types.Subject subject = this.SubjectFromTerm(aTermList.getFirst());
                subjectList = this.makeSubjectList(subject, subjectList);
                aTermList = aTermList.getNext();
            }
            return subjectList;
        }
        throw new RuntimeException("This is not a SubjectList: " + aTerm);
    }

    public ErrorList ErrorListFromTerm(ATerm aTerm) {
        if (aTerm instanceof ATermList) {
            ATermList aTermList = ((ATermList)aTerm).reverse();
            ErrorList errorList = this.makeErrorList();
            while (!aTermList.isEmpty()) {
                errorapi.types.Error error = this.ErrorFromTerm(aTermList.getFirst());
                errorList = this.makeErrorList(error, errorList);
                aTermList = aTermList.getNext();
            }
            return errorList;
        }
        throw new RuntimeException("This is not a ErrorList: " + aTerm);
    }

    public Location LocationFromTerm(ATerm aTerm) {
        Location location = this.Location_FileFromTerm(aTerm);
        if (location != null) {
            return location;
        }
        location = this.Location_AreaFromTerm(aTerm);
        if (location != null) {
            return location;
        }
        location = this.Location_AreaInFileFromTerm(aTerm);
        if (location != null) {
            return location;
        }
        throw new IllegalArgumentException("This is not a Location: " + aTerm);
    }

    public Area AreaFromTerm(ATerm aTerm) {
        Area area = this.Area_AreaFromTerm(aTerm);
        if (area != null) {
            return area;
        }
        throw new IllegalArgumentException("This is not a Area: " + aTerm);
    }

    public errorapi.types.Slice SliceFromTerm(ATerm aTerm) {
        errorapi.types.Slice slice = this.Slice_SliceFromTerm(aTerm);
        if (slice != null) {
            return slice;
        }
        throw new IllegalArgumentException("This is not a Slice: " + aTerm);
    }

    public AreaAreas AreaAreasFromTerm(ATerm aTerm) {
        if (aTerm instanceof ATermList) {
            ATermList aTermList = ((ATermList)aTerm).reverse();
            AreaAreas areaAreas = this.makeAreaAreas();
            while (!aTermList.isEmpty()) {
                Area area = this.AreaFromTerm(aTermList.getFirst());
                areaAreas = this.makeAreaAreas(area, areaAreas);
                aTermList = aTermList.getNext();
            }
            return areaAreas;
        }
        throw new RuntimeException("This is not a AreaAreas: " + aTerm);
    }

    public StrChar StrCharFromString(String string) {
        return this.StrCharFromTerm(this.factory.parse(string));
    }

    public StrChar StrCharFromFile(InputStream inputStream) throws IOException {
        return this.StrCharFromTerm(this.factory.readFromFile(inputStream));
    }

    public StrCon StrConFromString(String string) {
        return this.StrConFromTerm(this.factory.parse(string));
    }

    public StrCon StrConFromFile(InputStream inputStream) throws IOException {
        return this.StrConFromTerm(this.factory.readFromFile(inputStream));
    }

    public NatCon NatConFromString(String string) {
        return this.NatConFromTerm(this.factory.parse(string));
    }

    public NatCon NatConFromFile(InputStream inputStream) throws IOException {
        return this.NatConFromTerm(this.factory.readFromFile(inputStream));
    }

    public errorapi.types.Subject SubjectFromString(String string) {
        return this.SubjectFromTerm(this.factory.parse(string));
    }

    public errorapi.types.Subject SubjectFromFile(InputStream inputStream) throws IOException {
        return this.SubjectFromTerm(this.factory.readFromFile(inputStream));
    }

    public errorapi.types.Error ErrorFromString(String string) {
        return this.ErrorFromTerm(this.factory.parse(string));
    }

    public errorapi.types.Error ErrorFromFile(InputStream inputStream) throws IOException {
        return this.ErrorFromTerm(this.factory.readFromFile(inputStream));
    }

    public errorapi.types.Summary SummaryFromString(String string) {
        return this.SummaryFromTerm(this.factory.parse(string));
    }

    public errorapi.types.Summary SummaryFromFile(InputStream inputStream) throws IOException {
        return this.SummaryFromTerm(this.factory.readFromFile(inputStream));
    }

    public SubjectList SubjectListFromString(String string) {
        return this.SubjectListFromTerm(this.factory.parse(string));
    }

    public SubjectList SubjectListFromFile(InputStream inputStream) throws IOException {
        return this.SubjectListFromTerm(this.factory.readFromFile(inputStream));
    }

    public ErrorList ErrorListFromString(String string) {
        return this.ErrorListFromTerm(this.factory.parse(string));
    }

    public ErrorList ErrorListFromFile(InputStream inputStream) throws IOException {
        return this.ErrorListFromTerm(this.factory.readFromFile(inputStream));
    }

    public Location LocationFromString(String string) {
        return this.LocationFromTerm(this.factory.parse(string));
    }

    public Location LocationFromFile(InputStream inputStream) throws IOException {
        return this.LocationFromTerm(this.factory.readFromFile(inputStream));
    }

    public Area AreaFromString(String string) {
        return this.AreaFromTerm(this.factory.parse(string));
    }

    public Area AreaFromFile(InputStream inputStream) throws IOException {
        return this.AreaFromTerm(this.factory.readFromFile(inputStream));
    }

    public errorapi.types.Slice SliceFromString(String string) {
        return this.SliceFromTerm(this.factory.parse(string));
    }

    public errorapi.types.Slice SliceFromFile(InputStream inputStream) throws IOException {
        return this.SliceFromTerm(this.factory.readFromFile(inputStream));
    }

    public AreaAreas AreaAreasFromString(String string) {
        return this.AreaAreasFromTerm(this.factory.parse(string));
    }

    public AreaAreas AreaAreasFromFile(InputStream inputStream) throws IOException {
        return this.AreaAreasFromTerm(this.factory.readFromFile(inputStream));
    }

    public static String charsToString(ATerm aTerm) {
        ATermList aTermList = (ATermList)aTerm;
        StringBuffer stringBuffer = new StringBuffer();
        while (!aTermList.isEmpty()) {
            stringBuffer.append((char)((ATermInt)aTermList.getFirst()).getInt());
            aTermList = aTermList.getNext();
        }
        return stringBuffer.toString();
    }

    public static char charToByte(ATerm aTerm) {
        return (char)((ATermInt)aTerm).getInt();
    }

    public ATerm stringToChars(String string) {
        int n = string.length();
        byte[] byArray = string.getBytes();
        ATermList aTermList = this.getPureFactory().makeList();
        for (int i = n - 1; i >= 0; --i) {
            aTermList = aTermList.insert((ATerm)this.getPureFactory().makeInt((int)byArray[i]));
        }
        return aTermList;
    }

    public ATerm byteToChar(char c) {
        return this.getPureFactory().makeInt((int)c);
    }
}

