/*
 * This declarations of the PIC18F26K20 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2014.
 *
 * This file is generated automatically by the cinc2h.pl, 2014-03-09 13:32:38 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC18F26K20_H__
#define __PIC18F26K20_H__

//==============================================================================

//==============================================================================
//
//	Register Definitions
//
//==============================================================================


//==============================================================================
//        SSPMSK Bits

extern __at(0x0F77) __sfr SSPMSK;

typedef struct
  {
  unsigned MSK0                 : 1;
  unsigned MSK1                 : 1;
  unsigned MSK2                 : 1;
  unsigned MSK3                 : 1;
  unsigned MSK4                 : 1;
  unsigned MSK5                 : 1;
  unsigned MSK6                 : 1;
  unsigned MSK7                 : 1;
  } __SSPMSKbits_t;

extern __at(0x0F77) volatile __SSPMSKbits_t SSPMSKbits;

#define _MSK0                   0x01
#define _MSK1                   0x02
#define _MSK2                   0x04
#define _MSK3                   0x08
#define _MSK4                   0x10
#define _MSK5                   0x20
#define _MSK6                   0x40
#define _MSK7                   0x80

//==============================================================================


//==============================================================================
//        SLRCON Bits

extern __at(0x0F78) __sfr SLRCON;

typedef struct
  {
  unsigned SLRA                 : 1;
  unsigned SLRB                 : 1;
  unsigned SLRC                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __SLRCONbits_t;

extern __at(0x0F78) volatile __SLRCONbits_t SLRCONbits;

#define _SLRA                   0x01
#define _SLRB                   0x02
#define _SLRC                   0x04

//==============================================================================


//==============================================================================
//        CM2CON1 Bits

extern __at(0x0F79) __sfr CM2CON1;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned C2RSEL               : 1;
  unsigned C1RSEL               : 1;
  unsigned MC2OUT               : 1;
  unsigned MC1OUT               : 1;
  } __CM2CON1bits_t;

extern __at(0x0F79) volatile __CM2CON1bits_t CM2CON1bits;

#define _C2RSEL                 0x10
#define _C1RSEL                 0x20
#define _MC2OUT                 0x40
#define _MC1OUT                 0x80

//==============================================================================


//==============================================================================
//        CM2CON0 Bits

extern __at(0x0F7A) __sfr CM2CON0;

typedef union
  {
  struct
    {
    unsigned C2CH0              : 1;
    unsigned C2CH1              : 1;
    unsigned C2R                : 1;
    unsigned C2SP               : 1;
    unsigned C2POL              : 1;
    unsigned C2OE               : 1;
    unsigned C2OUT              : 1;
    unsigned C2ON               : 1;
    };

  struct
    {
    unsigned C2CH               : 2;
    unsigned                    : 6;
    };
  } __CM2CON0bits_t;

extern __at(0x0F7A) volatile __CM2CON0bits_t CM2CON0bits;

#define _C2CH0                  0x01
#define _C2CH1                  0x02
#define _C2R                    0x04
#define _C2SP                   0x08
#define _C2POL                  0x10
#define _C2OE                   0x20
#define _C2OUT                  0x40
#define _C2ON                   0x80

//==============================================================================


//==============================================================================
//        CM1CON0 Bits

extern __at(0x0F7B) __sfr CM1CON0;

typedef union
  {
  struct
    {
    unsigned C1CH0              : 1;
    unsigned C1CH1              : 1;
    unsigned C1R                : 1;
    unsigned C1SP               : 1;
    unsigned C1POL              : 1;
    unsigned C1OE               : 1;
    unsigned C1OUT              : 1;
    unsigned C1ON               : 1;
    };

  struct
    {
    unsigned C1CH               : 2;
    unsigned                    : 6;
    };
  } __CM1CON0bits_t;

extern __at(0x0F7B) volatile __CM1CON0bits_t CM1CON0bits;

#define _C1CH0                  0x01
#define _C1CH1                  0x02
#define _C1R                    0x04
#define _C1SP                   0x08
#define _C1POL                  0x10
#define _C1OE                   0x20
#define _C1OUT                  0x40
#define _C1ON                   0x80

//==============================================================================


//==============================================================================
//        WPUB Bits

extern __at(0x0F7C) __sfr WPUB;

typedef struct
  {
  unsigned WPUB0                : 1;
  unsigned WPUB1                : 1;
  unsigned WPUB2                : 1;
  unsigned WPUB3                : 1;
  unsigned WPUB4                : 1;
  unsigned WPUB5                : 1;
  unsigned WPUB6                : 1;
  unsigned WPUB7                : 1;
  } __WPUBbits_t;

extern __at(0x0F7C) volatile __WPUBbits_t WPUBbits;

#define _WPUB0                  0x01
#define _WPUB1                  0x02
#define _WPUB2                  0x04
#define _WPUB3                  0x08
#define _WPUB4                  0x10
#define _WPUB5                  0x20
#define _WPUB6                  0x40
#define _WPUB7                  0x80

//==============================================================================


//==============================================================================
//        IOCB Bits

extern __at(0x0F7D) __sfr IOCB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned IOCB4                : 1;
  unsigned IOCB5                : 1;
  unsigned IOCB6                : 1;
  unsigned IOCB7                : 1;
  } __IOCBbits_t;

extern __at(0x0F7D) volatile __IOCBbits_t IOCBbits;

#define _IOCB4                  0x10
#define _IOCB5                  0x20
#define _IOCB6                  0x40
#define _IOCB7                  0x80

//==============================================================================


//==============================================================================
//        ANSEL Bits

extern __at(0x0F7E) __sfr ANSEL;

typedef union
  {
  struct
    {
    unsigned ANS0               : 1;
    unsigned ANS1               : 1;
    unsigned ANS2               : 1;
    unsigned ANS3               : 1;
    unsigned ANS4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ANS                : 5;
    unsigned                    : 3;
    };
  } __ANSELbits_t;

extern __at(0x0F7E) volatile __ANSELbits_t ANSELbits;

#define _ANS0                   0x01
#define _ANS1                   0x02
#define _ANS2                   0x04
#define _ANS3                   0x08
#define _ANS4                   0x10

//==============================================================================


//==============================================================================
//        ANSELH Bits

extern __at(0x0F7F) __sfr ANSELH;

typedef struct
  {
  unsigned ANS8                 : 1;
  unsigned ANS9                 : 1;
  unsigned ANS10                : 1;
  unsigned ANS11                : 1;
  unsigned ANS12                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __ANSELHbits_t;

extern __at(0x0F7F) volatile __ANSELHbits_t ANSELHbits;

#define _ANS8                   0x01
#define _ANS9                   0x02
#define _ANS10                  0x04
#define _ANS11                  0x08
#define _ANS12                  0x10

//==============================================================================


//==============================================================================
//        PORTA Bits

extern __at(0x0F80) __sfr PORTA;

typedef union
  {
  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned RA6                : 1;
    unsigned RA7                : 1;
    };

  struct
    {
    unsigned AN0                : 1;
    unsigned AN1                : 1;
    unsigned AN2                : 1;
    unsigned AN3                : 1;
    unsigned C1OUT              : 1;
    unsigned AN4                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C12IN0M            : 1;
    unsigned C12IN1M            : 1;
    unsigned C2INP              : 1;
    unsigned C1INP              : 1;
    unsigned T0CKI              : 1;
    unsigned C2OUT              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C12IN0N            : 1;
    unsigned C12IN1N            : 1;
    unsigned VREFM              : 1;
    unsigned VREFP              : 1;
    unsigned                    : 1;
    unsigned SS                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned VREFN              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_SS             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CVREF              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LVDIN              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned HLVDIN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PORTAbits_t;

extern __at(0x0F80) volatile __PORTAbits_t PORTAbits;

#define _PORTA_RA0              0x01
#define _PORTA_AN0              0x01
#define _PORTA_C12IN0M          0x01
#define _PORTA_C12IN0N          0x01
#define _PORTA_RA1              0x02
#define _PORTA_AN1              0x02
#define _PORTA_C12IN1M          0x02
#define _PORTA_C12IN1N          0x02
#define _PORTA_RA2              0x04
#define _PORTA_AN2              0x04
#define _PORTA_C2INP            0x04
#define _PORTA_VREFM            0x04
#define _PORTA_VREFN            0x04
#define _PORTA_CVREF            0x04
#define _PORTA_RA3              0x08
#define _PORTA_AN3              0x08
#define _PORTA_C1INP            0x08
#define _PORTA_VREFP            0x08
#define _PORTA_RA4              0x10
#define _PORTA_C1OUT            0x10
#define _PORTA_T0CKI            0x10
#define _PORTA_RA5              0x20
#define _PORTA_AN4              0x20
#define _PORTA_C2OUT            0x20
#define _PORTA_SS               0x20
#define _PORTA_NOT_SS           0x20
#define _PORTA_LVDIN            0x20
#define _PORTA_HLVDIN           0x20
#define _PORTA_RA6              0x40
#define _PORTA_RA7              0x80

//==============================================================================


//==============================================================================
//        PORTB Bits

extern __at(0x0F81) __sfr PORTB;

typedef union
  {
  struct
    {
    unsigned RB0                : 1;
    unsigned RB1                : 1;
    unsigned RB2                : 1;
    unsigned RB3                : 1;
    unsigned RB4                : 1;
    unsigned RB5                : 1;
    unsigned RB6                : 1;
    unsigned RB7                : 1;
    };

  struct
    {
    unsigned INT0               : 1;
    unsigned INT1               : 1;
    unsigned INT2               : 1;
    unsigned CCP2               : 1;
    unsigned KBI0               : 1;
    unsigned KBI1               : 1;
    unsigned KBI2               : 1;
    unsigned KBI3               : 1;
    };

  struct
    {
    unsigned AN12               : 1;
    unsigned AN10               : 1;
    unsigned AN8                : 1;
    unsigned AN9                : 1;
    unsigned AN11               : 1;
    unsigned PGM                : 1;
    unsigned PGC                : 1;
    unsigned PGD                : 1;
    };

  struct
    {
    unsigned FLT0               : 1;
    unsigned C12IN3M            : 1;
    unsigned P1B                : 1;
    unsigned C12IN2M            : 1;
    unsigned P1D                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned C12IN3N            : 1;
    unsigned                    : 1;
    unsigned C12IN2N            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned P1C                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned INT                : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 4;
    unsigned KBI                : 4;
    };
  } __PORTBbits_t;

extern __at(0x0F81) volatile __PORTBbits_t PORTBbits;

#define _PORTB_RB0              0x01
#define _PORTB_INT0             0x01
#define _PORTB_AN12             0x01
#define _PORTB_FLT0             0x01
#define _PORTB_RB1              0x02
#define _PORTB_INT1             0x02
#define _PORTB_AN10             0x02
#define _PORTB_C12IN3M          0x02
#define _PORTB_C12IN3N          0x02
#define _PORTB_P1C              0x02
#define _PORTB_RB2              0x04
#define _PORTB_INT2             0x04
#define _PORTB_AN8              0x04
#define _PORTB_P1B              0x04
#define _PORTB_RB3              0x08
#define _PORTB_CCP2             0x08
#define _PORTB_AN9              0x08
#define _PORTB_C12IN2M          0x08
#define _PORTB_C12IN2N          0x08
#define _PORTB_RB4              0x10
#define _PORTB_KBI0             0x10
#define _PORTB_AN11             0x10
#define _PORTB_P1D              0x10
#define _PORTB_RB5              0x20
#define _PORTB_KBI1             0x20
#define _PORTB_PGM              0x20
#define _PORTB_RB6              0x40
#define _PORTB_KBI2             0x40
#define _PORTB_PGC              0x40
#define _PORTB_RB7              0x80
#define _PORTB_KBI3             0x80
#define _PORTB_PGD              0x80

//==============================================================================


//==============================================================================
//        PORTC Bits

extern __at(0x0F82) __sfr PORTC;

typedef union
  {
  struct
    {
    unsigned RC0                : 1;
    unsigned RC1                : 1;
    unsigned RC2                : 1;
    unsigned RC3                : 1;
    unsigned RC4                : 1;
    unsigned RC5                : 1;
    unsigned RC6                : 1;
    unsigned RC7                : 1;
    };

  struct
    {
    unsigned T1OSO              : 1;
    unsigned T1OSI              : 1;
    unsigned CCP1               : 1;
    unsigned SCK                : 1;
    unsigned SDI                : 1;
    unsigned SDO                : 1;
    unsigned TX                 : 1;
    unsigned RX                 : 1;
    };

  struct
    {
    unsigned T13CKI             : 1;
    unsigned CCP2               : 1;
    unsigned P1A                : 1;
    unsigned SCL                : 1;
    unsigned SDA                : 1;
    unsigned                    : 1;
    unsigned CK                 : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T1CKI              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T3CKI              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PORTCbits_t;

extern __at(0x0F82) volatile __PORTCbits_t PORTCbits;

#define _PORTC_RC0              0x01
#define _PORTC_T1OSO            0x01
#define _PORTC_T13CKI           0x01
#define _PORTC_T1CKI            0x01
#define _PORTC_T3CKI            0x01
#define _PORTC_RC1              0x02
#define _PORTC_T1OSI            0x02
#define _PORTC_CCP2             0x02
#define _PORTC_RC2              0x04
#define _PORTC_CCP1             0x04
#define _PORTC_P1A              0x04
#define _PORTC_RC3              0x08
#define _PORTC_SCK              0x08
#define _PORTC_SCL              0x08
#define _PORTC_RC4              0x10
#define _PORTC_SDI              0x10
#define _PORTC_SDA              0x10
#define _PORTC_RC5              0x20
#define _PORTC_SDO              0x20
#define _PORTC_RC6              0x40
#define _PORTC_TX               0x40
#define _PORTC_CK               0x40
#define _PORTC_RC7              0x80
#define _PORTC_RX               0x80

//==============================================================================


//==============================================================================
//        PORTE Bits

extern __at(0x0F84) __sfr PORTE;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RE3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned MCLR               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_MCLR           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned VPP                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PORTEbits_t;

extern __at(0x0F84) volatile __PORTEbits_t PORTEbits;

#define _RE3                    0x08
#define _MCLR                   0x08
#define _NOT_MCLR               0x08
#define _VPP                    0x08

//==============================================================================


//==============================================================================
//        LATA Bits

extern __at(0x0F89) __sfr LATA;

typedef struct
  {
  unsigned LATA0                : 1;
  unsigned LATA1                : 1;
  unsigned LATA2                : 1;
  unsigned LATA3                : 1;
  unsigned LATA4                : 1;
  unsigned LATA5                : 1;
  unsigned LATA6                : 1;
  unsigned LATA7                : 1;
  } __LATAbits_t;

extern __at(0x0F89) volatile __LATAbits_t LATAbits;

#define _LATA0                  0x01
#define _LATA1                  0x02
#define _LATA2                  0x04
#define _LATA3                  0x08
#define _LATA4                  0x10
#define _LATA5                  0x20
#define _LATA6                  0x40
#define _LATA7                  0x80

//==============================================================================


//==============================================================================
//        LATB Bits

extern __at(0x0F8A) __sfr LATB;

typedef struct
  {
  unsigned LATB0                : 1;
  unsigned LATB1                : 1;
  unsigned LATB2                : 1;
  unsigned LATB3                : 1;
  unsigned LATB4                : 1;
  unsigned LATB5                : 1;
  unsigned LATB6                : 1;
  unsigned LATB7                : 1;
  } __LATBbits_t;

extern __at(0x0F8A) volatile __LATBbits_t LATBbits;

#define _LATB0                  0x01
#define _LATB1                  0x02
#define _LATB2                  0x04
#define _LATB3                  0x08
#define _LATB4                  0x10
#define _LATB5                  0x20
#define _LATB6                  0x40
#define _LATB7                  0x80

//==============================================================================


//==============================================================================
//        LATC Bits

extern __at(0x0F8B) __sfr LATC;

typedef struct
  {
  unsigned LATC0                : 1;
  unsigned LATC1                : 1;
  unsigned LATC2                : 1;
  unsigned LATC3                : 1;
  unsigned LATC4                : 1;
  unsigned LATC5                : 1;
  unsigned LATC6                : 1;
  unsigned LATC7                : 1;
  } __LATCbits_t;

extern __at(0x0F8B) volatile __LATCbits_t LATCbits;

#define _LATC0                  0x01
#define _LATC1                  0x02
#define _LATC2                  0x04
#define _LATC3                  0x08
#define _LATC4                  0x10
#define _LATC5                  0x20
#define _LATC6                  0x40
#define _LATC7                  0x80

//==============================================================================


//==============================================================================
//        DDRA Bits

extern __at(0x0F92) __sfr DDRA;

typedef union
  {
  struct
    {
    unsigned TRISA0             : 1;
    unsigned TRISA1             : 1;
    unsigned TRISA2             : 1;
    unsigned TRISA3             : 1;
    unsigned TRISA4             : 1;
    unsigned TRISA5             : 1;
    unsigned TRISA6             : 1;
    unsigned TRISA7             : 1;
    };

  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned RA6                : 1;
    unsigned RA7                : 1;
    };
  } __DDRAbits_t;

extern __at(0x0F92) volatile __DDRAbits_t DDRAbits;

#define _TRISA0                 0x01
#define _RA0                    0x01
#define _TRISA1                 0x02
#define _RA1                    0x02
#define _TRISA2                 0x04
#define _RA2                    0x04
#define _TRISA3                 0x08
#define _RA3                    0x08
#define _TRISA4                 0x10
#define _RA4                    0x10
#define _TRISA5                 0x20
#define _RA5                    0x20
#define _TRISA6                 0x40
#define _RA6                    0x40
#define _TRISA7                 0x80
#define _RA7                    0x80

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x0F92) __sfr TRISA;

typedef union
  {
  struct
    {
    unsigned TRISA0             : 1;
    unsigned TRISA1             : 1;
    unsigned TRISA2             : 1;
    unsigned TRISA3             : 1;
    unsigned TRISA4             : 1;
    unsigned TRISA5             : 1;
    unsigned TRISA6             : 1;
    unsigned TRISA7             : 1;
    };

  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned RA6                : 1;
    unsigned RA7                : 1;
    };
  } __TRISAbits_t;

extern __at(0x0F92) volatile __TRISAbits_t TRISAbits;

#define _TRISA_TRISA0           0x01
#define _TRISA_RA0              0x01
#define _TRISA_TRISA1           0x02
#define _TRISA_RA1              0x02
#define _TRISA_TRISA2           0x04
#define _TRISA_RA2              0x04
#define _TRISA_TRISA3           0x08
#define _TRISA_RA3              0x08
#define _TRISA_TRISA4           0x10
#define _TRISA_RA4              0x10
#define _TRISA_TRISA5           0x20
#define _TRISA_RA5              0x20
#define _TRISA_TRISA6           0x40
#define _TRISA_RA6              0x40
#define _TRISA_TRISA7           0x80
#define _TRISA_RA7              0x80

//==============================================================================


//==============================================================================
//        DDRB Bits

extern __at(0x0F93) __sfr DDRB;

typedef union
  {
  struct
    {
    unsigned TRISB0             : 1;
    unsigned TRISB1             : 1;
    unsigned TRISB2             : 1;
    unsigned TRISB3             : 1;
    unsigned TRISB4             : 1;
    unsigned TRISB5             : 1;
    unsigned TRISB6             : 1;
    unsigned TRISB7             : 1;
    };

  struct
    {
    unsigned RB0                : 1;
    unsigned RB1                : 1;
    unsigned RB2                : 1;
    unsigned RB3                : 1;
    unsigned RB4                : 1;
    unsigned RB5                : 1;
    unsigned RB6                : 1;
    unsigned RB7                : 1;
    };
  } __DDRBbits_t;

extern __at(0x0F93) volatile __DDRBbits_t DDRBbits;

#define _TRISB0                 0x01
#define _RB0                    0x01
#define _TRISB1                 0x02
#define _RB1                    0x02
#define _TRISB2                 0x04
#define _RB2                    0x04
#define _TRISB3                 0x08
#define _RB3                    0x08
#define _TRISB4                 0x10
#define _RB4                    0x10
#define _TRISB5                 0x20
#define _RB5                    0x20
#define _TRISB6                 0x40
#define _RB6                    0x40
#define _TRISB7                 0x80
#define _RB7                    0x80

//==============================================================================


//==============================================================================
//        TRISB Bits

extern __at(0x0F93) __sfr TRISB;

typedef union
  {
  struct
    {
    unsigned TRISB0             : 1;
    unsigned TRISB1             : 1;
    unsigned TRISB2             : 1;
    unsigned TRISB3             : 1;
    unsigned TRISB4             : 1;
    unsigned TRISB5             : 1;
    unsigned TRISB6             : 1;
    unsigned TRISB7             : 1;
    };

  struct
    {
    unsigned RB0                : 1;
    unsigned RB1                : 1;
    unsigned RB2                : 1;
    unsigned RB3                : 1;
    unsigned RB4                : 1;
    unsigned RB5                : 1;
    unsigned RB6                : 1;
    unsigned RB7                : 1;
    };
  } __TRISBbits_t;

extern __at(0x0F93) volatile __TRISBbits_t TRISBbits;

#define _TRISB_TRISB0           0x01
#define _TRISB_RB0              0x01
#define _TRISB_TRISB1           0x02
#define _TRISB_RB1              0x02
#define _TRISB_TRISB2           0x04
#define _TRISB_RB2              0x04
#define _TRISB_TRISB3           0x08
#define _TRISB_RB3              0x08
#define _TRISB_TRISB4           0x10
#define _TRISB_RB4              0x10
#define _TRISB_TRISB5           0x20
#define _TRISB_RB5              0x20
#define _TRISB_TRISB6           0x40
#define _TRISB_RB6              0x40
#define _TRISB_TRISB7           0x80
#define _TRISB_RB7              0x80

//==============================================================================


//==============================================================================
//        DDRC Bits

extern __at(0x0F94) __sfr DDRC;

typedef union
  {
  struct
    {
    unsigned TRISC0             : 1;
    unsigned TRISC1             : 1;
    unsigned TRISC2             : 1;
    unsigned TRISC3             : 1;
    unsigned TRISC4             : 1;
    unsigned TRISC5             : 1;
    unsigned TRISC6             : 1;
    unsigned TRISC7             : 1;
    };

  struct
    {
    unsigned RC0                : 1;
    unsigned RC1                : 1;
    unsigned RC2                : 1;
    unsigned RC3                : 1;
    unsigned RC4                : 1;
    unsigned RC5                : 1;
    unsigned RC6                : 1;
    unsigned RC7                : 1;
    };
  } __DDRCbits_t;

extern __at(0x0F94) volatile __DDRCbits_t DDRCbits;

#define _TRISC0                 0x01
#define _RC0                    0x01
#define _TRISC1                 0x02
#define _RC1                    0x02
#define _TRISC2                 0x04
#define _RC2                    0x04
#define _TRISC3                 0x08
#define _RC3                    0x08
#define _TRISC4                 0x10
#define _RC4                    0x10
#define _TRISC5                 0x20
#define _RC5                    0x20
#define _TRISC6                 0x40
#define _RC6                    0x40
#define _TRISC7                 0x80
#define _RC7                    0x80

//==============================================================================


//==============================================================================
//        TRISC Bits

extern __at(0x0F94) __sfr TRISC;

typedef union
  {
  struct
    {
    unsigned TRISC0             : 1;
    unsigned TRISC1             : 1;
    unsigned TRISC2             : 1;
    unsigned TRISC3             : 1;
    unsigned TRISC4             : 1;
    unsigned TRISC5             : 1;
    unsigned TRISC6             : 1;
    unsigned TRISC7             : 1;
    };

  struct
    {
    unsigned RC0                : 1;
    unsigned RC1                : 1;
    unsigned RC2                : 1;
    unsigned RC3                : 1;
    unsigned RC4                : 1;
    unsigned RC5                : 1;
    unsigned RC6                : 1;
    unsigned RC7                : 1;
    };
  } __TRISCbits_t;

extern __at(0x0F94) volatile __TRISCbits_t TRISCbits;

#define _TRISC_TRISC0           0x01
#define _TRISC_RC0              0x01
#define _TRISC_TRISC1           0x02
#define _TRISC_RC1              0x02
#define _TRISC_TRISC2           0x04
#define _TRISC_RC2              0x04
#define _TRISC_TRISC3           0x08
#define _TRISC_RC3              0x08
#define _TRISC_TRISC4           0x10
#define _TRISC_RC4              0x10
#define _TRISC_TRISC5           0x20
#define _TRISC_RC5              0x20
#define _TRISC_TRISC6           0x40
#define _TRISC_RC6              0x40
#define _TRISC_TRISC7           0x80
#define _TRISC_RC7              0x80

//==============================================================================


//==============================================================================
//        OSCTUNE Bits

extern __at(0x0F9B) __sfr OSCTUNE;

typedef union
  {
  struct
    {
    unsigned TUN0               : 1;
    unsigned TUN1               : 1;
    unsigned TUN2               : 1;
    unsigned TUN3               : 1;
    unsigned TUN4               : 1;
    unsigned TUN5               : 1;
    unsigned PLLEN              : 1;
    unsigned INTSRC             : 1;
    };

  struct
    {
    unsigned TUN                : 6;
    unsigned                    : 2;
    };
  } __OSCTUNEbits_t;

extern __at(0x0F9B) volatile __OSCTUNEbits_t OSCTUNEbits;

#define _TUN0                   0x01
#define _TUN1                   0x02
#define _TUN2                   0x04
#define _TUN3                   0x08
#define _TUN4                   0x10
#define _TUN5                   0x20
#define _PLLEN                  0x40
#define _INTSRC                 0x80

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x0F9D) __sfr PIE1;

typedef struct
  {
  unsigned TMR1IE               : 1;
  unsigned TMR2IE               : 1;
  unsigned CCP1IE               : 1;
  unsigned SSPIE                : 1;
  unsigned TXIE                 : 1;
  unsigned RCIE                 : 1;
  unsigned ADIE                 : 1;
  unsigned                      : 1;
  } __PIE1bits_t;

extern __at(0x0F9D) volatile __PIE1bits_t PIE1bits;

#define _TMR1IE                 0x01
#define _TMR2IE                 0x02
#define _CCP1IE                 0x04
#define _SSPIE                  0x08
#define _TXIE                   0x10
#define _RCIE                   0x20
#define _ADIE                   0x40

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x0F9E) __sfr PIR1;

typedef struct
  {
  unsigned TMR1IF               : 1;
  unsigned TMR2IF               : 1;
  unsigned CCP1IF               : 1;
  unsigned SSPIF                : 1;
  unsigned TXIF                 : 1;
  unsigned RCIF                 : 1;
  unsigned ADIF                 : 1;
  unsigned                      : 1;
  } __PIR1bits_t;

extern __at(0x0F9E) volatile __PIR1bits_t PIR1bits;

#define _TMR1IF                 0x01
#define _TMR2IF                 0x02
#define _CCP1IF                 0x04
#define _SSPIF                  0x08
#define _TXIF                   0x10
#define _RCIF                   0x20
#define _ADIF                   0x40

//==============================================================================


//==============================================================================
//        IPR1 Bits

extern __at(0x0F9F) __sfr IPR1;

typedef struct
  {
  unsigned TMR1IP               : 1;
  unsigned TMR2IP               : 1;
  unsigned CCP1IP               : 1;
  unsigned SSPIP                : 1;
  unsigned TXIP                 : 1;
  unsigned RCIP                 : 1;
  unsigned ADIP                 : 1;
  unsigned                      : 1;
  } __IPR1bits_t;

extern __at(0x0F9F) volatile __IPR1bits_t IPR1bits;

#define _TMR1IP                 0x01
#define _TMR2IP                 0x02
#define _CCP1IP                 0x04
#define _SSPIP                  0x08
#define _TXIP                   0x10
#define _RCIP                   0x20
#define _ADIP                   0x40

//==============================================================================


//==============================================================================
//        PIE2 Bits

extern __at(0x0FA0) __sfr PIE2;

typedef union
  {
  struct
    {
    unsigned CCP2IE             : 1;
    unsigned TMR3IE             : 1;
    unsigned HLVDIE             : 1;
    unsigned BCLIE              : 1;
    unsigned EEIE               : 1;
    unsigned C2IE               : 1;
    unsigned C1IE               : 1;
    unsigned OSCFIE             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LVDIE              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIE2bits_t;

extern __at(0x0FA0) volatile __PIE2bits_t PIE2bits;

#define _CCP2IE                 0x01
#define _TMR3IE                 0x02
#define _HLVDIE                 0x04
#define _LVDIE                  0x04
#define _BCLIE                  0x08
#define _EEIE                   0x10
#define _C2IE                   0x20
#define _C1IE                   0x40
#define _OSCFIE                 0x80

//==============================================================================


//==============================================================================
//        PIR2 Bits

extern __at(0x0FA1) __sfr PIR2;

typedef union
  {
  struct
    {
    unsigned CCP2IF             : 1;
    unsigned TMR3IF             : 1;
    unsigned HLVDIF             : 1;
    unsigned BCLIF              : 1;
    unsigned EEIF               : 1;
    unsigned C2IF               : 1;
    unsigned C1IF               : 1;
    unsigned OSCFIF             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LVDIF              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIR2bits_t;

extern __at(0x0FA1) volatile __PIR2bits_t PIR2bits;

#define _CCP2IF                 0x01
#define _TMR3IF                 0x02
#define _HLVDIF                 0x04
#define _LVDIF                  0x04
#define _BCLIF                  0x08
#define _EEIF                   0x10
#define _C2IF                   0x20
#define _C1IF                   0x40
#define _OSCFIF                 0x80

//==============================================================================


//==============================================================================
//        IPR2 Bits

extern __at(0x0FA2) __sfr IPR2;

typedef union
  {
  struct
    {
    unsigned CCP2IP             : 1;
    unsigned TMR3IP             : 1;
    unsigned HLVDIP             : 1;
    unsigned BCLIP              : 1;
    unsigned EEIP               : 1;
    unsigned C2IP               : 1;
    unsigned C1IP               : 1;
    unsigned OSCFIP             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LVDIP              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __IPR2bits_t;

extern __at(0x0FA2) volatile __IPR2bits_t IPR2bits;

#define _CCP2IP                 0x01
#define _TMR3IP                 0x02
#define _HLVDIP                 0x04
#define _LVDIP                  0x04
#define _BCLIP                  0x08
#define _EEIP                   0x10
#define _C2IP                   0x20
#define _C1IP                   0x40
#define _OSCFIP                 0x80

//==============================================================================


//==============================================================================
//        EECON1 Bits

extern __at(0x0FA6) __sfr EECON1;

typedef struct
  {
  unsigned RD                   : 1;
  unsigned WR                   : 1;
  unsigned WREN                 : 1;
  unsigned WRERR                : 1;
  unsigned FREE                 : 1;
  unsigned                      : 1;
  unsigned CFGS                 : 1;
  unsigned EEPGD                : 1;
  } __EECON1bits_t;

extern __at(0x0FA6) volatile __EECON1bits_t EECON1bits;

#define _RD                     0x01
#define _WR                     0x02
#define _WREN                   0x04
#define _WRERR                  0x08
#define _FREE                   0x10
#define _CFGS                   0x40
#define _EEPGD                  0x80

//==============================================================================

extern __at(0x0FA7) __sfr EECON2;
extern __at(0x0FA8) __sfr EEDATA;

//==============================================================================
//        EEADR Bits

extern __at(0x0FA9) __sfr EEADR;

typedef struct
  {
  unsigned EEADR0               : 1;
  unsigned EEADR1               : 1;
  unsigned EEADR2               : 1;
  unsigned EEADR3               : 1;
  unsigned EEADR4               : 1;
  unsigned EEADR5               : 1;
  unsigned EEADR6               : 1;
  unsigned EEADR7               : 1;
  } __EEADRbits_t;

extern __at(0x0FA9) volatile __EEADRbits_t EEADRbits;

#define _EEADR0                 0x01
#define _EEADR1                 0x02
#define _EEADR2                 0x04
#define _EEADR3                 0x08
#define _EEADR4                 0x10
#define _EEADR5                 0x20
#define _EEADR6                 0x40
#define _EEADR7                 0x80

//==============================================================================


//==============================================================================
//        EEADRH Bits

extern __at(0x0FAA) __sfr EEADRH;

typedef struct
  {
  unsigned EEADR8               : 1;
  unsigned EEADR9               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __EEADRHbits_t;

extern __at(0x0FAA) volatile __EEADRHbits_t EEADRHbits;

#define _EEADR8                 0x01
#define _EEADR9                 0x02

//==============================================================================


//==============================================================================
//        RCSTA Bits

extern __at(0x0FAB) __sfr RCSTA;

typedef union
  {
  struct
    {
    unsigned RX9D               : 1;
    unsigned OERR               : 1;
    unsigned FERR               : 1;
    unsigned ADDEN              : 1;
    unsigned CREN               : 1;
    unsigned SREN               : 1;
    unsigned RX9                : 1;
    unsigned SPEN               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADEN               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __RCSTAbits_t;

extern __at(0x0FAB) volatile __RCSTAbits_t RCSTAbits;

#define _RX9D                   0x01
#define _OERR                   0x02
#define _FERR                   0x04
#define _ADDEN                  0x08
#define _ADEN                   0x08
#define _CREN                   0x10
#define _SREN                   0x20
#define _RX9                    0x40
#define _SPEN                   0x80

//==============================================================================


//==============================================================================
//        TXSTA Bits

extern __at(0x0FAC) __sfr TXSTA;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TXSTAbits_t;

extern __at(0x0FAC) volatile __TXSTAbits_t TXSTAbits;

#define _TX9D                   0x01
#define _TRMT                   0x02
#define _BRGH                   0x04
#define _SENDB                  0x08
#define _SYNC                   0x10
#define _TXEN                   0x20
#define _TX9                    0x40
#define _CSRC                   0x80

//==============================================================================

extern __at(0x0FAD) __sfr TXREG;
extern __at(0x0FAE) __sfr RCREG;
extern __at(0x0FAF) __sfr SPBRG;
extern __at(0x0FB0) __sfr SPBRGH;

//==============================================================================
//        T3CON Bits

extern __at(0x0FB1) __sfr T3CON;

typedef union
  {
  struct
    {
    unsigned TMR3ON             : 1;
    unsigned TMR3CS             : 1;
    unsigned NOT_T3SYNC         : 1;
    unsigned T3CCP1             : 1;
    unsigned T3CKPS0            : 1;
    unsigned T3CKPS1            : 1;
    unsigned T3CCP2             : 1;
    unsigned RD16               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T3SYNC             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T3CKPS             : 2;
    unsigned                    : 2;
    };
  } __T3CONbits_t;

extern __at(0x0FB1) volatile __T3CONbits_t T3CONbits;

#define _T3CON_TMR3ON           0x01
#define _T3CON_TMR3CS           0x02
#define _T3CON_NOT_T3SYNC       0x04
#define _T3CON_T3SYNC           0x04
#define _T3CON_T3CCP1           0x08
#define _T3CON_T3CKPS0          0x10
#define _T3CON_T3CKPS1          0x20
#define _T3CON_T3CCP2           0x40
#define _T3CON_RD16             0x80

//==============================================================================

extern __at(0x0FB2) __sfr TMR3;
extern __at(0x0FB2) __sfr TMR3L;
extern __at(0x0FB3) __sfr TMR3H;

//==============================================================================
//        CVRCON2 Bits

extern __at(0x0FB4) __sfr CVRCON2;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned FVRST                : 1;
  unsigned FVREN                : 1;
  } __CVRCON2bits_t;

extern __at(0x0FB4) volatile __CVRCON2bits_t CVRCON2bits;

#define _FVRST                  0x40
#define _FVREN                  0x80

//==============================================================================


//==============================================================================
//        CVRCON Bits

extern __at(0x0FB5) __sfr CVRCON;

typedef union
  {
  struct
    {
    unsigned CVR0               : 1;
    unsigned CVR1               : 1;
    unsigned CVR2               : 1;
    unsigned CVR3               : 1;
    unsigned CVRSS              : 1;
    unsigned CVRR               : 1;
    unsigned CVROE              : 1;
    unsigned CVREN              : 1;
    };

  struct
    {
    unsigned CVR                : 4;
    unsigned                    : 4;
    };
  } __CVRCONbits_t;

extern __at(0x0FB5) volatile __CVRCONbits_t CVRCONbits;

#define _CVR0                   0x01
#define _CVR1                   0x02
#define _CVR2                   0x04
#define _CVR3                   0x08
#define _CVRSS                  0x10
#define _CVRR                   0x20
#define _CVROE                  0x40
#define _CVREN                  0x80

//==============================================================================


//==============================================================================
//        ECCP1AS Bits

extern __at(0x0FB6) __sfr ECCP1AS;

typedef union
  {
  struct
    {
    unsigned PSSBD0             : 1;
    unsigned PSSBD1             : 1;
    unsigned PSSAC0             : 1;
    unsigned PSSAC1             : 1;
    unsigned ECCPAS0            : 1;
    unsigned ECCPAS1            : 1;
    unsigned ECCPAS2            : 1;
    unsigned ECCPASE            : 1;
    };

  struct
    {
    unsigned PSSBD              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSSAC              : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ECCPAS             : 3;
    unsigned                    : 1;
    };
  } __ECCP1ASbits_t;

extern __at(0x0FB6) volatile __ECCP1ASbits_t ECCP1ASbits;

#define _PSSBD0                 0x01
#define _PSSBD1                 0x02
#define _PSSAC0                 0x04
#define _PSSAC1                 0x08
#define _ECCPAS0                0x10
#define _ECCPAS1                0x20
#define _ECCPAS2                0x40
#define _ECCPASE                0x80

//==============================================================================


//==============================================================================
//        PWM1CON Bits

extern __at(0x0FB7) __sfr PWM1CON;

typedef union
  {
  struct
    {
    unsigned PDC0               : 1;
    unsigned PDC1               : 1;
    unsigned PDC2               : 1;
    unsigned PDC3               : 1;
    unsigned PDC4               : 1;
    unsigned PDC5               : 1;
    unsigned PDC6               : 1;
    unsigned PRSEN              : 1;
    };

  struct
    {
    unsigned PDC                : 7;
    unsigned                    : 1;
    };
  } __PWM1CONbits_t;

extern __at(0x0FB7) volatile __PWM1CONbits_t PWM1CONbits;

#define _PDC0                   0x01
#define _PDC1                   0x02
#define _PDC2                   0x04
#define _PDC3                   0x08
#define _PDC4                   0x10
#define _PDC5                   0x20
#define _PDC6                   0x40
#define _PRSEN                  0x80

//==============================================================================


//==============================================================================
//        BAUDCON Bits

extern __at(0x0FB8) __sfr BAUDCON;

typedef union
  {
  struct
    {
    unsigned ABDEN              : 1;
    unsigned WUE                : 1;
    unsigned                    : 1;
    unsigned BRG16              : 1;
    unsigned CKTXP              : 1;
    unsigned DTRXP              : 1;
    unsigned RCIDL              : 1;
    unsigned ABDOVF             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SCKP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __BAUDCONbits_t;

extern __at(0x0FB8) volatile __BAUDCONbits_t BAUDCONbits;

#define _ABDEN                  0x01
#define _WUE                    0x02
#define _BRG16                  0x08
#define _CKTXP                  0x10
#define _SCKP                   0x10
#define _DTRXP                  0x20
#define _RCIDL                  0x40
#define _ABDOVF                 0x80

//==============================================================================


//==============================================================================
//        BAUDCTL Bits

extern __at(0x0FB8) __sfr BAUDCTL;

typedef union
  {
  struct
    {
    unsigned ABDEN              : 1;
    unsigned WUE                : 1;
    unsigned                    : 1;
    unsigned BRG16              : 1;
    unsigned CKTXP              : 1;
    unsigned DTRXP              : 1;
    unsigned RCIDL              : 1;
    unsigned ABDOVF             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SCKP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __BAUDCTLbits_t;

extern __at(0x0FB8) volatile __BAUDCTLbits_t BAUDCTLbits;

#define _BAUDCTL_ABDEN          0x01
#define _BAUDCTL_WUE            0x02
#define _BAUDCTL_BRG16          0x08
#define _BAUDCTL_CKTXP          0x10
#define _BAUDCTL_SCKP           0x10
#define _BAUDCTL_DTRXP          0x20
#define _BAUDCTL_RCIDL          0x40
#define _BAUDCTL_ABDOVF         0x80

//==============================================================================


//==============================================================================
//        PSTRCON Bits

extern __at(0x0FB9) __sfr PSTRCON;

typedef struct
  {
  unsigned STRA                 : 1;
  unsigned STRB                 : 1;
  unsigned STRC                 : 1;
  unsigned STRD                 : 1;
  unsigned STRSYNC              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PSTRCONbits_t;

extern __at(0x0FB9) volatile __PSTRCONbits_t PSTRCONbits;

#define _STRA                   0x01
#define _STRB                   0x02
#define _STRC                   0x04
#define _STRD                   0x08
#define _STRSYNC                0x10

//==============================================================================


//==============================================================================
//        CCP2CON Bits

extern __at(0x0FBA) __sfr CCP2CON;

typedef union
  {
  struct
    {
    unsigned CCP2M0             : 1;
    unsigned CCP2M1             : 1;
    unsigned CCP2M2             : 1;
    unsigned CCP2M3             : 1;
    unsigned DC2B0              : 1;
    unsigned DC2B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP2M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC2B               : 2;
    unsigned                    : 2;
    };
  } __CCP2CONbits_t;

extern __at(0x0FBA) volatile __CCP2CONbits_t CCP2CONbits;

#define _CCP2M0                 0x01
#define _CCP2M1                 0x02
#define _CCP2M2                 0x04
#define _CCP2M3                 0x08
#define _DC2B0                  0x10
#define _DC2B1                  0x20

//==============================================================================

extern __at(0x0FBB) __sfr CCPR2;
extern __at(0x0FBB) __sfr CCPR2L;
extern __at(0x0FBC) __sfr CCPR2H;

//==============================================================================
//        CCP1CON Bits

extern __at(0x0FBD) __sfr CCP1CON;

typedef union
  {
  struct
    {
    unsigned CCP1M0             : 1;
    unsigned CCP1M1             : 1;
    unsigned CCP1M2             : 1;
    unsigned CCP1M3             : 1;
    unsigned DC1B0              : 1;
    unsigned DC1B1              : 1;
    unsigned P1M0               : 1;
    unsigned P1M1               : 1;
    };

  struct
    {
    unsigned CCP1M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC1B               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned P1M                : 2;
    };
  } __CCP1CONbits_t;

extern __at(0x0FBD) volatile __CCP1CONbits_t CCP1CONbits;

#define _CCP1M0                 0x01
#define _CCP1M1                 0x02
#define _CCP1M2                 0x04
#define _CCP1M3                 0x08
#define _DC1B0                  0x10
#define _DC1B1                  0x20
#define _P1M0                   0x40
#define _P1M1                   0x80

//==============================================================================

extern __at(0x0FBE) __sfr CCPR1;
extern __at(0x0FBE) __sfr CCPR1L;
extern __at(0x0FBF) __sfr CCPR1H;

//==============================================================================
//        ADCON2 Bits

extern __at(0x0FC0) __sfr ADCON2;

typedef union
  {
  struct
    {
    unsigned ADCS0              : 1;
    unsigned ADCS1              : 1;
    unsigned ADCS2              : 1;
    unsigned ACQT0              : 1;
    unsigned ACQT1              : 1;
    unsigned ACQT2              : 1;
    unsigned                    : 1;
    unsigned ADFM               : 1;
    };

  struct
    {
    unsigned ADCS               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 3;
    unsigned ACQT               : 3;
    unsigned                    : 2;
    };
  } __ADCON2bits_t;

extern __at(0x0FC0) volatile __ADCON2bits_t ADCON2bits;

#define _ADCS0                  0x01
#define _ADCS1                  0x02
#define _ADCS2                  0x04
#define _ACQT0                  0x08
#define _ACQT1                  0x10
#define _ACQT2                  0x20
#define _ADFM                   0x80

//==============================================================================


//==============================================================================
//        ADCON1 Bits

extern __at(0x0FC1) __sfr ADCON1;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned VCFG0              : 1;
    unsigned VCFG1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned VCFG               : 2;
    unsigned                    : 2;
    };
  } __ADCON1bits_t;

extern __at(0x0FC1) volatile __ADCON1bits_t ADCON1bits;

#define _VCFG0                  0x10
#define _VCFG1                  0x20

//==============================================================================


//==============================================================================
//        ADCON0 Bits

extern __at(0x0FC2) __sfr ADCON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned CHS3               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned DONE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned NOT_DONE           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO_DONE            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 4;
    unsigned                    : 2;
    };
  } __ADCON0bits_t;

extern __at(0x0FC2) volatile __ADCON0bits_t ADCON0bits;

#define _ADON                   0x01
#define _GO_NOT_DONE            0x02
#define _DONE                   0x02
#define _NOT_DONE               0x02
#define _GO_DONE                0x02
#define _GO                     0x02
#define _CHS0                   0x04
#define _CHS1                   0x08
#define _CHS2                   0x10
#define _CHS3                   0x20

//==============================================================================

extern __at(0x0FC3) __sfr ADRES;
extern __at(0x0FC3) __sfr ADRESL;
extern __at(0x0FC4) __sfr ADRESH;

//==============================================================================
//        SSPCON2 Bits

extern __at(0x0FC5) __sfr SSPCON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSPCON2bits_t;

extern __at(0x0FC5) volatile __SSPCON2bits_t SSPCON2bits;

#define _SEN                    0x01
#define _RSEN                   0x02
#define _PEN                    0x04
#define _RCEN                   0x08
#define _ACKEN                  0x10
#define _ACKDT                  0x20
#define _ACKSTAT                0x40
#define _GCEN                   0x80

//==============================================================================


//==============================================================================
//        SSPCON1 Bits

extern __at(0x0FC6) __sfr SSPCON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCON1bits_t;

extern __at(0x0FC6) volatile __SSPCON1bits_t SSPCON1bits;

#define _SSPM0                  0x01
#define _SSPM1                  0x02
#define _SSPM2                  0x04
#define _SSPM3                  0x08
#define _CKP                    0x10
#define _SSPEN                  0x20
#define _SSPOV                  0x40
#define _WCOL                   0x80

//==============================================================================


//==============================================================================
//        SSPSTAT Bits

extern __at(0x0FC7) __sfr SSPSTAT;

typedef union
  {
  struct
    {
    unsigned BF                 : 1;
    unsigned UA                 : 1;
    unsigned R_NOT_W            : 1;
    unsigned S                  : 1;
    unsigned P                  : 1;
    unsigned D_NOT_A            : 1;
    unsigned CKE                : 1;
    unsigned SMP                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R                  : 1;
    unsigned START              : 1;
    unsigned STOP               : 1;
    unsigned D                  : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_W              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_A              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R_W                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned D_A                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_WRITE          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_ADDRESS        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __SSPSTATbits_t;

extern __at(0x0FC7) volatile __SSPSTATbits_t SSPSTATbits;

#define _BF                     0x01
#define _UA                     0x02
#define _R_NOT_W                0x04
#define _R                      0x04
#define _NOT_W                  0x04
#define _R_W                    0x04
#define _NOT_WRITE              0x04
#define _S                      0x08
#define _START                  0x08
#define _P                      0x10
#define _STOP                   0x10
#define _D_NOT_A                0x20
#define _D                      0x20
#define _NOT_A                  0x20
#define _D_A                    0x20
#define _NOT_ADDRESS            0x20
#define _CKE                    0x40
#define _SMP                    0x80

//==============================================================================

extern __at(0x0FC8) __sfr SSPADD;
extern __at(0x0FC9) __sfr SSPBUF;

//==============================================================================
//        T2CON Bits

extern __at(0x0FCA) __sfr T2CON;

typedef union
  {
  struct
    {
    unsigned T2CKPS0            : 1;
    unsigned T2CKPS1            : 1;
    unsigned TMR2ON             : 1;
    unsigned T2OUTPS0           : 1;
    unsigned T2OUTPS1           : 1;
    unsigned T2OUTPS2           : 1;
    unsigned T2OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T2OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T2CONbits_t;

extern __at(0x0FCA) volatile __T2CONbits_t T2CONbits;

#define _T2CKPS0                0x01
#define _T2CKPS1                0x02
#define _TMR2ON                 0x04
#define _T2OUTPS0               0x08
#define _T2OUTPS1               0x10
#define _T2OUTPS2               0x20
#define _T2OUTPS3               0x40

//==============================================================================

extern __at(0x0FCB) __sfr PR2;
extern __at(0x0FCC) __sfr TMR2;

//==============================================================================
//        T1CON Bits

extern __at(0x0FCD) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned TMR1ON             : 1;
    unsigned TMR1CS             : 1;
    unsigned NOT_T1SYNC         : 1;
    unsigned T1OSCEN            : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned T1RUN              : 1;
    unsigned RD16               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1SYNC             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };
  } __T1CONbits_t;

extern __at(0x0FCD) volatile __T1CONbits_t T1CONbits;

#define _TMR1ON                 0x01
#define _TMR1CS                 0x02
#define _NOT_T1SYNC             0x04
#define _T1SYNC                 0x04
#define _T1OSCEN                0x08
#define _T1CKPS0                0x10
#define _T1CKPS1                0x20
#define _T1RUN                  0x40
#define _RD16                   0x80

//==============================================================================

extern __at(0x0FCE) __sfr TMR1;
extern __at(0x0FCE) __sfr TMR1L;
extern __at(0x0FCF) __sfr TMR1H;

//==============================================================================
//        RCON Bits

extern __at(0x0FD0) __sfr RCON;

typedef union
  {
  struct
    {
    unsigned NOT_BOR            : 1;
    unsigned NOT_POR            : 1;
    unsigned NOT_PD             : 1;
    unsigned NOT_TO             : 1;
    unsigned NOT_RI             : 1;
    unsigned                    : 1;
    unsigned SBOREN             : 1;
    unsigned IPEN               : 1;
    };

  struct
    {
    unsigned BOR                : 1;
    unsigned POR                : 1;
    unsigned PD                 : 1;
    unsigned TO                 : 1;
    unsigned RI                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __RCONbits_t;

extern __at(0x0FD0) volatile __RCONbits_t RCONbits;

#define _NOT_BOR                0x01
#define _BOR                    0x01
#define _NOT_POR                0x02
#define _POR                    0x02
#define _NOT_PD                 0x04
#define _PD                     0x04
#define _NOT_TO                 0x08
#define _TO                     0x08
#define _NOT_RI                 0x10
#define _RI                     0x10
#define _SBOREN                 0x40
#define _IPEN                   0x80

//==============================================================================


//==============================================================================
//        WDTCON Bits

extern __at(0x0FD1) __sfr WDTCON;

typedef union
  {
  struct
    {
    unsigned SWDTEN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SWDTE              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __WDTCONbits_t;

extern __at(0x0FD1) volatile __WDTCONbits_t WDTCONbits;

#define _SWDTEN                 0x01
#define _SWDTE                  0x01

//==============================================================================


//==============================================================================
//        HLVDCON Bits

extern __at(0x0FD2) __sfr HLVDCON;

typedef union
  {
  struct
    {
    unsigned HLVDL0             : 1;
    unsigned HLVDL1             : 1;
    unsigned HLVDL2             : 1;
    unsigned HLVDL3             : 1;
    unsigned HLVDEN             : 1;
    unsigned IRVST              : 1;
    unsigned                    : 1;
    unsigned VDIRMAG            : 1;
    };

  struct
    {
    unsigned LVDL0              : 1;
    unsigned LVDL1              : 1;
    unsigned LVDL2              : 1;
    unsigned LVDL3              : 1;
    unsigned LVDEN              : 1;
    unsigned IVRST              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LVV0               : 1;
    unsigned LVV1               : 1;
    unsigned LVV2               : 1;
    unsigned LVV3               : 1;
    unsigned                    : 1;
    unsigned BGST               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LVV                : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned HLVDL              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned LVDL               : 4;
    unsigned                    : 4;
    };
  } __HLVDCONbits_t;

extern __at(0x0FD2) volatile __HLVDCONbits_t HLVDCONbits;

#define _HLVDL0                 0x01
#define _LVDL0                  0x01
#define _LVV0                   0x01
#define _HLVDL1                 0x02
#define _LVDL1                  0x02
#define _LVV1                   0x02
#define _HLVDL2                 0x04
#define _LVDL2                  0x04
#define _LVV2                   0x04
#define _HLVDL3                 0x08
#define _LVDL3                  0x08
#define _LVV3                   0x08
#define _HLVDEN                 0x10
#define _LVDEN                  0x10
#define _IRVST                  0x20
#define _IVRST                  0x20
#define _BGST                   0x20
#define _VDIRMAG                0x80

//==============================================================================


//==============================================================================
//        LVDCON Bits

extern __at(0x0FD2) __sfr LVDCON;

typedef union
  {
  struct
    {
    unsigned HLVDL0             : 1;
    unsigned HLVDL1             : 1;
    unsigned HLVDL2             : 1;
    unsigned HLVDL3             : 1;
    unsigned HLVDEN             : 1;
    unsigned IRVST              : 1;
    unsigned                    : 1;
    unsigned VDIRMAG            : 1;
    };

  struct
    {
    unsigned LVDL0              : 1;
    unsigned LVDL1              : 1;
    unsigned LVDL2              : 1;
    unsigned LVDL3              : 1;
    unsigned LVDEN              : 1;
    unsigned IVRST              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LVV0               : 1;
    unsigned LVV1               : 1;
    unsigned LVV2               : 1;
    unsigned LVV3               : 1;
    unsigned                    : 1;
    unsigned BGST               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LVV                : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned HLVDL              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned LVDL               : 4;
    unsigned                    : 4;
    };
  } __LVDCONbits_t;

extern __at(0x0FD2) volatile __LVDCONbits_t LVDCONbits;

#define _LVDCON_HLVDL0          0x01
#define _LVDCON_LVDL0           0x01
#define _LVDCON_LVV0            0x01
#define _LVDCON_HLVDL1          0x02
#define _LVDCON_LVDL1           0x02
#define _LVDCON_LVV1            0x02
#define _LVDCON_HLVDL2          0x04
#define _LVDCON_LVDL2           0x04
#define _LVDCON_LVV2            0x04
#define _LVDCON_HLVDL3          0x08
#define _LVDCON_LVDL3           0x08
#define _LVDCON_LVV3            0x08
#define _LVDCON_HLVDEN          0x10
#define _LVDCON_LVDEN           0x10
#define _LVDCON_IRVST           0x20
#define _LVDCON_IVRST           0x20
#define _LVDCON_BGST            0x20
#define _LVDCON_VDIRMAG         0x80

//==============================================================================


//==============================================================================
//        OSCCON Bits

extern __at(0x0FD3) __sfr OSCCON;

typedef union
  {
  struct
    {
    unsigned SCS0               : 1;
    unsigned SCS1               : 1;
    unsigned IOFS               : 1;
    unsigned OSTS               : 1;
    unsigned IRCF0              : 1;
    unsigned IRCF1              : 1;
    unsigned IRCF2              : 1;
    unsigned IDLEN              : 1;
    };

  struct
    {
    unsigned SCS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned IRCF               : 3;
    unsigned                    : 1;
    };
  } __OSCCONbits_t;

extern __at(0x0FD3) volatile __OSCCONbits_t OSCCONbits;

#define _SCS0                   0x01
#define _SCS1                   0x02
#define _IOFS                   0x04
#define _OSTS                   0x08
#define _IRCF0                  0x10
#define _IRCF1                  0x20
#define _IRCF2                  0x40
#define _IDLEN                  0x80

//==============================================================================


//==============================================================================
//        T0CON Bits

extern __at(0x0FD5) __sfr T0CON;

typedef union
  {
  struct
    {
    unsigned T0PS0              : 1;
    unsigned T0PS1              : 1;
    unsigned T0PS2              : 1;
    unsigned PSA                : 1;
    unsigned T0SE               : 1;
    unsigned T0CS               : 1;
    unsigned T08BIT             : 1;
    unsigned TMR0ON             : 1;
    };

  struct
    {
    unsigned T0PS               : 3;
    unsigned                    : 5;
    };
  } __T0CONbits_t;

extern __at(0x0FD5) volatile __T0CONbits_t T0CONbits;

#define _T0PS0                  0x01
#define _T0PS1                  0x02
#define _T0PS2                  0x04
#define _PSA                    0x08
#define _T0SE                   0x10
#define _T0CS                   0x20
#define _T08BIT                 0x40
#define _TMR0ON                 0x80

//==============================================================================

extern __at(0x0FD6) __sfr TMR0;
extern __at(0x0FD6) __sfr TMR0L;
extern __at(0x0FD7) __sfr TMR0H;

//==============================================================================
//        STATUS Bits

extern __at(0x0FD8) __sfr STATUS;

typedef struct
  {
  unsigned C                    : 1;
  unsigned DC                   : 1;
  unsigned Z                    : 1;
  unsigned OV                   : 1;
  unsigned N                    : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUSbits_t;

extern __at(0x0FD8) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _OV                     0x08
#define _N                      0x10

//==============================================================================

extern __at(0x0FD9) __sfr FSR2L;
extern __at(0x0FDA) __sfr FSR2H;
extern __at(0x0FDB) __sfr PLUSW2;
extern __at(0x0FDC) __sfr PREINC2;
extern __at(0x0FDD) __sfr POSTDEC2;
extern __at(0x0FDE) __sfr POSTINC2;
extern __at(0x0FDF) __sfr INDF2;
extern __at(0x0FE0) __sfr BSR;
extern __at(0x0FE1) __sfr FSR1L;
extern __at(0x0FE2) __sfr FSR1H;
extern __at(0x0FE3) __sfr PLUSW1;
extern __at(0x0FE4) __sfr PREINC1;
extern __at(0x0FE5) __sfr POSTDEC1;
extern __at(0x0FE6) __sfr POSTINC1;
extern __at(0x0FE7) __sfr INDF1;
extern __at(0x0FE8) __sfr WREG;
extern __at(0x0FE9) __sfr FSR0L;
extern __at(0x0FEA) __sfr FSR0H;
extern __at(0x0FEB) __sfr PLUSW0;
extern __at(0x0FEC) __sfr PREINC0;
extern __at(0x0FED) __sfr POSTDEC0;
extern __at(0x0FEE) __sfr POSTINC0;
extern __at(0x0FEF) __sfr INDF0;

//==============================================================================
//        INTCON3 Bits

extern __at(0x0FF0) __sfr INTCON3;

typedef union
  {
  struct
    {
    unsigned INT1IF             : 1;
    unsigned INT2IF             : 1;
    unsigned                    : 1;
    unsigned INT1IE             : 1;
    unsigned INT2IE             : 1;
    unsigned                    : 1;
    unsigned INT1IP             : 1;
    unsigned INT2IP             : 1;
    };

  struct
    {
    unsigned INT1F              : 1;
    unsigned INT2F              : 1;
    unsigned                    : 1;
    unsigned INT1E              : 1;
    unsigned INT2E              : 1;
    unsigned                    : 1;
    unsigned INT1P              : 1;
    unsigned INT2P              : 1;
    };
  } __INTCON3bits_t;

extern __at(0x0FF0) volatile __INTCON3bits_t INTCON3bits;

#define _INT1IF                 0x01
#define _INT1F                  0x01
#define _INT2IF                 0x02
#define _INT2F                  0x02
#define _INT1IE                 0x08
#define _INT1E                  0x08
#define _INT2IE                 0x10
#define _INT2E                  0x10
#define _INT1IP                 0x40
#define _INT1P                  0x40
#define _INT2IP                 0x80
#define _INT2P                  0x80

//==============================================================================


//==============================================================================
//        INTCON2 Bits

extern __at(0x0FF1) __sfr INTCON2;

typedef union
  {
  struct
    {
    unsigned RBIP               : 1;
    unsigned                    : 1;
    unsigned TMR0IP             : 1;
    unsigned                    : 1;
    unsigned INTEDG2            : 1;
    unsigned INTEDG1            : 1;
    unsigned INTEDG0            : 1;
    unsigned NOT_RBPU           : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RBPU               : 1;
    };
  } __INTCON2bits_t;

extern __at(0x0FF1) volatile __INTCON2bits_t INTCON2bits;

#define _RBIP                   0x01
#define _TMR0IP                 0x04
#define _INTEDG2                0x10
#define _INTEDG1                0x20
#define _INTEDG0                0x40
#define _NOT_RBPU               0x80
#define _RBPU                   0x80

//==============================================================================


//==============================================================================
//        INTCON Bits

extern __at(0x0FF2) __sfr INTCON;

typedef union
  {
  struct
    {
    unsigned RBIF               : 1;
    unsigned INT0IF             : 1;
    unsigned TMR0IF             : 1;
    unsigned RBIE               : 1;
    unsigned INT0IE             : 1;
    unsigned TMR0IE             : 1;
    unsigned PEIE_GIEL          : 1;
    unsigned GIE_GIEH           : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned INT0F              : 1;
    unsigned T0IF               : 1;
    unsigned                    : 1;
    unsigned INT0E              : 1;
    unsigned T0IE               : 1;
    unsigned PEIE               : 1;
    unsigned GIE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GIEL               : 1;
    unsigned GIEH               : 1;
    };
  } __INTCONbits_t;

extern __at(0x0FF2) volatile __INTCONbits_t INTCONbits;

#define _RBIF                   0x01
#define _INT0IF                 0x02
#define _INT0F                  0x02
#define _TMR0IF                 0x04
#define _T0IF                   0x04
#define _RBIE                   0x08
#define _INT0IE                 0x10
#define _INT0E                  0x10
#define _TMR0IE                 0x20
#define _T0IE                   0x20
#define _PEIE_GIEL              0x40
#define _PEIE                   0x40
#define _GIEL                   0x40
#define _GIE_GIEH               0x80
#define _GIE                    0x80
#define _GIEH                   0x80

//==============================================================================

extern __at(0x0FF3) __sfr PROD;
extern __at(0x0FF3) __sfr PRODL;
extern __at(0x0FF4) __sfr PRODH;
extern __at(0x0FF5) __sfr TABLAT;
extern __at(0x0FF6) __sfr TBLPTR;
extern __at(0x0FF6) __sfr TBLPTRL;
extern __at(0x0FF7) __sfr TBLPTRH;
extern __at(0x0FF8) __sfr TBLPTRU;
extern __at(0x0FF9) __sfr PC;
extern __at(0x0FF9) __sfr PCL;
extern __at(0x0FFA) __sfr PCLATH;
extern __at(0x0FFB) __sfr PCLATU;

//==============================================================================
//        STKPTR Bits

extern __at(0x0FFC) __sfr STKPTR;

typedef union
  {
  struct
    {
    unsigned SP0                : 1;
    unsigned SP1                : 1;
    unsigned SP2                : 1;
    unsigned SP3                : 1;
    unsigned SP4                : 1;
    unsigned                    : 1;
    unsigned STKUNF             : 1;
    unsigned STKFUL             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned STKOVF             : 1;
    };

  struct
    {
    unsigned SP                 : 5;
    unsigned                    : 3;
    };
  } __STKPTRbits_t;

extern __at(0x0FFC) volatile __STKPTRbits_t STKPTRbits;

#define _SP0                    0x01
#define _SP1                    0x02
#define _SP2                    0x04
#define _SP3                    0x08
#define _SP4                    0x10
#define _STKUNF                 0x40
#define _STKFUL                 0x80
#define _STKOVF                 0x80

//==============================================================================

extern __at(0x0FFD) __sfr TOS;
extern __at(0x0FFD) __sfr TOSL;
extern __at(0x0FFE) __sfr TOSH;
extern __at(0x0FFF) __sfr TOSU;

//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define __CONFIG1H              0x300001
#define __CONFIG2L              0x300002
#define __CONFIG2H              0x300003
#define __CONFIG3H              0x300005
#define __CONFIG4L              0x300006
#define __CONFIG5L              0x300008
#define __CONFIG5H              0x300009
#define __CONFIG6L              0x30000A
#define __CONFIG6H              0x30000B
#define __CONFIG7L              0x30000C
#define __CONFIG7H              0x30000D

//----------------------------- CONFIG1H Options -------------------------------

#define _FOSC_LP_1H             0xF0    // LP oscillator.
#define _FOSC_XT_1H             0xF1    // XT oscillator.
#define _FOSC_HS_1H             0xF2    // HS oscillator.
#define _FOSC_RC_1H             0xF3    // External RC oscillator, CLKOUT function on RA6.
#define _FOSC_EC_1H             0xF4    // EC oscillator, CLKOUT function on RA6.
#define _FOSC_ECIO6_1H          0xF5    // EC oscillator, port function on RA6.
#define _FOSC_HSPLL_1H          0xF6    // HS oscillator, PLL enabled (Clock Frequency = 4 x FOSC1).
#define _FOSC_RCIO6_1H          0xF7    // External RC oscillator, port function on RA6.
#define _FOSC_INTIO67_1H        0xF8    // Internal oscillator block, port function on RA6 and RA7.
#define _FOSC_INTIO7_1H         0xF9    // Internal oscillator block, CLKOUT function on RA6, port function on RA7.
#define _FCMEN_OFF_1H           0xBF    // Fail-Safe Clock Monitor disabled.
#define _FCMEN_ON_1H            0xFF    // Fail-Safe Clock Monitor enabled.
#define _IESO_OFF_1H            0x7F    // Oscillator Switchover mode disabled.
#define _IESO_ON_1H             0xFF    // Oscillator Switchover mode enabled.

//----------------------------- CONFIG2L Options -------------------------------

#define _PWRT_ON_2L             0xFE    // PWRT enabled.
#define _PWRT_OFF_2L            0xFF    // PWRT disabled.
#define _BOREN_OFF_2L           0xF9    // Brown-out Reset disabled in hardware and software.
#define _BOREN_ON_2L            0xFB    // Brown-out Reset enabled and controlled by software (SBOREN is enabled).
#define _BOREN_NOSLP_2L         0xFD    // Brown-out Reset enabled in hardware only and disabled in Sleep mode (SBOREN is disabled).
#define _BOREN_SBORDIS_2L       0xFF    // Brown-out Reset enabled in hardware only (SBOREN is disabled).
#define _BORV_30_2L             0xE7    // VBOR set to 3.0 V nominal.
#define _BORV_27_2L             0xEF    // VBOR set to 2.7 V nominal.
#define _BORV_22_2L             0xF7    // VBOR set to 2.2 V nominal.
#define _BORV_18_2L             0xFF    // VBOR set to 1.8 V nominal.

//----------------------------- CONFIG2H Options -------------------------------

#define _WDTEN_OFF_2H           0xFE    // WDT is controlled by SWDTEN bit of the WDTCON register.
#define _WDTEN_ON_2H            0xFF    // WDT is always enabled. SWDTEN bit has no effect.
#define _WDTPS_1_2H             0xE1    // 1:1.
#define _WDTPS_2_2H             0xE3    // 1:2.
#define _WDTPS_4_2H             0xE5    // 1:4.
#define _WDTPS_8_2H             0xE7    // 1:8.
#define _WDTPS_16_2H            0xE9    // 1:16.
#define _WDTPS_32_2H            0xEB    // 1:32.
#define _WDTPS_64_2H            0xED    // 1:64.
#define _WDTPS_128_2H           0xEF    // 1:128.
#define _WDTPS_256_2H           0xF1    // 1:256.
#define _WDTPS_512_2H           0xF3    // 1:512.
#define _WDTPS_1024_2H          0xF5    // 1:1024.
#define _WDTPS_2048_2H          0xF7    // 1:2048.
#define _WDTPS_4096_2H          0xF9    // 1:4096.
#define _WDTPS_8192_2H          0xFB    // 1:8192.
#define _WDTPS_16384_2H         0xFD    // 1:16384.
#define _WDTPS_32768_2H         0xFF    // 1:32768.

//----------------------------- CONFIG3H Options -------------------------------

#define _CCP2MX_PORTBE_3H       0xFE    // CCP2 input/output is multiplexed with RB3.
#define _CCP2MX_PORTC_3H        0xFF    // CCP2 input/output is multiplexed with RC1.
#define _PBADEN_OFF_3H          0xFD    // PORTB<4:0> pins are configured as digital I/O on Reset.
#define _PBADEN_ON_3H           0xFF    // PORTB<4:0> pins are configured as analog input channels on Reset.
#define _LPT1OSC_OFF_3H         0xFB    // Timer1 configured for higher power operation.
#define _LPT1OSC_ON_3H          0xFF    // Timer1 configured for low-power operation.
#define _HFOFST_OFF_3H          0xF7    // The system clock is held off until the HFINTOSC is stable.
#define _HFOFST_ON_3H           0xFF    // HFINTOSC starts clocking the CPU without waiting for the oscillator to stablize.
#define _MCLRE_OFF_3H           0x7F    // RE3 input pin enabled; MCLR disabled.
#define _MCLRE_ON_3H            0xFF    // MCLR pin enabled; RE3 input pin disabled.

//----------------------------- CONFIG4L Options -------------------------------

#define _STVREN_OFF_4L          0xFE    // Stack full/underflow will not cause Reset.
#define _STVREN_ON_4L           0xFF    // Stack full/underflow will cause Reset.
#define _LVP_OFF_4L             0xFB    // Single-Supply ICSP disabled.
#define _LVP_ON_4L              0xFF    // Single-Supply ICSP enabled.
#define _XINST_OFF_4L           0xBF    // Instruction set extension and Indexed Addressing mode disabled (Legacy mode).
#define _XINST_ON_4L            0xFF    // Instruction set extension and Indexed Addressing mode enabled.
#define _DEBUG_ON_4L            0x7F    // Background debugger enabled, RB6 and RB7 are dedicated to In-Circuit Debug.
#define _DEBUG_OFF_4L           0xFF    // Background debugger disabled, RB6 and RB7 configured as general purpose I/O pins.

//----------------------------- CONFIG5L Options -------------------------------

#define _CP0_ON_5L              0xFE    // Block 0 (000800-003FFFh) code-protected.
#define _CP0_OFF_5L             0xFF    // Block 0 (000800-003FFFh) not code-protected.
#define _CP1_ON_5L              0xFD    // Block 1 (004000-007FFFh) code-protected.
#define _CP1_OFF_5L             0xFF    // Block 1 (004000-007FFFh) not code-protected.
#define _CP2_ON_5L              0xFB    // Block 2 (008000-00BFFFh) code-protected.
#define _CP2_OFF_5L             0xFF    // Block 2 (008000-00BFFFh) not code-protected.
#define _CP3_ON_5L              0xF7    // Block 3 (00C000-00FFFFh) code-protected.
#define _CP3_OFF_5L             0xFF    // Block 3 (00C000-00FFFFh) not code-protected.

//----------------------------- CONFIG5H Options -------------------------------

#define _CPB_ON_5H              0xBF    // Boot block (000000-0007FFh) code-protected.
#define _CPB_OFF_5H             0xFF    // Boot block (000000-0007FFh) not code-protected.
#define _CPD_ON_5H              0x7F    // Data EEPROM code-protected.
#define _CPD_OFF_5H             0xFF    // Data EEPROM not code-protected.

//----------------------------- CONFIG6L Options -------------------------------

#define _WRT0_ON_6L             0xFE    // Block 0 (000800-003FFFh) write-protected.
#define _WRT0_OFF_6L            0xFF    // Block 0 (000800-003FFFh) not write-protected.
#define _WRT1_ON_6L             0xFD    // Block 1 (004000-007FFFh) write-protected.
#define _WRT1_OFF_6L            0xFF    // Block 1 (004000-007FFFh) not write-protected.
#define _WRT2_ON_6L             0xFB    // Block 2 (008000-00BFFFh) write-protected.
#define _WRT2_OFF_6L            0xFF    // Block 2 (008000-00BFFFh) not write-protected.
#define _WRT3_ON_6L             0xF7    // Block 3 (00C000h-00FFFFh) write-protected.
#define _WRT3_OFF_6L            0xFF    // Block 3 (00C000h-00FFFFh) not write-protected.

//----------------------------- CONFIG6H Options -------------------------------

#define _WRTC_ON_6H             0xDF    // Configuration registers (300000-3000FFh) write-protected.
#define _WRTC_OFF_6H            0xFF    // Configuration registers (300000-3000FFh) not write-protected.
#define _WRTB_ON_6H             0xBF    // Boot Block (000000-0007FFh) write-protected.
#define _WRTB_OFF_6H            0xFF    // Boot Block (000000-0007FFh) not write-protected.
#define _WRTD_ON_6H             0x7F    // Data EEPROM write-protected.
#define _WRTD_OFF_6H            0xFF    // Data EEPROM not write-protected.

//----------------------------- CONFIG7L Options -------------------------------

#define _EBTR0_ON_7L            0xFE    // Block 0 (000800-003FFFh) protected from table reads executed in other blocks.
#define _EBTR0_OFF_7L           0xFF    // Block 0 (000800-003FFFh) not protected from table reads executed in other blocks.
#define _EBTR1_ON_7L            0xFD    // Block 1 (004000-007FFFh) protected from table reads executed in other blocks.
#define _EBTR1_OFF_7L           0xFF    // Block 1 (004000-007FFFh) not protected from table reads executed in other blocks.
#define _EBTR2_ON_7L            0xFB    // Block 2 (008000-00BFFFh) protected from table reads executed in other blocks.
#define _EBTR2_OFF_7L           0xFF    // Block 2 (008000-00BFFFh) not protected from table reads executed in other blocks.
#define _EBTR3_ON_7L            0xF7    // Block 3 (00C000-00FFFFh) protected from table reads executed in other blocks.
#define _EBTR3_OFF_7L           0xFF    // Block 3 (00C000-00FFFFh) not protected from table reads executed in other blocks.

//----------------------------- CONFIG7H Options -------------------------------

#define _EBTRB_ON_7H            0xBF    // Boot Block (000000-0007FFh) protected from table reads executed in other blocks.
#define _EBTRB_OFF_7H           0xFF    // Boot Block (000000-0007FFh) not protected from table reads executed in other blocks.

//==============================================================================

#define __DEVID1                0x3FFFFE
#define __DEVID2                0x3FFFFF

#define __IDLOC0                0x200000
#define __IDLOC1                0x200001
#define __IDLOC2                0x200002
#define __IDLOC3                0x200003
#define __IDLOC4                0x200004
#define __IDLOC5                0x200005
#define __IDLOC6                0x200006
#define __IDLOC7                0x200007

#endif // #ifndef __PIC18F26K20_H__
