/*
 * This declarations of the PIC16F1507 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2014.
 *
 * This file is generated automatically by the cinc2h.pl, 2014-03-09 13:32:16 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC16F1507_H__
#define __PIC16F1507_H__

//==============================================================================
//
//	Register Addresses
//
//==============================================================================

#ifndef NO_ADDR_DEFINES

#define INDF0_ADDR              0x0000
#define INDF1_ADDR              0x0001
#define PCL_ADDR                0x0002
#define STATUS_ADDR             0x0003
#define FSR0_ADDR               0x0004
#define FSR0L_ADDR              0x0004
#define FSR0H_ADDR              0x0005
#define FSR1_ADDR               0x0006
#define FSR1L_ADDR              0x0006
#define FSR1H_ADDR              0x0007
#define BSR_ADDR                0x0008
#define WREG_ADDR               0x0009
#define PCLATH_ADDR             0x000A
#define INTCON_ADDR             0x000B
#define PORTA_ADDR              0x000C
#define PORTB_ADDR              0x000D
#define PORTC_ADDR              0x000E
#define PIR1_ADDR               0x0011
#define PIR2_ADDR               0x0012
#define PIR3_ADDR               0x0013
#define TMR0_ADDR               0x0015
#define TMR1_ADDR               0x0016
#define TMR1L_ADDR              0x0016
#define TMR1H_ADDR              0x0017
#define T1CON_ADDR              0x0018
#define T1GCON_ADDR             0x0019
#define TMR2_ADDR               0x001A
#define PR2_ADDR                0x001B
#define T2CON_ADDR              0x001C
#define TRISA_ADDR              0x008C
#define TRISB_ADDR              0x008D
#define TRISC_ADDR              0x008E
#define PIE1_ADDR               0x0091
#define PIE2_ADDR               0x0092
#define PIE3_ADDR               0x0093
#define OPTION_REG_ADDR         0x0095
#define PCON_ADDR               0x0096
#define WDTCON_ADDR             0x0097
#define OSCCON_ADDR             0x0099
#define OSCSTAT_ADDR            0x009A
#define ADRES_ADDR              0x009B
#define ADRESL_ADDR             0x009B
#define ADRESH_ADDR             0x009C
#define ADCON0_ADDR             0x009D
#define ADCON1_ADDR             0x009E
#define ADCON2_ADDR             0x009F
#define LATA_ADDR               0x010C
#define LATB_ADDR               0x010D
#define LATC_ADDR               0x010E
#define BORCON_ADDR             0x0116
#define FVRCON_ADDR             0x0117
#define APFCON_ADDR             0x011D
#define ANSELA_ADDR             0x018C
#define ANSELB_ADDR             0x018D
#define ANSELC_ADDR             0x018E
#define PMADR_ADDR              0x0191
#define PMADRL_ADDR             0x0191
#define PMADRH_ADDR             0x0192
#define PMDAT_ADDR              0x0193
#define PMDATL_ADDR             0x0193
#define PMDATH_ADDR             0x0194
#define PMCON1_ADDR             0x0195
#define PMCON2_ADDR             0x0196
#define VREGCON_ADDR            0x0197
#define WPUA_ADDR               0x020C
#define WPUB_ADDR               0x020D
#define IOCAP_ADDR              0x0391
#define IOCAN_ADDR              0x0392
#define IOCAF_ADDR              0x0393
#define IOCBP_ADDR              0x0394
#define IOCBN_ADDR              0x0395
#define IOCBF_ADDR              0x0396
#define NCO1ACC_ADDR            0x0498
#define NCO1ACCL_ADDR           0x0498
#define NCO1ACCH_ADDR           0x0499
#define NCO1ACCU_ADDR           0x049A
#define NCO1INC_ADDR            0x049B
#define NCO1INCL_ADDR           0x049B
#define NCO1INCH_ADDR           0x049C
#define NCO1INCU_ADDR           0x049D
#define NCO1CON_ADDR            0x049E
#define NCO1CLK_ADDR            0x049F
#define PWM1DCL_ADDR            0x0611
#define PWM1DCH_ADDR            0x0612
#define PWM1CON_ADDR            0x0613
#define PWM1CON0_ADDR           0x0613
#define PWM2DCL_ADDR            0x0614
#define PWM2DCH_ADDR            0x0615
#define PWM2CON_ADDR            0x0616
#define PWM2CON0_ADDR           0x0616
#define PWM3DCL_ADDR            0x0617
#define PWM3DCH_ADDR            0x0618
#define PWM3CON_ADDR            0x0619
#define PWM3CON0_ADDR           0x0619
#define PWM4DCL_ADDR            0x061A
#define PWM4DCH_ADDR            0x061B
#define PWM4CON_ADDR            0x061C
#define PWM4CON0_ADDR           0x061C
#define CWG1DBR_ADDR            0x0691
#define CWG1DBF_ADDR            0x0692
#define CWG1CON0_ADDR           0x0693
#define CWG1CON1_ADDR           0x0694
#define CWG1CON2_ADDR           0x0695
#define CLCDATA_ADDR            0x0F0F
#define CLC1CON_ADDR            0x0F10
#define CLC1POL_ADDR            0x0F11
#define CLC1SEL0_ADDR           0x0F12
#define CLC1SEL1_ADDR           0x0F13
#define CLC1GLS0_ADDR           0x0F14
#define CLC1GLS1_ADDR           0x0F15
#define CLC1GLS2_ADDR           0x0F16
#define CLC1GLS3_ADDR           0x0F17
#define CLC2CON_ADDR            0x0F18
#define CLC2POL_ADDR            0x0F19
#define CLC2SEL0_ADDR           0x0F1A
#define CLC2SEL1_ADDR           0x0F1B
#define CLC2GLS0_ADDR           0x0F1C
#define CLC2GLS1_ADDR           0x0F1D
#define CLC2GLS2_ADDR           0x0F1E
#define CLC2GLS3_ADDR           0x0F1F
#define BSR_ICDSHAD_ADDR        0x0FE3
#define STATUS_SHAD_ADDR        0x0FE4
#define WREG_SHAD_ADDR          0x0FE5
#define BSR_SHAD_ADDR           0x0FE6
#define PCLATH_SHAD_ADDR        0x0FE7
#define FSR0L_SHAD_ADDR         0x0FE8
#define FSR0H_SHAD_ADDR         0x0FE9
#define FSR1L_SHAD_ADDR         0x0FEA
#define FSR1H_SHAD_ADDR         0x0FEB
#define STKPTR_ADDR             0x0FED
#define TOSL_ADDR               0x0FEE
#define TOSH_ADDR               0x0FEF

#endif // #ifndef NO_ADDR_DEFINES

//==============================================================================
//
//	Register Definitions
//
//==============================================================================

extern __at(0x0000) __sfr INDF0;
extern __at(0x0001) __sfr INDF1;
extern __at(0x0002) __sfr PCL;

//==============================================================================
//        STATUS Bits

extern __at(0x0003) __sfr STATUS;

typedef struct
  {
  unsigned C                    : 1;
  unsigned DC                   : 1;
  unsigned Z                    : 1;
  unsigned NOT_PD               : 1;
  unsigned NOT_TO               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUSbits_t;

extern __at(0x0003) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _NOT_PD                 0x08
#define _NOT_TO                 0x10

//==============================================================================

extern __at(0x0004) __sfr FSR0;
extern __at(0x0004) __sfr FSR0L;
extern __at(0x0005) __sfr FSR0H;
extern __at(0x0006) __sfr FSR1;
extern __at(0x0006) __sfr FSR1L;
extern __at(0x0007) __sfr FSR1H;

//==============================================================================
//        BSR Bits

extern __at(0x0008) __sfr BSR;

typedef union
  {
  struct
    {
    unsigned BSR0               : 1;
    unsigned BSR1               : 1;
    unsigned BSR2               : 1;
    unsigned BSR3               : 1;
    unsigned BSR4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned BSR                : 5;
    unsigned                    : 3;
    };
  } __BSRbits_t;

extern __at(0x0008) volatile __BSRbits_t BSRbits;

#define _BSR0                   0x01
#define _BSR1                   0x02
#define _BSR2                   0x04
#define _BSR3                   0x08
#define _BSR4                   0x10

//==============================================================================

extern __at(0x0009) __sfr WREG;
extern __at(0x000A) __sfr PCLATH;

//==============================================================================
//        INTCON Bits

extern __at(0x000B) __sfr INTCON;

typedef union
  {
  struct
    {
    unsigned IOCIF              : 1;
    unsigned INTF               : 1;
    unsigned TMR0IF             : 1;
    unsigned IOCIE              : 1;
    unsigned INTE               : 1;
    unsigned TMR0IE             : 1;
    unsigned PEIE               : 1;
    unsigned GIE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __INTCONbits_t;

extern __at(0x000B) volatile __INTCONbits_t INTCONbits;

#define _IOCIF                  0x01
#define _INTF                   0x02
#define _TMR0IF                 0x04
#define _T0IF                   0x04
#define _IOCIE                  0x08
#define _INTE                   0x10
#define _TMR0IE                 0x20
#define _T0IE                   0x20
#define _PEIE                   0x40
#define _GIE                    0x80

//==============================================================================


//==============================================================================
//        PORTA Bits

extern __at(0x000C) __sfr PORTA;

typedef union
  {
  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA                 : 6;
    unsigned                    : 2;
    };
  } __PORTAbits_t;

extern __at(0x000C) volatile __PORTAbits_t PORTAbits;

#define _RA0                    0x01
#define _RA1                    0x02
#define _RA2                    0x04
#define _RA3                    0x08
#define _RA4                    0x10
#define _RA5                    0x20

//==============================================================================


//==============================================================================
//        PORTB Bits

extern __at(0x000D) __sfr PORTB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned RB4                  : 1;
  unsigned RB5                  : 1;
  unsigned RB6                  : 1;
  unsigned RB7                  : 1;
  } __PORTBbits_t;

extern __at(0x000D) volatile __PORTBbits_t PORTBbits;

#define _RB4                    0x10
#define _RB5                    0x20
#define _RB6                    0x40
#define _RB7                    0x80

//==============================================================================


//==============================================================================
//        PORTC Bits

extern __at(0x000E) __sfr PORTC;

typedef struct
  {
  unsigned RC0                  : 1;
  unsigned RC1                  : 1;
  unsigned RC2                  : 1;
  unsigned RC3                  : 1;
  unsigned RC4                  : 1;
  unsigned RC5                  : 1;
  unsigned RC6                  : 1;
  unsigned RC7                  : 1;
  } __PORTCbits_t;

extern __at(0x000E) volatile __PORTCbits_t PORTCbits;

#define _RC0                    0x01
#define _RC1                    0x02
#define _RC2                    0x04
#define _RC3                    0x08
#define _RC4                    0x10
#define _RC5                    0x20
#define _RC6                    0x40
#define _RC7                    0x80

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x0011) __sfr PIR1;

typedef struct
  {
  unsigned TMR1IF               : 1;
  unsigned TMR2IF               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ADIF                 : 1;
  unsigned TMR1GIF              : 1;
  } __PIR1bits_t;

extern __at(0x0011) volatile __PIR1bits_t PIR1bits;

#define _TMR1IF                 0x01
#define _TMR2IF                 0x02
#define _ADIF                   0x40
#define _TMR1GIF                0x80

//==============================================================================


//==============================================================================
//        PIR2 Bits

extern __at(0x0012) __sfr PIR2;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned NCO1IF               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIR2bits_t;

extern __at(0x0012) volatile __PIR2bits_t PIR2bits;

#define _NCO1IF                 0x04

//==============================================================================


//==============================================================================
//        PIR3 Bits

extern __at(0x0013) __sfr PIR3;

typedef struct
  {
  unsigned CLC1IF               : 1;
  unsigned CLC2IF               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIR3bits_t;

extern __at(0x0013) volatile __PIR3bits_t PIR3bits;

#define _CLC1IF                 0x01
#define _CLC2IF                 0x02

//==============================================================================

extern __at(0x0015) __sfr TMR0;
extern __at(0x0016) __sfr TMR1;
extern __at(0x0016) __sfr TMR1L;
extern __at(0x0017) __sfr TMR1H;

//==============================================================================
//        T1CON Bits

extern __at(0x0018) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned TMR1ON             : 1;
    unsigned                    : 1;
    unsigned NOT_T1SYNC         : 1;
    unsigned T1OSCEN            : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned TMR1CS0            : 1;
    unsigned TMR1CS1            : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR1CS             : 2;
    };
  } __T1CONbits_t;

extern __at(0x0018) volatile __T1CONbits_t T1CONbits;

#define _TMR1ON                 0x01
#define _NOT_T1SYNC             0x04
#define _T1OSCEN                0x08
#define _T1CKPS0                0x10
#define _T1CKPS1                0x20
#define _TMR1CS0                0x40
#define _TMR1CS1                0x80

//==============================================================================


//==============================================================================
//        T1GCON Bits

extern __at(0x0019) __sfr T1GCON;

typedef union
  {
  struct
    {
    unsigned T1GSS0             : 1;
    unsigned T1GSS1             : 1;
    unsigned T1GVAL             : 1;
    unsigned T1GGO_NOT_DONE     : 1;
    unsigned T1GSPM             : 1;
    unsigned T1GTM              : 1;
    unsigned T1GPOL             : 1;
    unsigned TMR1GE             : 1;
    };

  struct
    {
    unsigned T1GSS              : 2;
    unsigned                    : 6;
    };
  } __T1GCONbits_t;

extern __at(0x0019) volatile __T1GCONbits_t T1GCONbits;

#define _T1GSS0                 0x01
#define _T1GSS1                 0x02
#define _T1GVAL                 0x04
#define _T1GGO_NOT_DONE         0x08
#define _T1GSPM                 0x10
#define _T1GTM                  0x20
#define _T1GPOL                 0x40
#define _TMR1GE                 0x80

//==============================================================================

extern __at(0x001A) __sfr TMR2;
extern __at(0x001B) __sfr PR2;

//==============================================================================
//        T2CON Bits

extern __at(0x001C) __sfr T2CON;

typedef union
  {
  struct
    {
    unsigned T2CKPS0            : 1;
    unsigned T2CKPS1            : 1;
    unsigned TMR2ON             : 1;
    unsigned TOUTPS0            : 1;
    unsigned TOUTPS1            : 1;
    unsigned TOUTPS2            : 1;
    unsigned TOUTPS3            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned TOUTPS             : 4;
    unsigned                    : 1;
    };
  } __T2CONbits_t;

extern __at(0x001C) volatile __T2CONbits_t T2CONbits;

#define _T2CKPS0                0x01
#define _T2CKPS1                0x02
#define _TMR2ON                 0x04
#define _TOUTPS0                0x08
#define _TOUTPS1                0x10
#define _TOUTPS2                0x20
#define _TOUTPS3                0x40

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x008C) __sfr TRISA;

typedef union
  {
  struct
    {
    unsigned TRISA0             : 1;
    unsigned TRISA1             : 1;
    unsigned TRISA2             : 1;
    unsigned TRISA3             : 1;
    unsigned TRISA4             : 1;
    unsigned TRISA5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TRISA              : 6;
    unsigned                    : 2;
    };
  } __TRISAbits_t;

extern __at(0x008C) volatile __TRISAbits_t TRISAbits;

#define _TRISA0                 0x01
#define _TRISA1                 0x02
#define _TRISA2                 0x04
#define _TRISA3                 0x08
#define _TRISA4                 0x10
#define _TRISA5                 0x20

//==============================================================================


//==============================================================================
//        TRISB Bits

extern __at(0x008D) __sfr TRISB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned TRISB4               : 1;
  unsigned TRISB5               : 1;
  unsigned TRISB6               : 1;
  unsigned TRISB7               : 1;
  } __TRISBbits_t;

extern __at(0x008D) volatile __TRISBbits_t TRISBbits;

#define _TRISB4                 0x10
#define _TRISB5                 0x20
#define _TRISB6                 0x40
#define _TRISB7                 0x80

//==============================================================================


//==============================================================================
//        TRISC Bits

extern __at(0x008E) __sfr TRISC;

typedef struct
  {
  unsigned TRISC0               : 1;
  unsigned TRISC1               : 1;
  unsigned TRISC2               : 1;
  unsigned TRISC3               : 1;
  unsigned TRISC4               : 1;
  unsigned TRISC5               : 1;
  unsigned TRISC6               : 1;
  unsigned TRISC7               : 1;
  } __TRISCbits_t;

extern __at(0x008E) volatile __TRISCbits_t TRISCbits;

#define _TRISC0                 0x01
#define _TRISC1                 0x02
#define _TRISC2                 0x04
#define _TRISC3                 0x08
#define _TRISC4                 0x10
#define _TRISC5                 0x20
#define _TRISC6                 0x40
#define _TRISC7                 0x80

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x0091) __sfr PIE1;

typedef struct
  {
  unsigned TMR1IE               : 1;
  unsigned TMR2IE               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ADIE                 : 1;
  unsigned TMR1GIE              : 1;
  } __PIE1bits_t;

extern __at(0x0091) volatile __PIE1bits_t PIE1bits;

#define _TMR1IE                 0x01
#define _TMR2IE                 0x02
#define _ADIE                   0x40
#define _TMR1GIE                0x80

//==============================================================================


//==============================================================================
//        PIE2 Bits

extern __at(0x0092) __sfr PIE2;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned NCO1IE               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIE2bits_t;

extern __at(0x0092) volatile __PIE2bits_t PIE2bits;

#define _NCO1IE                 0x04

//==============================================================================


//==============================================================================
//        PIE3 Bits

extern __at(0x0093) __sfr PIE3;

typedef struct
  {
  unsigned CLC1IE               : 1;
  unsigned CLC2IE               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIE3bits_t;

extern __at(0x0093) volatile __PIE3bits_t PIE3bits;

#define _CLC1IE                 0x01
#define _CLC2IE                 0x02

//==============================================================================


//==============================================================================
//        OPTION_REG Bits

extern __at(0x0095) __sfr OPTION_REG;

typedef union
  {
  struct
    {
    unsigned PS0                : 1;
    unsigned PS1                : 1;
    unsigned PS2                : 1;
    unsigned PSA                : 1;
    unsigned TMR0SE             : 1;
    unsigned TMR0CS             : 1;
    unsigned INTEDG             : 1;
    unsigned NOT_WPUEN          : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0SE               : 1;
    unsigned T0CS               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PS                 : 3;
    unsigned                    : 5;
    };
  } __OPTION_REGbits_t;

extern __at(0x0095) volatile __OPTION_REGbits_t OPTION_REGbits;

#define _PS0                    0x01
#define _PS1                    0x02
#define _PS2                    0x04
#define _PSA                    0x08
#define _TMR0SE                 0x10
#define _T0SE                   0x10
#define _TMR0CS                 0x20
#define _T0CS                   0x20
#define _INTEDG                 0x40
#define _NOT_WPUEN              0x80

//==============================================================================


//==============================================================================
//        PCON Bits

extern __at(0x0096) __sfr PCON;

typedef struct
  {
  unsigned NOT_BOR              : 1;
  unsigned NOT_POR              : 1;
  unsigned NOT_RI               : 1;
  unsigned NOT_RMCLR            : 1;
  unsigned NOT_RWDT             : 1;
  unsigned                      : 1;
  unsigned STKUNF               : 1;
  unsigned STKOVF               : 1;
  } __PCONbits_t;

extern __at(0x0096) volatile __PCONbits_t PCONbits;

#define _NOT_BOR                0x01
#define _NOT_POR                0x02
#define _NOT_RI                 0x04
#define _NOT_RMCLR              0x08
#define _NOT_RWDT               0x10
#define _STKUNF                 0x40
#define _STKOVF                 0x80

//==============================================================================


//==============================================================================
//        WDTCON Bits

extern __at(0x0097) __sfr WDTCON;

typedef union
  {
  struct
    {
    unsigned SWDTEN             : 1;
    unsigned WDTPS0             : 1;
    unsigned WDTPS1             : 1;
    unsigned WDTPS2             : 1;
    unsigned WDTPS3             : 1;
    unsigned WDTPS4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WDTPS              : 5;
    unsigned                    : 2;
    };
  } __WDTCONbits_t;

extern __at(0x0097) volatile __WDTCONbits_t WDTCONbits;

#define _SWDTEN                 0x01
#define _WDTPS0                 0x02
#define _WDTPS1                 0x04
#define _WDTPS2                 0x08
#define _WDTPS3                 0x10
#define _WDTPS4                 0x20

//==============================================================================


//==============================================================================
//        OSCCON Bits

extern __at(0x0099) __sfr OSCCON;

typedef union
  {
  struct
    {
    unsigned SCS0               : 1;
    unsigned SCS1               : 1;
    unsigned                    : 1;
    unsigned IRCF0              : 1;
    unsigned IRCF1              : 1;
    unsigned IRCF2              : 1;
    unsigned IRCF3              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SCS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned IRCF               : 4;
    unsigned                    : 1;
    };
  } __OSCCONbits_t;

extern __at(0x0099) volatile __OSCCONbits_t OSCCONbits;

#define _SCS0                   0x01
#define _SCS1                   0x02
#define _IRCF0                  0x08
#define _IRCF1                  0x10
#define _IRCF2                  0x20
#define _IRCF3                  0x40

//==============================================================================


//==============================================================================
//        OSCSTAT Bits

extern __at(0x009A) __sfr OSCSTAT;

typedef struct
  {
  unsigned HFIOFS               : 1;
  unsigned LFIOFR               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned HFIOFR               : 1;
  unsigned OSTS                 : 1;
  unsigned                      : 1;
  unsigned SOSCR                : 1;
  } __OSCSTATbits_t;

extern __at(0x009A) volatile __OSCSTATbits_t OSCSTATbits;

#define _HFIOFS                 0x01
#define _LFIOFR                 0x02
#define _HFIOFR                 0x10
#define _OSTS                   0x20
#define _SOSCR                  0x80

//==============================================================================

extern __at(0x009B) __sfr ADRES;
extern __at(0x009B) __sfr ADRESL;
extern __at(0x009C) __sfr ADRESH;

//==============================================================================
//        ADCON0 Bits

extern __at(0x009D) __sfr ADCON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned CHS3               : 1;
    unsigned CHS4               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ADGO               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 5;
    unsigned                    : 1;
    };
  } __ADCON0bits_t;

extern __at(0x009D) volatile __ADCON0bits_t ADCON0bits;

#define _ADON                   0x01
#define _GO_NOT_DONE            0x02
#define _ADGO                   0x02
#define _GO                     0x02
#define _CHS0                   0x04
#define _CHS1                   0x08
#define _CHS2                   0x10
#define _CHS3                   0x20
#define _CHS4                   0x40

//==============================================================================


//==============================================================================
//        ADCON1 Bits

extern __at(0x009E) __sfr ADCON1;

typedef union
  {
  struct
    {
    unsigned ADPREF0            : 1;
    unsigned ADPREF1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADCS0              : 1;
    unsigned ADCS1              : 1;
    unsigned ADCS2              : 1;
    unsigned ADFM               : 1;
    };

  struct
    {
    unsigned ADPREF             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ADCS               : 3;
    unsigned                    : 1;
    };
  } __ADCON1bits_t;

extern __at(0x009E) volatile __ADCON1bits_t ADCON1bits;

#define _ADPREF0                0x01
#define _ADPREF1                0x02
#define _ADCS0                  0x10
#define _ADCS1                  0x20
#define _ADCS2                  0x40
#define _ADFM                   0x80

//==============================================================================


//==============================================================================
//        ADCON2 Bits

extern __at(0x009F) __sfr ADCON2;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TRIGSEL0           : 1;
    unsigned TRIGSEL1           : 1;
    unsigned TRIGSEL2           : 1;
    unsigned TRIGSEL3           : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned TRIGSEL            : 4;
    };
  } __ADCON2bits_t;

extern __at(0x009F) volatile __ADCON2bits_t ADCON2bits;

#define _TRIGSEL0               0x10
#define _TRIGSEL1               0x20
#define _TRIGSEL2               0x40
#define _TRIGSEL3               0x80

//==============================================================================


//==============================================================================
//        LATA Bits

extern __at(0x010C) __sfr LATA;

typedef struct
  {
  unsigned LATA0                : 1;
  unsigned LATA1                : 1;
  unsigned LATA2                : 1;
  unsigned                      : 1;
  unsigned LATA4                : 1;
  unsigned LATA5                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __LATAbits_t;

extern __at(0x010C) volatile __LATAbits_t LATAbits;

#define _LATA0                  0x01
#define _LATA1                  0x02
#define _LATA2                  0x04
#define _LATA4                  0x10
#define _LATA5                  0x20

//==============================================================================


//==============================================================================
//        LATB Bits

extern __at(0x010D) __sfr LATB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned LATB4                : 1;
  unsigned LATB5                : 1;
  unsigned LATB6                : 1;
  unsigned LATB7                : 1;
  } __LATBbits_t;

extern __at(0x010D) volatile __LATBbits_t LATBbits;

#define _LATB4                  0x10
#define _LATB5                  0x20
#define _LATB6                  0x40
#define _LATB7                  0x80

//==============================================================================


//==============================================================================
//        LATC Bits

extern __at(0x010E) __sfr LATC;

typedef struct
  {
  unsigned LATC0                : 1;
  unsigned LATC1                : 1;
  unsigned LATC2                : 1;
  unsigned LATC3                : 1;
  unsigned LATC4                : 1;
  unsigned LATC5                : 1;
  unsigned LATC6                : 1;
  unsigned LATC7                : 1;
  } __LATCbits_t;

extern __at(0x010E) volatile __LATCbits_t LATCbits;

#define _LATC0                  0x01
#define _LATC1                  0x02
#define _LATC2                  0x04
#define _LATC3                  0x08
#define _LATC4                  0x10
#define _LATC5                  0x20
#define _LATC6                  0x40
#define _LATC7                  0x80

//==============================================================================


//==============================================================================
//        BORCON Bits

extern __at(0x0116) __sfr BORCON;

typedef struct
  {
  unsigned BORRDY               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned BORFS                : 1;
  unsigned SBOREN               : 1;
  } __BORCONbits_t;

extern __at(0x0116) volatile __BORCONbits_t BORCONbits;

#define _BORRDY                 0x01
#define _BORFS                  0x40
#define _SBOREN                 0x80

//==============================================================================


//==============================================================================
//        FVRCON Bits

extern __at(0x0117) __sfr FVRCON;

typedef union
  {
  struct
    {
    unsigned ADFVR0             : 1;
    unsigned ADFVR1             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TSRNG              : 1;
    unsigned TSEN               : 1;
    unsigned FVRRDY             : 1;
    unsigned FVREN              : 1;
    };

  struct
    {
    unsigned ADFVR              : 2;
    unsigned                    : 6;
    };
  } __FVRCONbits_t;

extern __at(0x0117) volatile __FVRCONbits_t FVRCONbits;

#define _ADFVR0                 0x01
#define _ADFVR1                 0x02
#define _TSRNG                  0x10
#define _TSEN                   0x20
#define _FVRRDY                 0x40
#define _FVREN                  0x80

//==============================================================================


//==============================================================================
//        APFCON Bits

extern __at(0x011D) __sfr APFCON;

typedef struct
  {
  unsigned NCO1SEL              : 1;
  unsigned CLC1SEL              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __APFCONbits_t;

extern __at(0x011D) volatile __APFCONbits_t APFCONbits;

#define _NCO1SEL                0x01
#define _CLC1SEL                0x02

//==============================================================================


//==============================================================================
//        ANSELA Bits

extern __at(0x018C) __sfr ANSELA;

typedef struct
  {
  unsigned ANSA0                : 1;
  unsigned ANSA1                : 1;
  unsigned ANSA2                : 1;
  unsigned                      : 1;
  unsigned ANSA4                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __ANSELAbits_t;

extern __at(0x018C) volatile __ANSELAbits_t ANSELAbits;

#define _ANSA0                  0x01
#define _ANSA1                  0x02
#define _ANSA2                  0x04
#define _ANSA4                  0x10

//==============================================================================


//==============================================================================
//        ANSELB Bits

extern __at(0x018D) __sfr ANSELB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ANSB4                : 1;
  unsigned ANSB5                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __ANSELBbits_t;

extern __at(0x018D) volatile __ANSELBbits_t ANSELBbits;

#define _ANSB4                  0x10
#define _ANSB5                  0x20

//==============================================================================


//==============================================================================
//        ANSELC Bits

extern __at(0x018E) __sfr ANSELC;

typedef struct
  {
  unsigned ANSC0                : 1;
  unsigned ANSC1                : 1;
  unsigned ANSC2                : 1;
  unsigned ANSC3                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ANSC6                : 1;
  unsigned ANSC7                : 1;
  } __ANSELCbits_t;

extern __at(0x018E) volatile __ANSELCbits_t ANSELCbits;

#define _ANSC0                  0x01
#define _ANSC1                  0x02
#define _ANSC2                  0x04
#define _ANSC3                  0x08
#define _ANSC6                  0x40
#define _ANSC7                  0x80

//==============================================================================

extern __at(0x0191) __sfr PMADR;
extern __at(0x0191) __sfr PMADRL;
extern __at(0x0192) __sfr PMADRH;
extern __at(0x0193) __sfr PMDAT;
extern __at(0x0193) __sfr PMDATL;
extern __at(0x0194) __sfr PMDATH;

//==============================================================================
//        PMCON1 Bits

extern __at(0x0195) __sfr PMCON1;

typedef struct
  {
  unsigned RD                   : 1;
  unsigned WR                   : 1;
  unsigned WREN                 : 1;
  unsigned WRERR                : 1;
  unsigned FREE                 : 1;
  unsigned LWLO                 : 1;
  unsigned CFGS                 : 1;
  unsigned EEPGD                : 1;
  } __PMCON1bits_t;

extern __at(0x0195) volatile __PMCON1bits_t PMCON1bits;

#define _RD                     0x01
#define _WR                     0x02
#define _WREN                   0x04
#define _WRERR                  0x08
#define _FREE                   0x10
#define _LWLO                   0x20
#define _CFGS                   0x40
#define _EEPGD                  0x80

//==============================================================================

extern __at(0x0196) __sfr PMCON2;

//==============================================================================
//        VREGCON Bits

extern __at(0x0197) __sfr VREGCON;

typedef union
  {
  struct
    {
    unsigned VREGPM0            : 1;
    unsigned VREGPM1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned VREGPM             : 2;
    unsigned                    : 6;
    };
  } __VREGCONbits_t;

extern __at(0x0197) volatile __VREGCONbits_t VREGCONbits;

#define _VREGPM0                0x01
#define _VREGPM1                0x02

//==============================================================================


//==============================================================================
//        WPUA Bits

extern __at(0x020C) __sfr WPUA;

typedef union
  {
  struct
    {
    unsigned WPUA0              : 1;
    unsigned WPUA1              : 1;
    unsigned WPUA2              : 1;
    unsigned WPUA3              : 1;
    unsigned WPUA4              : 1;
    unsigned WPUA5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned WPUA               : 6;
    unsigned                    : 2;
    };
  } __WPUAbits_t;

extern __at(0x020C) volatile __WPUAbits_t WPUAbits;

#define _WPUA0                  0x01
#define _WPUA1                  0x02
#define _WPUA2                  0x04
#define _WPUA3                  0x08
#define _WPUA4                  0x10
#define _WPUA5                  0x20

//==============================================================================


//==============================================================================
//        WPUB Bits

extern __at(0x020D) __sfr WPUB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned WPUB4                : 1;
  unsigned WPUB5                : 1;
  unsigned WPUB6                : 1;
  unsigned WPUB7                : 1;
  } __WPUBbits_t;

extern __at(0x020D) volatile __WPUBbits_t WPUBbits;

#define _WPUB4                  0x10
#define _WPUB5                  0x20
#define _WPUB6                  0x40
#define _WPUB7                  0x80

//==============================================================================


//==============================================================================
//        IOCAP Bits

extern __at(0x0391) __sfr IOCAP;

typedef union
  {
  struct
    {
    unsigned IOCAP0             : 1;
    unsigned IOCAP1             : 1;
    unsigned IOCAP2             : 1;
    unsigned IOCAP3             : 1;
    unsigned IOCAP4             : 1;
    unsigned IOCAP5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCAP              : 6;
    unsigned                    : 2;
    };
  } __IOCAPbits_t;

extern __at(0x0391) volatile __IOCAPbits_t IOCAPbits;

#define _IOCAP0                 0x01
#define _IOCAP1                 0x02
#define _IOCAP2                 0x04
#define _IOCAP3                 0x08
#define _IOCAP4                 0x10
#define _IOCAP5                 0x20

//==============================================================================


//==============================================================================
//        IOCAN Bits

extern __at(0x0392) __sfr IOCAN;

typedef union
  {
  struct
    {
    unsigned IOCAN0             : 1;
    unsigned IOCAN1             : 1;
    unsigned IOCAN2             : 1;
    unsigned IOCAN3             : 1;
    unsigned IOCAN4             : 1;
    unsigned IOCAN5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCAN              : 6;
    unsigned                    : 2;
    };
  } __IOCANbits_t;

extern __at(0x0392) volatile __IOCANbits_t IOCANbits;

#define _IOCAN0                 0x01
#define _IOCAN1                 0x02
#define _IOCAN2                 0x04
#define _IOCAN3                 0x08
#define _IOCAN4                 0x10
#define _IOCAN5                 0x20

//==============================================================================


//==============================================================================
//        IOCAF Bits

extern __at(0x0393) __sfr IOCAF;

typedef union
  {
  struct
    {
    unsigned IOCAF0             : 1;
    unsigned IOCAF1             : 1;
    unsigned IOCAF2             : 1;
    unsigned IOCAF3             : 1;
    unsigned IOCAF4             : 1;
    unsigned IOCAF5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCAF              : 6;
    unsigned                    : 2;
    };
  } __IOCAFbits_t;

extern __at(0x0393) volatile __IOCAFbits_t IOCAFbits;

#define _IOCAF0                 0x01
#define _IOCAF1                 0x02
#define _IOCAF2                 0x04
#define _IOCAF3                 0x08
#define _IOCAF4                 0x10
#define _IOCAF5                 0x20

//==============================================================================


//==============================================================================
//        IOCBP Bits

extern __at(0x0394) __sfr IOCBP;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned IOCBP4               : 1;
  unsigned IOCBP5               : 1;
  unsigned IOCBP6               : 1;
  unsigned IOCBP7               : 1;
  } __IOCBPbits_t;

extern __at(0x0394) volatile __IOCBPbits_t IOCBPbits;

#define _IOCBP4                 0x10
#define _IOCBP5                 0x20
#define _IOCBP6                 0x40
#define _IOCBP7                 0x80

//==============================================================================


//==============================================================================
//        IOCBN Bits

extern __at(0x0395) __sfr IOCBN;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned IOCBN4               : 1;
  unsigned IOCBN5               : 1;
  unsigned IOCBN6               : 1;
  unsigned IOCBN7               : 1;
  } __IOCBNbits_t;

extern __at(0x0395) volatile __IOCBNbits_t IOCBNbits;

#define _IOCBN4                 0x10
#define _IOCBN5                 0x20
#define _IOCBN6                 0x40
#define _IOCBN7                 0x80

//==============================================================================


//==============================================================================
//        IOCBF Bits

extern __at(0x0396) __sfr IOCBF;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned IOCBF4               : 1;
  unsigned IOCBF5               : 1;
  unsigned IOCBF6               : 1;
  unsigned IOCBF7               : 1;
  } __IOCBFbits_t;

extern __at(0x0396) volatile __IOCBFbits_t IOCBFbits;

#define _IOCBF4                 0x10
#define _IOCBF5                 0x20
#define _IOCBF6                 0x40
#define _IOCBF7                 0x80

//==============================================================================

extern __at(0x0498) __sfr NCO1ACC;

//==============================================================================
//        NCO1ACCL Bits

extern __at(0x0498) __sfr NCO1ACCL;

typedef struct
  {
  unsigned NCO1ACC0             : 1;
  unsigned NCO1ACC1             : 1;
  unsigned NCO1ACC2             : 1;
  unsigned NCO1ACC3             : 1;
  unsigned NCO1ACC4             : 1;
  unsigned NCO1ACC5             : 1;
  unsigned NCO1ACC6             : 1;
  unsigned NCO1ACC7             : 1;
  } __NCO1ACCLbits_t;

extern __at(0x0498) volatile __NCO1ACCLbits_t NCO1ACCLbits;

#define _NCO1ACC0               0x01
#define _NCO1ACC1               0x02
#define _NCO1ACC2               0x04
#define _NCO1ACC3               0x08
#define _NCO1ACC4               0x10
#define _NCO1ACC5               0x20
#define _NCO1ACC6               0x40
#define _NCO1ACC7               0x80

//==============================================================================


//==============================================================================
//        NCO1ACCH Bits

extern __at(0x0499) __sfr NCO1ACCH;

typedef struct
  {
  unsigned NCO1ACC8             : 1;
  unsigned NCO1ACC9             : 1;
  unsigned NCO1ACC10            : 1;
  unsigned NCO1ACC11            : 1;
  unsigned NCO1ACC12            : 1;
  unsigned NCO1ACC13            : 1;
  unsigned NCO1ACC14            : 1;
  unsigned NCO1ACC15            : 1;
  } __NCO1ACCHbits_t;

extern __at(0x0499) volatile __NCO1ACCHbits_t NCO1ACCHbits;

#define _NCO1ACC8               0x01
#define _NCO1ACC9               0x02
#define _NCO1ACC10              0x04
#define _NCO1ACC11              0x08
#define _NCO1ACC12              0x10
#define _NCO1ACC13              0x20
#define _NCO1ACC14              0x40
#define _NCO1ACC15              0x80

//==============================================================================


//==============================================================================
//        NCO1ACCU Bits

extern __at(0x049A) __sfr NCO1ACCU;

typedef struct
  {
  unsigned NCO1ACC16            : 1;
  unsigned NCO1ACC17            : 1;
  unsigned NCO1ACC18            : 1;
  unsigned NCO1ACC19            : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __NCO1ACCUbits_t;

extern __at(0x049A) volatile __NCO1ACCUbits_t NCO1ACCUbits;

#define _NCO1ACC16              0x01
#define _NCO1ACC17              0x02
#define _NCO1ACC18              0x04
#define _NCO1ACC19              0x08

//==============================================================================

extern __at(0x049B) __sfr NCO1INC;

//==============================================================================
//        NCO1INCL Bits

extern __at(0x049B) __sfr NCO1INCL;

typedef struct
  {
  unsigned NCO1INC0             : 1;
  unsigned NCO1INC1             : 1;
  unsigned NCO1INC2             : 1;
  unsigned NCO1INC3             : 1;
  unsigned NCO1INC4             : 1;
  unsigned NCO1INC5             : 1;
  unsigned NCO1INC6             : 1;
  unsigned NCO1INC7             : 1;
  } __NCO1INCLbits_t;

extern __at(0x049B) volatile __NCO1INCLbits_t NCO1INCLbits;

#define _NCO1INC0               0x01
#define _NCO1INC1               0x02
#define _NCO1INC2               0x04
#define _NCO1INC3               0x08
#define _NCO1INC4               0x10
#define _NCO1INC5               0x20
#define _NCO1INC6               0x40
#define _NCO1INC7               0x80

//==============================================================================


//==============================================================================
//        NCO1INCH Bits

extern __at(0x049C) __sfr NCO1INCH;

typedef struct
  {
  unsigned NCO1INC8             : 1;
  unsigned NCO1INC9             : 1;
  unsigned NCO1INC10            : 1;
  unsigned NCO1INC11            : 1;
  unsigned NCO1INC12            : 1;
  unsigned NCO1INC13            : 1;
  unsigned NCO1INC14            : 1;
  unsigned NCO1INC15            : 1;
  } __NCO1INCHbits_t;

extern __at(0x049C) volatile __NCO1INCHbits_t NCO1INCHbits;

#define _NCO1INC8               0x01
#define _NCO1INC9               0x02
#define _NCO1INC10              0x04
#define _NCO1INC11              0x08
#define _NCO1INC12              0x10
#define _NCO1INC13              0x20
#define _NCO1INC14              0x40
#define _NCO1INC15              0x80

//==============================================================================

extern __at(0x049D) __sfr NCO1INCU;

//==============================================================================
//        NCO1CON Bits

extern __at(0x049E) __sfr NCO1CON;

typedef struct
  {
  unsigned N1PFM                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned N1POL                : 1;
  unsigned N1OUT                : 1;
  unsigned N1OE                 : 1;
  unsigned N1EN                 : 1;
  } __NCO1CONbits_t;

extern __at(0x049E) volatile __NCO1CONbits_t NCO1CONbits;

#define _N1PFM                  0x01
#define _N1POL                  0x10
#define _N1OUT                  0x20
#define _N1OE                   0x40
#define _N1EN                   0x80

//==============================================================================


//==============================================================================
//        NCO1CLK Bits

extern __at(0x049F) __sfr NCO1CLK;

typedef union
  {
  struct
    {
    unsigned N1CKS0             : 1;
    unsigned N1CKS1             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned N1PWS0             : 1;
    unsigned N1PWS1             : 1;
    unsigned N1PWS2             : 1;
    };

  struct
    {
    unsigned N1CKS              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 5;
    unsigned N1PWS              : 3;
    };
  } __NCO1CLKbits_t;

extern __at(0x049F) volatile __NCO1CLKbits_t NCO1CLKbits;

#define _N1CKS0                 0x01
#define _N1CKS1                 0x02
#define _N1PWS0                 0x20
#define _N1PWS1                 0x40
#define _N1PWS2                 0x80

//==============================================================================


//==============================================================================
//        PWM1DCL Bits

extern __at(0x0611) __sfr PWM1DCL;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM1DCL0           : 1;
    unsigned PWM1DCL1           : 1;
    };

  struct
    {
    unsigned                    : 6;
    unsigned PWM1DCL            : 2;
    };
  } __PWM1DCLbits_t;

extern __at(0x0611) volatile __PWM1DCLbits_t PWM1DCLbits;

#define _PWM1DCL0               0x40
#define _PWM1DCL1               0x80

//==============================================================================


//==============================================================================
//        PWM1DCH Bits

extern __at(0x0612) __sfr PWM1DCH;

typedef struct
  {
  unsigned PWM1DCH0             : 1;
  unsigned PWM1DCH1             : 1;
  unsigned PWM1DCH2             : 1;
  unsigned PWM1DCH3             : 1;
  unsigned PWM1DCH4             : 1;
  unsigned PWM1DCH5             : 1;
  unsigned PWM1DCH6             : 1;
  unsigned PWM1DCH7             : 1;
  } __PWM1DCHbits_t;

extern __at(0x0612) volatile __PWM1DCHbits_t PWM1DCHbits;

#define _PWM1DCH0               0x01
#define _PWM1DCH1               0x02
#define _PWM1DCH2               0x04
#define _PWM1DCH3               0x08
#define _PWM1DCH4               0x10
#define _PWM1DCH5               0x20
#define _PWM1DCH6               0x40
#define _PWM1DCH7               0x80

//==============================================================================


//==============================================================================
//        PWM1CON Bits

extern __at(0x0613) __sfr PWM1CON;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PWM1POL              : 1;
  unsigned PWM1OUT              : 1;
  unsigned PWM1OE               : 1;
  unsigned PWM1EN               : 1;
  } __PWM1CONbits_t;

extern __at(0x0613) volatile __PWM1CONbits_t PWM1CONbits;

#define _PWM1POL                0x10
#define _PWM1OUT                0x20
#define _PWM1OE                 0x40
#define _PWM1EN                 0x80

//==============================================================================


//==============================================================================
//        PWM1CON0 Bits

extern __at(0x0613) __sfr PWM1CON0;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PWM1POL              : 1;
  unsigned PWM1OUT              : 1;
  unsigned PWM1OE               : 1;
  unsigned PWM1EN               : 1;
  } __PWM1CON0bits_t;

extern __at(0x0613) volatile __PWM1CON0bits_t PWM1CON0bits;

#define _PWM1CON0_PWM1POL       0x10
#define _PWM1CON0_PWM1OUT       0x20
#define _PWM1CON0_PWM1OE        0x40
#define _PWM1CON0_PWM1EN        0x80

//==============================================================================


//==============================================================================
//        PWM2DCL Bits

extern __at(0x0614) __sfr PWM2DCL;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM2DCL0           : 1;
    unsigned PWM2DCL1           : 1;
    };

  struct
    {
    unsigned                    : 6;
    unsigned PWM2DCL            : 2;
    };
  } __PWM2DCLbits_t;

extern __at(0x0614) volatile __PWM2DCLbits_t PWM2DCLbits;

#define _PWM2DCL0               0x40
#define _PWM2DCL1               0x80

//==============================================================================


//==============================================================================
//        PWM2DCH Bits

extern __at(0x0615) __sfr PWM2DCH;

typedef struct
  {
  unsigned PWM2DCH0             : 1;
  unsigned PWM2DCH1             : 1;
  unsigned PWM2DCH2             : 1;
  unsigned PWM2DCH3             : 1;
  unsigned PWM2DCH4             : 1;
  unsigned PWM2DCH5             : 1;
  unsigned PWM2DCH6             : 1;
  unsigned PWM2DCH7             : 1;
  } __PWM2DCHbits_t;

extern __at(0x0615) volatile __PWM2DCHbits_t PWM2DCHbits;

#define _PWM2DCH0               0x01
#define _PWM2DCH1               0x02
#define _PWM2DCH2               0x04
#define _PWM2DCH3               0x08
#define _PWM2DCH4               0x10
#define _PWM2DCH5               0x20
#define _PWM2DCH6               0x40
#define _PWM2DCH7               0x80

//==============================================================================


//==============================================================================
//        PWM2CON Bits

extern __at(0x0616) __sfr PWM2CON;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PWM2POL              : 1;
  unsigned PWM2OUT              : 1;
  unsigned PWM2OE               : 1;
  unsigned PWM2EN               : 1;
  } __PWM2CONbits_t;

extern __at(0x0616) volatile __PWM2CONbits_t PWM2CONbits;

#define _PWM2POL                0x10
#define _PWM2OUT                0x20
#define _PWM2OE                 0x40
#define _PWM2EN                 0x80

//==============================================================================


//==============================================================================
//        PWM2CON0 Bits

extern __at(0x0616) __sfr PWM2CON0;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PWM2POL              : 1;
  unsigned PWM2OUT              : 1;
  unsigned PWM2OE               : 1;
  unsigned PWM2EN               : 1;
  } __PWM2CON0bits_t;

extern __at(0x0616) volatile __PWM2CON0bits_t PWM2CON0bits;

#define _PWM2CON0_PWM2POL       0x10
#define _PWM2CON0_PWM2OUT       0x20
#define _PWM2CON0_PWM2OE        0x40
#define _PWM2CON0_PWM2EN        0x80

//==============================================================================


//==============================================================================
//        PWM3DCL Bits

extern __at(0x0617) __sfr PWM3DCL;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM3DCL0           : 1;
    unsigned PWM3DCL1           : 1;
    };

  struct
    {
    unsigned                    : 6;
    unsigned PWM3DCL            : 2;
    };
  } __PWM3DCLbits_t;

extern __at(0x0617) volatile __PWM3DCLbits_t PWM3DCLbits;

#define _PWM3DCL0               0x40
#define _PWM3DCL1               0x80

//==============================================================================


//==============================================================================
//        PWM3DCH Bits

extern __at(0x0618) __sfr PWM3DCH;

typedef struct
  {
  unsigned PWM3DCH0             : 1;
  unsigned PWM3DCH1             : 1;
  unsigned PWM3DCH2             : 1;
  unsigned PWM3DCH3             : 1;
  unsigned PWM3DCH4             : 1;
  unsigned PWM3DCH5             : 1;
  unsigned PWM3DCH6             : 1;
  unsigned PWM3DCH7             : 1;
  } __PWM3DCHbits_t;

extern __at(0x0618) volatile __PWM3DCHbits_t PWM3DCHbits;

#define _PWM3DCH0               0x01
#define _PWM3DCH1               0x02
#define _PWM3DCH2               0x04
#define _PWM3DCH3               0x08
#define _PWM3DCH4               0x10
#define _PWM3DCH5               0x20
#define _PWM3DCH6               0x40
#define _PWM3DCH7               0x80

//==============================================================================


//==============================================================================
//        PWM3CON Bits

extern __at(0x0619) __sfr PWM3CON;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PWM3POL              : 1;
  unsigned PWM3OUT              : 1;
  unsigned PWM3OE               : 1;
  unsigned PWM3EN               : 1;
  } __PWM3CONbits_t;

extern __at(0x0619) volatile __PWM3CONbits_t PWM3CONbits;

#define _PWM3POL                0x10
#define _PWM3OUT                0x20
#define _PWM3OE                 0x40
#define _PWM3EN                 0x80

//==============================================================================


//==============================================================================
//        PWM3CON0 Bits

extern __at(0x0619) __sfr PWM3CON0;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PWM3POL              : 1;
  unsigned PWM3OUT              : 1;
  unsigned PWM3OE               : 1;
  unsigned PWM3EN               : 1;
  } __PWM3CON0bits_t;

extern __at(0x0619) volatile __PWM3CON0bits_t PWM3CON0bits;

#define _PWM3CON0_PWM3POL       0x10
#define _PWM3CON0_PWM3OUT       0x20
#define _PWM3CON0_PWM3OE        0x40
#define _PWM3CON0_PWM3EN        0x80

//==============================================================================


//==============================================================================
//        PWM4DCL Bits

extern __at(0x061A) __sfr PWM4DCL;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM4DCL0           : 1;
    unsigned PWM4DCL1           : 1;
    };

  struct
    {
    unsigned                    : 6;
    unsigned PWM4DCL            : 2;
    };
  } __PWM4DCLbits_t;

extern __at(0x061A) volatile __PWM4DCLbits_t PWM4DCLbits;

#define _PWM4DCL0               0x40
#define _PWM4DCL1               0x80

//==============================================================================


//==============================================================================
//        PWM4DCH Bits

extern __at(0x061B) __sfr PWM4DCH;

typedef struct
  {
  unsigned PWM4DCH0             : 1;
  unsigned PWM4DCH1             : 1;
  unsigned PWM4DCH2             : 1;
  unsigned PWM4DCH3             : 1;
  unsigned PWM4DCH4             : 1;
  unsigned PWM4DCH5             : 1;
  unsigned PWM4DCH6             : 1;
  unsigned PWM4DCH7             : 1;
  } __PWM4DCHbits_t;

extern __at(0x061B) volatile __PWM4DCHbits_t PWM4DCHbits;

#define _PWM4DCH0               0x01
#define _PWM4DCH1               0x02
#define _PWM4DCH2               0x04
#define _PWM4DCH3               0x08
#define _PWM4DCH4               0x10
#define _PWM4DCH5               0x20
#define _PWM4DCH6               0x40
#define _PWM4DCH7               0x80

//==============================================================================


//==============================================================================
//        PWM4CON Bits

extern __at(0x061C) __sfr PWM4CON;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PWM4POL              : 1;
  unsigned PWM4OUT              : 1;
  unsigned PWM4OE               : 1;
  unsigned PWM4EN               : 1;
  } __PWM4CONbits_t;

extern __at(0x061C) volatile __PWM4CONbits_t PWM4CONbits;

#define _PWM4POL                0x10
#define _PWM4OUT                0x20
#define _PWM4OE                 0x40
#define _PWM4EN                 0x80

//==============================================================================


//==============================================================================
//        PWM4CON0 Bits

extern __at(0x061C) __sfr PWM4CON0;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PWM4POL              : 1;
  unsigned PWM4OUT              : 1;
  unsigned PWM4OE               : 1;
  unsigned PWM4EN               : 1;
  } __PWM4CON0bits_t;

extern __at(0x061C) volatile __PWM4CON0bits_t PWM4CON0bits;

#define _PWM4CON0_PWM4POL       0x10
#define _PWM4CON0_PWM4OUT       0x20
#define _PWM4CON0_PWM4OE        0x40
#define _PWM4CON0_PWM4EN        0x80

//==============================================================================


//==============================================================================
//        CWG1DBR Bits

extern __at(0x0691) __sfr CWG1DBR;

typedef union
  {
  struct
    {
    unsigned CWG1DBR0           : 1;
    unsigned CWG1DBR1           : 1;
    unsigned CWG1DBR2           : 1;
    unsigned CWG1DBR3           : 1;
    unsigned CWG1DBR4           : 1;
    unsigned CWG1DBR5           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG1DBR            : 6;
    unsigned                    : 2;
    };
  } __CWG1DBRbits_t;

extern __at(0x0691) volatile __CWG1DBRbits_t CWG1DBRbits;

#define _CWG1DBR0               0x01
#define _CWG1DBR1               0x02
#define _CWG1DBR2               0x04
#define _CWG1DBR3               0x08
#define _CWG1DBR4               0x10
#define _CWG1DBR5               0x20

//==============================================================================


//==============================================================================
//        CWG1DBF Bits

extern __at(0x0692) __sfr CWG1DBF;

typedef union
  {
  struct
    {
    unsigned CWG1DBF0           : 1;
    unsigned CWG1DBF1           : 1;
    unsigned CWG1DBF2           : 1;
    unsigned CWG1DBF3           : 1;
    unsigned CWG1DBF4           : 1;
    unsigned CWG1DBF5           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CWG1DBF            : 6;
    unsigned                    : 2;
    };
  } __CWG1DBFbits_t;

extern __at(0x0692) volatile __CWG1DBFbits_t CWG1DBFbits;

#define _CWG1DBF0               0x01
#define _CWG1DBF1               0x02
#define _CWG1DBF2               0x04
#define _CWG1DBF3               0x08
#define _CWG1DBF4               0x10
#define _CWG1DBF5               0x20

//==============================================================================


//==============================================================================
//        CWG1CON0 Bits

extern __at(0x0693) __sfr CWG1CON0;

typedef struct
  {
  unsigned G1CS0                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned G1POLA               : 1;
  unsigned G1POLB               : 1;
  unsigned G1OEA                : 1;
  unsigned G1OEB                : 1;
  unsigned G1EN                 : 1;
  } __CWG1CON0bits_t;

extern __at(0x0693) volatile __CWG1CON0bits_t CWG1CON0bits;

#define _G1CS0                  0x01
#define _G1POLA                 0x08
#define _G1POLB                 0x10
#define _G1OEA                  0x20
#define _G1OEB                  0x40
#define _G1EN                   0x80

//==============================================================================


//==============================================================================
//        CWG1CON1 Bits

extern __at(0x0694) __sfr CWG1CON1;

typedef union
  {
  struct
    {
    unsigned G1IS0              : 1;
    unsigned G1IS1              : 1;
    unsigned G1IS2              : 1;
    unsigned                    : 1;
    unsigned G1ASDLA0           : 1;
    unsigned G1ASDLA1           : 1;
    unsigned G1ASDLB0           : 1;
    unsigned G1ASDLB1           : 1;
    };

  struct
    {
    unsigned G1IS               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 4;
    unsigned G1ASDLA            : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned G1ASDLB            : 2;
    };
  } __CWG1CON1bits_t;

extern __at(0x0694) volatile __CWG1CON1bits_t CWG1CON1bits;

#define _G1IS0                  0x01
#define _G1IS1                  0x02
#define _G1IS2                  0x04
#define _G1ASDLA0               0x10
#define _G1ASDLA1               0x20
#define _G1ASDLB0               0x40
#define _G1ASDLB1               0x80

//==============================================================================


//==============================================================================
//        CWG1CON2 Bits

extern __at(0x0695) __sfr CWG1CON2;

typedef struct
  {
  unsigned G1ASDSCLC2           : 1;
  unsigned G1ASDSFLT            : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned G1ARSEN              : 1;
  unsigned G1ASE                : 1;
  } __CWG1CON2bits_t;

extern __at(0x0695) volatile __CWG1CON2bits_t CWG1CON2bits;

#define _G1ASDSCLC2             0x01
#define _G1ASDSFLT              0x02
#define _G1ARSEN                0x40
#define _G1ASE                  0x80

//==============================================================================


//==============================================================================
//        CLCDATA Bits

extern __at(0x0F0F) __sfr CLCDATA;

typedef struct
  {
  unsigned MCLC1OUT             : 1;
  unsigned MCLC2OUT             : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __CLCDATAbits_t;

extern __at(0x0F0F) volatile __CLCDATAbits_t CLCDATAbits;

#define _MCLC1OUT               0x01
#define _MCLC2OUT               0x02

//==============================================================================


//==============================================================================
//        CLC1CON Bits

extern __at(0x0F10) __sfr CLC1CON;

typedef union
  {
  struct
    {
    unsigned LC1MODE0           : 1;
    unsigned LC1MODE1           : 1;
    unsigned LC1MODE2           : 1;
    unsigned LC1INTN            : 1;
    unsigned LC1INTP            : 1;
    unsigned LC1OUT             : 1;
    unsigned LC1OE              : 1;
    unsigned LC1EN              : 1;
    };

  struct
    {
    unsigned LCMODE0            : 1;
    unsigned LCMODE1            : 1;
    unsigned LCMODE2            : 1;
    unsigned LCINTN             : 1;
    unsigned LCINTP             : 1;
    unsigned LCOUT              : 1;
    unsigned LCOE               : 1;
    unsigned LCEN               : 1;
    };

  struct
    {
    unsigned LC1MODE            : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned LCMODE             : 3;
    unsigned                    : 5;
    };
  } __CLC1CONbits_t;

extern __at(0x0F10) volatile __CLC1CONbits_t CLC1CONbits;

#define _LC1MODE0               0x01
#define _LCMODE0                0x01
#define _LC1MODE1               0x02
#define _LCMODE1                0x02
#define _LC1MODE2               0x04
#define _LCMODE2                0x04
#define _LC1INTN                0x08
#define _LCINTN                 0x08
#define _LC1INTP                0x10
#define _LCINTP                 0x10
#define _LC1OUT                 0x20
#define _LCOUT                  0x20
#define _LC1OE                  0x40
#define _LCOE                   0x40
#define _LC1EN                  0x80
#define _LCEN                   0x80

//==============================================================================


//==============================================================================
//        CLC1POL Bits

extern __at(0x0F11) __sfr CLC1POL;

typedef union
  {
  struct
    {
    unsigned LC1G1POL           : 1;
    unsigned LC1G2POL           : 1;
    unsigned LC1G3POL           : 1;
    unsigned LC1G4POL           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LC1POL             : 1;
    };

  struct
    {
    unsigned G1POL              : 1;
    unsigned G2POL              : 1;
    unsigned G3POL              : 1;
    unsigned G4POL              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned POL                : 1;
    };
  } __CLC1POLbits_t;

extern __at(0x0F11) volatile __CLC1POLbits_t CLC1POLbits;

#define _LC1G1POL               0x01
#define _G1POL                  0x01
#define _LC1G2POL               0x02
#define _G2POL                  0x02
#define _LC1G3POL               0x04
#define _G3POL                  0x04
#define _LC1G4POL               0x08
#define _G4POL                  0x08
#define _LC1POL                 0x80
#define _POL                    0x80

//==============================================================================


//==============================================================================
//        CLC1SEL0 Bits

extern __at(0x0F12) __sfr CLC1SEL0;

typedef union
  {
  struct
    {
    unsigned LC1D1S0            : 1;
    unsigned LC1D1S1            : 1;
    unsigned LC1D1S2            : 1;
    unsigned                    : 1;
    unsigned LC1D2S0            : 1;
    unsigned LC1D2S1            : 1;
    unsigned LC1D2S2            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D1S0               : 1;
    unsigned D1S1               : 1;
    unsigned D1S2               : 1;
    unsigned                    : 1;
    unsigned D2S0               : 1;
    unsigned D2S1               : 1;
    unsigned D2S2               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D1S                : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned LC1D1S             : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 4;
    unsigned LC1D2S             : 3;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned D2S                : 3;
    unsigned                    : 1;
    };
  } __CLC1SEL0bits_t;

extern __at(0x0F12) volatile __CLC1SEL0bits_t CLC1SEL0bits;

#define _LC1D1S0                0x01
#define _D1S0                   0x01
#define _LC1D1S1                0x02
#define _D1S1                   0x02
#define _LC1D1S2                0x04
#define _D1S2                   0x04
#define _LC1D2S0                0x10
#define _D2S0                   0x10
#define _LC1D2S1                0x20
#define _D2S1                   0x20
#define _LC1D2S2                0x40
#define _D2S2                   0x40

//==============================================================================


//==============================================================================
//        CLC1SEL1 Bits

extern __at(0x0F13) __sfr CLC1SEL1;

typedef union
  {
  struct
    {
    unsigned LC1D3S0            : 1;
    unsigned LC1D3S1            : 1;
    unsigned LC1D3S2            : 1;
    unsigned                    : 1;
    unsigned LC1D4S0            : 1;
    unsigned LC1D4S1            : 1;
    unsigned LC1D4S2            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D3S0               : 1;
    unsigned D3S1               : 1;
    unsigned D3S2               : 1;
    unsigned                    : 1;
    unsigned D4S0               : 1;
    unsigned D4S1               : 1;
    unsigned D4S2               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D3S                : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned LC1D3S             : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 4;
    unsigned D4S                : 3;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned LC1D4S             : 3;
    unsigned                    : 1;
    };
  } __CLC1SEL1bits_t;

extern __at(0x0F13) volatile __CLC1SEL1bits_t CLC1SEL1bits;

#define _LC1D3S0                0x01
#define _D3S0                   0x01
#define _LC1D3S1                0x02
#define _D3S1                   0x02
#define _LC1D3S2                0x04
#define _D3S2                   0x04
#define _LC1D4S0                0x10
#define _D4S0                   0x10
#define _LC1D4S1                0x20
#define _D4S1                   0x20
#define _LC1D4S2                0x40
#define _D4S2                   0x40

//==============================================================================


//==============================================================================
//        CLC1GLS0 Bits

extern __at(0x0F14) __sfr CLC1GLS0;

typedef union
  {
  struct
    {
    unsigned LC1G1D1N           : 1;
    unsigned LC1G1D1T           : 1;
    unsigned LC1G1D2N           : 1;
    unsigned LC1G1D2T           : 1;
    unsigned LC1G1D3N           : 1;
    unsigned LC1G1D3T           : 1;
    unsigned LC1G1D4N           : 1;
    unsigned LC1G1D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC1GLS0bits_t;

extern __at(0x0F14) volatile __CLC1GLS0bits_t CLC1GLS0bits;

#define _LC1G1D1N               0x01
#define _D1N                    0x01
#define _LC1G1D1T               0x02
#define _D1T                    0x02
#define _LC1G1D2N               0x04
#define _D2N                    0x04
#define _LC1G1D2T               0x08
#define _D2T                    0x08
#define _LC1G1D3N               0x10
#define _D3N                    0x10
#define _LC1G1D3T               0x20
#define _D3T                    0x20
#define _LC1G1D4N               0x40
#define _D4N                    0x40
#define _LC1G1D4T               0x80
#define _D4T                    0x80

//==============================================================================


//==============================================================================
//        CLC1GLS1 Bits

extern __at(0x0F15) __sfr CLC1GLS1;

typedef union
  {
  struct
    {
    unsigned LC1G2D1N           : 1;
    unsigned LC1G2D1T           : 1;
    unsigned LC1G2D2N           : 1;
    unsigned LC1G2D2T           : 1;
    unsigned LC1G2D3N           : 1;
    unsigned LC1G2D3T           : 1;
    unsigned LC1G2D4N           : 1;
    unsigned LC1G2D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC1GLS1bits_t;

extern __at(0x0F15) volatile __CLC1GLS1bits_t CLC1GLS1bits;

#define _CLC1GLS1_LC1G2D1N      0x01
#define _CLC1GLS1_D1N           0x01
#define _CLC1GLS1_LC1G2D1T      0x02
#define _CLC1GLS1_D1T           0x02
#define _CLC1GLS1_LC1G2D2N      0x04
#define _CLC1GLS1_D2N           0x04
#define _CLC1GLS1_LC1G2D2T      0x08
#define _CLC1GLS1_D2T           0x08
#define _CLC1GLS1_LC1G2D3N      0x10
#define _CLC1GLS1_D3N           0x10
#define _CLC1GLS1_LC1G2D3T      0x20
#define _CLC1GLS1_D3T           0x20
#define _CLC1GLS1_LC1G2D4N      0x40
#define _CLC1GLS1_D4N           0x40
#define _CLC1GLS1_LC1G2D4T      0x80
#define _CLC1GLS1_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC1GLS2 Bits

extern __at(0x0F16) __sfr CLC1GLS2;

typedef union
  {
  struct
    {
    unsigned LC1G3D1N           : 1;
    unsigned LC1G3D1T           : 1;
    unsigned LC1G3D2N           : 1;
    unsigned LC1G3D2T           : 1;
    unsigned LC1G3D3N           : 1;
    unsigned LC1G3D3T           : 1;
    unsigned LC1G3D4N           : 1;
    unsigned LC1G3D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC1GLS2bits_t;

extern __at(0x0F16) volatile __CLC1GLS2bits_t CLC1GLS2bits;

#define _CLC1GLS2_LC1G3D1N      0x01
#define _CLC1GLS2_D1N           0x01
#define _CLC1GLS2_LC1G3D1T      0x02
#define _CLC1GLS2_D1T           0x02
#define _CLC1GLS2_LC1G3D2N      0x04
#define _CLC1GLS2_D2N           0x04
#define _CLC1GLS2_LC1G3D2T      0x08
#define _CLC1GLS2_D2T           0x08
#define _CLC1GLS2_LC1G3D3N      0x10
#define _CLC1GLS2_D3N           0x10
#define _CLC1GLS2_LC1G3D3T      0x20
#define _CLC1GLS2_D3T           0x20
#define _CLC1GLS2_LC1G3D4N      0x40
#define _CLC1GLS2_D4N           0x40
#define _CLC1GLS2_LC1G3D4T      0x80
#define _CLC1GLS2_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC1GLS3 Bits

extern __at(0x0F17) __sfr CLC1GLS3;

typedef union
  {
  struct
    {
    unsigned LC1G4D1N           : 1;
    unsigned LC1G4D1T           : 1;
    unsigned LC1G4D2N           : 1;
    unsigned LC1G4D2T           : 1;
    unsigned LC1G4D3N           : 1;
    unsigned LC1G4D3T           : 1;
    unsigned LC1G4D4N           : 1;
    unsigned LC1G4D4T           : 1;
    };

  struct
    {
    unsigned G4D1N              : 1;
    unsigned G4D1T              : 1;
    unsigned G4D2N              : 1;
    unsigned G4D2T              : 1;
    unsigned G4D3N              : 1;
    unsigned G4D3T              : 1;
    unsigned G4D4N              : 1;
    unsigned G4D4T              : 1;
    };
  } __CLC1GLS3bits_t;

extern __at(0x0F17) volatile __CLC1GLS3bits_t CLC1GLS3bits;

#define _LC1G4D1N               0x01
#define _G4D1N                  0x01
#define _LC1G4D1T               0x02
#define _G4D1T                  0x02
#define _LC1G4D2N               0x04
#define _G4D2N                  0x04
#define _LC1G4D2T               0x08
#define _G4D2T                  0x08
#define _LC1G4D3N               0x10
#define _G4D3N                  0x10
#define _LC1G4D3T               0x20
#define _G4D3T                  0x20
#define _LC1G4D4N               0x40
#define _G4D4N                  0x40
#define _LC1G4D4T               0x80
#define _G4D4T                  0x80

//==============================================================================


//==============================================================================
//        CLC2CON Bits

extern __at(0x0F18) __sfr CLC2CON;

typedef union
  {
  struct
    {
    unsigned LC2MODE0           : 1;
    unsigned LC2MODE1           : 1;
    unsigned LC2MODE2           : 1;
    unsigned LC2INTN            : 1;
    unsigned LC2INTP            : 1;
    unsigned LC2OUT             : 1;
    unsigned LC2OE              : 1;
    unsigned LC2EN              : 1;
    };

  struct
    {
    unsigned LCMODE0            : 1;
    unsigned LCMODE1            : 1;
    unsigned LCMODE2            : 1;
    unsigned LCINTN             : 1;
    unsigned LCINTP             : 1;
    unsigned LCOUT              : 1;
    unsigned LCOE               : 1;
    unsigned LCEN               : 1;
    };

  struct
    {
    unsigned LC2MODE            : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned LCMODE             : 3;
    unsigned                    : 5;
    };
  } __CLC2CONbits_t;

extern __at(0x0F18) volatile __CLC2CONbits_t CLC2CONbits;

#define _CLC2CON_LC2MODE0       0x01
#define _CLC2CON_LCMODE0        0x01
#define _CLC2CON_LC2MODE1       0x02
#define _CLC2CON_LCMODE1        0x02
#define _CLC2CON_LC2MODE2       0x04
#define _CLC2CON_LCMODE2        0x04
#define _CLC2CON_LC2INTN        0x08
#define _CLC2CON_LCINTN         0x08
#define _CLC2CON_LC2INTP        0x10
#define _CLC2CON_LCINTP         0x10
#define _CLC2CON_LC2OUT         0x20
#define _CLC2CON_LCOUT          0x20
#define _CLC2CON_LC2OE          0x40
#define _CLC2CON_LCOE           0x40
#define _CLC2CON_LC2EN          0x80
#define _CLC2CON_LCEN           0x80

//==============================================================================


//==============================================================================
//        CLC2POL Bits

extern __at(0x0F19) __sfr CLC2POL;

typedef union
  {
  struct
    {
    unsigned LC2G1POL           : 1;
    unsigned LC2G2POL           : 1;
    unsigned LC2G3POL           : 1;
    unsigned LC2G4POL           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LC2POL             : 1;
    };

  struct
    {
    unsigned G1POL              : 1;
    unsigned G2POL              : 1;
    unsigned G3POL              : 1;
    unsigned G4POL              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned POL                : 1;
    };
  } __CLC2POLbits_t;

extern __at(0x0F19) volatile __CLC2POLbits_t CLC2POLbits;

#define _CLC2POL_LC2G1POL       0x01
#define _CLC2POL_G1POL          0x01
#define _CLC2POL_LC2G2POL       0x02
#define _CLC2POL_G2POL          0x02
#define _CLC2POL_LC2G3POL       0x04
#define _CLC2POL_G3POL          0x04
#define _CLC2POL_LC2G4POL       0x08
#define _CLC2POL_G4POL          0x08
#define _CLC2POL_LC2POL         0x80
#define _CLC2POL_POL            0x80

//==============================================================================


//==============================================================================
//        CLC2SEL0 Bits

extern __at(0x0F1A) __sfr CLC2SEL0;

typedef union
  {
  struct
    {
    unsigned LC2D1S0            : 1;
    unsigned LC2D1S1            : 1;
    unsigned LC2D1S2            : 1;
    unsigned                    : 1;
    unsigned LC2D2S0            : 1;
    unsigned LC2D2S1            : 1;
    unsigned LC2D2S2            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D1S0               : 1;
    unsigned D1S1               : 1;
    unsigned D1S2               : 1;
    unsigned                    : 1;
    unsigned D2S0               : 1;
    unsigned D2S1               : 1;
    unsigned D2S2               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC2D1S             : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned D1S                : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 4;
    unsigned LC2D2S             : 3;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned D2S                : 3;
    unsigned                    : 1;
    };
  } __CLC2SEL0bits_t;

extern __at(0x0F1A) volatile __CLC2SEL0bits_t CLC2SEL0bits;

#define _CLC2SEL0_LC2D1S0       0x01
#define _CLC2SEL0_D1S0          0x01
#define _CLC2SEL0_LC2D1S1       0x02
#define _CLC2SEL0_D1S1          0x02
#define _CLC2SEL0_LC2D1S2       0x04
#define _CLC2SEL0_D1S2          0x04
#define _CLC2SEL0_LC2D2S0       0x10
#define _CLC2SEL0_D2S0          0x10
#define _CLC2SEL0_LC2D2S1       0x20
#define _CLC2SEL0_D2S1          0x20
#define _CLC2SEL0_LC2D2S2       0x40
#define _CLC2SEL0_D2S2          0x40

//==============================================================================


//==============================================================================
//        CLC2SEL1 Bits

extern __at(0x0F1B) __sfr CLC2SEL1;

typedef union
  {
  struct
    {
    unsigned LC2D3S0            : 1;
    unsigned LC2D3S1            : 1;
    unsigned LC2D3S2            : 1;
    unsigned                    : 1;
    unsigned LC2D4S0            : 1;
    unsigned LC2D4S1            : 1;
    unsigned LC2D4S2            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D3S0               : 1;
    unsigned D3S1               : 1;
    unsigned D3S2               : 1;
    unsigned                    : 1;
    unsigned D4S0               : 1;
    unsigned D4S1               : 1;
    unsigned D4S2               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D3S                : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned LC2D3S             : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 4;
    unsigned D4S                : 3;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned LC2D4S             : 3;
    unsigned                    : 1;
    };
  } __CLC2SEL1bits_t;

extern __at(0x0F1B) volatile __CLC2SEL1bits_t CLC2SEL1bits;

#define _CLC2SEL1_LC2D3S0       0x01
#define _CLC2SEL1_D3S0          0x01
#define _CLC2SEL1_LC2D3S1       0x02
#define _CLC2SEL1_D3S1          0x02
#define _CLC2SEL1_LC2D3S2       0x04
#define _CLC2SEL1_D3S2          0x04
#define _CLC2SEL1_LC2D4S0       0x10
#define _CLC2SEL1_D4S0          0x10
#define _CLC2SEL1_LC2D4S1       0x20
#define _CLC2SEL1_D4S1          0x20
#define _CLC2SEL1_LC2D4S2       0x40
#define _CLC2SEL1_D4S2          0x40

//==============================================================================


//==============================================================================
//        CLC2GLS0 Bits

extern __at(0x0F1C) __sfr CLC2GLS0;

typedef union
  {
  struct
    {
    unsigned LC2G1D1N           : 1;
    unsigned LC2G1D1T           : 1;
    unsigned LC2G1D2N           : 1;
    unsigned LC2G1D2T           : 1;
    unsigned LC2G1D3N           : 1;
    unsigned LC2G1D3T           : 1;
    unsigned LC2G1D4N           : 1;
    unsigned LC2G1D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC2GLS0bits_t;

extern __at(0x0F1C) volatile __CLC2GLS0bits_t CLC2GLS0bits;

#define _CLC2GLS0_LC2G1D1N      0x01
#define _CLC2GLS0_D1N           0x01
#define _CLC2GLS0_LC2G1D1T      0x02
#define _CLC2GLS0_D1T           0x02
#define _CLC2GLS0_LC2G1D2N      0x04
#define _CLC2GLS0_D2N           0x04
#define _CLC2GLS0_LC2G1D2T      0x08
#define _CLC2GLS0_D2T           0x08
#define _CLC2GLS0_LC2G1D3N      0x10
#define _CLC2GLS0_D3N           0x10
#define _CLC2GLS0_LC2G1D3T      0x20
#define _CLC2GLS0_D3T           0x20
#define _CLC2GLS0_LC2G1D4N      0x40
#define _CLC2GLS0_D4N           0x40
#define _CLC2GLS0_LC2G1D4T      0x80
#define _CLC2GLS0_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC2GLS1 Bits

extern __at(0x0F1D) __sfr CLC2GLS1;

typedef union
  {
  struct
    {
    unsigned LC2G2D1N           : 1;
    unsigned LC2G2D1T           : 1;
    unsigned LC2G2D2N           : 1;
    unsigned LC2G2D2T           : 1;
    unsigned LC2G2D3N           : 1;
    unsigned LC2G2D3T           : 1;
    unsigned LC2G2D4N           : 1;
    unsigned LC2G2D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC2GLS1bits_t;

extern __at(0x0F1D) volatile __CLC2GLS1bits_t CLC2GLS1bits;

#define _CLC2GLS1_LC2G2D1N      0x01
#define _CLC2GLS1_D1N           0x01
#define _CLC2GLS1_LC2G2D1T      0x02
#define _CLC2GLS1_D1T           0x02
#define _CLC2GLS1_LC2G2D2N      0x04
#define _CLC2GLS1_D2N           0x04
#define _CLC2GLS1_LC2G2D2T      0x08
#define _CLC2GLS1_D2T           0x08
#define _CLC2GLS1_LC2G2D3N      0x10
#define _CLC2GLS1_D3N           0x10
#define _CLC2GLS1_LC2G2D3T      0x20
#define _CLC2GLS1_D3T           0x20
#define _CLC2GLS1_LC2G2D4N      0x40
#define _CLC2GLS1_D4N           0x40
#define _CLC2GLS1_LC2G2D4T      0x80
#define _CLC2GLS1_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC2GLS2 Bits

extern __at(0x0F1E) __sfr CLC2GLS2;

typedef union
  {
  struct
    {
    unsigned LC2G3D1N           : 1;
    unsigned LC2G3D1T           : 1;
    unsigned LC2G3D2N           : 1;
    unsigned LC2G3D2T           : 1;
    unsigned LC2G3D3N           : 1;
    unsigned LC2G3D3T           : 1;
    unsigned LC2G3D4N           : 1;
    unsigned LC2G3D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC2GLS2bits_t;

extern __at(0x0F1E) volatile __CLC2GLS2bits_t CLC2GLS2bits;

#define _CLC2GLS2_LC2G3D1N      0x01
#define _CLC2GLS2_D1N           0x01
#define _CLC2GLS2_LC2G3D1T      0x02
#define _CLC2GLS2_D1T           0x02
#define _CLC2GLS2_LC2G3D2N      0x04
#define _CLC2GLS2_D2N           0x04
#define _CLC2GLS2_LC2G3D2T      0x08
#define _CLC2GLS2_D2T           0x08
#define _CLC2GLS2_LC2G3D3N      0x10
#define _CLC2GLS2_D3N           0x10
#define _CLC2GLS2_LC2G3D3T      0x20
#define _CLC2GLS2_D3T           0x20
#define _CLC2GLS2_LC2G3D4N      0x40
#define _CLC2GLS2_D4N           0x40
#define _CLC2GLS2_LC2G3D4T      0x80
#define _CLC2GLS2_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC2GLS3 Bits

extern __at(0x0F1F) __sfr CLC2GLS3;

typedef union
  {
  struct
    {
    unsigned LC2G4D1N           : 1;
    unsigned LC2G4D1T           : 1;
    unsigned LC2G4D2N           : 1;
    unsigned LC2G4D2T           : 1;
    unsigned LC2G4D3N           : 1;
    unsigned LC2G4D3T           : 1;
    unsigned LC2G4D4N           : 1;
    unsigned LC2G4D4T           : 1;
    };

  struct
    {
    unsigned G4D1N              : 1;
    unsigned G4D1T              : 1;
    unsigned G4D2N              : 1;
    unsigned G4D2T              : 1;
    unsigned G4D3N              : 1;
    unsigned G4D3T              : 1;
    unsigned G4D4N              : 1;
    unsigned G4D4T              : 1;
    };
  } __CLC2GLS3bits_t;

extern __at(0x0F1F) volatile __CLC2GLS3bits_t CLC2GLS3bits;

#define _CLC2GLS3_LC2G4D1N      0x01
#define _CLC2GLS3_G4D1N         0x01
#define _CLC2GLS3_LC2G4D1T      0x02
#define _CLC2GLS3_G4D1T         0x02
#define _CLC2GLS3_LC2G4D2N      0x04
#define _CLC2GLS3_G4D2N         0x04
#define _CLC2GLS3_LC2G4D2T      0x08
#define _CLC2GLS3_G4D2T         0x08
#define _CLC2GLS3_LC2G4D3N      0x10
#define _CLC2GLS3_G4D3N         0x10
#define _CLC2GLS3_LC2G4D3T      0x20
#define _CLC2GLS3_G4D3T         0x20
#define _CLC2GLS3_LC2G4D4N      0x40
#define _CLC2GLS3_G4D4N         0x40
#define _CLC2GLS3_LC2G4D4T      0x80
#define _CLC2GLS3_G4D4T         0x80

//==============================================================================

extern __at(0x0FE3) __sfr BSR_ICDSHAD;

//==============================================================================
//        STATUS_SHAD Bits

extern __at(0x0FE4) __sfr STATUS_SHAD;

typedef struct
  {
  unsigned C_SHAD               : 1;
  unsigned DC_SHAD              : 1;
  unsigned Z_SHAD               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUS_SHADbits_t;

extern __at(0x0FE4) volatile __STATUS_SHADbits_t STATUS_SHADbits;

#define _C_SHAD                 0x01
#define _DC_SHAD                0x02
#define _Z_SHAD                 0x04

//==============================================================================

extern __at(0x0FE5) __sfr WREG_SHAD;
extern __at(0x0FE6) __sfr BSR_SHAD;
extern __at(0x0FE7) __sfr PCLATH_SHAD;
extern __at(0x0FE8) __sfr FSR0L_SHAD;
extern __at(0x0FE9) __sfr FSR0H_SHAD;
extern __at(0x0FEA) __sfr FSR1L_SHAD;
extern __at(0x0FEB) __sfr FSR1H_SHAD;
extern __at(0x0FED) __sfr STKPTR;
extern __at(0x0FEE) __sfr TOSL;
extern __at(0x0FEF) __sfr TOSH;

//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define _CONFIG1                0x8007
#define _CONFIG2                0x8008

//----------------------------- CONFIG1 Options -------------------------------

#define _FOSC_INTOSC            0xFFFC  // Internal Oscillator, I/O Function on OSC1.
#define _FOSC_ECL               0xFFFD  // External Clock, Low Power Mode.
#define _FOSC_ECM               0xFFFE  // External Clock, Medium Power Mode.
#define _FOSC_ECH               0xFFFF  // External Clock, High Power Mode.
#define _WDTE_OFF               0xFFE7  // WDT disabled.
#define _WDTE_SWDTEN            0xFFEF  // WDT controlled by the SWDTEN bit in the WDTCON register.
#define _WDTE_NSLEEP            0xFFF7  // WDT enabled while running and disabled in Sleep.
#define _WDTE_ON                0xFFFF  // WDT enabled.
#define _PWRTE_ON               0xFFDF  // PWRT enabled.
#define _PWRTE_OFF              0xFFFF  // PWRT disabled.
#define _MCLRE_OFF              0xFFBF  // MCLR/VPP pin function is digital input.
#define _MCLRE_ON               0xFFFF  // MCLR/VPP pin function is MCLR.
#define _CP_ON                  0xFF7F  // Program memory code protection is enabled.
#define _CP_OFF                 0xFFFF  // Program memory code protection is disabled.
#define _BOREN_OFF              0xF9FF  // Brown-out Reset disabled.
#define _BOREN_SBODEN           0xFBFF  // Brown-out Reset controlled by the SBOREN bit in the BORCON register.
#define _BOREN_NSLEEP           0xFDFF  // Brown-out Reset enabled while running and disabled in Sleep.
#define _BOREN_ON               0xFFFF  // Brown-out Reset enabled.
#define _CLKOUTEN_ON            0xF7FF  // CLKOUT function is enabled on the CLKOUT pin.
#define _CLKOUTEN_OFF           0xFFFF  // CLKOUT function is disabled. I/O or oscillator function on the CLKOUT pin.

//----------------------------- CONFIG2 Options -------------------------------

#define _WRT_ALL                0xFFFC  // 000h to 1FFFh write protected, no addresses may be modified by EECON control.
#define _WRT_HALF               0xFFFD  // 000h to FFFh write protected, 1000h to 1FFFh may be modified by EECON control.
#define _WRT_BOOT               0xFFFE  // 000h to 1FFh write protected, 200h to 1FFFh may be modified by EECON control.
#define _WRT_OFF                0xFFFF  // Write protection off.
#define _STVREN_OFF             0xFDFF  // Stack Overflow or Underflow will not cause a Reset.
#define _STVREN_ON              0xFFFF  // Stack Overflow or Underflow will cause a Reset.
#define _BORV_HI                0xFBFF  // Brown-out Reset Voltage (Vbor), high trip point selected.
#define _BORV_LO                0xFFFF  // Brown-out Reset Voltage (Vbor), low trip point selected.
#define _LPBOR_ON               0xF7FF  // Low-Power BOR is enabled.
#define _LPBOR_OFF              0xFFFF  // Low-Power BOR is disabled.
#define _LVP_OFF                0xDFFF  // High-voltage on MCLR/VPP must be used for programming.
#define _LVP_ON                 0xFFFF  // Low-voltage programming enabled.

//==============================================================================

#define _DEVID1                 0x8006

#define _IDLOC0                 0x8000
#define _IDLOC1                 0x8001
#define _IDLOC2                 0x8002
#define _IDLOC3                 0x8003

//==============================================================================

#ifndef NO_BIT_DEFINES

#define ADON                    ADCON0bits.ADON                 // bit 0
#define GO_NOT_DONE             ADCON0bits.GO_NOT_DONE          // bit 1, shadows bit in ADCON0bits
#define ADGO                    ADCON0bits.ADGO                 // bit 1, shadows bit in ADCON0bits
#define GO                      ADCON0bits.GO                   // bit 1, shadows bit in ADCON0bits
#define CHS0                    ADCON0bits.CHS0                 // bit 2
#define CHS1                    ADCON0bits.CHS1                 // bit 3
#define CHS2                    ADCON0bits.CHS2                 // bit 4
#define CHS3                    ADCON0bits.CHS3                 // bit 5
#define CHS4                    ADCON0bits.CHS4                 // bit 6

#define ADPREF0                 ADCON1bits.ADPREF0              // bit 0
#define ADPREF1                 ADCON1bits.ADPREF1              // bit 1
#define ADCS0                   ADCON1bits.ADCS0                // bit 4
#define ADCS1                   ADCON1bits.ADCS1                // bit 5
#define ADCS2                   ADCON1bits.ADCS2                // bit 6
#define ADFM                    ADCON1bits.ADFM                 // bit 7

#define TRIGSEL0                ADCON2bits.TRIGSEL0             // bit 4
#define TRIGSEL1                ADCON2bits.TRIGSEL1             // bit 5
#define TRIGSEL2                ADCON2bits.TRIGSEL2             // bit 6
#define TRIGSEL3                ADCON2bits.TRIGSEL3             // bit 7

#define ANSA0                   ANSELAbits.ANSA0                // bit 0
#define ANSA1                   ANSELAbits.ANSA1                // bit 1
#define ANSA2                   ANSELAbits.ANSA2                // bit 2
#define ANSA4                   ANSELAbits.ANSA4                // bit 4

#define ANSB4                   ANSELBbits.ANSB4                // bit 4
#define ANSB5                   ANSELBbits.ANSB5                // bit 5

#define ANSC0                   ANSELCbits.ANSC0                // bit 0
#define ANSC1                   ANSELCbits.ANSC1                // bit 1
#define ANSC2                   ANSELCbits.ANSC2                // bit 2
#define ANSC3                   ANSELCbits.ANSC3                // bit 3
#define ANSC6                   ANSELCbits.ANSC6                // bit 6
#define ANSC7                   ANSELCbits.ANSC7                // bit 7

#define NCO1SEL                 APFCONbits.NCO1SEL              // bit 0
#define CLC1SEL                 APFCONbits.CLC1SEL              // bit 1

#define BORRDY                  BORCONbits.BORRDY               // bit 0
#define BORFS                   BORCONbits.BORFS                // bit 6
#define SBOREN                  BORCONbits.SBOREN               // bit 7

#define BSR0                    BSRbits.BSR0                    // bit 0
#define BSR1                    BSRbits.BSR1                    // bit 1
#define BSR2                    BSRbits.BSR2                    // bit 2
#define BSR3                    BSRbits.BSR3                    // bit 3
#define BSR4                    BSRbits.BSR4                    // bit 4

#define LC1MODE0                CLC1CONbits.LC1MODE0            // bit 0, shadows bit in CLC1CONbits
#define LCMODE0                 CLC1CONbits.LCMODE0             // bit 0, shadows bit in CLC1CONbits
#define LC1MODE1                CLC1CONbits.LC1MODE1            // bit 1, shadows bit in CLC1CONbits
#define LCMODE1                 CLC1CONbits.LCMODE1             // bit 1, shadows bit in CLC1CONbits
#define LC1MODE2                CLC1CONbits.LC1MODE2            // bit 2, shadows bit in CLC1CONbits
#define LCMODE2                 CLC1CONbits.LCMODE2             // bit 2, shadows bit in CLC1CONbits
#define LC1INTN                 CLC1CONbits.LC1INTN             // bit 3, shadows bit in CLC1CONbits
#define LCINTN                  CLC1CONbits.LCINTN              // bit 3, shadows bit in CLC1CONbits
#define LC1INTP                 CLC1CONbits.LC1INTP             // bit 4, shadows bit in CLC1CONbits
#define LCINTP                  CLC1CONbits.LCINTP              // bit 4, shadows bit in CLC1CONbits
#define LC1OUT                  CLC1CONbits.LC1OUT              // bit 5, shadows bit in CLC1CONbits
#define LCOUT                   CLC1CONbits.LCOUT               // bit 5, shadows bit in CLC1CONbits
#define LC1OE                   CLC1CONbits.LC1OE               // bit 6, shadows bit in CLC1CONbits
#define LCOE                    CLC1CONbits.LCOE                // bit 6, shadows bit in CLC1CONbits
#define LC1EN                   CLC1CONbits.LC1EN               // bit 7, shadows bit in CLC1CONbits
#define LCEN                    CLC1CONbits.LCEN                // bit 7, shadows bit in CLC1CONbits

#define LC1G1D1N                CLC1GLS0bits.LC1G1D1N           // bit 0, shadows bit in CLC1GLS0bits
#define D1N                     CLC1GLS0bits.D1N                // bit 0, shadows bit in CLC1GLS0bits
#define LC1G1D1T                CLC1GLS0bits.LC1G1D1T           // bit 1, shadows bit in CLC1GLS0bits
#define D1T                     CLC1GLS0bits.D1T                // bit 1, shadows bit in CLC1GLS0bits
#define LC1G1D2N                CLC1GLS0bits.LC1G1D2N           // bit 2, shadows bit in CLC1GLS0bits
#define D2N                     CLC1GLS0bits.D2N                // bit 2, shadows bit in CLC1GLS0bits
#define LC1G1D2T                CLC1GLS0bits.LC1G1D2T           // bit 3, shadows bit in CLC1GLS0bits
#define D2T                     CLC1GLS0bits.D2T                // bit 3, shadows bit in CLC1GLS0bits
#define LC1G1D3N                CLC1GLS0bits.LC1G1D3N           // bit 4, shadows bit in CLC1GLS0bits
#define D3N                     CLC1GLS0bits.D3N                // bit 4, shadows bit in CLC1GLS0bits
#define LC1G1D3T                CLC1GLS0bits.LC1G1D3T           // bit 5, shadows bit in CLC1GLS0bits
#define D3T                     CLC1GLS0bits.D3T                // bit 5, shadows bit in CLC1GLS0bits
#define LC1G1D4N                CLC1GLS0bits.LC1G1D4N           // bit 6, shadows bit in CLC1GLS0bits
#define D4N                     CLC1GLS0bits.D4N                // bit 6, shadows bit in CLC1GLS0bits
#define LC1G1D4T                CLC1GLS0bits.LC1G1D4T           // bit 7, shadows bit in CLC1GLS0bits
#define D4T                     CLC1GLS0bits.D4T                // bit 7, shadows bit in CLC1GLS0bits

#define LC1G4D1N                CLC1GLS3bits.LC1G4D1N           // bit 0, shadows bit in CLC1GLS3bits
#define G4D1N                   CLC1GLS3bits.G4D1N              // bit 0, shadows bit in CLC1GLS3bits
#define LC1G4D1T                CLC1GLS3bits.LC1G4D1T           // bit 1, shadows bit in CLC1GLS3bits
#define G4D1T                   CLC1GLS3bits.G4D1T              // bit 1, shadows bit in CLC1GLS3bits
#define LC1G4D2N                CLC1GLS3bits.LC1G4D2N           // bit 2, shadows bit in CLC1GLS3bits
#define G4D2N                   CLC1GLS3bits.G4D2N              // bit 2, shadows bit in CLC1GLS3bits
#define LC1G4D2T                CLC1GLS3bits.LC1G4D2T           // bit 3, shadows bit in CLC1GLS3bits
#define G4D2T                   CLC1GLS3bits.G4D2T              // bit 3, shadows bit in CLC1GLS3bits
#define LC1G4D3N                CLC1GLS3bits.LC1G4D3N           // bit 4, shadows bit in CLC1GLS3bits
#define G4D3N                   CLC1GLS3bits.G4D3N              // bit 4, shadows bit in CLC1GLS3bits
#define LC1G4D3T                CLC1GLS3bits.LC1G4D3T           // bit 5, shadows bit in CLC1GLS3bits
#define G4D3T                   CLC1GLS3bits.G4D3T              // bit 5, shadows bit in CLC1GLS3bits
#define LC1G4D4N                CLC1GLS3bits.LC1G4D4N           // bit 6, shadows bit in CLC1GLS3bits
#define G4D4N                   CLC1GLS3bits.G4D4N              // bit 6, shadows bit in CLC1GLS3bits
#define LC1G4D4T                CLC1GLS3bits.LC1G4D4T           // bit 7, shadows bit in CLC1GLS3bits
#define G4D4T                   CLC1GLS3bits.G4D4T              // bit 7, shadows bit in CLC1GLS3bits

#define LC1G1POL                CLC1POLbits.LC1G1POL            // bit 0, shadows bit in CLC1POLbits
#define G1POL                   CLC1POLbits.G1POL               // bit 0, shadows bit in CLC1POLbits
#define LC1G2POL                CLC1POLbits.LC1G2POL            // bit 1, shadows bit in CLC1POLbits
#define G2POL                   CLC1POLbits.G2POL               // bit 1, shadows bit in CLC1POLbits
#define LC1G3POL                CLC1POLbits.LC1G3POL            // bit 2, shadows bit in CLC1POLbits
#define G3POL                   CLC1POLbits.G3POL               // bit 2, shadows bit in CLC1POLbits
#define LC1G4POL                CLC1POLbits.LC1G4POL            // bit 3, shadows bit in CLC1POLbits
#define G4POL                   CLC1POLbits.G4POL               // bit 3, shadows bit in CLC1POLbits
#define LC1POL                  CLC1POLbits.LC1POL              // bit 7, shadows bit in CLC1POLbits
#define POL                     CLC1POLbits.POL                 // bit 7, shadows bit in CLC1POLbits

#define LC1D1S0                 CLC1SEL0bits.LC1D1S0            // bit 0, shadows bit in CLC1SEL0bits
#define D1S0                    CLC1SEL0bits.D1S0               // bit 0, shadows bit in CLC1SEL0bits
#define LC1D1S1                 CLC1SEL0bits.LC1D1S1            // bit 1, shadows bit in CLC1SEL0bits
#define D1S1                    CLC1SEL0bits.D1S1               // bit 1, shadows bit in CLC1SEL0bits
#define LC1D1S2                 CLC1SEL0bits.LC1D1S2            // bit 2, shadows bit in CLC1SEL0bits
#define D1S2                    CLC1SEL0bits.D1S2               // bit 2, shadows bit in CLC1SEL0bits
#define LC1D2S0                 CLC1SEL0bits.LC1D2S0            // bit 4, shadows bit in CLC1SEL0bits
#define D2S0                    CLC1SEL0bits.D2S0               // bit 4, shadows bit in CLC1SEL0bits
#define LC1D2S1                 CLC1SEL0bits.LC1D2S1            // bit 5, shadows bit in CLC1SEL0bits
#define D2S1                    CLC1SEL0bits.D2S1               // bit 5, shadows bit in CLC1SEL0bits
#define LC1D2S2                 CLC1SEL0bits.LC1D2S2            // bit 6, shadows bit in CLC1SEL0bits
#define D2S2                    CLC1SEL0bits.D2S2               // bit 6, shadows bit in CLC1SEL0bits

#define LC1D3S0                 CLC1SEL1bits.LC1D3S0            // bit 0, shadows bit in CLC1SEL1bits
#define D3S0                    CLC1SEL1bits.D3S0               // bit 0, shadows bit in CLC1SEL1bits
#define LC1D3S1                 CLC1SEL1bits.LC1D3S1            // bit 1, shadows bit in CLC1SEL1bits
#define D3S1                    CLC1SEL1bits.D3S1               // bit 1, shadows bit in CLC1SEL1bits
#define LC1D3S2                 CLC1SEL1bits.LC1D3S2            // bit 2, shadows bit in CLC1SEL1bits
#define D3S2                    CLC1SEL1bits.D3S2               // bit 2, shadows bit in CLC1SEL1bits
#define LC1D4S0                 CLC1SEL1bits.LC1D4S0            // bit 4, shadows bit in CLC1SEL1bits
#define D4S0                    CLC1SEL1bits.D4S0               // bit 4, shadows bit in CLC1SEL1bits
#define LC1D4S1                 CLC1SEL1bits.LC1D4S1            // bit 5, shadows bit in CLC1SEL1bits
#define D4S1                    CLC1SEL1bits.D4S1               // bit 5, shadows bit in CLC1SEL1bits
#define LC1D4S2                 CLC1SEL1bits.LC1D4S2            // bit 6, shadows bit in CLC1SEL1bits
#define D4S2                    CLC1SEL1bits.D4S2               // bit 6, shadows bit in CLC1SEL1bits

#define MCLC1OUT                CLCDATAbits.MCLC1OUT            // bit 0
#define MCLC2OUT                CLCDATAbits.MCLC2OUT            // bit 1

#define G1CS0                   CWG1CON0bits.G1CS0              // bit 0
#define G1POLA                  CWG1CON0bits.G1POLA             // bit 3
#define G1POLB                  CWG1CON0bits.G1POLB             // bit 4
#define G1OEA                   CWG1CON0bits.G1OEA              // bit 5
#define G1OEB                   CWG1CON0bits.G1OEB              // bit 6
#define G1EN                    CWG1CON0bits.G1EN               // bit 7

#define G1IS0                   CWG1CON1bits.G1IS0              // bit 0
#define G1IS1                   CWG1CON1bits.G1IS1              // bit 1
#define G1IS2                   CWG1CON1bits.G1IS2              // bit 2
#define G1ASDLA0                CWG1CON1bits.G1ASDLA0           // bit 4
#define G1ASDLA1                CWG1CON1bits.G1ASDLA1           // bit 5
#define G1ASDLB0                CWG1CON1bits.G1ASDLB0           // bit 6
#define G1ASDLB1                CWG1CON1bits.G1ASDLB1           // bit 7

#define G1ASDSCLC2              CWG1CON2bits.G1ASDSCLC2         // bit 0
#define G1ASDSFLT               CWG1CON2bits.G1ASDSFLT          // bit 1
#define G1ARSEN                 CWG1CON2bits.G1ARSEN            // bit 6
#define G1ASE                   CWG1CON2bits.G1ASE              // bit 7

#define CWG1DBF0                CWG1DBFbits.CWG1DBF0            // bit 0
#define CWG1DBF1                CWG1DBFbits.CWG1DBF1            // bit 1
#define CWG1DBF2                CWG1DBFbits.CWG1DBF2            // bit 2
#define CWG1DBF3                CWG1DBFbits.CWG1DBF3            // bit 3
#define CWG1DBF4                CWG1DBFbits.CWG1DBF4            // bit 4
#define CWG1DBF5                CWG1DBFbits.CWG1DBF5            // bit 5

#define CWG1DBR0                CWG1DBRbits.CWG1DBR0            // bit 0
#define CWG1DBR1                CWG1DBRbits.CWG1DBR1            // bit 1
#define CWG1DBR2                CWG1DBRbits.CWG1DBR2            // bit 2
#define CWG1DBR3                CWG1DBRbits.CWG1DBR3            // bit 3
#define CWG1DBR4                CWG1DBRbits.CWG1DBR4            // bit 4
#define CWG1DBR5                CWG1DBRbits.CWG1DBR5            // bit 5

#define ADFVR0                  FVRCONbits.ADFVR0               // bit 0
#define ADFVR1                  FVRCONbits.ADFVR1               // bit 1
#define TSRNG                   FVRCONbits.TSRNG                // bit 4
#define TSEN                    FVRCONbits.TSEN                 // bit 5
#define FVRRDY                  FVRCONbits.FVRRDY               // bit 6
#define FVREN                   FVRCONbits.FVREN                // bit 7

#define IOCIF                   INTCONbits.IOCIF                // bit 0
#define INTF                    INTCONbits.INTF                 // bit 1
#define TMR0IF                  INTCONbits.TMR0IF               // bit 2, shadows bit in INTCONbits
#define T0IF                    INTCONbits.T0IF                 // bit 2, shadows bit in INTCONbits
#define IOCIE                   INTCONbits.IOCIE                // bit 3
#define INTE                    INTCONbits.INTE                 // bit 4
#define TMR0IE                  INTCONbits.TMR0IE               // bit 5, shadows bit in INTCONbits
#define T0IE                    INTCONbits.T0IE                 // bit 5, shadows bit in INTCONbits
#define PEIE                    INTCONbits.PEIE                 // bit 6
#define GIE                     INTCONbits.GIE                  // bit 7

#define IOCAF0                  IOCAFbits.IOCAF0                // bit 0
#define IOCAF1                  IOCAFbits.IOCAF1                // bit 1
#define IOCAF2                  IOCAFbits.IOCAF2                // bit 2
#define IOCAF3                  IOCAFbits.IOCAF3                // bit 3
#define IOCAF4                  IOCAFbits.IOCAF4                // bit 4
#define IOCAF5                  IOCAFbits.IOCAF5                // bit 5

#define IOCAN0                  IOCANbits.IOCAN0                // bit 0
#define IOCAN1                  IOCANbits.IOCAN1                // bit 1
#define IOCAN2                  IOCANbits.IOCAN2                // bit 2
#define IOCAN3                  IOCANbits.IOCAN3                // bit 3
#define IOCAN4                  IOCANbits.IOCAN4                // bit 4
#define IOCAN5                  IOCANbits.IOCAN5                // bit 5

#define IOCAP0                  IOCAPbits.IOCAP0                // bit 0
#define IOCAP1                  IOCAPbits.IOCAP1                // bit 1
#define IOCAP2                  IOCAPbits.IOCAP2                // bit 2
#define IOCAP3                  IOCAPbits.IOCAP3                // bit 3
#define IOCAP4                  IOCAPbits.IOCAP4                // bit 4
#define IOCAP5                  IOCAPbits.IOCAP5                // bit 5

#define IOCBF4                  IOCBFbits.IOCBF4                // bit 4
#define IOCBF5                  IOCBFbits.IOCBF5                // bit 5
#define IOCBF6                  IOCBFbits.IOCBF6                // bit 6
#define IOCBF7                  IOCBFbits.IOCBF7                // bit 7

#define IOCBN4                  IOCBNbits.IOCBN4                // bit 4
#define IOCBN5                  IOCBNbits.IOCBN5                // bit 5
#define IOCBN6                  IOCBNbits.IOCBN6                // bit 6
#define IOCBN7                  IOCBNbits.IOCBN7                // bit 7

#define IOCBP4                  IOCBPbits.IOCBP4                // bit 4
#define IOCBP5                  IOCBPbits.IOCBP5                // bit 5
#define IOCBP6                  IOCBPbits.IOCBP6                // bit 6
#define IOCBP7                  IOCBPbits.IOCBP7                // bit 7

#define LATA0                   LATAbits.LATA0                  // bit 0
#define LATA1                   LATAbits.LATA1                  // bit 1
#define LATA2                   LATAbits.LATA2                  // bit 2
#define LATA4                   LATAbits.LATA4                  // bit 4
#define LATA5                   LATAbits.LATA5                  // bit 5

#define LATB4                   LATBbits.LATB4                  // bit 4
#define LATB5                   LATBbits.LATB5                  // bit 5
#define LATB6                   LATBbits.LATB6                  // bit 6
#define LATB7                   LATBbits.LATB7                  // bit 7

#define LATC0                   LATCbits.LATC0                  // bit 0
#define LATC1                   LATCbits.LATC1                  // bit 1
#define LATC2                   LATCbits.LATC2                  // bit 2
#define LATC3                   LATCbits.LATC3                  // bit 3
#define LATC4                   LATCbits.LATC4                  // bit 4
#define LATC5                   LATCbits.LATC5                  // bit 5
#define LATC6                   LATCbits.LATC6                  // bit 6
#define LATC7                   LATCbits.LATC7                  // bit 7

#define NCO1ACC8                NCO1ACCHbits.NCO1ACC8           // bit 0
#define NCO1ACC9                NCO1ACCHbits.NCO1ACC9           // bit 1
#define NCO1ACC10               NCO1ACCHbits.NCO1ACC10          // bit 2
#define NCO1ACC11               NCO1ACCHbits.NCO1ACC11          // bit 3
#define NCO1ACC12               NCO1ACCHbits.NCO1ACC12          // bit 4
#define NCO1ACC13               NCO1ACCHbits.NCO1ACC13          // bit 5
#define NCO1ACC14               NCO1ACCHbits.NCO1ACC14          // bit 6
#define NCO1ACC15               NCO1ACCHbits.NCO1ACC15          // bit 7

#define NCO1ACC0                NCO1ACCLbits.NCO1ACC0           // bit 0
#define NCO1ACC1                NCO1ACCLbits.NCO1ACC1           // bit 1
#define NCO1ACC2                NCO1ACCLbits.NCO1ACC2           // bit 2
#define NCO1ACC3                NCO1ACCLbits.NCO1ACC3           // bit 3
#define NCO1ACC4                NCO1ACCLbits.NCO1ACC4           // bit 4
#define NCO1ACC5                NCO1ACCLbits.NCO1ACC5           // bit 5
#define NCO1ACC6                NCO1ACCLbits.NCO1ACC6           // bit 6
#define NCO1ACC7                NCO1ACCLbits.NCO1ACC7           // bit 7

#define NCO1ACC16               NCO1ACCUbits.NCO1ACC16          // bit 0
#define NCO1ACC17               NCO1ACCUbits.NCO1ACC17          // bit 1
#define NCO1ACC18               NCO1ACCUbits.NCO1ACC18          // bit 2
#define NCO1ACC19               NCO1ACCUbits.NCO1ACC19          // bit 3

#define N1CKS0                  NCO1CLKbits.N1CKS0              // bit 0
#define N1CKS1                  NCO1CLKbits.N1CKS1              // bit 1
#define N1PWS0                  NCO1CLKbits.N1PWS0              // bit 5
#define N1PWS1                  NCO1CLKbits.N1PWS1              // bit 6
#define N1PWS2                  NCO1CLKbits.N1PWS2              // bit 7

#define N1PFM                   NCO1CONbits.N1PFM               // bit 0
#define N1POL                   NCO1CONbits.N1POL               // bit 4
#define N1OUT                   NCO1CONbits.N1OUT               // bit 5
#define N1OE                    NCO1CONbits.N1OE                // bit 6
#define N1EN                    NCO1CONbits.N1EN                // bit 7

#define NCO1INC8                NCO1INCHbits.NCO1INC8           // bit 0
#define NCO1INC9                NCO1INCHbits.NCO1INC9           // bit 1
#define NCO1INC10               NCO1INCHbits.NCO1INC10          // bit 2
#define NCO1INC11               NCO1INCHbits.NCO1INC11          // bit 3
#define NCO1INC12               NCO1INCHbits.NCO1INC12          // bit 4
#define NCO1INC13               NCO1INCHbits.NCO1INC13          // bit 5
#define NCO1INC14               NCO1INCHbits.NCO1INC14          // bit 6
#define NCO1INC15               NCO1INCHbits.NCO1INC15          // bit 7

#define NCO1INC0                NCO1INCLbits.NCO1INC0           // bit 0
#define NCO1INC1                NCO1INCLbits.NCO1INC1           // bit 1
#define NCO1INC2                NCO1INCLbits.NCO1INC2           // bit 2
#define NCO1INC3                NCO1INCLbits.NCO1INC3           // bit 3
#define NCO1INC4                NCO1INCLbits.NCO1INC4           // bit 4
#define NCO1INC5                NCO1INCLbits.NCO1INC5           // bit 5
#define NCO1INC6                NCO1INCLbits.NCO1INC6           // bit 6
#define NCO1INC7                NCO1INCLbits.NCO1INC7           // bit 7

#define PS0                     OPTION_REGbits.PS0              // bit 0
#define PS1                     OPTION_REGbits.PS1              // bit 1
#define PS2                     OPTION_REGbits.PS2              // bit 2
#define PSA                     OPTION_REGbits.PSA              // bit 3
#define TMR0SE                  OPTION_REGbits.TMR0SE           // bit 4, shadows bit in OPTION_REGbits
#define T0SE                    OPTION_REGbits.T0SE             // bit 4, shadows bit in OPTION_REGbits
#define TMR0CS                  OPTION_REGbits.TMR0CS           // bit 5, shadows bit in OPTION_REGbits
#define T0CS                    OPTION_REGbits.T0CS             // bit 5, shadows bit in OPTION_REGbits
#define INTEDG                  OPTION_REGbits.INTEDG           // bit 6
#define NOT_WPUEN               OPTION_REGbits.NOT_WPUEN        // bit 7

#define SCS0                    OSCCONbits.SCS0                 // bit 0
#define SCS1                    OSCCONbits.SCS1                 // bit 1
#define IRCF0                   OSCCONbits.IRCF0                // bit 3
#define IRCF1                   OSCCONbits.IRCF1                // bit 4
#define IRCF2                   OSCCONbits.IRCF2                // bit 5
#define IRCF3                   OSCCONbits.IRCF3                // bit 6

#define HFIOFS                  OSCSTATbits.HFIOFS              // bit 0
#define LFIOFR                  OSCSTATbits.LFIOFR              // bit 1
#define HFIOFR                  OSCSTATbits.HFIOFR              // bit 4
#define OSTS                    OSCSTATbits.OSTS                // bit 5
#define SOSCR                   OSCSTATbits.SOSCR               // bit 7

#define NOT_BOR                 PCONbits.NOT_BOR                // bit 0
#define NOT_POR                 PCONbits.NOT_POR                // bit 1
#define NOT_RI                  PCONbits.NOT_RI                 // bit 2
#define NOT_RMCLR               PCONbits.NOT_RMCLR              // bit 3
#define NOT_RWDT                PCONbits.NOT_RWDT               // bit 4
#define STKUNF                  PCONbits.STKUNF                 // bit 6
#define STKOVF                  PCONbits.STKOVF                 // bit 7

#define TMR1IE                  PIE1bits.TMR1IE                 // bit 0
#define TMR2IE                  PIE1bits.TMR2IE                 // bit 1
#define ADIE                    PIE1bits.ADIE                   // bit 6
#define TMR1GIE                 PIE1bits.TMR1GIE                // bit 7

#define NCO1IE                  PIE2bits.NCO1IE                 // bit 2

#define CLC1IE                  PIE3bits.CLC1IE                 // bit 0
#define CLC2IE                  PIE3bits.CLC2IE                 // bit 1

#define TMR1IF                  PIR1bits.TMR1IF                 // bit 0
#define TMR2IF                  PIR1bits.TMR2IF                 // bit 1
#define ADIF                    PIR1bits.ADIF                   // bit 6
#define TMR1GIF                 PIR1bits.TMR1GIF                // bit 7

#define NCO1IF                  PIR2bits.NCO1IF                 // bit 2

#define CLC1IF                  PIR3bits.CLC1IF                 // bit 0
#define CLC2IF                  PIR3bits.CLC2IF                 // bit 1

#define RD                      PMCON1bits.RD                   // bit 0
#define WR                      PMCON1bits.WR                   // bit 1
#define WREN                    PMCON1bits.WREN                 // bit 2
#define WRERR                   PMCON1bits.WRERR                // bit 3
#define FREE                    PMCON1bits.FREE                 // bit 4
#define LWLO                    PMCON1bits.LWLO                 // bit 5
#define CFGS                    PMCON1bits.CFGS                 // bit 6
#define EEPGD                   PMCON1bits.EEPGD                // bit 7

#define RA0                     PORTAbits.RA0                   // bit 0
#define RA1                     PORTAbits.RA1                   // bit 1
#define RA2                     PORTAbits.RA2                   // bit 2
#define RA3                     PORTAbits.RA3                   // bit 3
#define RA4                     PORTAbits.RA4                   // bit 4
#define RA5                     PORTAbits.RA5                   // bit 5

#define RB4                     PORTBbits.RB4                   // bit 4
#define RB5                     PORTBbits.RB5                   // bit 5
#define RB6                     PORTBbits.RB6                   // bit 6
#define RB7                     PORTBbits.RB7                   // bit 7

#define RC0                     PORTCbits.RC0                   // bit 0
#define RC1                     PORTCbits.RC1                   // bit 1
#define RC2                     PORTCbits.RC2                   // bit 2
#define RC3                     PORTCbits.RC3                   // bit 3
#define RC4                     PORTCbits.RC4                   // bit 4
#define RC5                     PORTCbits.RC5                   // bit 5
#define RC6                     PORTCbits.RC6                   // bit 6
#define RC7                     PORTCbits.RC7                   // bit 7

#define PWM1POL                 PWM1CONbits.PWM1POL             // bit 4
#define PWM1OUT                 PWM1CONbits.PWM1OUT             // bit 5
#define PWM1OE                  PWM1CONbits.PWM1OE              // bit 6
#define PWM1EN                  PWM1CONbits.PWM1EN              // bit 7

#define PWM1DCH0                PWM1DCHbits.PWM1DCH0            // bit 0
#define PWM1DCH1                PWM1DCHbits.PWM1DCH1            // bit 1
#define PWM1DCH2                PWM1DCHbits.PWM1DCH2            // bit 2
#define PWM1DCH3                PWM1DCHbits.PWM1DCH3            // bit 3
#define PWM1DCH4                PWM1DCHbits.PWM1DCH4            // bit 4
#define PWM1DCH5                PWM1DCHbits.PWM1DCH5            // bit 5
#define PWM1DCH6                PWM1DCHbits.PWM1DCH6            // bit 6
#define PWM1DCH7                PWM1DCHbits.PWM1DCH7            // bit 7

#define PWM1DCL0                PWM1DCLbits.PWM1DCL0            // bit 6
#define PWM1DCL1                PWM1DCLbits.PWM1DCL1            // bit 7

#define PWM2POL                 PWM2CONbits.PWM2POL             // bit 4
#define PWM2OUT                 PWM2CONbits.PWM2OUT             // bit 5
#define PWM2OE                  PWM2CONbits.PWM2OE              // bit 6
#define PWM2EN                  PWM2CONbits.PWM2EN              // bit 7

#define PWM2DCH0                PWM2DCHbits.PWM2DCH0            // bit 0
#define PWM2DCH1                PWM2DCHbits.PWM2DCH1            // bit 1
#define PWM2DCH2                PWM2DCHbits.PWM2DCH2            // bit 2
#define PWM2DCH3                PWM2DCHbits.PWM2DCH3            // bit 3
#define PWM2DCH4                PWM2DCHbits.PWM2DCH4            // bit 4
#define PWM2DCH5                PWM2DCHbits.PWM2DCH5            // bit 5
#define PWM2DCH6                PWM2DCHbits.PWM2DCH6            // bit 6
#define PWM2DCH7                PWM2DCHbits.PWM2DCH7            // bit 7

#define PWM2DCL0                PWM2DCLbits.PWM2DCL0            // bit 6
#define PWM2DCL1                PWM2DCLbits.PWM2DCL1            // bit 7

#define PWM3POL                 PWM3CONbits.PWM3POL             // bit 4
#define PWM3OUT                 PWM3CONbits.PWM3OUT             // bit 5
#define PWM3OE                  PWM3CONbits.PWM3OE              // bit 6
#define PWM3EN                  PWM3CONbits.PWM3EN              // bit 7

#define PWM3DCH0                PWM3DCHbits.PWM3DCH0            // bit 0
#define PWM3DCH1                PWM3DCHbits.PWM3DCH1            // bit 1
#define PWM3DCH2                PWM3DCHbits.PWM3DCH2            // bit 2
#define PWM3DCH3                PWM3DCHbits.PWM3DCH3            // bit 3
#define PWM3DCH4                PWM3DCHbits.PWM3DCH4            // bit 4
#define PWM3DCH5                PWM3DCHbits.PWM3DCH5            // bit 5
#define PWM3DCH6                PWM3DCHbits.PWM3DCH6            // bit 6
#define PWM3DCH7                PWM3DCHbits.PWM3DCH7            // bit 7

#define PWM3DCL0                PWM3DCLbits.PWM3DCL0            // bit 6
#define PWM3DCL1                PWM3DCLbits.PWM3DCL1            // bit 7

#define PWM4POL                 PWM4CONbits.PWM4POL             // bit 4
#define PWM4OUT                 PWM4CONbits.PWM4OUT             // bit 5
#define PWM4OE                  PWM4CONbits.PWM4OE              // bit 6
#define PWM4EN                  PWM4CONbits.PWM4EN              // bit 7

#define PWM4DCH0                PWM4DCHbits.PWM4DCH0            // bit 0
#define PWM4DCH1                PWM4DCHbits.PWM4DCH1            // bit 1
#define PWM4DCH2                PWM4DCHbits.PWM4DCH2            // bit 2
#define PWM4DCH3                PWM4DCHbits.PWM4DCH3            // bit 3
#define PWM4DCH4                PWM4DCHbits.PWM4DCH4            // bit 4
#define PWM4DCH5                PWM4DCHbits.PWM4DCH5            // bit 5
#define PWM4DCH6                PWM4DCHbits.PWM4DCH6            // bit 6
#define PWM4DCH7                PWM4DCHbits.PWM4DCH7            // bit 7

#define PWM4DCL0                PWM4DCLbits.PWM4DCL0            // bit 6
#define PWM4DCL1                PWM4DCLbits.PWM4DCL1            // bit 7

#define C                       STATUSbits.C                    // bit 0
#define DC                      STATUSbits.DC                   // bit 1
#define Z                       STATUSbits.Z                    // bit 2
#define NOT_PD                  STATUSbits.NOT_PD               // bit 3
#define NOT_TO                  STATUSbits.NOT_TO               // bit 4

#define C_SHAD                  STATUS_SHADbits.C_SHAD          // bit 0
#define DC_SHAD                 STATUS_SHADbits.DC_SHAD         // bit 1
#define Z_SHAD                  STATUS_SHADbits.Z_SHAD          // bit 2

#define TMR1ON                  T1CONbits.TMR1ON                // bit 0
#define NOT_T1SYNC              T1CONbits.NOT_T1SYNC            // bit 2
#define T1OSCEN                 T1CONbits.T1OSCEN               // bit 3
#define T1CKPS0                 T1CONbits.T1CKPS0               // bit 4
#define T1CKPS1                 T1CONbits.T1CKPS1               // bit 5
#define TMR1CS0                 T1CONbits.TMR1CS0               // bit 6
#define TMR1CS1                 T1CONbits.TMR1CS1               // bit 7

#define T1GSS0                  T1GCONbits.T1GSS0               // bit 0
#define T1GSS1                  T1GCONbits.T1GSS1               // bit 1
#define T1GVAL                  T1GCONbits.T1GVAL               // bit 2
#define T1GGO_NOT_DONE          T1GCONbits.T1GGO_NOT_DONE       // bit 3
#define T1GSPM                  T1GCONbits.T1GSPM               // bit 4
#define T1GTM                   T1GCONbits.T1GTM                // bit 5
#define T1GPOL                  T1GCONbits.T1GPOL               // bit 6
#define TMR1GE                  T1GCONbits.TMR1GE               // bit 7

#define T2CKPS0                 T2CONbits.T2CKPS0               // bit 0
#define T2CKPS1                 T2CONbits.T2CKPS1               // bit 1
#define TMR2ON                  T2CONbits.TMR2ON                // bit 2
#define TOUTPS0                 T2CONbits.TOUTPS0               // bit 3
#define TOUTPS1                 T2CONbits.TOUTPS1               // bit 4
#define TOUTPS2                 T2CONbits.TOUTPS2               // bit 5
#define TOUTPS3                 T2CONbits.TOUTPS3               // bit 6

#define TRISA0                  TRISAbits.TRISA0                // bit 0
#define TRISA1                  TRISAbits.TRISA1                // bit 1
#define TRISA2                  TRISAbits.TRISA2                // bit 2
#define TRISA3                  TRISAbits.TRISA3                // bit 3
#define TRISA4                  TRISAbits.TRISA4                // bit 4
#define TRISA5                  TRISAbits.TRISA5                // bit 5

#define TRISB4                  TRISBbits.TRISB4                // bit 4
#define TRISB5                  TRISBbits.TRISB5                // bit 5
#define TRISB6                  TRISBbits.TRISB6                // bit 6
#define TRISB7                  TRISBbits.TRISB7                // bit 7

#define TRISC0                  TRISCbits.TRISC0                // bit 0
#define TRISC1                  TRISCbits.TRISC1                // bit 1
#define TRISC2                  TRISCbits.TRISC2                // bit 2
#define TRISC3                  TRISCbits.TRISC3                // bit 3
#define TRISC4                  TRISCbits.TRISC4                // bit 4
#define TRISC5                  TRISCbits.TRISC5                // bit 5
#define TRISC6                  TRISCbits.TRISC6                // bit 6
#define TRISC7                  TRISCbits.TRISC7                // bit 7

#define VREGPM0                 VREGCONbits.VREGPM0             // bit 0
#define VREGPM1                 VREGCONbits.VREGPM1             // bit 1

#define SWDTEN                  WDTCONbits.SWDTEN               // bit 0
#define WDTPS0                  WDTCONbits.WDTPS0               // bit 1
#define WDTPS1                  WDTCONbits.WDTPS1               // bit 2
#define WDTPS2                  WDTCONbits.WDTPS2               // bit 3
#define WDTPS3                  WDTCONbits.WDTPS3               // bit 4
#define WDTPS4                  WDTCONbits.WDTPS4               // bit 5

#define WPUA0                   WPUAbits.WPUA0                  // bit 0
#define WPUA1                   WPUAbits.WPUA1                  // bit 1
#define WPUA2                   WPUAbits.WPUA2                  // bit 2
#define WPUA3                   WPUAbits.WPUA3                  // bit 3
#define WPUA4                   WPUAbits.WPUA4                  // bit 4
#define WPUA5                   WPUAbits.WPUA5                  // bit 5

#define WPUB4                   WPUBbits.WPUB4                  // bit 4
#define WPUB5                   WPUBbits.WPUB5                  // bit 5
#define WPUB6                   WPUBbits.WPUB6                  // bit 6
#define WPUB7                   WPUBbits.WPUB7                  // bit 7

#endif // #ifndef NO_BIT_DEFINES

#endif // #ifndef __PIC16F1507_H__
