/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/* Detection tables for (The Bizarre Adventures of) Woodruff and the Schnibble (of Azimuth). */

#ifndef GOB_DETECTION_TABLES_WOODRUFF_H
#define GOB_DETECTION_TABLES_WOODRUFF_H

// -- Windows CD --

{
	{
		"woodruff",
		"v1.00",
		AD_ENTRY1s("intro.stk", "dccf9d31cb720b34d75487408821b77e", 20296390),
		EN_GRB,
		kPlatformDOS,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"woodruff",
		"v1.00",
		AD_ENTRY1s("intro.stk", "dccf9d31cb720b34d75487408821b77e", 20296390),
		DE_DEU,
		kPlatformDOS,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"woodruff",
		"v1.00",
		AD_ENTRY1s("intro.stk", "dccf9d31cb720b34d75487408821b77e", 20296390),
		FR_FRA,
		kPlatformDOS,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"woodruff",
		"v1.00",
		AD_ENTRY1s("intro.stk", "dccf9d31cb720b34d75487408821b77e", 20296390),
		IT_ITA,
		kPlatformDOS,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"woodruff",
		"v1.00",
		AD_ENTRY1s("intro.stk", "dccf9d31cb720b34d75487408821b77e", 20296390),
		ES_ESP,
		kPlatformDOS,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{ // Russian Akella version
	{
		"woodruff",
		"v1.00",
		AD_ENTRY1s("intro.stk", "dccf9d31cb720b34d75487408821b77e", 20296390),
		RU_RUS,
		kPlatformDOS,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "b50fee012a5abcd0ac2963e1b4b56bec", 20298108),
		EN_GRB,
		kPlatformDOS,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "b50fee012a5abcd0ac2963e1b4b56bec", 20298108),
		DE_DEU,
		kPlatformDOS,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "b50fee012a5abcd0ac2963e1b4b56bec", 20298108),
		FR_FRA,
		kPlatformDOS,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "b50fee012a5abcd0ac2963e1b4b56bec", 20298108),
		IT_ITA,
		kPlatformDOS,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "b50fee012a5abcd0ac2963e1b4b56bec", 20298108),
		ES_ESP,
		kPlatformDOS,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "5f5f4e0a72c33391e67a47674b120cc6", 20296422),
		DE_DEU,
		kPlatformDOS,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{ // Supplied by jvprat on #scummvm
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "270529d9b8cce770b1575908a3800b52", 20296452),
		ES_ESP,
		kPlatformDOS,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{ // Supplied by jvprat on #scummvm
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "270529d9b8cce770b1575908a3800b52", 20296452),
		EN_GRB,
		kPlatformDOS,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{ // Supplied by jvprat on #scummvm
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "270529d9b8cce770b1575908a3800b52", 20296452),
		DE_DEU,
		kPlatformDOS,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{ // Supplied by jvprat on #scummvm
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "270529d9b8cce770b1575908a3800b52", 20296452),
		FR_FRA,
		kPlatformDOS,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{ // Supplied by jvprat on #scummvm
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "270529d9b8cce770b1575908a3800b52", 20296452),
		IT_ITA,
		kPlatformDOS,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{ // Supplied by DjDiabolik in bug report #3737
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "60348a87651f92e8492ee070556a96d8", 7069736),
		EN_GRB,
		kPlatformDOS,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{ // Supplied by DjDiabolik in bug report #3737
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "60348a87651f92e8492ee070556a96d8", 7069736),
		DE_DEU,
		kPlatformDOS,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{ // Supplied by DjDiabolik in bug report #3737
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "60348a87651f92e8492ee070556a96d8", 7069736),
		FR_FRA,
		kPlatformDOS,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{ // Supplied by DjDiabolik in bug report #3737
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "60348a87651f92e8492ee070556a96d8", 7069736),
		IT_ITA,
		kPlatformDOS,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{ // Supplied by DjDiabolik in bug report #3737
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "60348a87651f92e8492ee070556a96d8", 7069736),
		ES_ESP,
		kPlatformDOS,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{ // Supplied by goodoldgeorg in bug report #3950
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "08a96bf061af1fa4f75c6a7cc56b60a4", 20734979),
		PL_POL,
		kPlatformDOS,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{ // Russian fanmade translation by PRCA
	{
		"woodruff",
		"Fanmade",
		AD_ENTRY1s("intro.stk", "3767f779996d64e8413fc1e2300ba032", 20651219),
		RU_RUS,
		kPlatformDOS,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},

// -- Demos --

{
	{
		"woodruff",
		"Non-Interactive Demo",
		AD_ENTRY2s("demo.scn",		"16bb85fc5f8e519147b60475dbf33962", 89,
				   "wooddem3.vmd",	"a1700596172c2d4e264760030c3a3d47", 8994250),
		EN_ANY,
		kPlatformDOS,
		ADGF_DEMO,
		GUIO3(GUIO_NOSUBTITLES, GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480 | kFeaturesSCNDemo,
	0, 0, 1
},

#endif // GOB_DETECTION_TABLES_WOODRUFF_H
