/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "engines/game.h"
#include "common/language.h"

namespace Glk {
namespace Adrift {

const PlainGameDescriptor ADRIFT_GAME_LIST[] = {
	{ "Adrift", "Adrift IF Game" },

	// English Games
	{ "1sttime", "1st Time" },
	{ "2playerex", "2 Player Extreme" },
	{ "30seconds", "30 Second" },
	{ "3monkeys", "Three Monkeys, One Cage" },
	{ "achtung", "Achtung Panzer!" },
	{ "adriftmasparty", "ADRIFTMAS Party" },
	{ "adriftorama", "ADRIFT-O-RAMA" },
	{ "adriftproject", "The ADRIFT Project: Classified" },
	{ "advent350", "Adventure" },
	{ "adventurepostman", "The Adventures of Postman Matt (and his black and white cat)" },
	{ "adventurestrikes", "Adventure Strikes When You Least Expect It" },
	{ "adventurethumper", "Adventures of Thumper: Wonder Wombat" },
	{ "afp", "Another Friday Party" },
	{ "agent4fmars", "Agent 4-F from Mars" },
	{ "akari", "A Day in the Life 3: Akari's Story" },
	{ "akron", "Akron" },
	{ "albertlost", "Albert is Lost!: An Adventure in Real Life" },
	{ "albridgemanor", "Albridge Manor" },
	{ "alchemist", "The Alchemist" },
	{ "alexis", "Alexis: Dalskee" },
	{ "alias", "Alias: Undercover Agent" },
	{ "allroadsmars", "All Roads Lead to Mars" },
	{ "alrhints", "ALR Hints System" },
	{ "amazgriswold", "The Amazing Uncle Griswold" },
	{ "amaztvcaper", "The Amazing TV Caper" },
	{ "ambassador", "Ambassador to Dupal" },
	{ "americanmoney", "USA Money Template" },
	{ "amnesiakid", "Amnesia Kid" },
	{ "amy", "Amy and the Raging Hormones" },
	{ "angel", "The Angel, the Devil and the Human" },
	{ "aquarius1", "The Doomed World of Aquarius" },
	{ "aquarius2", "The Doomed World of Aquarius" },
	{ "aram", "Alice's Restaurant Anti-Massacree Adventure" },
	{ "archiebdaych1", "Archie's Birthday - Chapter 1: Reggie's Gift" },
	{ "armour", "Armour" },
	{ "ascot", "The Ascot" },
	{ "asdfa", "A Short Damn Fantasy Adventure" },
	{ "asylumadrift", "Asylum" },
	{ "athylon", "The Tunnels of Athylon" },
	{ "attack", "Attack" },
	{ "average", "The Average Life" },
	{ "awalkatdusk", "A Walk at Dusk" },
	{ "azra", "The Town of Azra" },
	{ "backhome", "Back Home" },
	{ "backtolife", "Back to Life... Unfortunately" },
	{ "badlands", "Badlands" },
	{ "bananadvent", "The Foggy Banana Adventure" },
	{ "bandera", "Bandera" },
	{ "bariscebik", "Bariscebik" },
	{ "barneysproblem", "Barney's Problem" },
	{ "basement", "Escape the Basement From Hell" },
	{ "bcl", "Big City Laundry" },
	{ "bdw", "Brain Dead Weekend" },
	{ "bedlamadrift", "Bedlam" },
	{ "beerisntenough", "When Beer Isn't Enough" },
	{ "beethro", "Beethro’s Text Adventure" },
	{ "bethere", "Be There!" },
	{ "bellesmeres", "Belles-Mères" },
	{ "beythilda", "Beythilda the Night Witch" },
	{ "bfhouse", "Burtainian Fly's House" },
	{ "bigspyfiction", "The Big Spy Fiction: Comedy Mashup Game" },
	{ "blacksheep", "Black Sheep's Gold" },
	{ "blob", "Overriding Get" },
	{ "blood", "Fire in the Blood" },
	{ "bloodrelatives", "Blood Relatives" },  // Broken
	{ "blueskyadrift", "Blue Sky" },
	{ "bobbobsly", "The Adventures of Bob Bobsly" },
	{ "bombthreat", "Bomb Threat" },
	{ "bookbuilding", "Book Building" },
	{ "bookexistence", "Howard. Oblivion. Part 2: Book of Existence" },
	{ "bountyhunter", "Bounty Hunter" },
	{ "breakable", "Colored Numbers" },
	{ "bulkitem", "Bulk Item Test" },
	{ "businessasusual", "Business as Usual" },
	{ "bz3americans", "Battle Zone III: Americans" },
	{ "bz3soviets", "Battle Zone III: Soviets" },
	{ "caidalibre", "Caida Libre" },
	{ "camelot", "Camelot" },
	{ "campwindylake", "Camp Windy Lake" },
	{ "canidoit", "Can I Do It?" },
	{ "canyouguess", "Can You Guess?" },
	{ "canyoustandup", "Can You Stand Up?" },
	{ "captive", "Captive Universe" },
	{ "cardemo", "Car" },
	{ "cards", "Playing Cards" },
	{ "castlequest", "Castle Quest" },
	{ "catintree", "The Cat in the Tree" },
	{ "cat", "The Cat" },
	{ "caveofwonders", "Cave of Wonders" },
	{ "cccs2808", "CCCS Virtual Campus" },
	{ "cd", "Crimson Detritus" },
	{ "cellar", "The Cellar" },
	{ "cellpart1", "Cell: Part I" },
	{ "cellphone", "Cell Phone" },
	{ "cell", "The Cell" },
	{ "chairtest", "Chair Test" },
	{ "changepicture", "Locations Change Picture" },
	{ "charactercreator", "Character Creator!" },
	{ "characterturn", "Character Turns Back" },
	{ "chargenerator", "Character Generator" },
	{ "charloop", "Character Info Input with Loop" },
	{ "chasingrussian", "Chasing the Russian: Chapter 1" },
	{ "chicago", "Chicago" },
	{ "choices", "Choices" },
	{ "chooseyourown", "Choose Your Own..." },
	{ "chosen", "Chosen" },
	{ "church", "The Old Church" },
	{ "cif", "Scene of the Crime 2: City in Fear" },
	{ "circusmenagerie", "Menagerie!" },
	{ "cityinfear", "City In Fear" },
	{ "clear", "Description Display After" },
	{ "cleft", "The Cleft in the Rock" },
	{ "cloak", "Cloak of Darkness" },
	{ "clock", "Clock" },
	{ "clodquest", "Clod's Quest: The Dungeons of Zivulda" },
	{ "cluelessbob", "In the Claws of Clueless Bob" },
	{ "cobl", "Crazy Old Bag Lady" },
	{ "colony", "Colony" },
	{ "coloromcadrift", "Color of Milk Coffee" },
	{ "combat", "Combat" },
	{ "combilip", "Combi-Lip" },
	{ "compendiumendgame", "The Woodfish Compendium: The Game to End All Games" },
	{ "compendiumforum1", "The Woodfish Compendium: Forum" },
	{ "compendiumforum2", "The Woodfish Compendium: Forum2" },
	{ "compendiumimagi", "The Woodfish Compendium: ImagiDroids" },
	{ "compendiumsaffire", "The Woodfish Compendium: Saffire" },
	{ "compendiumtopaz", "The Woodfish Compendium: Topaz" },
	{ "com", "Starship Cliche: A Communications" },
	{ "consequences", "Consequences" },
	{ "cowboyblues", "Cowboy Blues" },
	{ "crawlersdelight", "Crawler's Delight" },
	{ "crimeadventure", "Crime Adventure" },
	{ "crimelife", "Crime Life" },
	{ "crimesceneadrift", "The Crime Scene" },
	{ "croftnon", "Lara Croft: The Sun Obelisk" },
	{ "crookedest", "The Crooked Estate" },
	{ "cumberbund", "Cumberbund" },
	{ "cursed", "Cursed" },
	{ "cut", "Cut the Red Wire! No, the Blue Wire!" },
	{ "cyber1", "Cyber Warp 1" },
	{ "cyber2", "Cyber Warp 2" },
	{ "cybercow", "Lair of the Cybercrow" },
	{ "cyo3", "Choose Your Own..." },
	{ "darkness", "Darkness" },
	{ "darktower", "The Dark Tower" },
	{ "datewithdeath", "A Date with Death" },
	{ "daveshouse", "Melbourne Beach" },
	{ "dayattheoffice", "A Day at the Office" },
	{ "daylifesuperhero", "A Day in the Life of a Super Hero" },
	{ "daynightcycle", "Day-Night Cycle" },
	{ "daypuzzlehouse", "A Day at the Puzzle House" },
	{ "dayschool", "A Day at School" },
	{ "daystemplate", "Day Template" },
	{ "dbaa", "Dung Beetles Are Aliens" },
	{ "dead", "A Dead Room" },
	{ "deadman", "The Dead Man" },
	{ "deadreckoningadrift", "Dead Reckoning" },
	{ "deathbedcash", "Moving Items after an NPC die" },
	{ "deathdoor", "Death's Door" },
	{ "decisions", "Decisions" },
	{ "delivery", "The Delivery" },
	{ "demonhunter2", "The Demon Hunter" },
	{ "demonhunter", "Apprentice of the Demonhunter" },
	{ "dff", "Die Feuerfaust" },
	{ "dickynoodle", "Dicky Noodle 2002" },
	{ "digby", "For Love of Digby" },
	{ "disambtest", "Disambiguation Test" },
	{ "display", "LED Display" },
	{ "dolg", "Debt" },
	{ "dontgoadrift", "Don't Go" },
	{ "door2", "Door and NPC" },
	{ "doortest", "Wedge-A-Door" },
	{ "doortoutopia", "The Door to Utopia" },
	{ "doorwithsensor", "Door with Sensor" },
	{ "dragondiamond", "The Dragon Diamond" },
	{ "dragonsheart", "Dragon's Heart" },
	{ "dragonsphere", "Dragonsphere" },
	{ "dreamland", "Dreamland" },
	{ "dreamquest", "Dream Quest" },
	{ "dreamspun", "Dreamspun" },
	{ "dressbygender", "Dress by Gender" },
	{ "driftingin", "Adrift Drifting In" },
	{ "driftmaze", "The ADRIFT Maze" },
	{ "drivingatnight", "The Dangers of Driving at Night" },
	{ "druggylane", "Druggy Lane" },
	{ "drwhovortexlust", "Doctor Who and The Vortex of Lust" },
	{ "duck", "Duck McCloud: The Fight Begins" },
	{ "easterpeeps", "It's Easter, Peeps" },
	{ "eatfull", "Task Counting" },
	{ "ebonysworld", "Ebony's World" },
	{ "ecod3d", "The Evil Chicken of Doom 3D" },
	{ "edithscats", "Edith's Cats" },
	{ "elascensor", "El Ascensor" },
	{ "elevator", "Elevator" },
	{ "emotions", "Emotions" },
	{ "enc1", "Encounter 1: Tim's Mom" },
	{ "enc2", "Encounter 2: The Study Group" },
	{ "enigmaadrift", "Enigma Creature" },
	{ "escapecamelot", "Escape from Camelot" },
	{ "escapefromsouth", "Tom Ceader: Escape From The South" },
	{ "escapehouse2", "The Escape from the House 2" },
	{ "escapetofreedom", "Escape to Freedom" },
	{ "etnyadrift", "Escape to New York" },
	{ "eveningwithecod", "An Evening with the Evil Chicken of Doom" },
	{ "event", "Event" },
	{ "expendableitems", "Expendable Items" },
	{ "expsystem", "Experience System" },
	{ "fairscarenightmare", "Fair Scare Nightmare" },
	{ "farfromhome", "Far From Home" },
	{ "faucets", "Running Water" },
	{ "findandy1", "Find Andy: Part 1" },
	{ "finedayforreaping", "A Fine Day for Reaping" },
	{ "firstarise", "The First to Arise" },
	{ "firstdayadrift", "First Day" },
	{ "first", "The Book of Fistandantalus" },
	{ "foresthouse", "Forest House" },
	{ "fox", "Fox" },
	{ "frustrated", "Frustrated Interviewee" },
	{ "fugitive", "The Fugitive" },
	{ "fullcircle", "Full Circle" },
	{ "funhouse", "The Funhouse" },
	{ "g7056", "G7056" },
	{ "gallows", "Showtime at the Gallows" },
	{ "gammagals", "The Gamma Gals" },
	{ "gateway", "Gateway: Guardian Child" },
	{ "ghoster", "Ghoster" },
	{ "ghosttownadrift", "Ghost Town" },
	{ "gmylm", "Give Me Your Lunch Money" },
	{ "go", "Go!" },
	{ "golddragon", "Howard. Oblivion. Part 1: Gold Dragon" },
	{ "goldilocksbreakent", "Goldilocks: Breaking & Entering" },
	{ "goldilocksfox", "Goldilocks is a FOX!" },
	{ "golfadrift", "Golf" },
	{ "golfball", "Golfball" },
	{ "gosha", "Gosha Adventure" },
	{ "gps", "GPS" },
	{ "grandjourney", "Grand Journey" },
	{ "grappling", "Grappling Hook" },
	{ "great", "The Great Escape" },
	{ "greek", "Greek School Adventure" },
	{ "gross", "Gross: The Game" },
	{ "guess3num", "Guess 3 Numbers" },
	{ "gumball", "Gumball Machine" },
	{ "guysguys", "Guys, Guys" },
	{ "halloweenhijinks", "Halloween Hijinks" },
	{ "hammurabiadrift", "Hammurabi" },
	{ "hangover", "Hangover" },
	{ "hcw", "How to Conquer the World" },
	{ "hellinahamper", "To Hell in a Hamper" },
	{ "heretoday", "Here Today, Tomorrow, Next Week!" },
	{ "heroesadrift", "Heroes are Interesting Things to Be" },
	{ "hhorror", "House of Horror" },
	{ "hhouse", "The Haunted House" },
	{ "hintsl", "Hint System Library" },
	{ "holdbreath", "Hold Breath" },
	{ "hornetsnest", "The Star Trek Chain Reaction: The Hornets' Nest" },
	{ "hotelfuego", "Hotel con Fuego" },
	{ "houseadrift", "House" },
	{ "housedeath", "House of Death" },
	{ "houseofthedamned", "House of the Damned" },
	{ "howdidi", "How Did I Get Into This?" },
	{ "howitstarted", "How It All Started" },
	{ "human", "Oh, Human" },
	{ "humbug", "Humbug" },
	{ "hungry", "Hungry" },
	{ "huntung", "Hunting Ground" },
	{ "hyperbs", "HYPER Battle System" },
	{ "hypertag", "Locked Door with Water Trap" },
	{ "iachini", "A Day at the Iachini House" },
	{ "icecream", "Ice Cream" },
	{ "igor", "Igor" },
	{ "igorone", "One Room" },
	{ "ilgolem", "Il Golem" },
	{ "illegal", "Illegal Socks" },
	{ "imaginings", "Imagings" },
	{ "impulso", "Impulso" },
	{ "infospace", "Info Space" },
	{ "inmemory", "In Memory" },
	{ "input", "Question/Input" },
	{ "insidejob", "Inside Job" },
	{ "interrogate", "Interrogate" },
	{ "inthemind", "In the Mind of the Master" },
	{ "invasionshirts", "Invasion of the Second-Hand Shirts" },
	{ "inverness", "Inverness Castle" },
	{ "invert", "Invert's Road Trip" },
	{ "invisible", "Invisible Visible" },
	{ "inyourhome", "WIP: More Test Runs" },
	{ "irvinequik", "Irvine Quik & the Search for the Fish of Traglea" },
	{ "isle", "The Isle" },
	{ "isummon", "I Summon Thee!" },
	{ "jacarandajim", "Jacaranda Jim" },
	{ "jason2", "Jason Evans 2" },
	{ "jason3", "Jason Evans 3" },
	{ "jason4", "Jason Evans 4" },
	{ "jasonevans", "Jason Evans 1" },
	{ "jgrim", "Jonathan Grimshaw: Space Tourist" },
	{ "jimpond", "Jim Pond 1" },
	{ "jinx", "JINXTRON" },
	{ "justanotherdayadrift", "Just Another Day" },
	{ "keys", "Where Are My Keys?" },
	{ "labrats", "Laboratory R.A.T.S." },
	{ "lairofthevampire", "Lair of the Vampire" },
	{ "largo", "Largo Winch" },
	{ "lastknight", "Last Knight" },
	{ "lastexpedition", "The Last Expedition" },
	{ "layers", "Clothing Layers" },
	{ "legacyofaprincess", "Legacy of a Princess" },
	{ "legends", "Legends RPG System" },
	{ "lesfeux", "Les Feux de l'Enfer" },
	{ "life", "Life" },
	{ "lifesimulation", "Life Simulation" },
	{ "lightsgoout", "When the Lights Go Out" },
	{ "lights", "Lights, Camera, Action!" },
	{ "liqid", "The Quest for More Hair" },
	{ "listenformonsters", "Listen for Monsters" },
	{ "location", "Location & Listen" },
	{ "lock2", "Locked Box" },
	{ "lockedout", "Locked Out" },
	{ "longjourneyhome", "The Long Journey Home" },
	{ "loopthrough", "Loop Through Objects" },
	{ "lostadrift", "Lost" },
	{ "lostcoastlines", "The Lost Coastline" },
	{ "lostmines", "The Lost Mines" },
	{ "losttomb", "The Lost Tomb" },
	{ "loveforreal", "Love for Real" },
	{ "magicshow", "The Magic Show" },
	{ "magneticmoon", "Magnetic Moon" },
	{ "makeshiftmagician", "The Makeshift Magician" },
	{ "mammoth", "Mammoth Vacuum Button of Death" },
	{ "marika", "Marika the Offering" },
	{ "marmalade", "Marmalade Skies" },
	{ "maroonedadrift", "Marooned" },
	{ "mattshouse", "Matt's House" },
	{ "mcl", "Character Library #1" },
	{ "meadrift", "X Me" },
	{ "mhpquestadrift", "Quest for the Magic Healing Plant" },
	{ "microwaveman", "Microwave Man!" },
	{ "mikes", "The Life of Mike" },
	{ "missingpersona", "Missing Person" },
	{ "ml256", "Makers Local and the Transdimensional Margarita Blender" },
	{ "mm2", "Monster in the Mirror" },
	{ "mm3", "Monster in the Mirror: Selma's Will" },
	{ "monsterage", "Monster Age: Trials of Dustorn" },
	{ "monsterisland", "Monster Island" },
	{ "monstermirror", "The Monster in the Mirror" },
	{ "monsters", "Monsters" },
	{ "morely", "The Murder of Jack Morely" },
	{ "morning", "A Morning with a Headache" },
	{ "morpheus", "The Cave of Morpheus" },
	{ "mortality", "Mortality" },
	{ "mould", "The Potter and the Mould" },
	{ "movechars", "Character Follows Character" },
	{ "movingobjects", "Task Command Functions" },
	{ "mrsmith", "The Search for Mr Smith" },
	{ "msl1", "Mystery’s Static Library #1" },
	{ "mudergreatfalls", "Murder in Great Falls" },
	{ "mudmonster", "Mud Monster" },
	{ "murdererhadleft", "What The Murderer Had Left" },
	{ "murders", "The Merry Murders" },
	{ "mustescape", "Must Escape!" },
	{ "mymindsmishmash", "My Mind's Mishmash" },
	{ "mynameis", "Player Name as Input" },
	{ "mysteryhouse", "Mystery House" },
	{ "mysterymanor", "Mystery Manor" },
	{ "n3reloj", "La Hija del Relojero" },
	{ "nameme", "Name Me" },
	{ "namiki", "A Day in the Life 2: Namiki" },
	{ "nastyescape", "The Nasty Escape" },
	{ "nat01", "Nathaniel Peck: Missing Necklace" },
	{ "neighboursfromhell", "Neighbours From Hell" },
	{ "nem", "The Nem Rehsif" },
	{ "newbie", "Newbie" },
	{ "newrooms", "News Rooms" },
	{ "newton", "Newton" },
	{ "nightelmstreet", "A Nightmare on Elm Streetn" },
	{ "nightmoon", "The Night the Moon Shone Grey" },
	{ "nightthatdripped", "The Night that Dripped Blood" },
	{ "nodrop", "No Drop" },
	{ "nonsensemachine", "The Nonsense Machine 6000" },
	{ "notebook", "Notebook" },
	{ "noximion", "Noximion" },
	{ "npcgroupwalk", "Room Group NPC Walk" },
	{ "nycholiday", "Protype Level" },
	{ "obsession", "Sad Obsession" },
	{ "oct31", "October 31st" },
	{ "officebreak", "Office Breakout" },
	{ "oldmoney", "Ye Olde Money" },
	{ "onnafa", "Oh No, Not Another Fantasy Adventure" },
	{ "options", "Options" },
	{ "orcho", "The Search for Orcho's Pot of Gold" },
	{ "orient", "Orient Express" },
	{ "os", "OS" },
	{ "outside", "Outside" },
	{ "overtheedge", "Over the Edge" },
	{ "paintadrift", "Paint!!!" },
	{ "panic", "Panic" },
	{ "paperrack", "Newspaper Rack" },
	{ "partytomurder", "A Party to Murder" },
	{ "passages", "The Passages" },
	{ "pathwayadrift", "Pathway to Destruction" },
	{ "percytheviking", "The Saga of Percy the Viking" },
	{ "phoenixdestiny", "Phoenix Destiny" },
	{ "phonebooth", "Pick Up the Phone Booth and Cry" },
	{ "picture", "Conversation with a Picture" },
	{ "pkgirl", "The PK Girl" },
	{ "plagueredux", "The Plague" },
	{ "platinum", "Generator Platinum" },
	{ "plunder", "Pirate's Plunder!" },
	{ "poker", "Poker Game" },
	{ "praxis", "from the Files of Sigmund Sigmund Praxis, Guerrilla Therapist" },
	{ "professional", "Professional" },
	{ "professorvonwitt", "Professor von Witt's Fabulous Flying Machine" },
	{ "projectactually", "A Place" },
	{ "provenance", "Provenance" },
	{ "ptbad65", "PTBAD6.5: THE URL THAT DIDN'T WORK" },
	{ "ptgood", "PTGOOD" },
	{ "puzzlebox", "The Puzzle Box" },
	{ "questforfood", "Quest for Food" },
	{ "quiatuedana", "Qui a tué Dana ?" },
	{ "rachelbadday", "Rachel has a bad day" },
	{ "radioactive", "That Crazy Radioactive Monkey!" },
	{ "raiders", "Raiders of Sheppey" },
	{ "rain0", "Rain Module" },
	{ "randomnumber", "Random Number Generator" },
	{ "random", "Random" },
	{ "randomscattering", "Random Scattering" },
	{ "randpuzzle", "Random Puzzle" },
	{ "razorsedge", "Razor's Edge" },
	{ "readinginmayadrift", "A Reading in May" },
	{ "realtime", "Real Time!" },
	{ "rechargablelantern", "Rechargable Lantern w/ Turn Counter" },
	{ "relife", "ReLife" },
	{ "renuntio", "Renuntio" },
	{ "report", "Report Espionage" },
	{ "requiem", "Requiem" },
	{ "respawningmonsters", "Respawning Monsters" },
	{ "restart", "Restart" },
	{ "richard", "Where is Richard?" },
	{ "rking", "The Reluctant Resurrectee" },
	{ "rndperson", "Random Person in Line" },
	{ "rockband", "Rock Band: Revenge of Gigantor!" },
	{ "rockyraccoon", "Rocky Raccoon" },
	{ "ronforest", "Forest on the Norm" },
	{ "rontoxic", "Toxically Earth" },
	{ "roomdescdemo", "Changing Room Description" },
	{ "roomentrytask", "Run Task on Room Entry" },
	{ "rtcountdown", "Realtime Countdown" },
	{ "sand", "Sand" },
	{ "savethekitten", "Save the Kitten" },
	{ "sbft", "Stupid Bloody Fairytale" },
	{ "sceneofthecrime", "Scene of the Crime" },
	{ "schoolproject", "My School Social Studies Project" },
	{ "score", "To Score or Not to Score" },
	{ "screensavers", "The Screen Savers on Planet X" },
	{ "seatdemo", "Seated Character" },
	{ "secondchance", "Second Chance" },
	{ "secretoflostworld", "The Secret of the Lost World" },
	{ "seekandenjoyr", "Seek and Enjoy" },
	{ "selmaswill", "Selma's Will" },
	{ "sentor", "Sentor" },
	{ "sere", "SERE: Survive, Evade, Resist, Escape" },
	{ "seriespasswords", "Series Passwords" },
	{ "severance", "Severance Battle System" },
	{ "seymoursstoopidquest", "Seymour's Stoopid Quest" },
	{ "shablon", "Shablon" },
	{ "shadowpeak", "Shadowpeak" },
	{ "shadrick1", "Shadrick's Travels" },
	{ "shadrick2", "Shadrick's Underground Adventures" },
	{ "shanilor", "Shanilor's Tower" },
	{ "shetland", "The Shetland Enigma" },
	{ "shredem", "Shred 'em" },
	{ "shuffling", "The Shuffling Room" },
	{ "sierramadre", "Terror of the Sierra Madre" },
	{ "sigurd", "Sigurd Fafnesbane" },
	{ "silknoil", "Silk Noil" },
	{ "sk8sponsorz", "SK8 Sponsorz" },
	{ "skybreak", "Skybreak!" },
	{ "sleaze", "Sleaze City" },
	{ "smercenary", "Space Mercenary" },
	{ "sniperscope", "Sniper Scope" },
	{ "snowdrift", "Snowdrift" },
	{ "solitaryadrift", "Four Walls and a Toilet" },
	{ "sommeril", "Sommeril" },
	{ "sophia", "Sophia" },
	{ "sophie", "Sophie's Adventure" },
	{ "sorcereradrift", "The Sorcerer" },
	{ "spaceboy2", "The Adventure of Space Boy! Volume II" },
	{ "spaceboy", "The Adventure of Space Boy!" },
	{ "spacerun", "Space Run" },
	{ "spawnmonstershop", "Respawning Monster and Shop" },
	{ "speaking", "Speaking NPC" },
	{ "spirit", "The Spirit's Flight" },
	{ "spooked", "Spooked!: The Wonders of Science" },
	{ "spooked2", "Spooked!: The Haunted Horror House" },
	{ "spotbother", "A Spot to Bother" },
	{ "stalker", "Stalker" },
	{ "standingdemo", "Stand on Stool to Examine" },
	{ "stardust", "S Tar Dus T" },
	{ "station", "Station XIII" },
	{ "stodw4", "The Strange Tale of Dr Wilkins" },
	{ "stopfollowing", "Stop Following" },
	{ "storetest", "Simple Store" },
	{ "stowaway", "Stowaway" },
	{ "strange", "The Strange Adventure" },
	{ "sunempire", "Sun Empire: Quest for the Founders" },
	{ "superliam", "Super Liam 1: A Hero Is Born" },
	{ "suzygotherpowers", "How Suzy got her Powers" },
	{ "swordincane", "Sword Concealed in Cane" },
	{ "sword", "Sword" },
	{ "talking", "Conversation Tree Sample" },
	{ "target", "Target" },
	{ "tearsoftoughman", "Tears of a Tough Man" },
	{ "teleport", "Teleport" },
	{ "television", "Television Channel Changing" },
	{ "tempest7", "Storm Tossed" },
	{ "templeofthesun", "Temple of the Sun" },
	{ "temporfell", "Temporfell" },
	{ "tempusfugit", "Tempus Fugit" },
	{ "testingstatus", "Testing Status" },
	{ "texevil", "Textident Evil" },
	{ "theannihilationofthink3", "Annihilation of Think.com 3" },
	{ "theawakeners", "The Awakeners" },
	{ "theclockadrift", "The Clock" },
	{ "thecrash", "The Crash" },
	{ "thedarkriver", "The Dark River" },
	{ "thedayprogram", "The Day Program" },
	{ "thehole", "The Hole" },
	{ "thehouse", "The House" },
	{ "thelabexperiment", "The Lab Experiment" },
	{ "thelabyrinthsystem", "The Labyrinth System" },
	{ "thelabyrinth", "The Labyrinth" },
	{ "thelasthour", "The Last Hour" },
	{ "thesisters", "The Sisters" },
	{ "thesorcerer", "The Sorcerer" },
	{ "thesuccessor", "The Successor" },
	{ "thetest", "The Test" },
	{ "thevirtualhuman", "The Virtual Human" },
	{ "thewill", "The Will" },
	{ "tickettonowhere", "Ticket to No Where" },
	{ "tictactoe", "Tic-Tac-Toe" },
	{ "timeadventure", "Time Adventure" },
	{ "timemachineadrift", "The Time Machine" },
	{ "timething", "Timething" },
	{ "time", "Time System" },
	{ "tmm", "The First Chapter" },
	{ "tmn", "The Magician’s Niece" },
	{ "togetyou", "We Are Coming to Get You!" },
	{ "tohell", "To Hell and Beyond" },
	{ "tomdickharry", "Tom Dick and Harry" },
	{ "toolkit", "Toolkit" },
	{ "topaz", "Topaz" },
	{ "tophat", "Top Hat" },
	{ "toronto", "A Day in Toronto" },
	{ "townofazra", "Town of Azra" },
	{ "tq3", "The Quest" },
	{ "trabula", "Get Treasure for Trabula" },
	{ "trackingdevice2", "Tracking Device 2" },
	{ "tra", "The Timmy Reid Adventure" },
	{ "tree", "Conversation Tree" },
	{ "trickortreat", "Trick or Treat" },
	{ "trolladrift", "Troll!" },
	{ "trouserpress", "Trouserpress" },
	{ "twentyone", "Twenty-One!" },
	{ "twilight", "The Twilight" },
	{ "txfbeg", "The X-Files: A New Beginning" },
	{ "unauthorizedtermination", "Unauthorised Termination" },
	{ "unravelinggod", "Unraveling God" },
	{ "untitled1", "Untitled Title #1" },
	{ "untitled2", "Untitled Title #2" },
	{ "upgirls", "Uptown Girls" },
	{ "urbandragon", "Urban Dragon" },
	{ "vagabond", "Vagabond" },
	{ "vague", "Vague" },
	{ "vampireconscience", "The Vampire with a Conscience" },
	{ "vandk", "Villains and Kings" },
	{ "vendetta", "Vendetta" },
	{ "veteranknowledge" , "Veteran Knowledge" },
	{ "videotapedecay", "Video.Tape / Decay" },
	{ "viewhome", "A View to a Home" },
	{ "viewisbetter", "The View Is Better Here" },
	{ "volant", "Starship Volant: Stowaway" },
	{ "warlord", "The Warlord, The Princess & The Bulldog" },
	{ "waspconnection", "The Wasp Connection" },
	{ "wasteland", "Wasteland" },
	{ "waxworx", "Wax Worx" },
	{ "weathertime", "Time and Weather System" },
	{ "weirdstuff", "And Then the Weird Stuff Started..." },
	{ "whatever", "Whatever Happened to Uncle Grumble?" },
	{ "wheel", "The Wheels Must Turn" },
	{ "whereami", "Where am I?" },
	{ "whitesingularity", "The White Singularity" },
	{ "without", "Without a Clue" },
	{ "wizardplayground", "Wizards Playground" },
	{ "wonderlandadrift", "Welcome to Wonderland" },
	{ "woodsaredark", "The Woods Are Dark" },
	{ "woof", "Woof" },
	{ "workingtrackingdevice", "Tracking Device" },
	{ "world", "The World According to CBN" },
	{ "worstgame", "The Worst Game in the World... Ever!!!" },
	{ "wreckage", "Wreckage" },
	{ "wrecked", "Wrecked" },
	{ "wumpushunt", "Wumpus Hunt" },
	{ "wumpusrun", "The Wumpus Run" },
	{ "xycanthus", "Doomed Xycanthus" },
	{ "yadfa", "Yet Another Damn Fantasy Adventure" },
	{ "yeh", "The Quest" },
	{ "yonastoundingcastle", "Yon Astounding Castle! of some sort" },
	{ "zanoza", "Zanoza Bill - Zolotaya likhoradka - Bilet v Vankuver" },
	{ "zombiesadrift", "Zombies Are Cool, But Not So Cool When They're Eating Your Head" },
	{ "zombiewalk", "Bringing Dead NPC Back to Life" },
	{ "zomelec", "Zomelec" },

	// ADRIFT 5 Intro Comp 2012
	{ "a5icblankwall", "The Blank Wall" },
	{ "a5icorganic", "Organic" },
	{ "a5icshatteredmemory", "Shattered Memory" },
	{ "a5ictrappedadrift", "Trapped" },
	{ "a5icheadcase", "Head Case" },
	{ "a5icaxeofkolt", "The Axe of Kolt" },

	// ADRIFT Hourglass Comp 2006
	{ "ahc3minutes", "3 Minutes to Live" },
	{ "ahcovertheedge", "Over the Edge" },
	{ "ahcboiledeggs", "Boiled Eggs" },
	{ "ahclongbarrow", "The Long Barrow" },
	{ "ahcpilfers", "Pilfers" },
	{ "ahcchooseyourown", "Choose Your Own..." },
	{ "ahcskydiver", "The Skydiver" },
	{ "ahcquestforfood", "Quest for Food" },
	{ "ahcdancing", "Dancing Even Him?" },
	{ "ahcrollingdough", "Rolling the Dough" },
	{ "ahcsmote", "Smote" },
	{ "ahcroadnowhere", "The Road Leads to Nowhere" },
	{ "ahcherrdoktor", "Herr Doktor von Nördlingendinkelsbühlhündchen-am-Rhein" },

	// ADRIFT Intro Comp 2005
	{ "aicmurdermansion", "Murder Mansion" },
	{ "aicoutline", "Outline" },
	{ "aicsrs", "Silk Road Secrets: Samarkand to Lop Nor" },
	{ "aicescape", "Must Escape!" },
	{ "aicfinalquestion", "The Final Question" },
	{ "aicrift", "Rift" },
	{ "aicp2p", "Point 2 Point" },
	{ "aiczacksmackfoot", "Zack Smackfoot" },

	// ADRIFT Intro Comp 2009
	{ "aicexistence", "Existence" },
	{ "aicapokalupsis", "Apokalupsis" },
	{ "aicdbaa", "Dung Beetles Are Aliens" },
	{ "aicteaw", "To End All Wars" },
	{ "aicmerlinbirdofprey", "The Merlin Bird of Prey" },
	{ "aicdeadrace", "Dead Race" },
	{ "aicdishduty", "Dish Duty" },
	{ "aicyoncastle", "Ye Intro for Yon Astounding Castle! of Some Sort" },
	{ "aicthroughtime", "Through Time" },
	{ "aicdonuts", "Donuts" },

	// ADRIFT Mini-Competition Summer 2003
	{ "amcthorn", "The Thorn" },
	{ "amcneighbours", "Neighbours From Hell" },
	{ "amcmonsters", "Monsters" },
	{ "amcdiarystrip", "Diary of a Stripper" },

	// ADRIFT One-Hour Game Competition 1
	{ "1hgprincess1", "The Princess in the Tower" },
	{ "1hg1hrgame", "A Masochist's Heaven" },
	{ "1hgendgame", "The Game To End All Games" },
	{ "1hgchicken", "The Evil Chicken of Doom!" },
	{ "1hghauntedhouse", "The Haunted House of Hideous Horror" },
	{ "1hgfrog", "The Green Princess" },
	{ "1hgmicrobewillie", "Microbe Willie vs. The Rat" },
	{ "1hgjasonvssalm", "Jason vs. Salm" },
	{ "1hgamonkeytoomany", "A Monkey too many" },

	// ADRIFT One-Hour Game Competition 2
	{ "1hgpercy", "The Saga of Percy the Viking" },
	{ "1hgforum", "Forum" },
	{ "1hgdfu", "Dance Fever USA" },

	// ADRIFT One-Hour Game Competition 3
	{ "1hgforum2", "Forum 2" },
	{ "1hgcrm", "That Crazy Radioactive Monkey!" },
	{ "1hgasdfa", "A Short Damn Fantasy Adventure" },
	{ "1hgdemonhunter", "Apprentice of the Demonhunter" },
	{ "1hgcbn1", "The Revenge of Clueless Bob Newbie!" },
	{ "1hgcbn2", "The Revenge of Clueless Bob Newbie Part 2: This Time it's Personal" },
	{ "1hgticktick", "Doom Cat!!!" },
	{ "1hgpyramid", "The Pyramid of Hamaratum" },
	{ "1hgquesti", "Quest for Flesh" },
	{ "1hgshore", "The Farthest Shore" },
	{ "1hgsaffire", "Saffire" },
	{ "1hgecod2", "The Curse of the Revenge of the Ghost of the Evil Chicken of Doom... Returns!" },
	{ "1hgimagination", "Just My Imagination-Musings of a Child" },

	// ADRIFT One-Hour Game Competition 4
	{ "1hgcah", "Cruel and Hilarious Punishment!" },
	{ "1hgarghsgreatescape", "Argh's Great Escape" },
	{ "1hgshreddem", "Shred 'em" },
	{ "1hgagent4f", "Agent 4-F from Mars" },
	{ "1hgecod3", "An Evening with the Evil Chicken of Doom" },
	{ "1hgtrabula", "Get Treasure for Trabula" },
	{ "1hgwoof", "Woof" },
	{ "1hgundefined", "Undefined" },
	{ "1hgadriftmaze", "The Adrift Maze" },
	{ "1hgicecream", "Ice Cream" },
	{ "1hgwreckage", "SE: Wreckage" },
	{ "1hgspam", "SPAM" },
	{ "1hgvagabond", "Vagabond" },
	{ "1hgthecatinthetree", "The Cat in the Tree" },
	{ "1hgtopaz", "Topaz" },
	{ "1hggoblinhunt", "Goblin Hunt" },

	// Ectocomp 2007
	{ "ectcvideotapedecay", "Video.Tape / Decay" },
	{ "ectcforesthouse", "Forest House" },
	{ "ectcstowie", "The Stowaway" },
	{ "ectcwitness", "Witness: Demon vs Vampire" },

	// Ectocomp 2008
	{ "ectcforesthouse3", "For3st House: Sacrifice" },
	{ "ectcdrinks", "Drinks with Lord Hansom" },
	{ "ectchiker", "Conversation with a Hitchhiker" },
	{ "ectcsalutations", "Salutations" },
	{ "ectcblast", "Blast" },
	{ "ectcr2dc", "Return to Dracula's Castle II: Revenge of Dracula's Castle" },
	{ "ectcdelsol", "DeL SoL MADNESS" },

	// Ectocomp 2009
	{ "ectcdrivingatnight", "The Dangers of Driving at Night" },
	{ "ectcpatient7", "Patient 7" },
	{ "ectcwayout", "Way Out" },

	// Ectocomp 2010
	{ "ectcpetespunkin", "Pete's Punkin Junkinator" },
	{ "ectcrenegadebrainwave", "Renegade Brainwave" },
	{ "ectchelsing", "Steve Van Helsing: Process Server" },
	{ "ectciwasteenage", "I Was a Teenage Headless Experiment" },
	{ "ectcthevault", "The Vault" },
	{ "ectcflyhuman", "The Fly Human" },
	{ "ectcallhallows", "All Hallows Eve" },
	{ "ectctenebraesemper", "Tenebrae Semper" },

	// Ectocomp 2011
	{ "ectcattacklobster", "Attack of Doc Lobster's Mutant Menagerie of Horror" },
	{ "ectcdeathshack", "Death Shack" },
	{ "ectcignisfatuus", "Ignis Fatuus" },
	{ "ectcthehouse", "The House" },
	{ "ectcstuckpiggy", "Stuck Piggy" },

	// Game of the Year Competition: December 2004
	{ "goyshardsofmemory", "Shards of Memory" },
	{ "goypaint", "Paint!!!" },
	{ "goydragonshrine", "The Curse of DragonShrine" },
	{ "goydarkness", "Darkness" },
	{ "goywaxworx", "Wax Worx" },

	// Game of the Year Competition 2007
	{ "goymarika", "Marika the Offering" },
	{ "goyrking", "The Reluctant Resurrectee" },
	{ "goyvideotapedecay", "Video.Tape / Decay" },
	{ "goyterrified", "Terrified" },
	{ "goyfinedayforreaping", "A Fine Day for Reaping" },
	{ "goypuzzlebox", "The Puzzle Box" },

	// InsideADRIFT Spring Competition 2004
	{ "iadcshardsofmemory", "Shards of Memory" },
	{ "iadcdragonshrine", "The Curse of DragonShrine" },
	{ "iadcwaxworx", "Wax Worx" },
	{ "iadcsommeril", "A Day at the Seaside" },

	// InsideADRIFT Summer Competition 2004
	{ "iadcchooseyourown", "Choose Your Own..." },
	{ "iadcdarkhavenmystery", "The Mystery of the Darkhaven Caves" },
	{ "iadcshadricksunderground", "Shadrack's Underground Adventure" },
	{ "iadctickettonowhere", "Ticket to No Where" },
	{ "iadctearsofatoughman", "Tears of a Tough Man" },
	{ "iadctheadriftproject", "The ADRIFT Project" },

	// InsideADRIFT Spring Competition 2005
	{ "iadcseaside", "A Day at the Seaside" },
	{ "iadcfrustrated", "Frustrated Interviewee" },
	{ "iadchub", "The House Husband" },
	{ "iadcprivateeye", "Private Eye" },
	{ "iadcblood", "Fire in the Blood" },

	// InsideADRIFT Summer Competition 2005
	{ "iadccibass", "Can It Be All So Simple?" },
	{ "iadcmustescape", "Must Escape!" },
	{ "iadclca", "Lights, Camera, Action!" },
	{ "iadcregrets", "Regrets" },
	{ "iadctarget", "Target" },

	// InsideADRIFT Summer Competition 2006
	{ "iadcpestilence", "Pestilence" },
	{ "iadcreluctantvampire", "The Reluctant Vampire" },
	{ "iadcspooked", "Spooked!: The Wonders of Science" },

	// InsideAdrift Summer Competition 2008
	{ "iadcdoor", "Door" },
	{ "iadcwolvesatthedoor", "Wolves at the Door" },
	{ "iadchappyvalley", "Happy Valley" },
	{ "iadcmarlin", "The Marlin Affair: Prologue" },
	{ "iadchuntung", "Hunting Ground" },

	// InsideADRIFT Summer Competition 2010
	{ "iadcaegis", "Aegis" },
	{ "iadcbaroo", "Ba'Roo!" },
	{ "iadccamelot", "Camelot" },
	{ "iadclightup", "Light Up" },
	{ "iadcmotion", "Motion" },
	{ "iadcplunder", "Pirate's Plunder!" },

	// No Name Competition
	{ "noncpiecesofeden", "Pieces of Eden" },
	{ "noncbeanstalk", "Beanstalk the and Jack" },
	{ "noncperfectspy", "The Perfect Spy" },

	// P⁄o Prune's Finish the Game Comp 2005
	{ "ftgcshadowjack", "Jack of Shadows" },
	{ "ftgctakeone", "Take One" },
	{ "ftgcdemonhunter", "The Demon Hunter" },
	{ "ftgcpathwayadrift", "Pathway to Destruction" },
	{ "ftgcshadow", "Shadow of the Past" },
	{ "ftgchunter", "The Hunter" },

	// P/o Prune's Mini Comp 2021
	{ "prmcdifficultpuzzle", "A Difficult Puzzle" },
	{ "prmcillumina", "Illumina" },
	{ "prmcquestgiver", "Quest Giver" },
	{ "prmcthegardenparty", "The Garden Party" },

	// P/o Prune's Spring Ting 2009
	{ "prsthomelesslarry", "Homeless Harry" },
	{ "prstmrfluffy", "Mr. Fluffykin’s Most Harrowing Misadventure" },
	{ "prstreactor", "ESS Chance: Reactor 1" },
	{ "prstsandy", "Sandy’s Lost Doll" },

	// P/o Prune's Spring Ting 2010
	{ "prstwghn", "Wes Garden's Halting Nightmare" },
	{ "prstegghunt", "Easter Egg Hunt" },

	// P/o Prune's Twin Competition
	{ "prtcmelancholy", "Melancholy Blood: Act 1" },
	{ "prtccrashland", "Crashland" },

	// Poodle's One Room Competition
	{ "porcdeadman", "The Dead Man" },
	{ "porcdreamland", "Dreamland" },
	{ "porceverything", "Everything Emanuelle" },
	{ "porciadrift", "I" },
	{ "porcinsanity", "Escape from Insanity" },
	{ "porcmsmobius", "Montahue Scott and the Mobius Belt" },
	{ "porcdayattheoffice", "A Day at the Office" },
	{ "porctrappedwithagirl", "Trapped with a Girl" },

	// The 'Anyone in the mood for a comp?' Comp
	{ "tamcalgernon", "Algernon's Conundrum" },
	{ "tamcbeagle", "Beagle" },

	// The Challenge
	{ "tchgmangiasour", "Mangiasaur" },
	{ "tchgsuburban", "Surburban Prodigy" },
	{ "tchgwhitterscap", "Whitterscap's Key" },

	// The Even Competition
	{ "tevcattackamutaydid", "Attack of the Mutaydid Meat Monsters" },
	{ "tevcrain", "Bringing the Rain" },
	{ "tevcperspectives", "Perspectives" },

	// The Odd Competition
	{ "todcasteroidaftermath", "Asteroid Aftermath" },
	{ "todcbusinessasusual", "Business as Usual" },
	{ "todcgorxungula", "Gorxungula’s Curse" },
	{ "todciamlaw", "I Am the Law" },
	{ "todcmaincourse", "Main Course" },
	{ "todchuman", "Oh, Human" },
	{ "todcreturnforesthouse", "Return to the Forest House" },
	{ "todcseance", "Seance" },
	{ "todcwitchtale", "A Witch Tale" },
	{ "todcyakshaving", "Yak Shaving for Kicks and Giggles!" },

	// The Writing Challenges Comp
	{ "twccmanoverboard", "Man Overboard!!!" },
	{ "twccglumfiddle", "Glum Fiddle" },
	{ "twccjgrim", "Jonathan Grim Space Tourist: Ren" },
	{ "twcctoomuchexercise", "Too Much Exercise" },

	// Three Hour Games Competition: July 2004
	{ "3hgjailbreakbob", "Jailbreak Bob" },
	{ "3hgbriefcase", "Briefcase" },
	{ "3hgtheannihilationofthink", "Annihilation of Think.com" },
	{ "3hgshadricktravels", "Shadrick's Travels" },
	{ "3hglostsouls", "Lost Souls" },
	{ "3hgtheamulet", "The Amulet" },
	{ "3hgzombiecow", "Zombie Cow" },

	// Three Hour Games Competition: November 2004
	{ "3hgsandl", "Snakes and Ladders" },
	{ "3hgconfession", "The Murder of Jack Morely" },
	{ "3hgveteran", "Veteran Experience" },
	{ "3hgburiedalive", "Buried Alive" },
	{ "3hgzac", "Zombies Are Cool, But Not So Cool When They're Eating Your Head" },
	{ "3hgtogetyou", "We are coming to get you!" },

	{ nullptr, nullptr }
};

const PlainGameDescriptor ADRIFT5_GAME_LIST[] = {
	{ "4rooms", "4rooms" },
	{ "advbackyard", "An Adventurer's Backyard" },
	{ "aliendiver", "Alien Diver" },
	{ "allthroughthenight", "All Through the Night" },
	{ "anno1700", "Anno 1700" },
	{ "axeofkolt", "The Axe of Kolt" },
	{ "beagle", "Beagle" },
	{ "beginnerscave", "Beginner's Cave" },
	{ "birthofphoenix", "Birth of the Phoenix" },
	{ "darkhour", "The Dark Hour" },
	{ "ddf", "The Dwarf of Direwood Forest" },
	{ "deadwinter", "The Dead of Winter" },
	{ "dementophobia", "Dementophobia" },
	{ "difficultpuzzle", "A Difficult Puzzle" },
	{ "digitalroots", "DigitalRoots" },
	{ "fortress", "The Fortress of Fear" },
	{ "grandma", "Grandma's Flying Saucer" },
	{ "grandpa", "Grandpa's Ranch" },
	{ "halloween", "Halloween" },
	{ "heritage", "The Heritage" },
	{ "illumina", "Illumina" },
	{ "jabberwocky", "Jabberwocky: The Untold Story" },
	{ "jacd", "Just Another Christmas Day" },
	{ "jaft", "Just Another Fairy Tale" },
	{ "labyrinthadrift", "The Leviathan Labyrinth" },
	{ "lazaitch", "The Lost Labyrinth of Lazaitch" },
	{ "lmk", "Land of the Mountain King" },
	{ "museumheist", "Museum Heist" },
	{ "noblecrook1", "Noble Crook, episode 1" },
	{ "noblecrook2", "Noble Crook, episode 2" },
	{ "noblecrook3", "Noble Crook, episode 3" },
	{ "noblecrook4", "Noble Crook, episode 4" },
	{ "penrhyn", "Penrhyn: Burning Skies" },
	{ "rbr", "Run, Bronwynn, Run!" },
	{ "royalpuzzle", "The Royal Puzzle" },
	{ "rsp", "Revenge of the Space Pirates" },
	{ "rtcc", "Return to Castle Coris" },
	{ "rtc", "Return to Camelot" },
	{ "salvage", "The Salvage" },
	{ "sixsilverbullets", "Six Silver Bullets" },
	{ "soc", "Son of Camelot" },
	{ "socc", "The Spectre of Castle Coris" },
	{ "sonofcamelot", "Son of Camelot" },
	{ "sorryforyourloss", "Sorry for Your Loss" },
	{ "spacedetective1", "Space Detective, episode 1" },
	{ "spacedetective2", "Space Detective, episode 2" },
	{ "spacedetective3", "Space Detective, episode 3" },
	{ "spacedetective4", "Space Detective, episode 4" },
	{ "spacedetective5", "Space Detective, episode 5" },
	{ "spacedetective6", "Space Detective, episode 6" },
	{ "spacedetective7", "Space Detective, episode 7" },
	{ "starshipquest", "Starship Quest" },
	{ "stoneofwisdom", "Stone of Wisdom" },
	{ "symphonica", "Symphonica 64" },
	{ "tcom1", "The Cave of Morpheus 1" },
	{ "tcom2", "The Cave of Morpheus 2" },
	{ "tcots", "The Call of the Shaman" },
	{ "tee", "The Euripedes Enigma" },
	{ "temperamentum", "Temperamentum" },
	{ "thegardenparty", "The Garden Party" },
	{ "thewayhome", "The Way Home: Episode 2 of the Bash Saga" },
	{ "tingalan", "Tingalan" },
	{ "tlc", "The Lost Children" },
	{ "ttp", "The Tartarus Project" },
	{ "treasurehunt", "Treasure Hunt in the Amazon" },
	{ "tributereturntocos", "Tribute Return to CoS" },
	{ "wwiiee", "WWII Elevator Escape" },

	{ nullptr, nullptr }
};


const GlkDetectionEntry ADRIFT_GAMES[] = {
	// English Games
	DT_ENTRY0("1sttime", "2ee60ee51dc1a2c672df78a3c91614bc", 29101),
	DT_ENTRY0("2playerex", "cc4a6e2019115daece9f94d1c66082dd", 1890),
	DT_ENTRY1("30seconds", "Demo", "85f0c04222a017f1139cbbd965d7e026", 612),
	DT_ENTRY0("3monkeys", "dec34c282511b1eadfe231dbbb49f625", 79286),
	DT_ENTRY0("achtung", "f035e68e00477056402f69fd4049471c", 120732),
	DT_ENTRY0("adriftmasparty", "d06febddd1f136bb7ef59713c31f2066", 3034048),
	DT_ENTRY0("adriftorama", "db66d96e2cbd397fc668abcd32d59aeb", 46432),
	DT_ENTRY0("adriftproject", "fcce2118d99574eb724364d36dc71d0b", 231621),
	DT_ENTRY1("advent350", "350 Points", "1d50a4f82fda17e06a178fd634ced8b4", 45400),
	DT_ENTRY0("adventurepostman", "bbdd2a34e831964eafb5c06562429c74", 6668),
	DT_ENTRY0("adventurestrikes", "f5e18081fd6ec4955ed0665aee8580de", 3770),
	DT_ENTRY0("adventurethumper", "d050a635699242cbfd383f7e16fe3a63", 107200),
	DT_ENTRY0("afp", "218d6543f45a7cd921cb7c2187f9600e", 79881),
	DT_ENTRY0("agent4fmars", "2935a990ade72f4c51a22f5843306b98", 3686),
	DT_ENTRY0("akari", "71a1137269234ee0941e54965c951c73", 31094),
	DT_ENTRY0("akron", "2461ceeef3ef1eac15a2051a549b4402", 22258),
	DT_ENTRYL0("akron", Common::RU_RUS, "9ee9af6f08091f7e3c7c0043f99e378f", 31744),
	DT_ENTRY0("albertlost", "3667644307d9e9683eb88b1fd4f90562", 279251),
	DT_ENTRY0("albridgemanor", "268003e454c4ade042d593af8397a490", 31353),
	DT_ENTRY1("alchemist", "No Media", "730b4f2e255024c501f28456324dc1b9", 165299),
	DT_ENTRY1("alchemist", "With Media", "c22b910b9c9703dd190c6bce71532bae", 165297),
	DT_ENTRY0("alexis", "d1adc72ae5f19e18e386ec1a3cab7212", 87229),
	DT_ENTRY0("alias", "14176ef2af8207d54b6c4ae6a8938046", 9213),
	DT_ENTRY0("alrhints", "799a0f2f0d9e44fd7542a13638c9f087", 3763),
	DT_ENTRY0("allroadsmars", "703cb672f13f7174a37c8d379abe466f", 2006),
	DT_ENTRY0("amazgriswold", "a044a6c6117b98aaa81c4083a2144946", 18992),
	DT_ENTRY0("amaztvcaper", "f456b996a5dcb6037e75196406e3c86d", 6187),
	DT_ENTRY0("americanmoney", "ecbe30e0a0e1610591f11e4538abd837", 2356),
	DT_ENTRY0("amnesiakid", "fa5998636923d0319b7a62ac685a49b7", 10268),
	DT_ENTRY0("amy", "be11b8af8fb1885c684f34962a32a887", 23957),
	DT_ENTRY0("angel", "a4508d6fbbd89ead3e72e961fe288427", 4429),
	DT_ENTRY1("aquarius1", "Part 1", "46b916da57f20730af8efa872acf1dd5", 13043),
	DT_ENTRY1("aquarius2", "Part 2", "7b0d73d080a9a456591a8b0144788fbe", 18961),
	DT_ENTRY0("aram", "442cc382e180eabe878f69c1d8470374", 18765),
	DT_ENTRY0("archiebdaych1", "fe52abda2b95ef53b23fb0fbaa7cbae7", 284319),
	DT_ENTRY1("armour", "Demo/v1", "4e9f3b70ef54f736fe18d40087248ff6", 315),
	DT_ENTRY1("armour", "Demo/v2", "e42a5cde88dbb8dd07df855c785a9564", 279),
	DT_ENTRY1("ascot", "Release 1", "01ed200d7aec907aa84ad4007c5b296b", 24494),
	DT_ENTRY1("ascot", "Release 2", "878ebf802cab7ad9e0d2ff54be096266", 24332),
	DT_ENTRY0("asdfa", "06173b47b4e88c0a494d2263666ad375", 27733),
	DT_ENTRY0("asylumadrift", "5d03f29f530701db4dc096b9e7307ae4", 44503),
	DT_ENTRY0("athylon", "431cfbc8a19c86c40cb9e4e57a733926", 6456),
	DT_ENTRY1("attack", "Demo", "c26f50555e90b95772402c6517ca8614", 1391),
	DT_ENTRY0("average", "bc4d0db4a6b95136bdb92aae623b7786", 11350),
	DT_ENTRY1("awalkatdusk", "v1", "f2e8aca65a17d41804709ee5a420ef36", 20725),
	DT_ENTRY1("awalkatdusk", "v2", "7baf130db0c1f24b198a6cf55fe704f7", 20529),
	DT_ENTRY0("azra", "26c4688cb6f66c9540fc4e603145e385", 13868),
	DT_ENTRY1("backhome", "v1", "bc13667aac95da199cf6ad32a51410dd", 31171),
	DT_ENTRY1("backhome", "v2", "5b086640b6099b686e8439d027449891", 36350),
	DT_ENTRY1("backtolife", "v2", "8493ffd877273ef95c88c8f433126473", 55438),
	DT_ENTRY1("backtolife", "v4", "e90cc6d87ce02fd0fa86ca1fdb4fbc54", 75316),
	DT_ENTRY1("badlands", "Demo", "5d654bb182e0337937e792af8caf8d5d", 20248),
	DT_ENTRY0("bananadvent", "e5b4283f59f5d4feb322c653c7dd8cc0", 2745),
	DT_ENTRYL1("bandera", Common::ES_ESP, "Release 1", "dd472902495610b4db02267d4fa2eff3", 8260541),
	DT_ENTRYL1("bandera", Common::ES_ESP, "Release 2", "e5257c2b5c66f2519da56023f5c84cc6", 36653),
	DT_ENTRY0("bariscebik", "d63d310e2b2fe4ab7ea6bc74c136b8e0", 14634),
	DT_ENTRY0("barneysproblem", "3fe45352a6c0d7bb0bdbf4f9c08afba7", 66055),
	DT_ENTRY0("basement", "bd037c5c85b73880caa75a65f6efcfca", 3237),
	DT_ENTRY0("bedlamadrift", "a86a6d6f3c54e787aafd9f9a8c9bef86", 21344),
	DT_ENTRY0("blueskyadrift", "32104bad81f6502654cf100bb5edd0e1", 30629),
	DT_ENTRY0("bcl", "14bfd0a8a53e95d23f8a5dcb3a79ae90", 8088),
	DT_ENTRY0("bdw", "85540c66a7a48a518572fb34bef5c1f8", 9723),
	DT_ENTRY1("beerisntenough", "Release 1", "8962dd84cee64d5239af7c6c50cc0c0d", 14186),
	DT_ENTRY1("beerisntenough", "Release 2", "98248a8e65a36f6d0fb98111255a85dc", 14070),
	DT_ENTRY1("beethro", "Demo", "3d362adf355f2e0b0016703f9ca90eb0", 18602),
	DT_ENTRYL0("bellesmeres", Common::FR_FRA, "3d556ba5448b4bce8e7b0ee818bd1e79", 73972744),
	DT_ENTRY0("bfhouse", "56f654ad401311cd827fb7a53354e0f4", 8148),
	DT_ENTRY1("bigspyfiction", "Chapter I", "220f5d03bc089e1618ab358820b1eaca", 2051),
	DT_ENTRY1("bigspyfiction", "Chapter II", "b27751a30a60d36a78a603560d9e41fd", 1989),
	DT_ENTRY1("bigspyfiction", "Chapter III", "1e8392e3715bc5d553abcd1e0db50c0f", 2729),
	DT_ENTRY0("blacksheep", "ac466de9e8f2e660bfe0c03b47f43d85", 29293),
	DT_ENTRY1("blob", "Demo", "f6a852a1b4588be3848d4158fdd5325e", 463),
	DT_ENTRY1("blood", "v1.03", "7c56c7ecaf14c440eefa64afadac8103", 100210),
	DT_ENTRY1("blood", "v1.04", "7b7a00f5d26e352a1650f13f9dd54869", 100202),
	DT_ENTRY0("bobbobsly", "de60977da0c1ddbcc467d2fedd9751bd", 10310),
	DT_ENTRY0("bombthreat", "150218c0377528a8353cb44a6806d5dd", 17955),
	DT_ENTRYL0("bookexistence", Common::RU_RUS, "6f2bca3a945a221c575fa1b05d99e7a3", 183448),
	DT_ENTRY0("bountyhunter", "6c23ce1ba2fd6aa9abc958442d14579b", 4057),
	DT_ENTRY1("breakable", "Demo", "269f443d8d7102efc2c77eddba9d3672", 2135),
	DT_ENTRY1("bulkitem", "Demo", "f0d0241ed7fd59ab40342ab414114a40", 622),
	DT_ENTRY0("businessasusual", "d71d95db428047e0963042ad09181176", 7235),
	DT_ENTRY0("bz3americans", "c78f5f1b1347b149499464534e358e49", 5402),
	DT_ENTRY0("bz3soviets", "199985dba2074122502af4c4422b8f1a", 4209),
	DT_ENTRYL0("caidalibre", Common::ES_ESP, "acdea550b0323f2e0832f66a6fbf5eaa", 18926),
	DT_ENTRY0("camelot", "f4c632787aebebbad220e5e4edb944f5", 54148),
	DT_ENTRY0("campwindylake", "33ea1f1fea9998472e9c352ea6e1c1d8", 114698),
	DT_ENTRY0("canidoit", "072f42e0a6d340e12885cae34e14bfd7", 5161),
	DT_ENTRY0("captive", "11409953b0f0042e9a36fabd8c46363f", 74568),
	DT_ENTRY1("cardemo", "Stewart J. McAbney Release/Demo", "970643c6a2eaeb20b42706759b334ba1", 1027),
	DT_ENTRY1("cardemo", "Mystery Release/Demo", "24ce042d41969aae4eff41b980174ffb", 525),
	DT_ENTRY0("cards", "a4b8feeb2deea9f8c7abeb77a1af7586", 2422),
	DT_ENTRY0("castlequest", "485e9c1c15fb40b9da9f5bb865b36854", 14777),
	DT_ENTRY1("cat", "Demo", "b45b97920aab576f37fdc9ef7e13825a", 588),
	DT_ENTRY0("catintree", "fa9477ce0960b5819291479a78687315", 6176),
	DT_ENTRY0("caveofwonders", "f55f4e63886eb09e1f89bea547574919", 85471),
	DT_ENTRY0("cd", "72d56f65dfdfded022f06c6d1dbc5294", 6312),
	DT_ENTRY0("cell", "3a6196e757d96ca07dab638325698c34", 20800),
	DT_ENTRY0("cellar", "acce6030ec753bffc6023f2d8cdc8994", 24032),
	DT_ENTRY0("cellpart1", "ad727adff523f2402a47901048c8e0e5", 18439),
	DT_ENTRY1("cellphone", "Demo", "08395bf21cd1c0e2981def85864d7015", 4192),
	DT_ENTRY1("chairtest", "Demo", "5dfb2744edc4e8521936f33ee266e598", 494),
	DT_ENTRY1("changepicture", "Demo", "1f8f81330cf5f8b4259363c20ecdb1a7", 39732),
	DT_ENTRY1("charactercreator", "v0.1", "486cecd739b228f00d16141192b4cf54", 9363),
	DT_ENTRY1("charactercreator", "v0.5", "5c68e2721487e9f4ae8328da27270b8b", 12562),
	DT_ENTRY1("charactercreator", "v0.9", "21269fa2721a6d2397a8e570f7185498", 16329),
	DT_ENTRY1("charactercreator", "v1.0", "42914213ec25cf038e5a5d5e6935db79", 27074),
	DT_ENTRY1("characterturn", "Demo", "6831efcef857abbf21e1f5113e7b79c7", 550),
	DT_ENTRY0("chargenerator", "fe37edc2577db84d20eba9659f198f1e", 18918),
	DT_ENTRY1("chasingrussian", "No Sound", "cb34a8cd2c852e34286b8913c61fb3e1", 35967),
	DT_ENTRY0("chicago", "c511775b25d9897b04df67ecd01e4af1", 19755),
	DT_ENTRY0("choices", "ac22dd465213347de1b97e03240a9bb7", 84761),
	DT_ENTRY0("chooseyourown", "67ac6321ad8be84bf6933c76c8e549bb", 54875),
	DT_ENTRY0("chosen", "63250f92da88b4909a65a76cdbd70776", 23866),
	DT_ENTRY0("church", "24e037d68d0597b43b5747c7d718f608", 40146),
	DT_ENTRY0("cif", "f146767064244176f8f40d03d790e6e7", 248182),
	DT_ENTRY1("circusmenagerie", "v1.03", "3814400e3abb3e6340f055d5ec883c46", 117017),
	DT_ENTRY1("circusmenagerie", "v1.05", "b5e10d082fc95bb62fc688cdb732c8f5", 1002489),
	DT_ENTRY0("cityinfear", "a6f625f184fa848ee6746e9aa6c94915", 248088),
	DT_ENTRY1("clear", "Demo", "d0d8d3a1848668de28c9534a89c4abd3", 579),
	DT_ENTRY0("cleft", "59ebfd6a539bc98347ce5c95e1a861ec", 11820),
	DT_ENTRY1("cloak", "Release 1/Demo", "be07e768b470920fe16f6aa6831d312d", 4936),
	DT_ENTRY1("clock", "Release 2/Demo", "db977ba50ce044a599b334b8a2867623", 710),
	DT_ENTRY1("clodquest", "Demo", "ac5887ce48635c45475bcaba1e2926a5", 59848),
	DT_ENTRY0("cluelessbob", "b3015b3ef35ecb99909d1e91f1b7e4cd", 35109),
	DT_ENTRY0("cobl", "09b2348c28d18b31b14da4305be38a61", 22995),
	DT_ENTRY0("colony", "3cc46c5c44e1e853c6e8aeca4f3624db", 14781),
	DT_ENTRY0("coloromcadrift", "6b8d8f115a89c99f785156a9b5802bc2", 12681),
	DT_ENTRY1("com", "Demo", "e376e159e41d8a46883d543b7f0acc90", 2221),
	DT_ENTRY1("combat", "v1/Demo", "69ce1c3cebc83b928ebc9d423cecab53", 1481),
	DT_ENTRY1("combat", "v2/Demo", "f4b54ddd2d9aa2db4c390ba772a5420d", 3422),
	DT_ENTRY0("compendiumendgame", "ad76afa2fcdb8c9e2272a115cce6bd4f", 4092),
	DT_ENTRY0("compendiumforum1", "273b73bf6262f603bee198238bc02196", 9128),
	DT_ENTRY0("compendiumforum2", "b4af4a085707f221dbabd2906e411d29", 11172),
	DT_ENTRY0("compendiumimagi", "3cfd6a4dd7ce552afdc52d0923e079cd", 9273),
	DT_ENTRY0("compendiumsaffire", "d8a0413cdb908ba2ac400fe6a880d954", 7486),
	DT_ENTRY0("compendiumtopaz", "5f91c9cd4391b6e44c2c052698d01118", 4866),
	DT_ENTRY0("consequences", "9e6b2d926f4d7beb485570bb598443aa", 542253),
	DT_ENTRY0("cowboyblues", "23eabfd5db63ded776dd0323d2abe7ea", 111835),
	DT_ENTRY0("crawlersdelight", "9da704541689f95b3636ad729cfda5f4", 18705),
	DT_ENTRY1("crimeadventure", "Release 1", "1bde8c066f6a38ac74ca67d5fa90e0c7", 3669),
	DT_ENTRY1("crimeadventure", "Release 2", "965eafa4579caa3bb8382a07b5e1771e", 15073),
	DT_ENTRY0("crimesceneadrift", "dbf0dbcb8fb2392c899aba46b690b32f", 10468),
	DT_ENTRY0("crimelife", "866b152bb8f718ad1c9437c4400d2e58", 25642),
	DT_ENTRY1("croftnon", "Non-Adult version", "0679075bcdb07776660a15e15d248270", 70722),
	DT_ENTRY1("croftnon", "Adult version", "9dedbea3ca0ff1032bea290c27a5a7ad", 148447),
	DT_ENTRY0("crookedest", "f534e863b144b1e35c592e1740a00d68", 8745),
	DT_ENTRY0("cumberbund", "f96d2e9840d7a1a1d71dfd742ce01803", 1865),
	DT_ENTRY0("cut", "0369af54c60f3d25ea2ebfe80579057b", 6102),
	DT_ENTRY1("cursed", "Competition Release", "ebfd66b37cc4f288e94825768c905e8e", 464552),
	DT_ENTRY1("cursed", "Competition Release/Hints", "56b1b8a2ade186686004d3517fbedbc9", 32536),
	DT_ENTRY1("cursed", "Hints", "4ad13bf274af97ebbfe47c4a852b3a46", 36793),
	DT_ENTRY1("cursed", "v2.00.08", "e01017d4bf6462a2aed5129e05e25e1f", 487499),
	DT_ENTRY1("cursed", "v2.01.10", "62d2e05e62f1137b25a61bbb46154729", 487990),
	DT_ENTRY0("cyber1", "b53f7a302edad4d9e2a3310dc1c66e72", 1786),
	DT_ENTRY0("cyber2", "535c161818ee238e112b1d00bd082b26", 3384),
	DT_ENTRY0("cybercow", "1ee59ffd44378be75b4b099c06e386a9", 108209),
	DT_ENTRY1("darkness", "v1.0", "6047363499d5eb666c341139d0eb532a", 24847),
	DT_ENTRY1("darkness", "v1.2", "cdf8d81b96e1778c810b28be4341918f", 25248),
	DT_ENTRY1("darkness", "v1.21", "f02a5be2f9a2fd59ef10f3d16157ee27", 25238),
	DT_ENTRY0("darktower", "6f544f097ce212ab8b33ecfa1cac0ccb", 39485),
	DT_ENTRY0("datewithdeath", "e52151688837e9c0be232b841097688a", 180314),
	DT_ENTRY0("daveshouse", "2acccf1ea2b5a3391d7f33150cd4b81f", 70579),
	DT_ENTRY0("dayattheoffice", "4771123f35431714ad489a2abc4448a9", 13802),
	DT_ENTRY1("daylifesuperhero", "Release 1", "e3d14c0caf21f2739d1f461333fed885", 165073),
	DT_ENTRY1("daylifesuperhero", "Release 2", "c69534cf0c1e373a91978438ede6ba17", 164543),
	DT_ENTRY1("daynightcycle", "Demo", "b6b2fd7e8adb3f87098f65cd656110fb", 417),
	DT_ENTRY0("daypuzzlehouse", "bf6a3d149d11160aff8f1286e05f232c", 65823),
	DT_ENTRY0("dayschool", "14d2e091f8fa7c7a5877ebdc445af4fd", 119682),
	DT_ENTRY0("daystemplate", "92cba739c4f4566b83c33f4feac362d5", 9864),
	DT_ENTRY1("dead", "Demo", "ff5ec87f8add5b4cfef50428e72a299d", 1012),
	DT_ENTRY0("deadman", "fa965f82a338db5c8ab0e101d092bcec", 16148),
	DT_ENTRY1("deathbedcash", "Demo", "6e48a69211c0c63513dba2a7f4b4b652", 580),
	DT_ENTRY0("decisions", "b79e2a2e6584f9d6fbddd8fe611bcead", 148913),
	DT_ENTRY0("deadreckoningadrift", "c49f787df29d6a73e77a0a33386614d3", 82279),
	DT_ENTRY0("deathdoor", "4df8f62198293a7ae569c7b4de77eb72", 25058),
	DT_ENTRY0("delivery", "3217f2a650d13c59f9da74a68e850c81", 7622),
	DT_ENTRY0("demonhunter", "cc9c55b0f67577f4e9bbaa388a61c494", 18643),
	DT_ENTRY0("demonhunter2", "aede840a7cfc1d82cc15d705a82d9410", 18725),
	DT_ENTRY0("dickynoodle", "1eff2af99b0b4d4fd674f01bce7fd6d0", 48044),
	DT_ENTRY1("digby", "v1", "301eab10bb6f882ff38b40ef79c1d252", 48365),
	DT_ENTRY1("digby", "v2", "770eebe936abff4de71fc6f15f7842bc", 48062),
	DT_ENTRY1("disambtest", "v1", "69c6c3a16bc0b79a8f26bc95f7227336", 441),
	DT_ENTRY1("disambtest", "v2", "0102b5e347eb57f3376df4b018d6cb71", 587),
	DT_ENTRY0("display", "beab90b4f3078113f981b4f7413f46b0", 1635),
	DT_ENTRYL0("dolg", Common::RU_RUS, "7f00a84a881593e1e61943520641dfb4", 377103),
	DT_ENTRY0("dontgoadrift", "f192abcc4e1f04787a7f1fde2ad05385", 13789),
	DT_ENTRY1("door2", "Demo", "8b2e10db0ed489b59a74618c2e2aeaa0", 434),
	DT_ENTRY1("doortest", "Demo", "f7842f2b8c90ce1217e8077cf09574ef", 805),
	DT_ENTRY1("doortoutopia", "v1", "9e727b8ad5b9c62d712d4a302083f6d8", 15432),
	DT_ENTRY1("doortoutopia", "v2", "a2a1b1fc91aa7e8557bfa29f241a8bb1", 18188),
	DT_ENTRY1("doorwithsensor", "Demo", "020977ae43897fe72bdceb164c27c741", 803),
	DT_ENTRY0("dragonsheart", "a01f55139780cc0c3d48d6ad9265ad4a", 5912),
	DT_ENTRY1("dragonsphere", "v1", "e0fd0fef272cec3d5a9045738ab18530", 22738),
	DT_ENTRY1("dragonsphere", "v2", "63e9745b9b85cd2161e6248a64bb3496", 6421),
	DT_ENTRY0("dreamland", "4eb8715f7a8f30c7e9baabae999b1148", 6508),
	DT_ENTRY0("dreamquest", "894cc0faedf186fe0f54536872bfc0ad", 26175),
	DT_ENTRY1("dressbygender", "Demo", "058f39d5f7395c402840d5cd5644882c", 529),
	DT_ENTRY0("driftingin", "7ee4b9d8cc9547b22a3fac8e34a70a03", 34637),
	DT_ENTRY0("driftmaze", "b91ff6d0d0038e9c9968ac62638a00d9", 2226),
	DT_ENTRY0("drivingatnight", "d7f914130efffd907d82914a7c1c6ee2", 7479),
	DT_ENTRY0("druggylane", "ad740fa9cca9d13d1bd3d321a8f25019", 12028),
	DT_ENTRY0("drwhovortexlust", "e2b76d720096fb6427927456fc80c5a2", 166913),
	DT_ENTRY0("duck", "d4b10dcad94ca6167139622421198380", 2498),
	DT_ENTRY0("easterpeeps", "f9f7c5179f4dbda76be638ada1dc3b1b", 21295),
	DT_ENTRY1("eatfull", "Demo", "18ba7253a21dab4c1655d8b0abbd3f36", 354),
	DT_ENTRY0("ebonysworld", "2ce6173633b5f49a08c0c2df018a13f8", 25668),
	DT_ENTRY0("edithscats", "0c6bbf3d292a427182458bd5332f2348", 18316),
	DT_ENTRYL0("elascensor", Common::ES_ESP, "30494599eb5c012b677fec49fa0766a8", 3219428),
	DT_ENTRY1("emotions", "Demo", "c634a5e84887ae043589060efd4aca43", 1044),
	DT_ENTRY0("enc1", "d297f4376e5ba5b05985ca12a60d8671", 101668),
	DT_ENTRY0("enc2", "4bd8ebd78a0a227510f62f2074e60ee5", 120335),
	DT_ENTRY0("enigmaadrift", "8cac4426368204e34bf2316d86d35353", 10627),
	DT_ENTRY0("escapecamelot", "aa00c4cd06c40e303de81208e38723c4", 240667),
	DT_ENTRY1("escapefromsouth", "Release 1", "5b2608a2b7963ce2ba117dd361c91936", 4648),
	DT_ENTRY1("escapefromsouth", "Release 2", "3a742c4bb03442749a4f89dc12e0eef1", 15407),
	DT_ENTRY1("escapetofreedom", "v1.0", "a7edcb289eb8177a143a96912ec55393", 18171),
	DT_ENTRY1("escapetofreedom", "v1.1", "41b58982572f1275831ce2a9367135f2", 18156),
	DT_ENTRY1("etnyadrift", "v1.0", "8a376d5bdf833fa79614271d05dd36a8", 59531),
	DT_ENTRY1("etnyadrift", "v1.1", "990c0e2390d197ebcae1109e5534c433", 59583),
	DT_ENTRY1("eveningwithecod", "Release 1", "736f0276c4028ccd972d391f0b30ab14", 3937),
	DT_ENTRY1("eveningwithecod", "Release 2", "bd783057274a626868b052915bad2a2c", 10870),
	DT_ENTRY1("event", "Demo", "7b9b2c949b584c838dc950454c3ee43c", 561),
	DT_ENTRY0("expsystem", "fc8043096e6594cf0ffdaa74be858552", 3615),
	DT_ENTRY0("fairscarenightmare", "975c72341afb6664df6cbecc28319596", 8121),
	DT_ENTRY1("farfromhome", "v1.0", "58d03e96c3500d6e804f8a4cafbe08a5", 14550),
	DT_ENTRY1("farfromhome", "v1.2", "b84df75a6ff647006f1f2783bde114f7", 42118),
	DT_ENTRY1("faucets", "Demo", "3f2ae204587b9dd7ae97d33c00c72022", 763),
	DT_ENTRY1("findandy1", "Release 1", "ca1aeba91f2d17dff959f73da8b48f03", 27512645),
	DT_ENTRY1("findandy1", "Release 2", "5210c86752b788c9bc512cceed3bdab7", 28236489),
	DT_ENTRY1("finedayforreaping", "v1.0", "9733d9cd4f000b409c171ecb507f1c6b", 96741),
	DT_ENTRY1("finedayforreaping", "v1.2", "3eb40409db8034e4d2d4ff77e406caba", 96819),
	DT_ENTRY0("first", "a44aac0441648f68a85e1cbaef4c5e53", 12213),
	DT_ENTRY0("firstarise", "d9d205cb6bcedbd159c826287b71a4e6", 13390),
	DT_ENTRY0("firstdayadrift", "00e1d28a1357484d3baf7a7e5de0bf9d", 13892),
	DT_ENTRY1("foresthouse", "v1", "e22e9f6dcc7870a82280dd4ca9ea87f2", 6269),
	DT_ENTRY1("foresthouse", "v2", "fc3b75ac5b5a6e13d415dd8049de99ad", 9476),
	DT_ENTRY0("fox", "1923d86c2614a35653c1a5234078f8fa", 28216),
	DT_ENTRY0("fugitive", "4e81d29f22b743c3f57b5be433b592ed", 184974),
	DT_ENTRY0("funhouse", "ae8f15c95e8589392e4824acddaa64a7", 3585),
	DT_ENTRY1("frustrated", "Release 1", "ed79b5b0e3fd477441ee8db54c292380", 50625),
	DT_ENTRY1("frustrated", "Release 2", "86dcc06a9edcd967183d5448165fd92e", 50578),
	DT_ENTRY0("fullcircle", "3de7dd74666f51ca89d37edc75ae85f3", 68233),
	DT_ENTRY0("g7056", "ad4cfe7411d00b57d432a4bdb1db3bc8", 9184),
	DT_ENTRY0("gallows", "fce80062c50c4a44b3c8681c6fd101b6", 38073),
	DT_ENTRY1("gallows", "Competition Release", "a62d1e2f2f1a639602577b78752354c4", 38117),
	DT_ENTRY0("gammagals", "db813e61ded3e7f642d437ef1e77d0b3", 277834),
	DT_ENTRY0("gateway", "b641bd132791bd847e9cc1aaa879e19f", 81139),
	DT_ENTRY0("ghoster", "23ef182c934ba46bbda93c8290d6cdd8", 8031),
	DT_ENTRY1("ghosttownadrift", "v1.00", "cfbe1e8099cdc9850aa006593bf46489", 30205598),
	DT_ENTRY1("ghosttownadrift", "v1.05", "60c11a24853dec5e6a292914c6b4f7f2", 30205645),
	DT_ENTRY0("gmylm", "f757a3642284738d51b7540c1fe24409", 29488),
	DT_ENTRY1("gmylm", "2010 Version", "67b61f16ca39d8abc9eb770385ef0e50", 15194757),
	DT_ENTRY0("go", "ea447aa7dea7164abad03517bc678367", 34724),
	DT_ENTRYL0("golddragon", Common::RU_RUS, "6b36ffed69e8389ebfb42fe1d6a367a7", 238623),
	DT_ENTRY0("goldilocksbreakent", "0800e11d1a3c54bd56fe57f21cf2b2f5", 8398),
	DT_ENTRY1("goldilocksfox", "v1.2", "12e596065ae94d3f86a67acb4de2aae7", 56539),
	DT_ENTRY1("goldilocksfox", "v1.3", "ed0d92c4d4e2c0936bf7686404f52204", 56572),
	DT_ENTRY1("golfadrift", "Demo", "bf75533058a1d9a2cab18eb9561ae92b", 752),
	DT_ENTRY1("golfball", "Demo", "7b9b9e70f50d6b230d37f6595f1f0186", 230),
	DT_ENTRY0("gosha", "11abaedb5650bcc47cbb4daed44a36f8", 5625),
	DT_ENTRY1("gps", "Demo", "5e9b07bdd5272ea6914b40d2adbca77d", 3259),
	DT_ENTRY0("grandjourney", "d38a8ba3df7e496c53238e2a0c6626a3", 85136),
	DT_ENTRY1("grappling", "Demo", "5d1749c0ec8e412c3bd3c753e543118a", 5828),
	DT_ENTRY0("great", "4cd33d4bbd04d8537f23bc5d278d2211", 108994),
	DT_ENTRY0("greek", "70a5e7abd3f76acf413bf5247f54f78f", 49664),
	DT_ENTRY0("gross", "8e05a9e3208a332fa9175a193e5262db", 7131),
	DT_ENTRY0("guess3num", "3f05bfc34575a8f4ed8b3daf1eb26cd5", 829),
	DT_ENTRY1("gumball", "Demo", "e48b9db2269bee7b0b5da07af52256da", 952),
	DT_ENTRY0("guysguys", "baaca4f89c5107be250d5894bc440601", 11162),
	DT_ENTRY1("halloweenhijinks", "Release 1", "14694f7b9cef4baeb0f958500119d2ff", 68052),
	DT_ENTRY1("halloweenhijinks", "Release 2", "d82508a70cf2a46e81042fb433ea49a5", 68060),
	DT_ENTRY0("hammurabiadrift", "1d84182e20c95959d1b9045f116cf548", 2960),
	DT_ENTRY0("hangover", "610c83cbe9d9e1353ebc444a769c85a9", 33933),
	DT_ENTRY0("hcw", "327dfec3d8f0b63ff5b05a552ee946ca", 82659),
	DT_ENTRY1("hellinahamper", "Release 1", "810247344fddc9a812bf6283b4826093", 80183),
	DT_ENTRY1("hellinahamper", "Release 2", "0af4c4b3b1bdd38db22a484c72885210", 80183),
	DT_ENTRY0("heretoday", "9d3f74bbe250156eafecf9d8b8f43cc2", 4856),
	DT_ENTRY0("heroesadrift", "26a4eb30b9497ba6dbd57e21309e1901", 5483),
	DT_ENTRY0("hhorror", "68a77ba6e6fee7ed74cbe0b737446b12", 51820),
	DT_ENTRY1("hhouse", "Release 1", "8531a2ad7b8457bab1179c9cc652e9b1", 11132),
	DT_ENTRY1("hhouse", "Release 2", "c29c27f23dd1ba32e3df8e055bbe4b7c", 42874),
	DT_ENTRY1("holdbreath", "Demo", "07846768d69e77f17e85e5f44e5cb77a", 454),
	DT_ENTRY0("hornetsnest", "4c598fd478a17a5a54228ddb1f2e44b0", 20080),
	DT_ENTRY0("hotelfuego", "4462d410e2f521cad1f971d95773b95f", 23790),
	DT_ENTRY0("houseadrift", "6b7feeb14682aceace2b7234900aab15", 144023),
	DT_ENTRY1("housedeath", "Release 1", "d610ddbdbadffb257940c6d34931a743", 18416),
	DT_ENTRY1("housedeath", "Release 2", "62f7c43f9cb942d10773cdce5fcb1ce6", 6074),
	DT_ENTRY1("houseofthedamned", "Release 1", "3b25e7d9e1fd6ff2206ab0555c19e899", 35974),
	DT_ENTRY1("houseofthedamned", "Release 2", "4f0a349840f5eaaf66922fd04a17cc52", 12089),
	DT_ENTRY0("howdidi", "f3c11c1983d8e75f389c9348da6c132b", 2619),
	DT_ENTRY0("howitstarted", "54032ee25c7119567833f937722ccf1c", 10528),
	DT_ENTRY0("human", "f5a6697f301011934bd36587c28a136f", 7392),
	DT_ENTRY0("humbug", "716cc338bfaab7574cc2618e3b104cda", 73308),
	DT_ENTRY0("hungry", "671f8460f67dfb722d349d6d3136596e", 5529),
	DT_ENTRY0("huntung", "1bebe58266fb3da3ec4edf5c895464c6", 49950),
	DT_ENTRY0("hyperbs", "f2f0e2a778efb96c7d73bb131d7147a7", 132534),
	DT_ENTRY0("hypertag", "87983ede01d5ecf02a8426dc652fe427", 37967),
	DT_ENTRY0("iachini", "977daa9b7f7ae26234c2a50845b758ef", 19083),
	DT_ENTRY0("icecream", "c16451fbd61f5dc2dd6bc29eff9e5759", 5039),
	DT_ENTRY0("igor", "45693b3ddb21b12e3026cfd0022bc5be", 3228846),
	DT_ENTRY0("igorone", "de307f99a56fc109f1bafad5a33af524", 1106051),
	DT_ENTRYL0("ilgolem", Common::IT_ITA, "7ab97545be9c30457d0c9e748ab7885f", 6372213),
	DT_ENTRY0("illegal", "a4097e0b3c63bb12ffd7ac2f0ab43faa", 202752),
	DT_ENTRY1("imaginings", "Demo", "23bedbba022acd0736ef92305432f617", 3335),
	DT_ENTRYL0("impulso", Common::ES_ESP, "c53f5ac48c9a831ce18a611301b5cb1b", 22214),
	DT_ENTRY0("infospace", "376a9471cb92c93db1ed2ff2737ce7b5", 7834),
	DT_ENTRY0("inmemory", "2d1fc2d0645ecb3bfdc6b2f1d66be5cd", 32093),
	DT_ENTRY1("input", "Colour Question Release", "7fddb4e9e902ea5b76c9426946e9eb92", 1250),
	DT_ENTRY1("input", "Age Question Release", "318ec4281d26a6090b99c443ca28c56b", 1311),
	DT_ENTRY0("insidejob", "10ba64f64ddb6ded4bf7f2975c95ad51", 20502),
	DT_ENTRY1("interrogate", "Demo", "4c72f4a6191284021188d0df95123c47", 1414),
	DT_ENTRY0("inthemind", "111ff1ff5c451c0a31b6849dc0277915", 101898),
	DT_ENTRY0("invasionshirts", "65ac612a92dbd6ea11cc026f9587aa4b", 5335),
	DT_ENTRY0("inverness", "e462cea35b007d91945dc443fdc9eee8", 45957),
	DT_ENTRY0("invert", "bd15b1b68ca064a23c9986d0b5c9a354", 1941),
	DT_ENTRY1("invisible", "Demo", "bb85a3e2d4cf8b70e197591bd5b8aa48", 340),
	DT_ENTRY1("irvinequik", "v1", "213092ee3387a2b9eecf0ca93cd7a0be", 195043),
	DT_ENTRY1("irvinequik", "v3", "a05651907f191f5f4ab9fb9ff51fd80d", 195059),
	DT_ENTRY0("isle", "cb3bc0c6ddaf702cb4fe288894563eec", 1436),
	DT_ENTRY1("jacarandajim", "Release 3", "1755731d0bb0ce234d6160ec50b2d431", 109571),
	DT_ENTRY0("jason2", "c8bcbb6eeb4dfc303bb19d85fb8cd5c4", 21091),
	DT_ENTRY0("jason3", "0e05e75dd85c60d1b675d175dfc45430", 12923),
	DT_ENTRY0("jason4", "9d4289031b6c0d86bc97867f2fc0c6b6", 267043),
	DT_ENTRY0("jasonevans", "fd842c27af8e599f1e8fd6f9c6ed6f24", 43165),
	DT_ENTRY1("jgrim", "Release 1", "f9c1b2064edeed5675a3466baeebdefd", 96713),
	DT_ENTRY1("jgrim", "Release 2", "68b8e430bcc8515d7cccbc1dc136aabe", 96720),
	DT_ENTRY0("jimpond", "eef1aed7efbd36283b7d39b1514b3933", 50551),
	DT_ENTRY1("jinx", "Demo", "2f10da81a1e1d352c3c1175c329bfd0f", 2179),
	DT_ENTRY0("justanotherdayadrift", "2831d06f1faccd5b2b459eda5188dbd6", 2886),
	DT_ENTRY1("keys", "v1.07", "2faedd1bd484d0c51657bad81d058c75", 40864),
	DT_ENTRY1("keys", "v1.08", "c4509dd642e67960085c7f9354dc9abe", 40852),
	DT_ENTRY0("labrats", "8afaeee7d46387a02fc651820e2be44b", 7250),
	DT_ENTRY1("lairofthevampire", "Release 1", "6b9cecc5a79579ebe427578ed634147a", 133685),
	DT_ENTRY1("lairofthevampire", "Release 2", "33dce0c1c3f9ed2beded0bab931e8d78", 133689),
	DT_ENTRY0("largo", "2544ee9502a97511b27fee722508bd2c", 282396),
	DT_ENTRY0("lastknight", "54ee8d64078e90969aa66992e1f0c685", 1405),
	DT_ENTRY0("legacyofaprincess", "9db58796cc772b662743e9a65ae1a876", 37003),
	DT_ENTRY0("legends", "70d80e6a8c5df484bf5e00bc1853c0a0", 66733),
	DT_ENTRYL0("lesfeux", Common::FR_FRA, "b3534d72ce3d2a5bd40d1b0d922419a4", 54162),
	DT_ENTRY0("life", "896b097fdb742cefdfa06c198e90338e", 45737),
	DT_ENTRY0("lifesimulation", "7d637eea155abec98f9a2cfd4020553f", 35886),
	DT_ENTRY0("lights", "41470ec04235f0b6fa33ac1eb1a98140", 125378),
	DT_ENTRY0("lightsgoout", "497c59d46ed00e100e51df6a458ab6e1", 16919),
	DT_ENTRY0("liqid", "036a9b14c7fc3eb4b67ef67963ac6fb2", 49095),
	DT_ENTRY1("listenformonsters", "Demo", "5a4e16620d65edca902294d79c07a801", 1376),
	DT_ENTRY1("location", "Demo", "8684c35b213e4fc06e55debb17ab0b1c", 410),
	DT_ENTRY1("lock2", "Demo", "5526da113101cd964a6d92853ba57610", 313),
	DT_ENTRY0("lockedout", "745360aa69f555882d3737b366b983b4", 22292),
	DT_ENTRY0("longjourneyhome", "c16c9e02c4a3248b25cb4f6c1ada0646", 59124),
	DT_ENTRY0("lostadrift", "904b80ebf94df890ad7c26e454b6a612", 42596),
	DT_ENTRY0("lostcoastlines", "55ca67bed8541e0343f7462605570129", 990831),
	DT_ENTRY0("lostmines", "08719eb487b62aa0072344ddabdb3ccd", 37088),
	DT_ENTRY0("losttomb", "3a6cb8ca1c9de79161a65ecb6a40fedd", 56336),
	DT_ENTRY0("loveforreal", "1d2629fe44ba4b363dd1c47a999c9dc3", 54635),
	DT_ENTRY1("magicshow", "v1.9g", "29fd03636eec8ffdaea26251a6f2444c", 104201),
	DT_ENTRY1("magicshow", "v2.0a", "14c3abea49429b35f7c9a599e61fba2a", 104422),
	DT_ENTRY0("makeshiftmagician", "022e92887a488baefc0bd868ed76f22c", 10862),
	DT_ENTRY0("mammoth", "84037b03ff0dee65e800b64d4229e325", 4290),
	DT_ENTRY1("marika", "v1.0", "9825adb22d66d16eb463f1c2674e1162", 29174),
	DT_ENTRY1("marika", "v1.1", "af69d85f6766aad3d7c3983f0d77a3c8", 29687),
	DT_ENTRY0("marmalade", "89669a0e1c82045b1a2fc0d8a2e5be5b", 15549),
	DT_ENTRY1("maroonedadrift", "Release 1", "5e3e0435c98a0a915a98d5b1b080522c", 50516),
	DT_ENTRY1("maroonedadrift", "Release 2", "6856af3da4f2821124115d16a610d20e", 12287),
	DT_ENTRY1("mattshouse", "Release 1", "0116c0272509776b59767f4619af3759", 7127),
	DT_ENTRY1("mattshouse", "Release 2", "39c67a455f68d1b01eadd9fe0563bfa0", 33429),
	DT_ENTRY0("mcl", "7cdfb44d05ae773c758fecdb88f4a1e5", 5952),
	DT_ENTRY1("meadrift", "Demo", "8b68328f70fdeb13d3d66e92915e6407", 1499),
	DT_ENTRY0("mhpquestadrift", "b3fe34b0d01f6486245eb15643417ce0", 17143),
	DT_ENTRY0("microwaveman", "45adefa528c0da90dea695ca5b4e5373", 1943),
	DT_ENTRY0("mikes", "b19a80fb6e82b571b4efbf5099df63e1", 5552),
	DT_ENTRY0("missingpersona", "751cedd28b92d205f2f2aa1d2c5d483c", 63928),
	DT_ENTRY0("ml256", "68862c0031f1497e32ce26e0654bb07f", 32397),
	DT_ENTRY0("mm2", "7a5e1ab956e5526df6a25375e3ecded0", 34133),
	DT_ENTRY0("mm3", "d212909ac670ea371756f12a243b2df9", 55878),
	DT_ENTRY0("monsterage", "00b8e89e5e7421a0ea017707466efe17", 16486),
	DT_ENTRY0("monsterisland", "8061045e6e083d940ea3c489ef4e39cf", 887821),
	DT_ENTRY0("monsters", "fde7be359d37c9229fec77244fc38a54", 17168),
	DT_ENTRY0("monstermirror", "c6dad4827bdeef9c3c7e3edea74e9cbd", 17950),
	DT_ENTRY0("morely", "9386162f8c53584a693a865bbb3ed683", 6355),
	DT_ENTRY0("morning", "4f72aa2af2d53114644694af372d1307", 26973),
	DT_ENTRY0("morpheus", "e31568ec16ba376229f117c7e9802aae", 13280),
	DT_ENTRY1("mortality", "Release 1", "f940c211a945c2c81b1f72941a2d661c", 94578),
	DT_ENTRY1("mortality", "Release 2", "1422ba317791af9084d9646c2e50ee30", 99502),
	DT_ENTRY0("mould", "f9bb352e4b174b20fdfa6813da6eedc5", 124593),
	DT_ENTRY1("movechars", "Demo", "987ac1bccd75ac2a46d8fed21b15e37d", 289),
	DT_ENTRY1("movingobjects", "Demo", "3a64cce6a686f65d81b0d8ca7d7e9069", 415),
	DT_ENTRY0("mrsmith", "64de13adc2b22380ef4fcb5817fae229", 28863),
	DT_ENTRY0("msl1", "1e9e15973eba1413864c0313fac7513a", 4791),
	DT_ENTRY0("mudergreatfalls", "f8ad4ad63c7ebcaa7b479622c4acb867", 59896),
	DT_ENTRY0("mudmonster", "5c466401d629e0ffa243ef314a7d8d3f", 2176),
	DT_ENTRY0("murders", "bcc1499cc7fac4e9ef966a32caa18359", 69489),
	DT_ENTRY0("murdererhadleft", "f95c63f90f28061a15dbe3bdf0cd4048", 13425),
	DT_ENTRY0("mustescape", "e58fd08918fa3d5a38f424f79595fb4e", 17497),
	DT_ENTRY0("mymindsmishmash", "593f536f38418fdd334a6fa50fd79d97", 68353),
	DT_ENTRY1("mynameis", "Demo", "33c9541d44a06ea25114ee67f1acc64f", 358),
	DT_ENTRY0("mysteryhouse", "9c7f8577c506737cc07d026d8318598e", 4916),
	DT_ENTRY0("mysterymanor", "4262cee0ad7ff3062aa08ac69b980625", 24879),
	DT_ENTRYL0("n3reloj", Common::ES_ESP, "0a65561670b4df68c1a47decd012cd7c", 17966),
	DT_ENTRY1("nameme", "Demo", "e0ab63271acb09c013529354ad7b6820", 413),
	DT_ENTRY0("namiki", "d70ef2d3fc256813c13604b37c2858ce", 22297),
	DT_ENTRYL0("nat01", Common::RU_RUS, "7d9f722d6b3cafbab8b6e962598243e6", 47603),
	DT_ENTRY0("neighboursfromhell", "686d8c0995aa085fb056c6a5bd402911", 13520),
	DT_ENTRY0("nem", "01040757a6078cf1b9fa2ab80cb06a10", 21424),
	DT_ENTRY0("newbie", "5d3419855684f2fe65f9e1ed638ecda5", 3644),
	DT_ENTRY1("newrooms", "Demo", "1fcdac97c2fa02a375f64104c128fbb7", 473),
	DT_ENTRY0("newton", "c847ab6a44719356f9a25c8519d397a8", 1291),
	DT_ENTRYL0("nightelmstreet", Common::RU_RUS, "5b6ea1810d1320d3262a61c9f7e6de22", 51770),
	DT_ENTRY0("nightmoon", "b7294103bcea0797d6af870a308100a8", 52330),
	DT_ENTRY0("nightthatdripped", "0a4fdf3c02c45977d83d334fdbacb8a2", 18637),
	DT_ENTRY1("nodrop", "Demo", "3a98daa4b8301672983d58dadc240fea", 355),
	DT_ENTRY0("nonsensemachine", "8bd2414033024e1f926c9d017bed2e7a", 3590),
	DT_ENTRY1("notebook", "Demo", "055cab41692d04b959d15ef717d68cef", 1861),
	DT_ENTRY0("noximion", "6702a7a1b01162578d84494a0ce34a2b", 7321),
	DT_ENTRY1("npcgroupwalk", "Demo", "e33a4e6b791390168ae3359745d13157", 334),
	DT_ENTRY0("obsession", "ac1a5d34888c978ad67800eee42c8eca", 6523),
	DT_ENTRY1("oct31", "Release 1", "7ca7980f7adf3da370464610b702e94b", 356192),
	DT_ENTRY0("officebreak", "c075f4d19abdde30bdcaec6f25e34ebc", 7770),
	DT_ENTRY0("oldmoney", "fb8fa484a86b9cd7c2e2757b7816c53f", 2346),
	DT_ENTRY1("onnafa", "Release 1", "da4c0cc6fe34a08047de54abc66de038", 167339),
	DT_ENTRY1("onnafa", "Release 2", "df5a458010cad788691f362d7bbd77b3", 168018),
	DT_ENTRY0("options", "472392dafa9ac6a52d8e0810f395530b", 302728),
	DT_ENTRY0("orcho", "82e8fd85e5ae7ba83c5614c13b84e226", 93928),
	DT_ENTRY0("orient", "c30c0319e44395c138bf548164dab197", 12651),
	DT_ENTRY0("outside", "926b3cd9a7ba18183711e7e61c3d8eb1", 53526),
	DT_ENTRY1("overtheedge", "Release 1", "3dbca4d6fb60f6e9945e383f230e205f", 14760),
	DT_ENTRY1("overtheedge", "Release 2", "80f8e3f00c0390b7b0e3e83de5e1fb1c", 14764),
	DT_ENTRY1("overtheedge", "Gargoyle Release 1", "4b2c0ff495bd9b2bb3ef46e3300fd11a", 14927),
	DT_ENTRY1("overtheedge", "Gargoyle Release 2", "2e98a67cc74e551975f0953f4c979394", 14906),
	DT_ENTRY0("paintadrift", "d2bdca626f51b216f400355318c40000", 54899),
	DT_ENTRY0("panic", "904ef60ba74852dcf17f347e2680a082", 198625),
	DT_ENTRY1("paperrack", "Demo", "c29c3672b67da01bc0e8c949e2cdc42f", 261),
	DT_ENTRY0("partytomurder", "bd2d6d3202ff772173220b9acdf613cf", 39180),
	DT_ENTRY0("passages", "524ca347d623936586c68536a3b4d0d3", 85728),
	DT_ENTRY1("pathwayadrift", "v1.2", "1ac0787c4948e540a04ccdb1f8c156f7", 20935),
	DT_ENTRY1("pathwayadrift", "v1.21", "73cc920942af7d162538ead0d118f34c", 20926),
	DT_ENTRY0("phoenixdestiny", "6a271aae0ed4f9e99e5ea9dc14b402a5", 121059),
	DT_ENTRY0("phonebooth", "25f4977d7b8df28322df945809826f43", 1372),
	DT_ENTRY0("picture", "cffa045b7364b531473d2eb69fea2931", 2257),
	DT_ENTRY1("pkgirl", "v1", "038fb1c7d80bc03a48f71ab5231ab08f", 1627482),
	DT_ENTRY1("pkgirl", "v3", "196773493b04cf42c92f6d1e85039469", 1645174),
	DT_ENTRY1("pkgirl", "v4", "c9282cf8f91ebfe5a93b136f56d7a1aa", 1645515),
	DT_ENTRY1("plagueredux", "Redux", "ed6ea0a04b135e4531636dc4e5005195", 92327),
	DT_ENTRY0("platinum", "bff449ef3d0f9bda6177903498164dbf", 149350),
	DT_ENTRY1("plunder", "Adrift Release", "837f53cd1d467a04e92f048719631a56", 17989),
	DT_ENTRY1("plunder", "Gargoyle Release", "f95124ff1253a03d71d3a8718ece299f", 17947),
	DT_ENTRY1("poker", "Demo", "579224562b53a73a8ea828ac4e962fc0", 583),
	DT_ENTRY0("praxis", "da2b19b01df82d147f214a737a641a52", 9977),
	DT_ENTRY0("professional", "0a79bee5792f05febdbac82260ee6313", 51657),
	DT_ENTRY0("professorvonwitt", "570e7d90fa42a199ee0cba44a3c95d6b", 31253),
	DT_ENTRY1("provenance", "Release 1", "9b121d31282c687fddb705f789e80132", 532153),
	DT_ENTRY1("provenance", "Release 2", "49ebc8ad4f681eb727c8a2c90c3c6dd7", 532278),
	DT_ENTRY0("ptbad65", "2a90b684c6c086b6e4d7143d70da3d4f", 3349),
	DT_ENTRY0("ptgood", "aca9cde82850a28b2da871c4d9e34edb", 1971),
	DT_ENTRY0("puzzlebox", "f0c4e68a0fe03947621eb35506bc509f", 19262),
	DT_ENTRYL0("quiatuedana", Common::FR_FRA, "d22079f4b173d33272bb5f3e97f71aae", 20034),
	DT_ENTRY0("rachelbadday", "8940ad383d78b2ba5d1fa9738bf1ea98", 98539),
	DT_ENTRY0("radioactive", "9b63538d88e6d61b6091fae55598e32d", 5155),
	DT_ENTRY0("raiders", "3ca78ce9c91df25c811103a5cec679cc", 4729),
	DT_ENTRY1("rain0", "Rain Module Sample #1", "544333041624fb4b37a11ee1ce142de0", 2703),
	DT_ENTRY1("rain0", "Rain Module Sample #2", "283eece3157e4b2548cfcc3073add18d", 3109),
	DT_ENTRY1("rain0", "Rain Module Sample #3", "e0230e42074c36b3589375c62ff504d9", 3127),
	DT_ENTRY1("rain0", "Rain Module Sample #4", "b7211c1718e62dbb4f4d5e06a4280165", 2759),
	DT_ENTRY1("random", "Demo", "e0f418cfc68a86d0a1746d00006385f2", 423),
	DT_ENTRY0("randomnumber", "b1dd0667df44632689411d22d0201dbb", 405),
	DT_ENTRY1("randomscattering", "Demo", "2773de334367b223898d9d5f39a8d859", 562),
	DT_ENTRY1("randpuzzle", "Demo", "27670c4c2e87a6c0982f3b65fbb6d8d1", 2766),
	DT_ENTRY0("razorsedge", "114c459be9cd7b642fed574f8e87840d", 3846),
	DT_ENTRY0("realtime", "c71d018130b1c5430aabb67519ca4320", 3857),
	DT_ENTRY1("rechargablelantern", "Demo", "ee00b82275ffc2936eab3c800112feac", 3026),
	DT_ENTRYL0("relife", Common::RU_RUS, "d936a059df8362d7d45d10f38d1d4332", 62524),
	DT_ENTRYL0("renuntio", Common::ES_ESP, "feb81a137ac9641008dced9ff706449f", 48764),
	DT_ENTRY0("report", "a968fc7b37ebbb150ea927e5e5d02ab7", 41801),
	DT_ENTRY0("requiem", "3cbe26d9153edaa74d000ca86f15920e", 114759),
	DT_ENTRY1("respawningmonsters", "Demo", "ec64c70c61a6a34075fbf169aba6a866", 1742),
	DT_ENTRY1("restart", "Demo", "6ac51e638473c57061d2506e8684b32d", 385),
	DT_ENTRY0("richard", "90dbf939d2548f8d61066ad77fe5af25", 55039),
	DT_ENTRY1("rking", "No Graphics", "198d2ac6056ea8f6b1acec7ce6fcdb03", 98452),
	DT_ENTRY1("rking", "With Graphics", "ef460bce1b6b692c714ff720f7884165", 183341),
	DT_ENTRY1("rndperson", "Demo", "e7ee5e9ee632bf743598e47358d375e0", 839),
	DT_ENTRY0("rockband", "f01a0ffae6fb39338ca26075bb45644c", 43719),
	DT_ENTRY1("rockyraccoon", "Release 1", "8d393c6946cff07440aff14f4410c4a5", 5532),
	DT_ENTRY1("rockyraccoon", "Release 2", "147b6ff138571c8f700c66db572e1a77", 5530),
	DT_ENTRY0("ronforest", "9cc5999e462e0d53a3d0cf45c5acac70", 8292),
	DT_ENTRYL0("ronforest", Common::DE_DEU, "d445d58bc4737003f70edc4b34cc04a6", 7972),
	DT_ENTRY0("rontoxic", "d12fd2d5fb22c16de740c7556ec5eadc", 51225),
	DT_ENTRYL0("rontoxic", Common::DE_DEU, "453daa2ec43a6dcc795a02debcd562d6", 60110),
	DT_ENTRY1("roomdescdemo", "Demo", "5ebaf1afec17a97eb42845f1af6c1aec", 592),
	DT_ENTRY0("roomentrytask", "49bb4299a979614b3bc185c4b0c5821b", 341),
	DT_ENTRY1("rtcountdown", "Demo", "41b3bf0e121d113da727542a7f888500", 440),
	DT_ENTRY1("sand", "Demo", "aec1b0b5bf5611facca3bbc93ef2f03d", 579),
	DT_ENTRY0("sbft", "e5610b103dc25449d4232c745ac8dd81", 143564),
	DT_ENTRY1("sceneofthecrime", "Release 1", "6ebd76c3586165c13707855bd337bf83", 228446),
	DT_ENTRY1("sceneofthecrime", "Release 2", "af077e5463b69778ac0d076eb50a574f", 67886),
	DT_ENTRY1("sceneofthecrime", "Release 3", "a8a094b145523c622e65ab6897727f2d", 68054),
	DT_ENTRY0("score", "f97e463fe05c17e4fc59606ea7884f1a", 24186),
	DT_ENTRY0("screensavers", "cc11d1576475aa78366c4c8416f67e3e", 80870),
	DT_ENTRY1("seatdemo", "Demo", "f3aad262fdef15ca48ae80f80a1b79e1", 706),
	DT_ENTRY0("secondchance", "3a3c30b7ab715a6dab7114a5cfb89cd2", 139093),
	DT_ENTRY0("secretoflostworld", "fcadd63ccfa96b38a20f2a850c6ed21b", 49842),
	DT_ENTRY0("seekandenjoyr", "069596f2641e03f6bfcaf3bf8181eaf4", 9573160),
	DT_ENTRY1("selmaswill", "Release 1", "23b7fb4bf976135b8be2740e1fbfb83b", 19559),
	DT_ENTRY1("selmaswill", "Release 2", "28f22f3762597793a376d3cdcd6ba2d6", 19599),
	DT_ENTRY0("sentor", "ddca204b605c37fc1cb5e74c1cb49dbe", 9787),
	DT_ENTRY1("sere", "With Music", "e60363aad3c8dc5890ca85b95955b2d4", 2724371),
	DT_ENTRY1("sere", "No Music/Release 1", "ddbdaccee5a532ea9a8e25753a8e14e8", 25956),
	DT_ENTRY1("sere", "No Music/Release 2", "aa3360b0f6dc69daf56d3c00534ecb33", 11086),
	DT_ENTRY1("seriespasswords", "Game #1", "bc2073a2cfcfd368b86ce387b6e3f531", 1508),
	DT_ENTRY1("seriespasswords", "Game #2", "5584f5db8593ff2b6573a49fbd7748ac", 1527),
	DT_ENTRY0("severance", "7674507e99bda35cd9df46c5fd2de82f", 1864),
	DT_ENTRY0("seymoursstoopidquest", "61f4e155b958c1c652f12ed4216ee10d", 12623),
	DT_ENTRYL0("shablon", Common::RU_RUS, "bcb2a259e96ed2717ba7e6ce56d51750", 21271),
	DT_ENTRY1("shadowpeak", "Release 1", "79a637f5b7de7e4cbdbf853d5834ab41", 92285),
	DT_ENTRY1("shadowpeak", "Release 2", "39cdda2d8b303d0b4d292f4983af4591", 92859),
	DT_ENTRY1("shadowpeak", "Release 3", "63cb42d7928336dacd0025a6bced32dc", 96190),
	DT_ENTRY0("shadrick1", "33036e2b4c11a36d28e6532051e9f05b", 7456),
	DT_ENTRY0("shadrick2", "6c39ed75d19b60ee7b806edb97725d43", 113424),
	DT_ENTRY0("shanilor", "57516c5b8ebb6d9217c71ffc4491bf8a", 6133),
	DT_ENTRY0("shetland", "9b194a340f1f1123b1c4b8eb0f1c38e2", 9485),
	DT_ENTRY0("shredem", "d2daab124408fb67deeada21dc356840", 1212),
	DT_ENTRY0("shuffling", "ec258e7584d43d4a43d8d03fcacccf11", 4419),
	DT_ENTRY0("sierramadre", "2e2fd88d193aa2d2b6a46933c4f766e4", 4094),
	DT_ENTRY0("sigurd", "c7f6cf278cfff76afd3f8a0c99623522", 53838),
	DT_ENTRY0("silknoil", "f3bf16d9004a2b0ada39918ebd07aff5", 71345),
	DT_ENTRY0("sk8sponsorz", "ed33436d13bf7897636ab4f69ead2441", 8047),
	DT_ENTRY0("sleaze", "6674fe9167b4be0db99ba0c746342bcc", 29811),
	DT_ENTRY0("smercenary", "5978a46dcf84e25897832813650d09e8", 51458),
	DT_ENTRY1("sniperscope", "Demo", "680cfcb04a541890fe029a2b34007d78", 1726),
	DT_ENTRY0("sommeril", "cf74b9be4772079380c0589309e399ba", 29092),
	DT_ENTRY1("sommeril", "Special Edition", "1870db33af741482bb5d93ab54200e7c", 22839),
	DT_ENTRY1("sophie", "v1", "60d7c8034c96c935ab4c6595655da3d1", 536662),
	DT_ENTRY1("sophie", "v2", "7436328561d2ab8686649adfbe1edb17", 536710),
	DT_ENTRY0("sorcereradrift", "aea6313f54cd9a56ac90f8a425db6245", 6456),
	DT_ENTRY0("spaceboy2", "62f9b0e0840ee70cc311108d24cd7c83", 12712),
	DT_ENTRY0("spacerun", "c00956d8a2ce1bb46c14c8d2f718793c", 19501),
	DT_ENTRY0("spawnmonstershop", "cc2477d8ee67b6d850bb0586d89b743e", 1827),
	DT_ENTRY1("speaking", "Demo", "216a55fdb8ae20c05382f84bbb6e487a", 1011),
	DT_ENTRY0("spirit", "1ea2a26f248cd3f1235167c952e55a4d", 37670),
	DT_ENTRY0("spooked", "ea200097ef6603bc8ee54fd4b7128edb", 9909),
	DT_ENTRY0("spooked2", "8255dca87623d0641828b3aaa9be2a08", 17320),
	DT_ENTRY0("spotbother", "ffc3b255381b0315ee2210a309706508", 113076),
	DT_ENTRY0("stalker", "8130b5b37d050d6fcbdf1af5c56c39d0", 7934),
	DT_ENTRY1("standingdemo", "Demo", "87918bb50bc4dea047b443fd8d90a94a", 564),
	DT_ENTRY1("stardust", "Release 1", "caa5cdc48e4f23bad3a6893b5fd2b2a4", 35343),
	DT_ENTRY1("stardust", "Release 2", "0d0a2aa60004be9b02b1a212b3cd582e", 42463),
	DT_ENTRY0("station", "efdac6169c91e2b70fa1b63f0abdb237", 10823),
	DT_ENTRY0("stodw4", "bb6e78687fae941c7755e9d00c5d91b9", 26532),
	DT_ENTRY1("stopfollowing", "Demo", "cb2721d383c930a8cc298772d65bf7f2", 499),
	DT_ENTRY1("storetest", "Demo", "1615e89ef2e5b4edd90ddc2aabff74cb", 1010),
	DT_ENTRY0("stowaway", "6877c3079978ecf74e72b792005fca32", 14231),
	DT_ENTRY0("strange", "e298be9c1b55c9866c7355ecbac74534", 8912),
	DT_ENTRY0("sunempire", "667cb96684f2cf3367c86aa70638cd77", 24355),
	DT_ENTRY0("superliam", "835df44f633a5526656c6cfbbbabd72b", 28799),
	DT_ENTRY0("suzygotherpowers", "f2d47df24e1d2a71c60a58831bc9b9fa", 40676),
	DT_ENTRY1("sword", "Demo", "8ee854268fe8d0f1db821b6a33d1f4e3", 640),
	DT_ENTRY1("swordincane", "Demo", "5fae53e155140692405dce9833450d20", 447),
	DT_ENTRY0("talking", "20cb9b81381a297c19e25a98d41921fb", 2804),
	DT_ENTRY1("target", "v1.00", "c6bbbae5ea3f6407a55435cb4e0c20c3", 43024),
	DT_ENTRY1("target", "v1.02", "47202ea8385188b3045c91bb55a72561", 43014),
	DT_ENTRY0("tearsoftoughman", "da92145aebc1d511cb12ff7c433b0438", 9437),
	DT_ENTRY1("teleport", "Demo", "86152d768f524777d0d091f97bd4a04e", 519),
	DT_ENTRY0("tempest7", "04a7d73ca191374cb112833ff5d705bf", 31369),
	DT_ENTRY0("templeofthesun", "8a18a97d0f46659d0436d891e7e0c8af", 18973),
	DT_ENTRY1("temporfell", "Demo", "927bfa7b6c75489d39be1c40bfd256a7", 70045),
	DT_ENTRY1("testingstatus", "Demo", "202dbce394a3cfacf309a47d536e67ac", 221),
	DT_ENTRY0("texevil", "1cc1157f409a435847074342adbef27f", 20652),
	DT_ENTRY0("theannihilationofthink3", "d277ea444f279f6f6fe25c4686c14bfd", 11401),
	DT_ENTRY1("thedarkriver", "Release 1", "bde0f0f135bcf33212c9d19d7ea2f645", 3547),
	DT_ENTRY1("thedarkriver", "Release 2", "63788f315bc11fe476eb2f53b5c57258", 4158),
	DT_ENTRY1("theclockadrift", "Demo", "90ba998e679618644ae747d798f6a832", 881),
	DT_ENTRY0("thecrash", "6fcf1713c0b5bb8472f842f1805daf7a", 4509),
	DT_ENTRY0("thehole", "9d7449170ff3d6d8139a641d47e307ca", 5198),
	DT_ENTRY1("thehouse", "Joe Powell Release", "ab48826ab779b1d261e2afa0b5a9aebd", 14568),
	DT_ENTRY0("thelabexperiment", "6218d1a6ba705799bb863e9136a139c2", 3009),
	DT_ENTRY0("thelabyrinth", "a984fbc7d9a6d592315f17406981b04d", 19468),
	DT_ENTRY0("thelabyrinthsystem", "e6ceb574b2499d0629da789d53ab5d60", 38100),
	DT_ENTRY0("thelasthour", "786d39eb223a64fe836f87b032b60ae1", 10658),
	DT_ENTRY1("thesisters", "Release 1", "cd5aec78ac5cd64b7444768faecd10fc", 46788),
	DT_ENTRY1("thesisters", "Release 2", "3f4d015651477767377390e237ee7621", 46836),
	DT_ENTRY1("thesorcerer", "Remake", "189e4135879d163cb2f4c55890d5bc08", 22316),
	DT_ENTRY0("thesuccessor", "4c588168479f101a574610609ce192d6", 32966),
	DT_ENTRY0("thetest", "61a6f178f646c6158c0557ae4257b20d", 22465),
	DT_ENTRY0("thevirtualhuman", "b894e19638a65e03d28b696a761d23a3", 6168),
	DT_ENTRY0("thewill", "289f8ee71bfefe6469913cf8058bde0f", 132602),
	DT_ENTRY1("tickettonowhere", "v1.1", "8c549a6bdc6a5a4895412516be8dce25", 65502),
	DT_ENTRY1("tickettonowhere", "v1.2/Release 1", "123aa5225a1060bd3b12bca07ac95e18", 65725),
	DT_ENTRY1("tickettonowhere", "v1.2/Release 2", "b969b13cd0fe0d499f9c4d414e4abd79", 65526),
	DT_ENTRY0("tictactoe", "cc48b5fa6ccc64dd0fbe164a85bd44fc", 1790391),
	DT_ENTRY0("time", "7f878438548731d90591aaee6154a59c", 3436),
	DT_ENTRY0("timeadventure", "34c978820d4bdd7d612be1c2257898dc", 12353),
	DT_ENTRY0("timemachineadrift", "c564fdef87a7cdc7a56bd123b9faacde", 10540),
	DT_ENTRY0("timething", "9241e0716aad5aed40e739abc1925639", 338),
	DT_ENTRY0("tmm", "b4730e7fc98802ade0ae85b104588016", 2573),
	DT_ENTRY1("tmn", "Intro", "70f502d2f8a605909afa855e28440f05", 10801),
	DT_ENTRY0("togetyou", "cb0203f31bde1acf05312015363105d6", 4527),
	DT_ENTRY0("tohell", "43eb5899b3301dfc60fdd1c84a9e46a7", 18080),
	DT_ENTRY0("tomdickharry", "4be1f57ca11511034f32a0ea2c54fa86", 1318),
	DT_ENTRY1("toolkit", "Dice Module", "e76c34e0ed932b944a5545addf20041b", 819),
	DT_ENTRY1("toolkit", "Calculator Module", "17db8c8cf86332ba19badeceb8ce622f", 1818),
	DT_ENTRY1("toolkit", "Game Module", "bf74230b1f7839e0a93954e5b7529644", 3365),
	DT_ENTRY0("topaz", "0777a97e473b41ae04ab825556748e8d", 5980),
	DT_ENTRY0("tophat", "4303ad8ce8d338ac3598d64940a2d546", 12959),
	DT_ENTRY0("toronto", "9371f62ed34f3eb382b0b97b5f9a676f", 9420),
	DT_ENTRY0("townofazra", "f89eb8b96ff1810c5d8430a1b521ad51", 44145),
	DT_ENTRY1("tq3", "Chris Moody Release", "8dff23d59f9dc9560ae3c82b53d2adb6", 22573),
	DT_ENTRY0("trabula", "b091d28e0c4fed988ae053415e8190aa", 2224),
	DT_ENTRY1("trackingdevice2", "Demo", "a330535c4b5024a3ad49b48a8011c533", 441),
	DT_ENTRY1("tree", "Demo", "d9310c133da963b1162579b70cd7d49d", 3778),
	DT_ENTRY0("trickortreat", "060156357075cedaca65904ebacdad70", 66556),
	DT_ENTRY0("trolladrift", "5a9d7d4fea2f12bc010acadeff9dee01", 68742),
	DT_ENTRY1("trouserpress", "Demo", "a28dfdee50b5af4b9c26a1d0f3c4ad8c", 508),
	DT_ENTRY0("twentyone", "a08597706f81b58c331940c1aa7be126", 92778),
	DT_ENTRY1("twilight", "Release 1", "ab5ddd461c1fb2065d26fcfdf4baa5aa", 71377),
	DT_ENTRY1("twilight", "Release 2", "9824de022e7959fb9f974f01964b772c", 71621),
	DT_ENTRY1("txfbeg", "Release 1", "e874a0b37474d84d9349a08c285afc6a", 101727),
	DT_ENTRY1("txfbeg", "Release 2", "5e7a485ffa177482669986350680285e", 35739),
	DT_ENTRY1("unauthorizedtermination", "v1.00", "c28bf76f5c9873c0944db39b0c3faadd", 107316),
	DT_ENTRY1("unauthorizedtermination", "v1.01", "a7bba6890fe2945bb192c67e395516ac", 107335),
	DT_ENTRY1("unravelinggod", "v1.0", "e93e057e5f6790ebdd90bb940efa0300", 44382),
	DT_ENTRY1("unravelinggod", "v1.1", "2d43577a756ddc6b561f447e67270ac4", 45000),
	DT_ENTRY1("untitled1", "Demo", "0b3eadc3f32d95e335ed9d409b36b089", 1086),
	DT_ENTRY1("untitled2", "Demo", "12bf1cfe67acce801a3ff1e6ce4e3b54", 1620),
	DT_ENTRY0("upgirls", "cbb2a224b019220bf4a22415a2acf5a9", 3538),
	DT_ENTRY0("urbandragon", "26a6abb965fe12ee2837b9f1a0d2fa47", 30158),
	DT_ENTRY0("vagabond", "954858806b66da9cf80bd701c01ec168", 4762),
	DT_ENTRY0("vague", "0f5ef8616c668b9c3de078a77b26a512", 122681),
	DT_ENTRY0("vampireconscience", "1da43163193776d43f4e2a2918b1551b", 63183),
	DT_ENTRY0("vandk", "ec6de9a7062f0445bb09a2c9caf63d6d", 23938),
	DT_ENTRY0("vendetta", "1d84bb4a60e7c559774133f6aff48bbb", 104909),
	DT_ENTRY1("veteranknowledge", "Release 1", "409d3d59cb767dc8b812e16db78b2e47", 52248),
	DT_ENTRY1("veteranknowledge", "Release 2", "c2b2b3d07b399f7ef1daf7453de8d704", 197649),
	DT_ENTRY1("veteranknowledge", "Release 3", "1a1c58aef367f40c8539e74bd3c990ff", 52290),
	DT_ENTRY0("videotapedecay", "469463ccacba1b7db3a0f95f3c895b1e", 9423),
	DT_ENTRY0("viewhome", "ac6d123e7133c8fb2dd9f60474bd9d61", 9237),
	DT_ENTRY0("viewisbetter", "9334adc4ccd03ceb1684ee56fdb07ab9", 7720),
	DT_ENTRY0("volant", "ed8e93c25a77e4f331799dc4647e1e54", 64718),
	DT_ENTRY1("warlord", "v1", "78e822290745dd8b42590da7436c8b04", 199403),
	DT_ENTRY1("warlord", "v2", "5694fe2acc420bf276e22c48e9ef7003", 217096),
	DT_ENTRY0("waspconnection", "df289810b7dded4aa3f0a6df7f0414fa", 2310),
	DT_ENTRY0("wasteland", "2587f2f2a72cc0d4bb43b09f66ada361", 5383),
	DT_ENTRY1("waxworx", "Release 1", "97e5e0c7206a062f8892ba91fa721f59", 37541),
	DT_ENTRY1("waxworx", "Release 2", "a10a1e404ae77fd968b4427a13bd7034", 38414),
	DT_ENTRY1("weathertime", "Demo", "e812b3135627bc2af4ff0b28a85ef939", 2144),
	DT_ENTRY0("weirdstuff", "bbc31a2675b31a800277e1e6f4a5797d", 27589),
	DT_ENTRY1("whatever", "Release 1","3e0f5ca9f0acff5ac8c4f60f0c60e712", 110051),
	DT_ENTRY1("whatever", "Release 2","c7cf9bf6eba661ee4d089b648ac5d307", 110122),
	DT_ENTRY0("wheel", "6c7993a9339530081da521235f715957", 44666),
	DT_ENTRY0("whereami", "6d8c799069d790b38b20f029ba21c119", 3470),
	DT_ENTRY0("whitesingularity", "9fe8537aecaf47059e6d2e4073fed06c", 788034),
	DT_ENTRY1("without", "Release 1", "2310f8d0ae20b048e28ea703a4819097", 117307),
	DT_ENTRY1("without", "Release 2", "e660b79c7fde567ff7515e70654fa9f7", 117288),
	DT_ENTRY0("wizardplayground", "c75d4ccce821284710dd757abe86b78a", 18585),
	DT_ENTRY0("wonderlandadrift", "845497c0a1617f724382e4f85f14dedd", 7381),
	DT_ENTRY0("woodsaredark", "4acae86746292076b90fa6fa73ea76d0", 71216),
	DT_ENTRY0("woof", "b27d426413d982ed0325765a87916bb8", 1712),
	DT_ENTRY1("workingtrackingdevice", "Demo", "22866fbcae738e66d212ccd91069089a", 895),
	DT_ENTRY0("world", "155da95d704d262db3de6afd95d90023", 23152),
	DT_ENTRY0("worstgame", "8789e209419529ac22d2be4774620c78", 9858),
	DT_ENTRY0("wreckage", "6d02b43c6f14ff851c5b006746ff89d3", 4486),
	DT_ENTRY0("wrecked", "b1c6c4ef73025fbbe99b612a72e3186a", 88550),
	DT_ENTRY0("wrecked", "b1c6c4ef73025fbbe99b612a72e3186a", 88550),
	DT_ENTRY0("wumpusrun", "464c1b782ef3dd4fe0623cfe819ac04e", 858951),
	DT_ENTRY1("xycanthus", "Release 1", "5637cb8221087c5cca094b13138655c3", 116769),
	DT_ENTRY1("xycanthus", "Release 2", "5637cb8221087c5cca094b13138655c3", 116322),
	DT_ENTRY1("yadfa", "Release 1", "5ee5906fc4b889d126cdfd83bd883a43", 77880),
	DT_ENTRY1("yadfa", "Release 2", "d64d8bde594d6b5d306d2dbcc2e0d7d6", 77658),
	DT_ENTRY1("yeh", "BoyBiz Release", "ca9ec86147f95d5498e9a111f15f6865", 22322),
	DT_ENTRY1("yonastoundingcastle", "v1", "f157eaf4c75d6f8499fa188ae7059cb0", 2326484),
	DT_ENTRY1("yonastoundingcastle", "v2", "baf2c0423903a3104f67d3a19bde43df", 2320881),
	DT_ENTRYL0("zanoza", Common::RU_RUS, "773eb8198e9f138215f82421f6ba0bf5", 91722),
	DT_ENTRY0("zombiesadrift", "5282bb5e768658946d37ebc5b380f461", 5098),
	DT_ENTRY1("zombiewalk", "Demo", "634b892a9ae2ccb944278a40903cd7fd", 583),
	DT_ENTRY0("zomelec", "a1aad86dbdaf90688e36a5b0abdbbf35", 15320),

#ifndef RELEASE_BUILD
	// Unsupported English ADRIFT 4 games
	DT_ENTRY0("ambassador", "d19a12c2c8c2eff7b3e8da5f3594163a", 29708),
	DT_ENTRY0("bethere", "2fd4326a88602c00e6215e167f9b9311", 36384),
	DT_ENTRY0("beythilda", "527c5afe73b34f297d3d6dcfe7039aab", 18349),
	DT_ENTRY0("bloodrelatives", "d9384fe44f98113e5df8fdb4aba1d2a2", 81356),
	DT_ENTRY1("bookbuilding", "Demo", "84386cfe7bee273b289d6e3b69aae114", 15628),
	DT_ENTRY0("canyouguess", "0b305b9014dc44066ec95a816b4fdf4b", 16254),
	DT_ENTRY0("canyoustandup", "b02aa7d160a6d1e3e86ce4f3027dd89e", 13425),
	DT_ENTRY0("cccs2808", "d779608ca4dd3aab27bac53e7f671b23", 20086),
	DT_ENTRY1("charloop", "Demo", "e2523c216117855c3ea5b68eb4ad0829", 16824),
	DT_ENTRY0("combilip", "3ecc566574e9c1f551e6885c6ef94bbd", 46524),
	DT_ENTRY1("dragondiamond", "Release 1", "5ced50484c4bc3806702084c589e3ea1", 41670),
	DT_ENTRY1("dragondiamond", "Release 2", "4c92c4f0c578c9d6d309d3169ae8e5b6", 54783),
	DT_ENTRY0("dreamspun", "490ff0065ff10268fd53ecd50082b94d", 29140),
	DT_ENTRY0("ecod3d", "b727a3df5a8cc75ce98899d01c479b9e", 19904),
	DT_ENTRY1("elevator", "Demo", "16c2c030091cd02f1dc4babd85e49933", 78306),
	DT_ENTRY0("escapehouse2", "d62bd657046d87cc15eb285dc87d3046", 18244),
	DT_ENTRY1("expendableitems", "Demo", "02ef3452a42b66ae6e86b402bc8837c4", 16429),
	DT_ENTRY1("hintsl", "Demo", "1084481cfdb745b72497def3f42d4e7b", 58005),
	DT_ENTRY1("inyourhome", "Demo", "0040d880903b8a7fe6795e8680a7bbbf", 18280),
	DT_ENTRY0("isummon", "9bdc97bb90db1bcd6cfdbfcb26bb59ce", 58467),
	DT_ENTRY0("lastexpedition", "4c65d3cf06d24134268e1d8015d722b9", 68762),
	DT_ENTRY0("layers", "aea348f66c8f2e2fba08d7a15451f33f", 17787),
	DT_ENTRY1("loopthrough", "Demo", "44d20d05134108ab5143aab2a13f8fd6", 24056),
	DT_ENTRY0("nastyescape", "24b95325d0602ad7178926a0e0125892", 18008),
	DT_ENTRY0("nycholiday", "616722d93cff001d234a6e2c2c284b73", 19514),
	DT_ENTRY0("os", "dbdf2e91125a057eab5fa044023c28e3", 22244),
	DT_ENTRY0("projectactually", "178324d32fb2bf27e2c14bf84190e9a5", 25559),
	DT_ENTRY0("readinginmayadrift", "ba8a12e79520234e31622f141c99cafd", 13434),
	DT_ENTRY0("savethekitten", "3ce730972fc402d46c46b38546599c5f", 19957),
	DT_ENTRY0("schoolproject", "01aca4dc431d0661adcdef1f1b87bf2b", 19822),
	DT_ENTRY1("skybreak", "v1.0", "5d2f34b91ff26546e7b1da18914d649c", 1132198),
	DT_ENTRY1("skybreak", "v1.1", "a5322754939d41aaf46c69c0a1100df8", 1191014),
	DT_ENTRY1("skybreak", "v1.2", "321ef94722e2ce0a5caebd55aee19c3b", 1390449),
	DT_ENTRY1("skybreak", "v1.4", "4e652cfbd76f164d5a90840d39d48b85", 1655947),
	DT_ENTRY0("snowdrift", "27409a216a03756bb13ca0984922e219", 25254),
	DT_ENTRY0("solitaryadrift", "38259fa302905d70ec345d6ed6495747", 15178),
	DT_ENTRY1("sophia", "Release 1", "85e8f7306ca02dabe0a083828981c31a", 531015),
	DT_ENTRY1("sophia", "Release 2", "53ff34729255845adad73eb8d133ef7c", 1242046),
	DT_ENTRY1("television", "Demo", "ad3db06d606092c734eb4f74953b9bb7", 9704),
	DT_ENTRY0("tempusfugit", "20e6c61ef3a98f4be78faebd15bb434e", 52386),
	DT_ENTRY0("theawakeners", "9323fdd3734fff99fa49469b3e04d933", 17117),
	DT_ENTRY1("thedayprogram", "v0.1", "a2bceb91de7de4751056522d3cfd43a6", 18120),
	DT_ENTRY1("thedayprogram", "v1.0", "c07e41d0cb219089af4bf846d8bc2eab", 24664),
	DT_ENTRY0("tra", "675a2d9b7428e2c19a50d2fd03393b76", 275724),
	DT_ENTRY0("wumpushunt", "48cfecc5c37bcb766c2657a8b0c98f71", 20608),

	// Unsupported English ADRIFT 5 games
	DT_ENTRY0("4rooms", "db1616914cd81115ab9eed737384b7b1", 27928),
	DT_ENTRY0("advbackyard", "73b1171283ffa2b3cf6fb72a0ec31a35", 48990),
	DT_ENTRY1("aliendiver", "v13", "7a746245878dc3a5edafcc851562aa3a", 77266),
	DT_ENTRY1("aliendiver", "v15", "6fdb9210b4c42d2d496a63bd04ee14e2", 87904),
	DT_ENTRY0("allthroughthenight", "89dcb84d74f70945780ed9e719401301", 36345976),
	DT_ENTRY0("anno1700", "ec665dafae59aced3bade7c5b64e1e2e", 865004),
	DT_ENTRY1("anno1700", "Competition Release", "b45b7f7bdb90745c53d5df06ddcfeea2", 880810),
	DT_ENTRY1("axeofkolt", "Release 1", "e2cb7f32478a69b647bc90e0de158ac9", 901650),
	DT_ENTRY1("axeofkolt", "Release 2", "c9555483f6706d60bd6b8ea18f7b92ae", 906106),
	DT_ENTRY0("beagle", "004db9d8bd9aca27d72387913b79eb5c", 25352),
	DT_ENTRY0("beginnerscave", "44e32fc05411bfa1468e93e1e6e325ee", 30358),
	DT_ENTRY0("birthofphoenix", "de798149fc307dbcfb5ccf173f95f24a", 23532),
	DT_ENTRY0("darkhour", "75bc2ac4d561ad2a2143bd90a19d1b46", 35184),
	DT_ENTRY1("ddf", "Release 1", "58e46de405a7d6b7cc9c924416c8318c", 240970),
	DT_ENTRY1("ddf", "Release 2", "4c41ebaa7578c72ca38f50fd756c6660", 242106),
	DT_ENTRY0("deadwinter", "331789f8590a39c811ea4b5f1b1f5a96", 86702),
	DT_ENTRY1("dementophobia", "Demo", "3f283f808ac6b9baa92e95e9edf83529", 6696738),
	DT_ENTRY0("difficultpuzzle", "5d94dd2adfccce9b8bcee9581f7bdfff", 59466),
	DT_ENTRY0("digitalroots", "b30ec06838f688fc98b899c28f0b7025", 727156),
	DT_ENTRY1("dff", "v1", "42991208d92645d9ddd07dd8be82d1dc", 565482),
	DT_ENTRY1("dff", "v6", "8e107f2a3de2686ebac22e2c9b3752cc", 521536),
	DT_ENTRY1("fortress", "Release 1", "d540bc6077de03e6d98aa99a26fca4e4", 1409426),
	DT_ENTRY1("fortress", "Release 2", "45a24ff9ce0f22fb606b1ad0d56250b2", 1332618),
	DT_ENTRY0("grandma", "cb06f302e135cc907df429660cf11e22", 132016),
	DT_ENTRY1("grandma", "Frankendrift Version", "cf1cf12c32b8adef27bfab78354304d8", 133460),
	DT_ENTRY1("grandma", "Online Version", "a348dce214ebd982b290c9acbf7eb86c", 132210),
	DT_ENTRY1("grandma", "Source Version", "62a10746a7d547422e8034b6d6e8e006", 106461),
	DT_ENTRY1("grandpa", "Release 1", "999e88229f0cfb59cce87de0e8af6f59", 9372808),
	DT_ENTRY1("grandpa", "Release 2", "a213dabff7f75307ffad0a053c119746", 9372916),
	DT_ENTRY1("grandpa", "Online Version", "ce027321ed2d8ecd28a17e7dfea89ac8", 9374112),
	DT_ENTRY1("grandpa", "Source Version", "816f17ff20bbd973641f17c22162c94e", 64633),
	DT_ENTRYL0("halloween", Common::DA_DNK, "ed3155a2581428dc72506297dc4cc49e", 67476),
	DT_ENTRY0("heritage", "01f8f81bf56bfdc81acd0ecc83671599", 27906),
	DT_ENTRY1("illumina", "Release 1", "185fff329dec70801e4b7957b4513808", 198446),
	DT_ENTRY1("illumina", "Release 2", "c96b0810cc672f053d2ff3f42b4ebce0", 195958),
	DT_ENTRYL0("illumina", Common::DA_DNK, "2a79f187f6c67b2160ae8baf8d6e4742", 202576),
	DT_ENTRY1("jabberwocky", "Release 1", "f2b9a4ed9f19bffb735bbe7c4c25751a", 48674),
	DT_ENTRY1("jabberwocky", "Release 2", "aaa98f426d20c156d427faf95424becb", 48574),
	DT_ENTRY1("jaft", "Release 1", "0c754a07c00d9701b36f68703f1a58bd", 2018252),
	DT_ENTRY1("jaft", "Release 2", "ca12aa24867b9eb43aab1ad972dec202", 2018188),
	DT_ENTRY0("labyrinthadrift", "be233d835a3f821e757b122539544bbf", 298592),
	DT_ENTRY0("lazaitch", "055df9090ae88991a66a8be045534e65", 298502),
	DT_ENTRY1("lmk", "Release 1", "6b5ade214129491afcebc0e280eb22da", 10600962),
	DT_ENTRY1("lmk", "Release 2", "c46e80c58bf0e343c1d0b8fb6be90f40", 10601042),
	DT_ENTRY1("lmk", "Release 3", "a2907b5e4c64937222282fc564d9f7d3", 10600484),
	DT_ENTRY1("magneticmoon", "Release 1", "b6305fd896beeb933045e121b3261c4b", 492690),
	DT_ENTRY1("magneticmoon", "Release 2", "b435f18684dce693fd64b10ae0df0021", 492630),
	DT_ENTRY1("museumheist", "Release 1", "3c10249b9d1580ec63ac63ddddb5342d", 2709918),
	DT_ENTRY1("museumheist", "Release 2", "c3ea7b30f4ad6736d1f344a95b3343c2", 2711656),
	DT_ENTRY0("noblecrook1", "334c706261ab79b783403ad3315980fd", 23966),
	DT_ENTRY0("noblecrook2", "9d460ed691ad1b45d5d7c19f1ebf61d9", 22446),
	DT_ENTRY0("noblecrook3", "c9d4a1ba7d5c1625f2d4cad0f067275a", 22088),
	DT_ENTRY0("noblecrook4", "cb26241f8dba982bb0cd357ebd8fac45", 20606),
	DT_ENTRY1("oct31", "Release 2", "a1da95b23480fe69e7a2975a570326b4", 356130),
	DT_ENTRY1("oct31", "Release 3", "9d74f378405b783d8ca041be70dc25b7", 356434),
	DT_ENTRYL0("oct31", Common::DA_DNK, "7f0637944bc69e2bff843e76689b645b", 194758),
	DT_ENTRY0("penrhyn", "114335d0be1efac51fba6030fd00ebf2", 2765872),
	DT_ENTRY1("rbr", "v1", "88d7babfbc6122dc70e2673dabe93a47", 335894),
	DT_ENTRY1("rbr", "v2", "c095893f61c9f1d8e1d047e148eb4894", 319278),
	DT_ENTRY1("royalpuzzle", "v1", "5ecced3471bbc0cff671238707d1e980", 41780),
	DT_ENTRY1("royalpuzzle", "v3", "fe9be5e874d51dd8dd7bb272f8d99ed7", 41708),
	DT_ENTRY0("rtc", "58729d1f54ca2311d7ff584f223c6396", 149000),
	DT_ENTRY1("rsp", "Release 1", "ce9d950582fc63a90599e158498a9691", 244356),
	DT_ENTRY1("rsp", "Release 2", "4c7a5b57bff1cce91d2bfc63a6e0f18e", 244810),
	DT_ENTRY1("rtcc", "Release 1", "c79ed07084f08890c2ec4912c353ed34", 300308),
	DT_ENTRY1("rtcc", "Release 2", "0e4ed541ed65b7ea207b31a50c471c28", 333916),
	DT_ENTRY0("salvage", "2493cfdd477d64dcd6fef8b9e9a603cb", 1302300),
	DT_ENTRY0("sixsilverbullets", "e0f6170b5cbde7005609e68d8a25ddd3", 376934),
	DT_ENTRY0("soc", "16b43395e647605562c04e5e8954d907", 474850),
	DT_ENTRY1("socc", "Release 1", "7fd4574ae646b8e052eb6513a1e7ece5", 513520),
	DT_ENTRY1("socc", "Release 2", "3cbcffb47f0a81ac15201276d9f83d2a", 576250),
	DT_ENTRY0("sonofcamelot", "7b3e9e45edc75202b3f586d0ca8dddde", 474380),
	DT_ENTRY0("sorryforyourloss", "3b061665f0d67150681c539229b56f2d", 41566),
	DT_ENTRY0("spaceboy", "b9c350309385706eb7ae30e2e52e1096", 22605),
	DT_ENTRY0("spacedetective1", "170517dae3a195f37d876f5645637953", 34044),
	DT_ENTRY0("spacedetective2", "1e12b19d8777173cbf9866b3dd2fc2f0", 32632),
	DT_ENTRY0("spacedetective3", "fc9fb75830d7f59bf932896152b1e759", 30560),
	DT_ENTRY0("spacedetective4", "86fbcf204c6b0982ef2394a60bb8df3e", 32184),
	DT_ENTRY0("spacedetective5", "f1bf863cce436a5ef17e64237803571a", 32676),
	DT_ENTRY0("spacedetective6", "6035c865f7a4831e4539b7a2ff2ab711", 31922),
	DT_ENTRY0("spacedetective7", "2044086edd9b2288ff2279b3824dfcef", 30066),
	DT_ENTRY1("starshipquest", "Release 1", "424984a2c89d4b404d180cf274d539a3", 454822),
	DT_ENTRY1("starshipquest", "Release 2", "02fb2460c61c8d82c31fa1d763e63a7e", 449736),
	DT_ENTRY1("stoneofwisdom", "v1", "f414f8b8aa9bfaf3256a1d2b6c887921", 80444),
	DT_ENTRY1("stoneofwisdom", "v4", "c9014e44b756c2e795179eacddb83805", 93416),
	DT_ENTRY0("symphonica", "62e3685e0e28a8bd1030fc66adb12041", 13685722),
	DT_ENTRY0("tcom1", "61364f96ffdfd01e878f1a33557aff93", 37422),
	DT_ENTRY0("tcom2", "b22abbff746998051e06bfa9a8083432", 67783),
	DT_ENTRY1("tcots", "Release 1", "04f8330b06466a5eb96cd3ed6a914224", 231358),
	DT_ENTRY1("tcots", "Release 2", "06a4402f1757b17e4c04b923c177d449", 312596),
	DT_ENTRY1("tee", "Release 1", "4f94cf6cfbbd0e141a14ad3c47341226", 359362),
	DT_ENTRY1("tee", "Release 2", "402bf552411f5da434c97e6ccf06e3de", 359550),
	DT_ENTRY0("temperamentum", "c23c52ca0c2652edf94f3c6ea24c48f5", 17986940),
	DT_ENTRY0("thegardenparty", "e5149c4915f17ac97174f6afa46110b4", 64572),
	DT_ENTRY1("thewayhome", "Release 1", "98293a7c5fcd4754b90cf53f1c6242ae", 69660),
	DT_ENTRY1("thewayhome", "Release 2", "7331c940d269a8186789c6f4216674ba", 83478),
	DT_ENTRY0("tingalan", "08c9ecd86664b62335d3852a2bb3d201", 259969026),
	DT_ENTRY0("tlc", "38480cff2f832d413812cb3d30310542", 299704),
	DT_ENTRY0("treasurehunt", "f3c35c9b3f4051897d7c891e8e33e779", 25371192),
	DT_ENTRY1("tributereturntocos", "Release 1", "6132158b3cbc58cf38f2290c11b6768e", 99728),
	DT_ENTRY1("tributereturntocos", "Release 2", "2a5327a3ef791c7b9c8ac3d8c03e1925", 99780),
	DT_ENTRY0("ttp", "059940072c256539fb4ae20340ce6cc2", 72902),
	DT_ENTRY0("wwiiee", "f16636dee08e361339c724ac6d9b2611", 102152),

	// P/o Prune's Mini Comp 2021
	DT_ENTRY1("prmcdifficultpuzzle", "Competition Release", "315033c146b17ea767ef6d76529065d6", 54700),
	DT_ENTRY1("prmcillumina", "Competition Release", "3db679c32f240f7dcda0cefe1bd2e7a0", 44262),
	DT_ENTRY0("prmcquestgiver", "98758b4ba735cf1503a32ad5fad95cce", 1555684),
	DT_ENTRY1("prmcthegardenparty", "Competition Release", "7176bb8c7b174166ae1c22c6411c6a93", 51770),
#endif

	// ADRIFT 5 Intro Comp 2012
	DT_ENTRY1("a5icblankwall", "Intro", "7b2490ab9015632eb546185c936b53d0", 44799),
	DT_ENTRY0("a5icorganic", "7d3cce3b62f3d7773c8a567e45d5fada", 22738),
	DT_ENTRY1("a5icshatteredmemory", "Intro", "f37a962adfe504a4e1ff3badd4e26745", 33266),
	DT_ENTRY1("a5ictrappedadrift", "Intro", "d80b609f3d25caa6e66fbb887bb387a1", 14495),
	DT_ENTRY0("a5icheadcase", "81cdf1d83cd6f88aafb8ac4d77585fb7", 45980),
	DT_ENTRY1("a5icaxeofkolt", "Intro", "85bfd8637e8758c36ffd0659448f8087", 71534),

	// ADRIFT Hourglass Comp 2006
	DT_ENTRY0("ahc3minutes", "0313370bb74005525ec96580f146d286", 13232),
	DT_ENTRY1("ahcovertheedge", "Competition Release", "d3fcc9f5fd301731610e0b3cd8c9ddd1", 8128),
	DT_ENTRY0("ahcboiledeggs", "b4cb135ba16c5177c58c7a3f146437e8", 6423),
	DT_ENTRY0("ahclongbarrow", "b74d914a61421dbc322f3dbc7656eb97", 6211),
	DT_ENTRY0("ahcpilfers", "fad35bf79453844ef82f0a9b11d5d6e2", 3727),
	DT_ENTRY1("ahcchooseyourown", "Competition Release 1", "fb9c940b6997e9fe961db910cd7e882c", 10332),
	DT_ENTRY0("ahcskydiver", "57f0c54ab6e8c87904ebfde9d255d6f9", 7631),
	DT_ENTRY0("ahcquestforfood", "0618e06900fd5f15b3b18594d98a8090", 4534),
	DT_ENTRY0("ahcdancing", "eee9f9d60bc1f642fae83f59117a8780", 4578),
	DT_ENTRY0("ahcrollingdough", "f36ab00d8f64b55569ddd2227f20c6e3", 3919),
	DT_ENTRY0("ahcsmote", "ef386edce4af4e55152596759cbc8e8c", 1987),
	DT_ENTRY0("ahcroadnowhere", "4bdc52566f67189ea1239e73c8734435", 7903),
	DT_ENTRY0("ahcherrdoktor", "7c71715d076ce00cf39043b1c60d3bd4", 4422),

	// ADRIFT Intro Comp 2005
	DT_ENTRY0("aicmurdermansion", "07367e1f546f80e64b44923f474f5906", 6793),
	DT_ENTRY0("aicoutline", "b86de4feca73e0ea49c324a2181b8b8f", 5724),
	DT_ENTRY0("aicsrs", "f1243c19976246c2c319fba5be6f9d13", 157833),
	DT_ENTRY1("aicescape", "Competition Release 1", "c5a13fa9059ebc2904eea95e1c6b790a", 3964),
	DT_ENTRY0("aicfinalquestion", "1f1ede210336b6b8bd8e28eda2d00e0c", 15555),
	DT_ENTRY0("aicrift", "b4dc3233be12767837bd596789379473", 2606),
	DT_ENTRY0("aicp2p", "3b3386f5f0f844c3a9eb47ba2596135a", 6491),
	DT_ENTRY0("aiczacksmackfoot", "a8d2d303c6e5f698d40714c3d5e241e2", 6374),

	// ADRIFT Intro Comp 2009
	DT_ENTRY1("aicexistence", "Intro", "041e134a39146830a389d8dc62206563", 6370),
	DT_ENTRY1("aicapokalupsis", "Intro", "c3e90bfb8cea957cebbf306add17cd3e", 19822),
	DT_ENTRY1("aicdbaa", "Competition Release", "e827961c66e95bbc2a0d4645f63f6ec4", 37521),
	DT_ENTRY1("aicteaw", "Intro", "132d0803e31d70729194a292be93be64", 1235834),
	DT_ENTRY1("aicmerlinbirdofprey", "Intro", "2e64695a67e1b4ffc0fc379d3f5a4e4d", 3842),
	DT_ENTRY1("aicdeadrace", "Intro", "b62ec01f511e761d65ab637de7dda0f2", 5311),
	DT_ENTRY1("aicdishduty", "Intro", "263db72fe0be3fb494aa2566fd7e38b5", 5753),
	DT_ENTRY1("aicyoncastle", "Intro", "6dd95cdc736ffab10a08e39cd9069356", 9814),
	DT_ENTRY1("aicthroughtime", "Intro", "181706abbfc03745d1ddc9b788638b9a", 42109),
	DT_ENTRY1("aicdonuts", "Intro", "55d52c6cd6a42dcb424ff3888e7aa88b", 5201),

	// ADRIFT Mini-Competition Summer 2003
	DT_ENTRY0("amcthorn", "0d02030e9ac6563cda759a20ae1fc06b", 13887),
	DT_ENTRY1("amcneighbours", "Competition Release", "afdf85651706a4568762565b2c24aa8d", 13333),
	DT_ENTRY1("amcmonsters", "Competition Release", "02a042f7277dfc9789bd6ffee1e8db08", 9628),
	DT_ENTRY0("amcdiarystrip", "0e04238a2b49220c284ce9c8723abd77", 43334),

	// ADRIFT One-Hour Game Competition 1
	DT_ENTRY0("1hgprincess1", "d745a3f2c4dc40fb10f25d1539a2a1e7", 7181),
	DT_ENTRY0("1hg1hrgame", "63e9594bf2b4e7cf5bf75dd9cc1353dc", 2978),
	DT_ENTRY0("1hgendgame", "6036e5654786f841ca59f8f7e95276be", 4063),
	DT_ENTRY0("1hgchicken", "40f0f52f2eeb029516bca3e01e6ceac0", 5249),
	DT_ENTRY0("1hghauntedhouse", "cff22c2f2af619ac56e075e95385e600", 6541),
	DT_ENTRY0("1hgfrog", "3a8f3a0a6b4efd4787e6d338e4b31cea", 2089),
	DT_ENTRY0("1hgmicrobewillie", "14fe6ac0db4943fc9951610f5d0e0428", 3538),
	DT_ENTRY0("1hgjasonvssalm", "70d60774dc777918645d7f3359f534cf", 2947),
	DT_ENTRY0("1hgamonkeytoomany", "c9d719261d0f760f95685899aa80bbf5", 5016),

	// ADRIFT One-Hour Game Competition 2
	DT_ENTRY0("1hgpercy", "e995d3a23005914eb92836f141ebe1c4", 5965),
	DT_ENTRY0("1hgforum", "4df8a13d8823aca26207fb459e98dd8b", 9005),
	DT_ENTRY0("1hgdfu", "e70e0bdfd9ffa0f20c2bc682eeb2f1ab", 16443),

	// ADRIFT One-Hour Game Competition 3
	DT_ENTRY0("1hgforum2", "5a534ac4e39a319022d145094c46930a", 11185),
	DT_ENTRY1("1hgcrm", "Competition Release", "d97d1ff8f01a61fb477b76df65c77795", 15432),
	DT_ENTRY1("1hgasdfa", "Competition Release", "fccb2fb890d554263d5f55bc02220ab8", 6440),
	DT_ENTRY1("1hgdemonhunter", "Competition Release", "ca37aaf35fb15a40a7f5f8caa1475112", 4169),
	DT_ENTRY0("1hgcbn1", "9e27ab68a1f37f5f7591b362c4888526", 7577),
	DT_ENTRY0("1hgcbn2", "983eacedabebf7bbd8fed72ed399bba4", 6137),
	DT_ENTRY0("1hgticktick", "5b952d75e3e46a71334419c78dc6ff51", 2055),
	DT_ENTRY0("1hgpyramid", "a198f4ca146fed3094bf5fd70d2eefdd", 1953),
	DT_ENTRY0("1hgquesti", "c7d6058e8172ff5d4a974fe159aa9cb7", 2544),
	DT_ENTRY0("1hgshore", "ef0b6074e47f55b7dff868e5dbd0c0cf", 4354),
	DT_ENTRY0("1hgsaffire", "d3eb89cf10d11a42df2df8f7bdb1505a", 7489),
	DT_ENTRY0("1hgecod2", "ff55438090db248964fd8944f3a2da9f", 17584),
	DT_ENTRY0("1hgimagination", "91923aeec3b7a8c55a15bc6dd240f7fb", 3257),

	// ADRIFT One-Hour Game Competition 4
	DT_ENTRY0("1hgcah", "1945c5584b775b22c9b329915629eb44", 9808),
	DT_ENTRY0("1hgarghsgreatescape", "0de27ef52495de415637d78e393c612f", 3608),
	DT_ENTRY1("1hgshreddem", "Competition Release", "426885b0a8a9aade134307fad1693512", 1209),
	DT_ENTRY1("1hgagent4f", "Competition Release", "407cc79b128aefdae4fdabb4d7a661e4", 3703),
	DT_ENTRY0("1hgecod3", "bd783057274a626868b052915bad2a2c", 10870),
	DT_ENTRY1("1hgtrabula", "Competition Release", "54fd39f8d86b4e1726970073342057da", 2224),
	DT_ENTRY1("1hgwoof", "Competition Release", "f66cbdcf9f7c6a3b30b0c7ca95bdea46", 1712),
	DT_ENTRY0("1hgundefined", "cf5172b53c8e3ef3a8739a31b78cccc2", 2920),
	DT_ENTRY1("1hgadriftmaze", "Competition Release", "017d681d45402c2d75ae70c28d2b467f", 2224),
	DT_ENTRY1("1hgicecream", "Competition Release", "f68b7ec0959459cd1ee3c741660010c6", 5039),
	DT_ENTRY0("1hgwreckage", "822b988245ff40c6f490edc046921fcf", 4487),
	DT_ENTRY0("1hgspam", "2ffc74d57936add0cdc06d83924f0f15", 2807),
	DT_ENTRY1("1hgvagabond", "Competition Release", "ae8545f6506fe3a49e27c96721196dce", 4762),
	DT_ENTRY0("1hgthecatinthetree", "f67640c2ed3b621272ebbea06a5fd467", 6174),
	DT_ENTRY0("1hgtopaz", "7d4beb159bf3876f761bbac911395d05", 4839),
	DT_ENTRY0("1hggoblinhunt", "5e36c63feebf77cfba30757042a9fafa", 10891),

	// Ectocomp 2007
	DT_ENTRY1("ectcvideotapedecay", "Competition Release", "658e9dbe38364219b6a530332f2ed183", 10173),
	DT_ENTRY1("ectcforesthouse", "Competition Release", "423fede762b0bfc1cb1547edce5d4aed", 8965),
	DT_ENTRY0("ectcstowie", "73322467bf8e29c9ea7745a095c9091e", 3785),
	DT_ENTRY0("ectcwitness", "fce8f16deac176ee958cdcf0c5964df6", 3849),

	// Ectocomp 2008
	DT_ENTRY0("ectcforesthouse3", "a4992f8debcd083c3d5489e2243d6929", 13492),
	DT_ENTRY0("ectcdrinks", "855589bf11df411d6943bcdd0718ef4b", 8458),
	DT_ENTRY0("ectchiker", "55b1ebfd0d37dc855fe4180cf45de0c4", 4401),
	DT_ENTRY0("ectcsalutations", "c7d16f4fa626346256e08a0ac6617b4d", 5591),
	DT_ENTRY0("ectcblast", "ff101cb5b9a29701e1c9b0e8e42dfb85", 3447),
	DT_ENTRY0("ectcr2dc", "647af322abede732259866d91dd5ad4c", 8861),
	DT_ENTRY0("ectcdelsol", "ab2a1d114782f8bc2b4da5d1b56f8de7", 6552),

	// Ectocomp 2009
	DT_ENTRY1("ectcdrivingatnight", "Competition Release", "a66f03afba88b6ece716201319bda621", 7505),
	DT_ENTRY0("ectcpatient7", "a9417623fdeb4370f25f7849968bdeb3", 15502),
	DT_ENTRY0("ectcwayout", "75c96f7fdf26104992db0a5b754637f1", 4598),

	// Ectocomp 2010
	DT_ENTRY0("ectcpetespunkin", "98dbc751d01eb51b0a3fda3562c6960d", 8512),
	DT_ENTRY0("ectcrenegadebrainwave", "6ba674cb8f8c531d66c9b22c446bea2d", 8346),
	DT_ENTRY0("ectchelsing", "9c06145372e7128bc8ce9ca6f2ef97da", 9776),
	DT_ENTRY0("ectciwasteenage", "d5890b294eb82890e3fdfa979cd8aa7b", 6521),
	DT_ENTRY0("ectcthevault", "8cd76c2b9278f37b98666317a823c44d", 4258),
	DT_ENTRY0("ectcflyhuman", "06e4371bf939531f0bb91dcaaa08c88a", 4743),
	DT_ENTRY0("ectcallhallows", "941fb55e949f3272a089ea69a6ddba8d", 6707),
	DT_ENTRY0("ectctenebraesemper", "f0db9c56ba0c50fad1b1baaedf156771", 9757),

	// Ectocomp 2011
	DT_ENTRY0("ectcattacklobster", "e4fdf252cfa05e672ffaeb806e9d6c0c", 7186),
	DT_ENTRY0("ectcdeathshack", "b7073278da4b3980b7ccc01a4f865f82", 17858),
	DT_ENTRY0("ectcignisfatuus", "0414d55fc3984c158804575044809c48", 20575),
	DT_ENTRY0("ectcthehouse", "338d24e1cabc2c398927599dc89dd986", 21925),
	DT_ENTRY0("ectcstuckpiggy", "bf6d5cd1b5a3865ff610110459d3104f", 18506),

	// Game of the Year Competition: December 2004
	DT_ENTRY1("goyshardsofmemory", "Competition Release 1", "7e9cb5002fa22a25000b3478c826413d", 118610),
	DT_ENTRY1("goypaint", "Competition Release", "1183921d034d3614ec277e18d9112b69", 76493),
	DT_ENTRY0("goydragonshrine", "604250027cfd8cfd1fb0d231085e40e5", 636932),
	DT_ENTRY0("goydarkness", "6047363499d5eb666c341139d0eb532a", 24847),
	DT_ENTRY1("goywaxworx", "Competition Release 1", "94aaf6625541238867b079bfe475f146", 38471),

	// Game of the Year Competition 2007
	DT_ENTRY1("goymarika", "Competition Release", "d7694ac50de852126fadc7cc73dffd76", 29625),
	DT_ENTRY1("goyrking", "Competition Release", "2c9ede2cb9a50f7274bed28c9d9bc5f7", 186477),
	DT_ENTRY1("goyvideotapedecay", "Competition Release", "658e9dbe38364219b6a530332f2ed183", 10173),
	DT_ENTRY0("goyterrified", "38697e087d267c4ea0d6c607ce463847", 10488),
	DT_ENTRY1("goyfinedayforreaping", "Competition Release", "ff47d5fa749d52e18c1d488b83d1d45e", 96834),
	DT_ENTRY1("goypuzzlebox", "Competition Release", "0adbb7f9a7c37819e1a695468001acaa", 19540),

	// InsideADRIFT Spring Competition 2004
	DT_ENTRY1("iadcshardsofmemory", "Competition Release 2", "9b75834354aed4b148d4ec2b8cdd66ae", 118604),
	DT_ENTRY0("iadcdragonshrine", "604250027cfd8cfd1fb0d231085e40e5", 636932),
	DT_ENTRY1("iadcwaxworx", "Competition Release 2", "4fa14c7944506f4e0142cb865738d0b0", 37542),
	DT_ENTRY1("iadcsommeril", "Competition Release", "9e8ee4cbd4ecab3ab51c702f4e0277e1", 400940),

	// InsideADRIFT Summer Competition 2004
	DT_ENTRY1("iadcchooseyourown", "Competition Release 2", "774ae5ba4fea61da0898069df4ed1c81", 54869),
	DT_ENTRY0("iadcdarkhavenmystery", "1027e9e3dba08e0fd2796e0e934be855", 27826),
	DT_ENTRY0("iadcshadricksunderground", "a9e1e59b37976c6c0fcc6aee69978afe", 113385),
	DT_ENTRY1("iadctickettonowhere", "Competition Release", "a69b0fa1b33d8e0ab6504d37615e6a3c", 65083),
	DT_ENTRY1("iadctearsofatoughman", "Competition Release", "b440d0b4b18a93537803750f31e838b7", 9436),
	DT_ENTRY0("iadctheadriftproject", "18a4db8af27fd98751504ee3e45089e3", 231594),

	// InsideADRIFT Spring Competition 2005
	DT_ENTRY0("iadcseaside", "271c64455f4abb3dee35c3902e5cdfc1", 279480),
	DT_ENTRY1("iadcfrustrated", "Competition Release", "1c218d4fcbbfa11271fb4d0003df7a6a", 210267),
	DT_ENTRY0("iadchub", "c3224b3d6c55997056ea195ba4ebb60a", 24610),
	DT_ENTRY0("iadcprivateeye", "3076b9f11acf2b1e377a31cd1a11c323", 236323),
	DT_ENTRY1("iadcblood", "Competition Release", "775404faa0d7973c1df537bd423a45d3", 100201),

	// InsideADRIFT Summer Competition 2005
	DT_ENTRY0("iadccibass", "7c2e95feb2e2debbbb0c343c1a920f6f", 21705),
	DT_ENTRY1("iadcmustescape", "Competition Release 2", "3de7c345c6f1dc26712b4ce6fa365830", 17472),
	DT_ENTRY1("iadclca", "Competition Release", "cebe4af96402a18915f15205e52c7415", 124774),
	DT_ENTRY0("iadcregrets", "5b1a5763226b0f489e1d0760be59ccf4", 10448),
	DT_ENTRY1("iadctarget", "Competition Release", "ea12656119b5522156539dd1da23866b", 42999),

	// InsideADRIFT Summer Competition 2006
	DT_ENTRY0("iadcpestilence", "2d5ff3fe2d866150689749087d5cee3d", 29021),
	DT_ENTRY0("iadcreluctantvampire", "619d031556cdff0805e599d6a82caa1d", 199575),
	DT_ENTRY1("iadcspooked", "Competition Release", "642ff47378f398ca97e9238dddea3914", 9908),

	// InsideAdrift Summer Competition 2008
	DT_ENTRY0("iadcdoor", "696b2c0579a2c66afc5be808e54e4847", 6363),
	DT_ENTRY0("iadcwolvesatthedoor", "2341592c42f93f12033f8a309fc11386", 19126),
	DT_ENTRY0("iadchappyvalley", "375b217ae661e4ce192b0ea3756a01b6", 24938),
	DT_ENTRY0("iadcmarlin", "15627cddf3b2a30393397d4faf2f6df8", 13192),
	DT_ENTRY1("iadchuntung", "Competition Release", "e3fe91ea00f762fbc78f5297e240f59f", 42578),

	// InsideADRIFT Summer Competition 2010
	DT_ENTRY0("iadcaegis", "8726e90b50bdc92967f944a582daff2c", 45755),
	DT_ENTRY0("iadcbaroo", "d6919d2e21beafb46c5b4712703bea73", 46299),
	DT_ENTRY1("iadccamelot", "Competition Release", "ad0856d169448c6a43d2f2441aa13780", 53528),
	DT_ENTRY0("iadclightup", "2805a4f680c1b8343b940e3c89fc867b", 28347),
	DT_ENTRY0("iadcmotion", "25382d94db738588da78078cc34f83cc", 11579),
	DT_ENTRY1("iadcplunder", "Competition Release", "e4f28c23cb4faf4387a8859eb8221f59", 16696),

	// No Name Competition
	DT_ENTRY0("noncpiecesofeden", "378dce8e7d36433a188cb0f2d69f2570", 5741),
	DT_ENTRY0("noncbeanstalk", "fc9c17c355894948dc2e72c66e8d9963", 9837),
	DT_ENTRY0("noncperfectspy", "4248dee44c099804ee2932b7b8cbea9d", 7988),

	// P⁄o Prune's Finish the Game Comp 2005
	DT_ENTRY0("ftgcshadowjack", "25f33d23e126ea0a86ed55833dbba8ef", 11606),
	DT_ENTRY0("ftgctakeone", "114caad9308b7adf9e15267a11f12632", 9547),
	DT_ENTRY1("ftgcdemonhunter", "Competition Release", "2af5b32810e6960881122732f48d3ccf", 18644),
	DT_ENTRY1("ftgcpathwayadrift", "Competition Release", "bcf1f61393c1b8123a98ee4879ffd8a6", 20896),
	DT_ENTRY0("ftgcshadow", "f4d0a427ebec3a4c3b7029adaa3e401f", 272030),
	DT_ENTRY0("ftgchunter", "d7af67a0753910bf32ec233e538ad659", 23531),

	// P/o Prune's Spring Ting 2009
	DT_ENTRY0("prsthomelesslarry", "1508b4cb0cd4be5d7d8365abe4660c36", 21880),
	DT_ENTRY0("prstmrfluffy", "c04ffec6475a2ac3d79290613edeecd6", 14541),
	DT_ENTRY0("prstreactor", "a5a0005b4c6668dfe27e1658f85d0713", 11380),
	DT_ENTRY0("prstsandy", "a6953f57c4632dc9847ef5dfe494283a", 1286),

	// P⁄o Prune's Spring Ting 2010
	DT_ENTRY0("prstwghn", "ae6a590cf043c14b10e9567d6f6661f3", 3559268),
	DT_ENTRY0("prstegghunt", "ade16e3ac57d32a6be3c95438a651683", 7575026),

	// P/o Prune's Twin Competition
	DT_ENTRY0("prtcmelancholy", "355aa8cbe66388627edb4cf2742cb22c", 43845),
	DT_ENTRY0("prtccrashland", "3626601b910e0beb7be717eb5381e6bf", 8106),

	// Poodle's One Room Competition
	DT_ENTRY1("porcdeadman", "Competition Release", "480da7306b482ac2df44527931523ccc", 14092),
	DT_ENTRY1("porcdreamland", "Competition Release", "684cd1932e909105b7898953792c4065", 2422),
	DT_ENTRY0("porceverything", "44a5b102675bcbc48c04c269301d0cd3", 20065),
	DT_ENTRY0("porciadrift", "4e7e5beab23931f6f574c13cbde8c535", 5164),
	DT_ENTRY0("porcinsanity", "c57c140cc9331a60695a3f90fba8fb9a", 12660),
	DT_ENTRY0("porcmsmobius", "81cfc7e042294e71c60a264a2fbb3f2d", 23225),
	DT_ENTRY1("porcdayattheoffice", "Competition Release", "2d908b5448c6fd2dbc98a7f9d2dda9df", 13824),
	DT_ENTRY0("porctrappedwithagirl", "61e1c14dddef8d3b6804c47b2072d9c4", 17235),

	// The 'Anyone in the mood for a comp?' Comp
	DT_ENTRY0("tamcalgernon", "7dcf06245873bb65bf56bfca08086ff0", 31280),
	DT_ENTRY1("tamcbeagle", "Competition Release", "6d5235a68aba891442a9da5ffb4f96a3", 25368),

	// The Challenge
	DT_ENTRY0("tchgmangiasour", "699e454caf6b2134acdfa8284b84721c", 28676),
	DT_ENTRY0("tchgsuburban", "2bb9e69e373d35e6426185473decb5d0", 2427725),
	DT_ENTRY0("tchgwhitterscap", "0456c1308fe97af89ccb097cc97b0f10", 7604),

	// The Even Competition
	DT_ENTRY0("tevcattackamutaydid", "23c47fd2ff2a06e05e7ae7ba028ce090", 513587),
	DT_ENTRY0("tevcrain", "9f19f6c2637867be0bfce484b2daee8f", 10512),
	DT_ENTRY0("tevcperspectives", "c1fdcd8c811a892186c7d7ca6e070f44", 8043),

	// The Odd Competition
	DT_ENTRY0("todcasteroidaftermath", "d555b913fd85319b745a83efeb9a0601", 5792),
	DT_ENTRY1("todcbusinessasusual", "Competition Release", "cbde699c47f946ef3936b8866affc5a7", 7234),
	DT_ENTRY0("todcgorxungula", "b04e511c4a47adbf7b2d6392ed6d5f70", 6777),
	DT_ENTRY0("todciamlaw", "9835c286df225e0357ae99a47775a78b", 30185),
	DT_ENTRY0("todcmaincourse", "f9c5a5041de7b2fc74f007339deb93de", 7389),
	DT_ENTRY1("todchuman", "Competition Release", "eff595bd11066585b41275e92b461f11", 7427),
	DT_ENTRY0("todcreturnforesthouse", "47a4a95da7babb06066825d048d20056", 8019),
	DT_ENTRY0("todcseance", "619599e36090917ea6ef4d02cd62c484", 10934),
	DT_ENTRY0("todcwitchtale", "2c69ada0c304413364739e98f3e8e8c1", 15252),
	DT_ENTRY0("todcyakshaving", "3cfab2021cb4711229bdc380b6a19058", 9716),

	// The Writing Challenges Comp
	DT_ENTRY0("twccmanoverboard", "c14ac9285a265451aec669d76ca5d4d1", 14141),
	DT_ENTRY0("twccglumfiddle", "f4ea370e93b2fad4d873f82332b113cb", 23074),
	DT_ENTRY0("twccjgrim", "0df0ded3147cd8bfd59787ab57ba00d7", 42994),
	DT_ENTRY0("twcctoomuchexercise", "aebb58d94f632c4232bee72b9a1b5e25", 6248),

	// Three Hour Games Competition: July 2004
	DT_ENTRY0("3hgjailbreakbob", "c2e909cf2ddda863d2eb613c8273ee37", 31064),
	DT_ENTRY0("3hgbriefcase", "f1c899773faf027d9cbb50078a6667c3", 10872),
	DT_ENTRY0("3hgtheannihilationofthink", "22743eceafe94bf60ab5a3e43241883e", 6303),
	DT_ENTRY0("3hgshadricktravels", "33036e2b4c11a36d28e6532051e9f05b", 7456),
	DT_ENTRY0("3hglostsouls", "3083e21a3bd6766ea5fdf3166e8bd4d8", 16695),
	DT_ENTRY0("3hgtheamulet", "7c08e1f03763ad757dc39f5df37a28b7", 5585),
	DT_ENTRY0("3hgzombiecow", "f0fe890f9679b158f9a22ed9f78179e6", 5193),

	// Three Hour Games Competition: November 2004
	DT_ENTRY0("3hgsandl", "73a1e0b4451690e76d306136ec30754b", 27995),
	DT_ENTRY1("3hgconfession", "Competition Release", "718faa6f6e72fcd4b95ebcb1601be7bd", 203757),
	DT_ENTRY0("3hgveteran", "65d5fc95b59f24e0e4997f62bf592ba3", 12043),
	DT_ENTRY0("3hgburiedalive", "9e9a71babf3012461205dc7aa2cd2a3f", 11808),
	DT_ENTRY1("3hgzac", "Competition Release", "85d95b8a6a962222d15724d42740f378", 13692),
	DT_ENTRY0("3hgtogetyou", "388b5596945067ed3b92e6282e670825", 4496),

	DT_END_MARKER
};

} // End of namespace Adrift
} // End of namespace Glk
