/* ScummVM - Graphic Adventure Engine
*
* ScummVM is the legal property of its developers, whose names
* are too numerous to list here. Please refer to the COPYRIGHT
* file distributed with this source distribution.
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*
*/

#ifndef SUPERNOVA_IMAGEID_H
#define SUPERNOVA_IMAGEID_H

namespace Supernova {

enum ImageId {
	// file 0
	kAxacussanShipBackground,
	kAxacussanShipCenterMouthOpen,
	kAxacussanShipRightMouthOpen,
	// file 1
	kNewspaper1,
	// file 2
	kNewspaper2,
	// file 3
	kElevatorBackground,
	kElevatorGreenButton,
	kElevatorRedButton,
	kElevatorDoorAnimation1,
	kElevatorDoorAnimation2,
	kElevatorDoorAnimation3,
	kElevatorDoorAnimation4,
	kElevatorDoorAnimation5,
	kElevatorDummy1,
	kElevatorDummy2,
	kElevatorDummy3,
	kElevatorDummy4,
	// file 4
	kShipSpaceBackground,
	kShipSpaceRope,
	kShipSpaceDummy1,
	kShipSpaceDummy2,
	// file 5
	kBusStationBackground,
	kBusStationArrived,
	kBusStationPlantAnimation1,
	kBusStationPlantAnimation2,
	kBusStationPlantAnimation3,
	kBusStationPlantAnimation4,
	kBusStationPlantAnimation5,
	kBusStationPlantAnimation6,
	kBusStationPlantAnimation7,
	kBusStationDoorOpened,
	// file 6
	kOfficesBackground,
	kOfficesDoorOpenTopLeft,
	kOfficesDoorOpenBottomLeft,
	kOfficesDoorOpenTopRight,
	kOfficesDoorOpenBottomRight,
	kOfficesAlienCorridorAnimation1,
	kOfficesAlienCorridorAnimation2,
	kOfficesAlienCorridorAnimation3,
	kOfficesAlienCorridorAnimation4,
	kOfficesAlienCorridorAnimation5,
	kOfficesAlienCorridorAnimation6,
	kOfficesAlienTopOfficeAnimation1,
	kOfficesAlienTopOfficeAnimation2,
	kOfficesAlienTopOfficeAnimation3,
	kOfficesAlienTopOfficeAnimation4,
	kOfficesAlienTopOfficeAnimation5,
	kOfficesAlienBottomOfficeAnimation1,
	kOfficesAlienBottomOfficeAnimation2,
	kOfficesAlienBottomOfficeAnimation3,
	kOfficesAlienBottomOfficeAnimation4,
	kOfficesAlienBottomOfficeAnimation5,
	kOfficesAlienBottom,
	// file 7
	kOfficeLeftBackground,
	kOfficeLeftDecoration,
	kOfficeLeftMemo,
	kOfficeLeftGraffiti,
	kOfficeLeftTerminalSmashed,
	kOfficeLeftDrawerMoney,
	kOfficeLeftSafeOpen,
	kOfficeLeftSafeClosed,
	kOfficeLeftSafeMoney,
	kOfficeLeftDoorOpen,
	kOfficeLeftAlienShootAnimation1,
	kOfficeLeftAlienShootAnimation2,
	kOfficeLeftAlienShootAnimation3,
	kOfficeLeftAlienShootAnimation4,
	kOfficeLeftAlienShootAnimation5,
	kOfficeLeftAlienShootAnimation6,
	kOfficeLeftTerminalText,
	kOfficeLeftDoorClosed,
	kOfficeLeftDummy1,
	kOfficeLeftDummy2,
	kOfficeLeftDummy3,
	kOfficeLeftDummy4,
	kOfficeLeftDummy5,
	// file 8
	kOfficeRightBackground,
	kOfficeRightDecorationPictures,
	kOfficeRightDecorationPlants,
	kOfficeRightDoorOpen,
	kOfficeRightTerminalSmashed,
	kOfficeRightAlienShootAnimation1,
	kOfficeRightAlienShootAnimation2,
	kOfficeRightAlienShootAnimation3,
	kOfficeRightAlienTalking,
	kOfficeRightDummy1,
	kOfficeRightDummy2,
	kOfficeRightDummy3,
	kOfficeRightDummy4,
	// file 9
	kShipCockpitBackground,
	kShipCockpitPilotAnimation1,
	kShipCockpitPilotAnimation2,
	kShipCockpitPilotAnimation3,
	kShipCockpitPilotAnimation4,
	kShipCockpitPilotAnimation5,
	kShipCockpitPilotAnimation6,
	kShipCockpitPilotAnimation7,
	kShipCockpitPilotAnimation8,
	kShipCockpitPilotAnimation9,
	kShipCockpitPilotAnimation10,
	kShipCockpitPilotAnimation11,
	kShipCockpitPilotAnimation12,
	kShipCockpitPilotAnimation13,
	kShipCockpitPilotAnimation14,
	kShipCockpitPilotAnimation15,
	kShipCockpitPilotAnimation16,
	kShipCockpitPilotAnimation17,
	kShipCockpitPilotAnimation18,
	kShipCockpitPilotAnimation19,
	kShipCockpitPilotAnimation20,
	kShipCockpitDisplayStatusAnimation1,
	kShipCockpitDisplayStatusAnimation2,
	kShipCockpitWindowRocks,
	// file 10
	kRestaurantEntranceBackground,
	kRestaurantEntrancePorterAnimation1,
	kRestaurantEntrancePorterAnimation2,
	kRestaurantEntrancePorterAnimation3,
	kRestaurantEntrancePorterAnimation4,
	kRestaurantEntranceBathroomDoorAnimation1,
	kRestaurantEntranceBathroomDoorAnimation2,
	kRestaurantEntranceBathroomDoorAnimation3,
	kRestaurantEntranceBathroomDoorAnimation4,
	kRestaurantEntranceBathroomDoorAnimation5,
	kRestaurantEntranceGreenCandy,
	kRestaurantEntranceBlueCandy,
	kRestaurantEntrancePinkCandy,
	kRestaurantEntranceWhiteCandy,
	kRestaurantEntranceBlackCandy,
	kRestaurantEntraceDummy1,
	kRestaurantEntraceDummy2,
	// file 11
	kDeathScreen,
	// file 12
	kRocksBackground,
	kRocksRockAnimation1,
	kRocksRockAnimation2,
	kRocksRockAnimation3,
	// file 13
	kBluePlanetBackground,
	kBluePlanetShipAnimation1,
	kBluePlanetShipAnimation2,
	kBluePlanetShipAnimation3,
	kBluePlanetShipAnimation4,
	kBluePlanetShipAnimation5,
	kBluePlanetShipAnimation6,
	kBluePlanetShipAnimation7,
	kBluePlanetShipAnimation8,
	kBluePlanetShipAnimation9,
	kBluePlanetShipAnimation10,
	kBluePlanetShipAnimation11,
	kBluePlanetShipAnimation12,
	kBluePlanetShipAnimation13,
	// file 14
	kRogerCrashBackground,
	kRogerCrashAnimation1,
	kRogerCrashAnimation2,
	kRogerCrashAnimation3,
	kRogerCrashAnimation4,
	kRogerCrashAnimation5,
	kRogerCrashAnimation6,
	kRogerCrashAnimation7,
	kRogerCrashAnimation8,
	kRogerCrashAnimation9,
	kRogerCrashAnimation10,
	kRogerCrashAnimation11,
	kRogerCrashAnimation12,
	kRogerCrashAnimation13,
	kRogerCrashAnimation14,
	kRogerCrashAnimation15,
	kRogerCrashAnimation16,
	kRogerCrashAnimation17,
	kRogerCrashAnimation18,
	kRogerCrashAnimation19,
	// file 15
	kShipCorridorBackground,
	kShipCorridorCockpitDoorOpen,
	kShipCorridorSleepCabinDoorAnimation1,
	kShipCorridorSleepCabinDoorAnimation2,
	kShipCorridorSleepCabinDoorAnimation3,
	kShipCorridorDummy1,
	// file 16
	kAxacussCorridorTileWalled,
	kAxacussCorridorToLeft,
	kAxacussCorridorToRight,
	kAxacussCorridorToTop,
	kAxacussCorridorToBottom,
	kAxacussCorridorTile,
	kAxacussCorridorDoorClosed,
	kAxacussCorridorDoorOpen,
	kAxacussCorridorDesk,
	kAxacussCorridorLaptop,
	kAxacussCorridorStuff10,
	kAxacussCorridorStuff11,
	kAxacussCorridorStuff12,
	kAxacussCorridorStuff13,
	kAxacussCorridorStuff14,
	kAxacussCorridorStuff15,
	kAxacussCorridorStuff16,
	kAxacussCorridorStuff17,
	kAxacussCorridorStuff18,
	kAxacussCorridorStuff19,
	kAxacussCorridorStuff21,
	kAxacussCorridorStuff22,
	kAxacussCorridorStuff23,
	kAxacussCorridorStuff24,
	kAxacussCorridorStuff25,
	kAxacussCorridorStuff26,
	kAxacussCorridorStuff27,
	kAxacussCorridorStuff28,
	kAxacussCorridorAlarmStatus,
	kAxacussCorridorAlienRight,
	kAxacussCorridorAlienLeft,
	kAxacussCorridorAlienBottom,
	kAxacussCorridorAlienTop,
	kAxacussCorridorDummy1,
	// file 17
	kShipCorridorCabinBackground,
	kShipCorridorCabinL1Open,
	kShipCorridorCabinL2Open,
	kShipCorridorCabinL3Open,
	kShipCorridorCabinR1Open,
	kShipCorridorCabinR2Open,
	kShipCorridorCabinR3Open,
	kShipCorridorCabinAirlockDoorAnimation1,
	kShipCorridorCabinAirlockDoorAnimation2,
	kShipCorridorCabinAirlockDoorAnimation3,
	kShipCorridorCabinDummy1,
	kShipCorridorCabinDummy2,
	kShipCorridorCabinDummy3,
	kShipCorridorCabinDummy4,
	kShipCorridorCabinDummy5,
	kShipCorridorCabinDummy6,
	// file 18
	kShipGeneratorBackground,
	kShipGeneratorHatchOpen,
	kShipGeneratorJunctionBoxOpen,
	kShipGeneratorJunctionBoxOffline,
	kShipGeneratorJunctionBoxDisplay,
	kShipGeneratorKeycard,
	kShipGeneratorSpoolFloating,
	kShipGeneratorSpoolOnGround,
	kShipGeneratorCableUnplugged,
	kShipGeneratorCablePluggedIn,
	kShipGeneratorHatchRocks,
	kShipGeneratorRopeRocks,
	kShipGeneratorRopeSpace,
	kShipGeneratorRopeFloor,
	kShipGeneratorDummy1,
	kShipGeneratorDummy2,
	kShipGeneratorDummy3,
	kShipGeneratorDummy4,
	kShipGeneratorDummy5,
	kShipGeneratorDummy6,
	kShipGeneratorDummy7,
	kShipGeneratorDummy8,
	// file 19
	kRogerShipBackground,
	kRogerShipButtonPressed1,
	kRogerShipButtonPressed2,
	kRogerShipButtonPressed3,
	kRogerShipButtonPressed4,
	kRogerShipCardInSlot,
	kRogerShipCompartmentOpen,
	kRogerShipUnknown7,
	kRogerShipDisplayLeftOn,
	kRogerShipGreenDisplayAnimation1,
	kRogerShipGreenDisplayAnimation2,
	kRogerShipGreenDisplayAnimation3,
	kRogerShipGreenDisplayAnimation4,
	kRogerShipGreenDisplayAnimation5,
	kRogerShipGreenDisplayAnimation6,
	kRogerShipGreenDisplayAnimation7,
	kRogerShipBlueDisplayAnimation1,
	kRogerShipBlueDisplayAnimation2,
	kRogerShipBlueDisplayAnimation3,
	kRogerShipBlueDisplayAnimation4,
	kRogerShipBlueDisplayAnimation5,
	kRogerShipBlueDisplayAnimation6,
	kRogerShipBlueDisplayAnimation7,
	kRogerShipUnknown23,
	kRogerShipDisplaySinewaveAnimation1,
	kRogerShipDisplaySinewaveAnimation2,
	kRogerShipDisplaySinewaveAnimation3,
	kRogerShipDisplaySinewaveAnimation4,
	kRogerShipDisplaySinewaveAnimation5,
	kRogerShipDisplaySinewaveAnimation6,
	kRogerShipDisplaySinewaveAnimation7,
	kRogerShipDisplaySinewaveAnimation8,
	kRogerShipDisplaySinewaveAnimation9,
	kRogerShipDisplaySinewaveAnimation10,
	kRogerShipDisplaySinewaveAnimation11,
	kRogerShipDisplaySinewaveAnimation12,
	kRogerShipDisplaySinewaveAnimation13,
	kRogerShipDisplaySinewaveAnimation14,
	kRogerShipCompartmentContent,
	kRogerShipDummy1,
	kRogerShipDummy2,
	// file 20
	kHelpScreen,
	// file 21
	kShipCabinLeftBackground,
	kShipCabinLeftPaintingSunset,
	kShipCabinLeftPaintingLandscape,
	kShipCabinLeftPaintingAbstract,
	kShipCabinLeftTableStuff1,
	kShipCabinLeftCeilingPencil,
	kShipCabinLeft3Decoration,
	kShipCabinLeftSocketPluggedIn,
	kShipCabinLeftVinyl,
	kShipCabinLeftTurntable,
	kShipCabinLeftSocketUnplugged,
	kShipCabinLeftTurntableCableCut,
	kShipCabinLeftTurntableCable,
	kShipCabinLeftTurntableAnimation1,
	kShipCabinLeftTurntableAnimation2,
	kShipCabinLeftTurntableAnimation3,
	kShipCabinLeftTableStuff2,
	kShipCabinLeftLockerOpen,
	kShipCabinLeftLockerBooksOpen,
	kShipCabinLeftLockerSpoolOpen,
	kShipCabinLeftLockerPistolRemoved,
	kShipCabinLeftLockerSpoolRemoved,
	kShipCabinLeftBedSafeOpen,
	kShipCabinLeftBedSafeEmpty,
	kShipCabinLeftDoorClosed,
	kShipCabinLeftTurntableCableSparks,
	kShipCabinLeftTurntableCableCutEnd,
	kShipCabinLeftDummy1,
	kShipCabinLeftDummy2,
	kShipCabinLeftDummy3,
	kShipCabinLeftDummy4,
	kShipCabinLeftDummy5,
	kShipCabinLeftDummy6,
	kShipCabinLeftDummy7,
	kShipCabinLeftDummy8,
	kShipCabinLeftDummy9,
	kShipCabinLeftDummy10,
	kShipCabinLeftDummy11,
	kShipCabinLeftDummy12,
	// file 22
	kShipCabinRightBackground,
	kShipCabinRightPosterSnowman,
	kShipCabinRightTableStuff,
	kShipCabinRightCeilingChess,
	kShipCabinRightTennisRacket,
	kShipCabinRightTennisBallsFloating,
	kShipCabinRightTennisBallsOnGround,
	kShipCabinRightTableChess,
	kShipCabinRight2Bed,
	kShipCabinRightLockerBooksOpen,
	kShipCabinRightLockerRopeOpen,
	kShipCabinRightLockerOpen,
	kShipCabinRightLockerRopeRemoved,
	kShipCabinRightBedSafeOpen,
	kShipCabinRightBedSafeEmpty,
	kShipCabinRightDoorClosed,
	kShipCabinRightLockerDiscmanRemoved,
	kShipCabinRightDummy1,
	kShipCabinRightDummy2,
	// file 23
	kShipBathroomBackground,
	// file 24
	kShipHoldBackgroundFloating,
	kShipHoldBackgroundOnGround,
	kShipHoldLandingModuleDoorOpen,
	kShipHoldGeneratorHatchOpen,
	kShipHoldLandingModuleSpool,
	kShipHoldCableToGeneratorUnplugged,
	kShipHoldCableToGeneratorPluggedIn,
	kShipHoldDummy1,
	kShipHoldDummy2,
	// file 25
	kShipLandingModuleBackground,
	kShipLandingModuleDoorClosed,
	kShipLandingModuleDisplayLeftOn,
	kShipLandingModuleCablePluggedIn,
	kShipLandingModuleCableSpoolConnected,
	kShipLandingModuleCableToHold,
	kShipLandingModuleDisplayRightOn,
	kShipLandingModuleDisplayTop1On,
	kShipLandingModuleDisplayTop2On,
	kShipLandingModuleDisplayTop3On,
	kShipLandingModuleCableWithTerminalStrip,
	kShipLandingModuleDummy1,
	kShipLandingModuleDummy2,
	kShipLandingModuleDummy3,
	kShipLandingModuleDummy4,
	kShipLandingModuleDummy5,
	kShipLandingModuleDummy6,
	kShipLandingModuleDummy7,
	kShipLandingModuleDummy8,
	// file 26
	kArsanoStar,
	// file 27
	kSaveLoadScreen,
	// file 28
	kRestaurantBackground,
	kRestaurantAnimation1,
	kRestaurantAnimation2,
	kRestaurantAnimation3,
	kRestaurantAnimation4,
	kRestaurantAnimation5,
	kRestaurantAnimation6,
	kRestaurantAnimation7,
	kRestaurantAnimation8,
	kRestaurantAnimation9,
	kRestaurantAnimation10,
	kRestaurantAnimation11,
	kRestaurantAnimation12,
	kRestaurantAnimation13,
	kRestaurantAnimation14,
	kRestaurantAnimation15,
	kRestaurantAnimation16,
	kRestaurantAnimation17,
	kRestaurantAnimation18,
	kRestaurantAnimation19,
	kRestaurantAnimation20,
	kRestaurantAnimation21,
	kRestaurantAnimation22,
	// file 29
	kRestaurantRogerBackground,
	kRestaurantRogerEyes1Closed,
	kRestaurantRogerMouthOpen,
	kRestaurantRogerPlayingChess,
	kRestaurantRogerWalletRemoved,
	kRestaurantRogerHandAnimation1,
	kRestaurantRogerHandAnimation2,
	kRestaurantRogerHandAnimation3,
	kRestaurantRogerHandAnimation4,
	kRestaurantRogerHandAnimation5,
	kRestaurantRogerEyes2Closed,
	kRestaurantRogerChessBoard,
	kRestaurantRogerEyes2Open,
	kRestaurantRogerDummy1,
	// file 30
	kRogerOutsideBackground,
	kRogerOutsideMouthOpen,
	// file 31
	kIntroScreenBackground,
	kIntroScreenShipAnimation1,
	kIntroScreenShipAnimation2,
	kIntroScreenShipAnimation3,
	kIntroScreenShipAnimation4,
	kIntroScreenShipAnimation5,
	kIntroScreenShipAnimation6,
	// file 32
	kBusStationSignBackground,
	kBusStationSignPrice,
	kBusStationSignPleaseWait,
	kBusStationSignPleasantFlight,
	// file 33
	kShipSleepCabinBackground,
	kShipSleepCabinTerminalWarning,
	kShipSleepCabinTerminal1,
	kShipSleepCabinTerminal2,
	kShipSleepCabinStatusLight,
	kShipSleepCabinTerminal3,
	// file 34
	kShipAirlockBackground,
	kShipAirlockDoorLeftAnimation1,
	kShipAirlockDoorLeftAnimation2,
	kShipAirlockDoorLeftAnimation3,
	kShipAirlockDoorRightAnimation1,
	kShipAirlockDoorRightAnimation2,
	kShipAirlockDoorRightAnimation3,
	kShipAirlockHelmetRemoved,
	kShipAirlockSpacesuitRemoved,
	kShipAirlockSupplyRemoved,
	kShipAirlockDoorLeftButton,
	kShipAirlockDoorRightButton,
	kShipAirlockManometerAnimation1,
	kShipAirlockManometerAnimation2,
	kShipAirlockManometerAnimation3,
	kShipAirlockManometerAnimation4,
	kShipAirlockManometerAnimation5,
	kShipAirlockManometerAnimation6,
	// file 35
	kAxacussSpaceBackground,
	kAxacussSpaceShipAnimation1,
	kAxacussSpaceShipAnimation2,
	kAxacussSpaceShipAnimation3,
	kAxacussSpaceShipAnimation4,
	kAxacussSpaceShipAnimation5,
	kAxacussSpaceShipAnimation6,
	kAxacussSpaceShipAnimation7,
	kAxacussSpaceBusAnimation1,
	kAxacussSpaceBusAnimation2,
	kAxacussSpaceBusAnimation3,
	kAxacussSpaceBusAnimation4,
	kAxacussSpaceBusAnimation5,
	kAxacussSpaceBusAnimation6,
	kAxacussSpaceBusAnimation7,
	kAxacussSpaceBusAnimation8,
	kAxacussSpaceBusAnimation9,
	kAxacussSpaceBusAnimation10,
	kAxacussSpaceBusAnimation11,
	kAxacussSpaceBusAnimation12,
	kAxacussSpaceBusAnimation13,
	kAxacussSpaceBusAnimation14,
	// file 36
	kAxacussanCapsuleBackground,
	kAxacussanCapsuleRobotAnimation1,
	kAxacussanCapsuleRobotAnimation2,
	kAxacussanCapsuleRobotAnimation3,
	kAxacussanCapsuleRobotAnimation4,
	kAxacussanCapsuleDummy1,
	// file 37
	kArsanoMeetupBackground,
	kArsanoMeetupRestaurantLightAnimation1,
	kArsanoMeetupRestaurantLightAnimation2,
	kArsanoMeetupRestaurantLightAnimation3,
	kArsanoMeetupRestaurantLightAnimation4,
	kArsanoMeetupRestaurantLightAnimation5,
	kArsanoMeetupRestaurantDoorAnimation1,
	kArsanoMeetupRestaurantDoorAnimation2,
	kArsanoMeetupRestaurantDoorSignAnimation1,
	kArsanoMeetupRestaurantDoorSignAnimation2,
	kArsanoMeetupRestaurantDoorSignAnimation3,
	kArsanoMeetupRestaurantDoorSignAnimation4,
	kArsanoMeetupRestaurantDoorSignAnimation5,
	kArsanoMeetupRestaurantSignAnimation1,
	kArsanoMeetupRestaurantSignAnimation2,
	kArsanoMeetupRestaurantSignAnimation3,
	kArsanoMeetupRestaurantSignAnimation4,
	kArsanoMeetupRestaurantSignAnimation5,
	kArsanoMeetupRestaurantSignAnimation6,
	kArsanoMeetupRestaurantSignAnimation7,
	kArsanoMeetupRestaurantSignAnimation8,
	kArsanoMeetupRestaurantSignAnimation9,
	kArsanoMeetupRestaurantSignAnimation10,
	kArsanoMeetupRestaurantSignAnimation11,
	kArsanoMeetupRestaurantSignAnimation12,
	kArsanoMeetupRestaurantSignAnimation13,
	kArsanoMeetupRestaurantSignAnimation14,
	// file 38
	kArsanoAfterNovaBackground,
	kArsanoAfterNovaRogerShipAnimation1,
	kArsanoAfterNovaRogerShipAnimation2,
	kArsanoAfterNovaRogerShipAnimation3,
	kArsanoAfterNovaRogerShipAnimation4,
	kArsanoAfterNovaRogerShipAnimation5,
	kArsanoAfterNovaRogerShipAnimation6,
	kArsanoAfterNovaRogerShipAnimation7,
	kArsanoAfterNovaRogerShipAnimation8,
	kArsanoAfterNovaRogerShipAnimation9,
	kArsanoAfterNovaRogerShipAnimation10,
	kArsanoAfterNovaRogerShipAnimation11,
	kArsanoAfterNovaRoger,
	// file 39
	kArsanoDesolate,
	// file 40
	kIntersectionBackground,
	kIntersectionGuardRemoved,
	kIntersectionGuardMouthOpen,
	kIntersectionGuardShootAnimation1,
	kIntersectionGuardShootAnimation2,
	kIntersectionGuardMouthClosed,
	kIntersectionDoorOpen,
	kIntersectoinKeycard,
	// file 41
	kInformationDeskBackground,
	kInformationDeskAlienMouthOpen,
	kInformationDeskAlienHandMoved,
	kInformationDeskAlienShoot,
	// file 42
	kArtGalleryBackground,
	kArtGalleryAlienShootAnimation1,
	kArtGalleryAlienShootAnimation2,
	kArtGalleryAlienShootAnimation3,
	kArtGalleryThrowingBlockAnimation1,
	kArtGalleryThrowingBlockAnimation2,
	kArtGalleryThrowingBlockAnimation3,
	kArtGalleryThrowingBlockAnimation4,
	kArtGalleryThrowingBlockAnimation5,
	kArtGalleryThrowingBlockAnimation6,
	kArtGalleryThrowingBlockAnimation7,
	kArtGalleryDummy1,
	// file 43
	kCellBackground,
	kCellCablePluggedIn,
	kCellCableUnplugged,
	kCellCableCutUnplugged,
	kCellCableCutPluggedIn,
	kCellCableCutTableUnplugged,
	kCellCableCutTablePluggedIn,
	kCellTableTablet,
	kCellRobotComesAnimation1,
	kCellRobotComesAnimation2,
	kCellRobotComesAnimation3,
	kCellRobotComesAnimation4,
	kCellRobotComesAnimation5,
	kCellRobotComesAnimation6,
	kCellRobotComesAnimation7,
	kCellRobotComesAnimation8,
	kCellRobotComesAnimation9,
	kCellRobotComesAnimation10,
	kCellRobotComesAnimation11,
	kCellRobotLeavesAnimation1,
	kCellRobotLeavesAnimation2,
	kCellRobotLeavesAnimation3,
	kCellRobotLeavesAnimation4,
	kCellRobotLeavesAnimation5,
	kCellRobotLeavesAnimation6,
	kCellRobotLeavesAnimation7,
	kCellRobotLeavesAnimation8,
	kCellRobotLeavesAnimation9,
	kCellRobotSparks,
	kCellRobotBroken,
	kCellDoorClosed,
	kCellDummy1
};

}

#endif
