/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.ApksigSigningConfiguration;
import com.android.tools.build.bundletool.model.AutoValue_SigningConfigurationProvider_ApkDescription;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.targeting.TargetingUtils;
import com.google.auto.value.AutoValue;
import com.google.common.primitives.Ints;

public interface SigningConfigurationProvider {
    public ApksigSigningConfiguration getSigningConfiguration(ApkDescription var1);

    public boolean hasRestrictedV3SigningConfig();

    @AutoValue
    public static abstract class ApkDescription {
        public abstract int getMinSdkVersionFromManifest();

        public abstract Targeting.ApkTargeting getApkTargeting();

        public abstract Targeting.VariantTargeting getVariantTargeting();

        public int getMinSdkVersionTargeting() {
            int minApkTargetingSdkVersion = TargetingUtils.getMinSdk(this.getApkTargeting().getSdkVersionTargeting());
            int minVariantTargetingSdkVersion = TargetingUtils.getMinSdk(this.getVariantTargeting().getSdkVersionTargeting());
            return Ints.max(this.getMinSdkVersionFromManifest(), minApkTargetingSdkVersion, minVariantTargetingSdkVersion);
        }

        public static ApkDescription fromModuleSplit(ModuleSplit moduleSplit) {
            int minSdkVersionFromManifest = moduleSplit.getAndroidManifest().getEffectiveMinSdkVersion();
            return ApkDescription.builder().setMinSdkVersionFromManifest(minSdkVersionFromManifest).setApkTargeting(moduleSplit.getApkTargeting()).setVariantTargeting(moduleSplit.getVariantTargeting()).build();
        }

        public static Builder builder() {
            return new AutoValue_SigningConfigurationProvider_ApkDescription.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setMinSdkVersionFromManifest(int var1);

            public abstract Builder setApkTargeting(Targeting.ApkTargeting var1);

            public abstract Builder setVariantTargeting(Targeting.VariantTargeting var1);

            public abstract ApkDescription build();
        }
    }
}

