/*
 * Copyright (C) 2001-2003 R. David Quattlebaum <drq@drqware.com>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 */

/* $Id: scud.h,v 1.34 2003/06/14 14:35:20 drq Exp $ */

/*
 * scud.h - defines for scud
 */
#ifndef __scud_h__
#define __scud_h__

#define SCUD_VERSION "1.5.5"

#ifdef WIN32
#include "regex.h"

/*
 * functions that WIN32 names something else
 */
#define close(a)      CloseHandle((HANDLE)(a))
#define sleep(a)      Sleep((a)*1000)
#define strncasecmp(a,b,n) strnicmp((a),(b),(n))

#define SCUDKEY       "SOFTWARE\\scud"
#define DEFAULT_MODEM "COM2"
#define LOGFILE       "C:\\scud.log"
#define PIDFILE       "\\scud.pid"
#define RCFILE        "\\scud.conf"
#define PATH_DELIMITER '\\'
#define BAD_FD        (int)INVALID_HANDLE_VALUE
#define MAXPATHLEN    MAX_PATH
#else
#include <regex.h>

#define DEFAULT_MODEM  "/dev/ttyd1"
#define LOGFILE        "/var/log/scud.log"
#define PIDFILE        "/var/run/scud.pid"
#define RCFILE         "/usr/local/etc/scud.conf"
#define PATH_DELIMITER '/'
#define BAD_FD         (int)-1
#endif

#define REG_FLAGS     (REG_EXTENDED|REG_NOSUB|REG_ICASE|REG_NEWLINE)
#define BUFLEN        512

typedef struct SELECTED {
   char    *pattern;
   regex_t *re;
} Selected;

#endif
