/*
 * Copyright (C) 2001-2003 R. David Quattlebaum <drq@drqware.com>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 */

/* $Id: scud.c,v 1.44 2003/05/18 23:12:23 drq Exp $ */

/*
 * Selected Caller and Unavailable Deterent
 *
 * To detect unavailable callers and "selected" callers from a file
 * and either hangup or cause the modem to answer (or squeal)
 *
 */
#include <fcntl.h>
#ifdef WIN32
#include <io.h>
#include <fcntl.h>
#include <process.h>
#else
#include <unistd.h>
#include <sys/param.h>
#endif
#include <string.h>
#include <time.h>

#include "cid.h"
#include "scud.h"
#include "modem.h"
#include "parse.h"
#include "util.h"

#if defined(WIN32) && defined(_CONSOLE)
#include "service.h"
#endif

/*
 * global variables
 */
char *progname;
char *version = SCUD_VERSION;
#ifdef WIN32
OSVERSIONINFO info;
#endif
long pid;
int pidfile;

char *progid = "$Id: scud.c,v 1.44 2003/05/18 23:12:23 drq Exp $    ";

/*
 * option variables 
 */
extern int console;
extern int verbose;
extern char *device;
extern char *input_file;
char rcfilename[MAXPATHLEN];
char pidfilename[MAXPATHLEN];

#if defined(WIN32) && ! defined(_CONSOLE)
/*
 * when building with Dev Studio, create a project of type Win32 App (empty)
 *
 */
APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
#else
int
main(int argc, char *argv[])
#endif
{

   int fd;
   int i, j, rc;
   char argc_rcfile;
   char **argv_rcfile;
   char pidstr[9];
#ifdef   WIN32
#ifndef _CONSOLE
   int  argc = __argc;
   char **argv = __argv;
#else
   /* we want a console version of scud too */
   console = 1;
#endif
   info.dwOSVersionInfoSize = sizeof(info);
   GetVersionEx(&info);
#endif


   progname = strindex(argv[0], PATH_DELIMITER);
   if (progname)
      progname++;
   else
      progname = argv[0];

   rcfilename[0] = pidfilename[0] = 0;
   /*
    * Parse the config file and the command line options
    *
    * Scan thru argv[] lookine for "-NORc". If found, we don't want to
    * parse the rc file
    */
   for (i=1; i<argc; i++)
      if (!strncasecmp(argv[i], "-nor", 4))
         break;

   for (j=1; j<argc; j++)
      if (!strncasecmp(argv[j], "-config", 7)) {
         strcat(rcfilename, argv[j+1]);
         i = argc;
         break;
      }

#ifdef WIN32
      {
         long len;
         long type;
         HKEY sk;
         if ( RegOpenKeyEx( HKEY_LOCAL_MACHINE, SCUDKEY, 0, KEY_ALL_ACCESS, &sk) != ERROR_SUCCESS )
            log_printf("ERROR: Can't open registry key: %s\n", SCUDKEY);
         len = sizeof(rcfilename);
         rc = RegQueryValueEx(sk, "Directory", 0, &type, pidfilename, &len);
         RegCloseKey(sk);
      }
#endif
  /*
   * If we don't already have a config file from a command argument, 
   * append the default RCFILE name to what we have already. For windows
   * this will be the installation directory..
   */
      if (!rcfilename[0]) {
#ifdef WIN32
         strncpy(rcfilename, pidfilename, sizeof(rcfilename));
#endif
         strcat(rcfilename, RCFILE);
      }
   strcat(pidfilename, PIDFILE);

#if defined(WIN32) && defined(_CONSOLE)
   if (service_main(argc, argv))
      return(0);
#endif

   if (i == argc) {
      argc_rcfile = file_to_argv(rcfilename, &argv_rcfile);
      if (argc_rcfile > 0)
         parse_args(argc_rcfile, argv_rcfile);
   }
   if (argc > 1) 
      parse_args(argc-1, &argv[1]);

   print_header();

   if (input_file) {
      fd = open(input_file, O_RDONLY);
   }
   else {
      fd = init_cid(device);
   }
   if (fd == BAD_FD)
      log_printf("ERROR: can't open modem\n");

   pid = getpid();
   rc = sprintf(pidstr, "%ld\n", pid);
   pidfile = open(pidfilename, O_WRONLY|O_CREAT, 0644);
   rc = write(pidfile, pidstr, rc);
   close(pidfile);

#if defined(WIN32) && defined(_CONSOLE)
   /*
    * report to Service Control Manager that we are running
    * as a service 
    */
   if (info.dwPlatformId == VER_PLATFORM_WIN32_NT)
      ReportStatusToSCM(SERVICE_RUNNING, NO_ERROR, 0);
#endif

   rc = cid(fd);

   close(fd);
   
   return(0);
}
