'\"
'\" Copyright (c) 1994-1996 Technical University of Braunschweig.
'\" Copyright (c) 1996-1997 University of Twente.
'\" Copyright (c) 1997-2003 Technical University of Braunschweig.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
.so man.macros
.TH Tnm::udp n "November 2003" Tnm "Tnm Tcl Extension"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
Tnm::udp \- Send and receive UDP datagrams.
.BE

.SH DESCRIPTION
The Tnm::udp command allows to send and receive datagrams using the
User Datagram Protocol (UDP) (RFC 768).

.SH UDP COMMANDS
The Tnm::udp command allows to create new udp endpoints and to search for
existing endpoints that match certain criterias.
.TP
.B Tnm::udp create \fR[\fIoption value\fR ...]
The \fBTnm::udp create\fR command creates a new udp endpoint. The
\fIoptions\fR can be used to configure the new endpoint. See the
description of supported options below.
.TP
.B Tnm::udp find \fR[\fB-tags \fIpatternList\fR]
The \fBTnm::udp find\fR command retrieves a list of udp endpoints that
match the search options. If no options are present, the list of all
existing udp endpoints will be returned. The \fB-tags\fR option
matches the tag associated with an udp endpoint against the pattern
contained in the \fIpatternList\fR.  Matching is done according to the
rules defined for the Tcl string match command.

.SH UDP INSTANCE COMMANDS
Every udp endpoint is represented by a udp object command which allows
to manipulate the udp endpoint.
.TP
.B udp# cget
The \fBudp# cget\fR command returns the current value of a
configuration option. See the description of supported options below.
.TP
.B udp# configure
The \fBudp# configure\fR command manipulates configuration options.
See the description of supported options below. A list describing all
options is returned if the optional arguments are absent.
.TP
.B udp# connect \fIhost\fR \fIport\fR
The \fBudp# connect\fR command connects an unconnected udp endpoint
it to a \fIport\fR on a remote \fIhost\fR. A connected udp endpoint
only allows to send messages to a single destination. This may be
useful to shorten scripts since there is no need to specify the 
destination address for each \fBudp# send\fR command on a connected 
udp socket.
.TP
.B udp# destroy
The \fBudp$ destroy\fR command destroys the udp object and the udp
endpoint it represents.
.TP
.B udp# receive
The \fBudp# receive\fR command receives a datagram from the udp 
endpoint. This command blocks until a datagram is ready to be received.
.TP
.B udp# send \fR [\fIhost port\fR] \fImessage\fR
The \fBudp# send\fR command sends a datagram containing \fImessage\fR
to the destination specified by \fIhost\fR and \fIport\fR. The
\fIhost\fR and \fIport\fR arguments may not be used if the udp
endpoint is connected to a remote udp endpoint.  If the udp endpoint
is not connected, you must use \fIhost\fR and \fIport\fR arguments to
specify the destination of the datagram.

.SH UDP OPTIONS
Every udp endpoint has associated configuration options which control
the endpoint and its behaviour as well as the scripts attached to the
endpoint.
.TP
.BI "-address " address
The remote IP address associated with the udp endpoint or the wildcard
address.
.TP
.BI "-port " port
The remote port number associated with the udp endpoint or 0.
.TP
.BI "-myaddress " myaddress
The local IP address associated with the udp endpoint or the wildcard
address.
.TP
.BI "-myport " myport
The local port number associated with the udp endpoint or 0.
.TP
.BI "-read " command
The 'fB-read\fR option defines the Tcl command that is evaluated
whenever the udp endpoint becomes readable.
.TP
.BI "-write " command
The 'fB-write\fR option defines the Tcl command that is evaluated
whenever the udp endpoint becomes writable.
.TP
.BI "-tags " tagList
The \fB-tags\fR option is used to tag udp endpoints. Tags are a
convenient way to group udp endpoints that perform a single task
together. Tags are also convenient to relate udp endpoints to network
map objects and/or management functions.

.SH SEE ALSO
scotty(1), Tnm(n), Tcl(n)

.SH AUTHORS
Juergen Schoenwaelder <schoenw@ibr.cs.tu-bs.de>
.br
