'\"
'\" Copyright (c) 2000-2001 Technical University of Braunschweig.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" @(#) $Id: smx.n 1550 2001-12-07 18:17:20Z schoenw $
'\" 
.so man.macros
.TH Tnm::smx n "February 2001" Tnm "Tnm Tcl Extension"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
Tnm::smx \- Interact with a controlling SMX peer.
.BE

.SH DESCRIPTION
The SMX protocol defined in RFC 2593 is used to interface script
runtime systems like a Tcl interpreter with the language independent
Script MIB as defined in RFC 2592. The Tnm SMX support provides a
way to install and execute Tcl scripts on remote devices by using
the SNMP management protocol.

A Tcl interpreter becomes an SMX controlled runtime engine
automatically during Tnm initialization if the SMX\_PORT and
SMX\_COOKIE variables described in RFC 2593 exist in the process
environment. The Tnm extension automatically sets up a TCP connection
to the SMX\_PORT on the local host. Once the SMX control connection
has been established, the SMX protocol engine will listen for SMX
commands.  Every script invoked via the SMX start command will execute
in its own Tcl interpreter in the same process.

.SH EXECUTION MODEL
A single operating system level process can execute multiple Tcl
scripts under SMX control. Every script runs it is own Tcl interpreter
and does not share any Tcl resources (variables, procedures) with
other concurrently running scripts.

    +-----------+         +-----------+
    | interp #1 |  . . .  | interp #n |
   +-----------------------------------+     script
   |      master Tcl interpreter       | <- defining
   +-----------------------------------+    profiles
   | SMX protocol implementation (Tnm) |
   +-----------------------------------+

Tcl interpreters executing scripts are all slave interpreters of the
application's main Tcl interpreter. All slave interpreters are safe
Tcl interpreters. The master interpreter can therefore be used to
establish security profiles. A security profile is basically a set of
aliases etc. which is installed in a slave interpreter during
startup. Security profiles are implemented as Tcl procedures that are
loaded into the master interpreter during the initialization of the
Tnm extension. The master interpreter can also be used to establish
communication paths between scripts executing in different Tcl
interpreters.

.SH SMX COMMAND
The Tnm::smx command can be invoked by scripts to send results or log
messages to the controlling SMX peer.
.TP
.B Tnm::smx error \fR[\fB-notify\fR] \fIstring\fR
The \fBTnm::smx error\fR command writes an error \fIstring\fR to the 
controlling SMX peer. The SMX peer will then store the \fIstring\fR 
in the smRunError object of the DISMAN-SCRIPT-MIB (RFC 2592). The 
\fB-notify\fR option can be used to let the controlling SMX peer 
generate a smScriptError notification.
.TP
.B Tnm::smx exit \fR[\fIexitCode\fR]
The \fBTnm::smx exit\fR command must be used to terminate a script.
The optional \fIexitCode\fR argument can be used to define the exit
code which is returned to the controlling SMX peer. The \fIexitCode\fR
must be one of the values noError, halted, lifeTimeExceeded,
noResourcesLeft, languageError, runtimeError, invalidArgument,
securityViolation, or genericError. The exit code noError is used if
the \fIexitCode\fR option is not present.
.TP
.B Tnm::smx log \fImessage\fR
The \fBTnm::smx log\fR command writes a \fImessage\fR to the logging
facility provided by the controlling SMX peer.
.TP
.B Tnm::smx profiles \fR[\fIlist\fR]
The \fBTnm::smx profile\fR command installs or retrieves the list of
known runtime security profiles. Each element in the \fIlist\fR
identifies a runtime security profile. The \fBTnm::smx profile\fR
command always returns the list of installed profiles. The list of
known profiles is updated if the optional \fIlist\fR argument is
present.

Security profiles are implemented by Tcl procedures in the master
interpreter with the same name. The SMX protocol implementation will
automatically create a new slave Tcl interpreter when a new script is
started. The Tnm extension calls the runtime security profile
procedure in the master interpreter during the initialization of the
slave interpreter so that the master can setup the security
environment before script execution starts. The name of the slave
interpreter is passed to the procedure so that the master can access
the slave interpreter.

The \fBTnm::smx profiles\fR command may only be used by a master Tcl
interpreter which implements security profiles for safe interpreters
that are executing scripts. Invoking the command from a safe slave
interpreter will cause an error.

.TP
.B Tnm::smx result \fR[\fB-notify\fR] \fIstring\fR
The \fBTnm::smx result\fR command writes a \fIstring\fR to the 
controlling SMX peer. The SMX peer will then store the \fIstring\fR 
in the smRunResult object of the DISMAN-SCRIPT-MIB (RFC 2592). The 
\fB-notify\fR option can be used to let the controlling SMX peer 
generate a smScriptResult notification.

.SH VARIABLES
The SMX implementation sets the following global Tcl variables before
a script is executed:
.TP 15
\fBargc\fR
Contains a count of the number of arguments (0 if none),
not including the name of the script file.
.TP 15
\fBargv\fR
Contains a Tcl list whose elements are the arguments,
in order, or an empty string if there are no arguments.
.TP 15
\fBargv0\fR
Contains the script name.


.SH SEE ALSO
scotty(1), Tnm(n), Tcl(n)

.SH AUTHORS
Juergen Schoenwaelder <schoenw@ibr.cs.tu-bs.de>
