'\"
'\" Copyright (c) 1994-1996 Technical University of Braunschweig.
'\" Copyright (c) 1996-1997 University of Twente.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
.so man.macros
.TH ntp n "July 1997" Tnm "Tnm Tcl Extension"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
ntp \- Retrieve NTP status information.
.BE

.SH DESCRIPTION
The Network Time Protocol (NTP) (RFC 1119, RFC 1305) allows to
synchronize computer clocks by exchanging NTP messages. The \fBntp\fR
command allows to retrieve control variables from NTP peers.

.SH NTP COMMAND
.TP
\fBntp\fR [\fIoptions\fR]
Invoking the \fBntp\fR command with options but without any command
arguments allows to retrieve and change the default values. See the
description of supported options below. Default values are bound
to a Tcl interpreter which allows to have multiple Tcl interpreter
with different defaults.
.TP
\fBntp\fR [\fIoptions\fR] \fIhost\fR \fIarrayName\fR
The \fBntp\fR command sends a NTP version 3 mode 6 request to
\fIhost\fR and writes status information into the Tcl array
\fIarrayName\fR. After successful completion, the array will contain
the following elements (RFC 1305):
.RS
.TP
peer.delay
This is a signed fixed-point number indicating the roundtrip delay of
the peer clock relative to the local clock over the network path
between them, in seconds.
.TP
peer.dispersion
This is a signed fixed-point number indicating the maximum error of
the peer clock relative to the local clock over the network path
between them, in seconds.
.TP
peer.offset
This is a signed, fixed-point number indicating the offset of the peer
clock relative to the local clock, in seconds.
.TP
peer.precision
This is a signed integer indicating the precision of the various
clocks, in seconds to the nearest power of two.
.TP
peer.reach
This is a shift register used to determine the reachability status of
the peer, with bits entering from the least significant (rightmost)
end. A peer is considered reachable if at least one bit in this
register is set to one.
.TP
peer.srcadr
This is the IP address of the peer.
.TP
peer.stratum
This is an integer indicating the stratum of the local clock.
.TP
peer.valid
This is an integer counter indicating the valid samples remaining in
the filter register. It is used to determine the reachability state
and when the poll interval should be increased or decreased.
.TP
sys.peer
This is a selector identifying the current synchronization source.
.TP
sys.precision
This is a signed integer indicating the precision of the various
clocks, in seconds to the nearest power of two.
.TP
sys.refid
This is a 32-bit code identifying the particular reference clock.
.TP
sys.rootdelay
This is a signed fixed-point number indicating the total roundtrip
delay to the primary reference source at the root of the
synchronization subnet, in seconds.
.TP
sys.rootdispersion
This is a signed fixed-point number indicating the maximum error
relative to the primary reference source at the root of the
synchronization subnet, in seconds.
.TP
sys.stratum
This is an integer indicating the stratum of the local clock
.TP
sys.system
A textual description of the system type.
.RE

.SH NTP OPTIONS
The following options control how NTP requests are send and how the ntp
command deals with lost NTP packets.
.TP
.BI "-timeout " time
The \fB-timeout\fR option defines the time the \fBntp\fR command will
wait for a response. The \fItime\fR is defined in seconds with a
default of 2 seconds.
.TP
.BI "-retries " number
The \fB-retries\fR option defines how many times a request is
retransmitted during the timeout interval. The default \fInumber\fR of
retries is 2.

.SH SEE ALSO
scotty(1), Tnm(n), Tcl(n)

.SH AUTHORS
Erik Schoenfelder <schoenfr@gaertner.de>
.br
Juergen Schoenwaelder <schoenw@cs.utwente.nl>
.br
