'\"
'\" Copyright (c) 1994-1996 Technical University of Braunschweig.
'\" Copyright (c) 1996-1997 University of Twente.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
.so man.macros
.TH cmip n "July 1997" Tnm "Tnm Tcl Extension"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
cmip \- A Tcl interface to the CMIP protocol.
.BE

.SH DESCRIPTION
The \fBcmip\fR command provides an interface to the Common Management
Information Protocol. It enables Tcl scripts to connect to a remote
OSI management agent and to use the Common Management Information
Services (CMIS).

.SH CMIP COMMAND
.TP
.B cmip connect \fIagent\fR \fIhost\fR
The \fBcmip connect\fR command establishes an association to a remote
\fIagent\fR running on \fIhost\fR.  This command returns a cmip
association object which allows to invoke association specific
commands (see below).
.TP
.B cmip wait
The \fBcmip wait\fR command blocks until all asynchronous requests for
all CMIP associations have been processed. Events are processed while
waiting for outstanding responses which can have arbitrary side
effects.
.TP
.B cmip info
The \fBcmip info\fR command returns a list of all existing cmip
association handles that have been created using the \fBcmip connect\fR
command.

.SH CMIP ASSOCIATION COMMAND
.TP
.B cmip# get \fIclass\fR \fIinstance\fR ?\fIoptions\fR?
Retrieve management information on this association (cmip#). The \fIclass\fR
and the \fIinstance\fR define the base managed object that will be returned,
if not modified by the options.

.RS 5
The available 
.I options
for get are:
.RE

.RS 
.TP 10

.B -scope \fIscope\fR ?-atomic?
Set the \fIscope\fR for the request. If -atomic is given, it tells the agent
to perform the request only, if it can be performed on all scoped managed
objects.

.TP
.BI "-filter " filter
Set a \fIfilter\fR on the scoped managed object(s).

.TP
.B -attributes \fIattributes\fR
The \fIattributes\fR is a list, that may contain the attributes to ask
for. {} for no attributes. Default is all attributes. Each Element of
the list may be a list, but only the first element is used as an
attribute to look for (so e.g. the result of an get or set request may
be used as the input).

.TP
.B -callback \fIcallback\fR
Specify a \fIcallback\fR that will be executed, if the result of the
asynchronous request is completely answered.

.RE

.TP
.B cmip# set \fIclass\fR \fIinstance\fR \fIattributes\fR ?\fIoptions\fR?
Set management information at the agent (cmip#). The \fIclass\fR and
the \fIinstance\fR define the base managed object on which
\fIattributes\fR will be set, if not modified by the options. The
\fIattributes\fR argument is a list whose elements are a list of
attribute-type, attribute-value and an
\fImodify-operation\fRtriples. The possible \fImodify-operations\fR
are replace, addValue, removeValue and setToDefault. If no
\fImodify-operation\fR is given, than replace is used.

.RS 5
The available 
.I options
for set are:
.RE

.RS 
.TP 10

.B -scope \fIscope\fR ?-atomic?
Set the \fIscope\fR for the request. If -atomic is given, it tells the agent
to perform the request only, if it can be performed on all scoped managed
objects.

.TP
.BI "-filter " filter
Set a \fIfilter\fR on the scoped managed object(s).

.TP
.B -callback \fIcallback\fR
Specify a \fIcallback\fR that will be executed, if the result of the
asynchronous request is completely answered.

.TP
.B -nonconfirmed
The set-option may be used as a confirmed or non-confirmed service.
Default is to use the confirmed service, but if you want to use the
unconfirmed service just use -nonconfirmed as one of the options.

.RE

.TP
.B cmip# action \fIclass\fR \fIinstance\fR \fIaction\fR ?\fIoptions\fR?
Perform an action on management information at the agent (cmip#).
The \fIclass\fR and the \fIinstance\fR define the base managed object on
which the \fIaction\fR will be performed,
if not modified by the options. The \fIaction\fR is a list containing the
action-type and an optional action-value.

.RS 5
The available 
.I options
for set are:
.RE

.RS 
.TP 10

.B -scope \fIscope\fR ?-atomic?
Set the \fIscope\fR for the request. If -atomic is given, it tells the agent
to perform the request only, if it can be performed on all scoped managed
objects.

.TP
.BI "-filter " filter
Set a \fIfilter\fR on the scoped managed object(s).

.TP
.B -callback \fIcallback\fR
Specify a \fIcallback\fR that will be executed, if the result of the
asynchronous request is completely answered.

.TP
.B -nonconfirmed
The action-option may be used as a confirmed or non-confirmed service.
Default is to use the confirmed service, but if you want to use the
unconfirmed service just use -nonconfirmed as one of the options.

.RE

.TP
.B cmip# create \fIclass\fR ?\fIoptions\fR?
Create a managed object (MO) at the agent (cmip#).

.RS 5
The available 
.I options
for create are:
.RE

.RS 
.TP 10
.B -instance \fIinstance\fR | -superior \fIsuperiorInst\fR
The \fIinstance\fR specifies the object instance name, alternatively
the \fIsuperiorInst\fR specifies the object that is the parent in the
containment tree

.TP
.B -reference \fIreferenceInst\fR
The \fIreferenceInst\fR specifies a reference object instance to be used for
initial attribute values to be copied.

.TP
.B -attributes \fIattributes\fR
The \fIattributes\fR specifies initial attribute values, it contains a
list of attribute-type and attribute-value pairs.

.TP
.B -callback \fIcallback\fR
Specify a \fIcallback\fR that will be executed, if the result of the
asynchronous request is complete.
.RE

.TP
.B cmip# delete \fIclass\fR \fIinstance\fR ?\fIoptions\fR?
Delete managed object(s) at the agent (cmip#). The \fIclass\fR
and the \fIinstance\fR define the base managed object which
will be deleted,
if not modified by the options.

.RS 5
The available 
.I options
for delete are:
.RE

.RS 
.TP 10
.B -scope \fIscope\fR ?-atomic?
Set the \fIscope\fR for the request. If -atomic is given, it tells the agent
to perform the request only, if it can be performed on all scoped managed
objects.

.TP
.BI "-filter " filter
Set a \fIfilter\fR on the scoped managed object(s).

.TP
.B -callback \fIcallback\fR
Specify a \fIcallback\fR that will be executed, if the result of the
asynchronous request is complete.

.RE

.TP
.B cmip# cancelGet \fIrequestHandle\fR ?-callback callback?
Cancel the outstanding asynchronous GET request at the agent (cmip#),
given by \fIrequestHandle\fR. If a callback is given, it will be executed,
if the result of the asynchronous request is complete.

.TP
.B cmip# eventSink ?-callback callback?
Initialize a callback for event reports. If no callback is given, this
will wait for event reports till eternity and show event reports
emitted by MOs of the agent.

.TP
.B cmip# requests
The \fBcmip# requests\fR command returns a list of all outstanding
asynchronous requests.
.TP
.B cmip# wait
The \fBcmip# wait\fR command blocks until all asynchronous requests
for this association are processed. Events are processed while
waiting for outstanding responses which can have arbitrary side
effects.
.TP
.B cmip# release
The \fBcmip# release\fR command releases the association and deletes
the cmip# object. The \fBcmip# release\fR command should be the normal
way to terminate an association.
.TP
.B cmip# abort
The \fBcmip# abort\fR command aborts the association immediately and
deletes the cmip# object.

.SH BUGS
The current implementation of the \fBcmip\fR commands described above
depends on the OSIMIS package which itself depends on the ISODE
package. Both packages are no longer freely available and both
packages tend to be complicated to install.

.SH SEE ALSO
scotty(1), Tcl(n)

.SH AUTHORS
Michael Kernchen
.br
Juergen Schoenwaelder <schoenw@cs.utwente.nl>
.br
