/*
 * tnmWinPort.h --
 *
 *	This header file handles porting issues that occur because of
 *	differences between Windows and Unix. It should be the only
 *	file that contains #ifdefs to handle different flavors of OS.
 *
 * Copyright (c) 1993-1996 Technical University of Braunschweig.
 * Copyright (c) 1996-1997 University of Twente. 
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

#ifndef _TNMWINPORT
#define _TNMWINPORT

#ifndef _TNMINT
#include "tnmInt.h"
#endif

/*
 * The default directory name where we will find the Tnm library
 * files. This is normally overwritten in the Makefile. Note that
 * the Windows version will use the information in the registry
 * is available. This is only a fall through definition here.
 */

#define TKI_VERSION "1.5.0"

#ifndef TNMLIB
#define TNMLIB "c:/tcl/lib/tnm3.0.0"
#endif

#ifndef TKINEDLIB
#define TKINEDLIB "c:/tcl/lib/tkined1.5.0"
#endif

/*
 *----------------------------------------------------------------
 * Windows related defines and includes.
 *----------------------------------------------------------------
 */

#define WORDS_BIGENDIAN
#define HAVE_RPCENT

#include <malloc.h>
#include <stdio.h>

#include <ctype.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>

#include <time.h>

#include <process.h>
#include <io.h>
#include <windows.h>
#include <winsock.h>

#ifndef IN_CLASSD
#define	IN_CLASSD(i)		(((long)(i) & 0xf0000000) == 0xe0000000)
#endif

/*
 *----------------------------------------------------------------
 * Windows does not define the access modes - we add them here.
 *----------------------------------------------------------------
 */

#ifndef F_OK
#define F_OK 00
#endif
#ifndef X_OK
#define X_OK 01
#endif
#ifndef W_OK
#define W_OK 02
#endif
#ifndef R_OK
#define R_OK 04
#endif

/*
 *----------------------------------------------------------------
 * A define that we use to create Tcl_File handles on sockets.
 *----------------------------------------------------------------
 */

#define TNM_SOCKET_FD	TCL_WIN_SOCKET

#endif /* _TNMWINPORT */
