'\"
'\" Copyright (c) 1994-1996 Technical University of Braunschweig.
'\" Copyright (c) 1996-1997 University of Twente.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
.so man.macros
.TH Tnm::dns n "December 1997" Tnm "Tnm Tcl Extension"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
Tnm::dns \- Query the Domain Name System of the Internet.
.BE

.SH DESCRIPTION
The Tnm::dns command allows to query the Internet Domain Name System
(DNS) (RFC 1034, RFC 1035, RFC 974, RFC 1912) for host
information. The main purpose of this command is to convert host names
into IP addresses and vice versa. The Tnm::dns command also allows to
retrieve host information records as well as mail exchanger records.

.SH DNS COMMAND
.TP
\fbTnm::dns\fR [\fIoptions\fR]
Invoking the \fbTnm::dns\fR command with options but without any command
arguments allows to retrieve and change the default values. See the
description of supported options below. Default values are bound
to a Tcl interpreter which allows to have multiple Tcl interpreter
with different defaults.
.TP
\fbTnm::dns\fR [\fIoptions\fR] \fBaddress\fR \fIhost\fR
The \fbTnm::dns address\fR command sends a query to retrieve the address
record for the specified \fIhost\fR. The command returns the list of
IP addresses for the given host name.
.TP 
\fbTnm::dns\fR [\fIoptions\fR] \fBname\fR \fIaddress\fR
The \fbTnm::dns name\fR command sends a query to retrieve the domain name
pointer record. A pointer record maps an IP address to a fully
qualified domain name. The command returns the fully qualified
domain name for the given IP \fIaddress\fR.
.TP
\fbTnm::dns\fR [\fIoptions\fR] \fBhinfo\fR \fIname\fR
The \fbTnm::dns hinfo\fR command sends a query to retrieve the host
information (HINFO) record. The command returns a list containing two
elements. The first element describes the hardware type and the second
element the operating system.
.TP
\fbTnm::dns\fR [\fIoptions\fR] \fBmx\fR \fIname\fR
The \fbTnm::dns mx\fR command sends a query to retrieve the mail exchanger
(MX) record. The command returns a list of mail exchanger records if
\fIname\fR is a domain name for which one or more MX records exist. Each
element of this list contains a fully qualified domain name and 
its priority.
.TP
\fbTnm::dns\fR [\fIoptions\fR] \fBsoa\fR \fIname\fR
The \fbTnm::dns soa\fR command sends a query to retrieve the start of
authority record for a DNS domain. The command returns the name of the
authoritative DNS server of the DNS domain \fIname\fR.

.SH DNS OPTIONS
.TP
.BI "-server " server
The \fB-server\fR option defines the list of DNS \fIserver\fR which
will be used to process the request. The default value is the list
of default DNS server configured on the local system.
.TP
.BI "-timeout " time
The \fB-timeout\fR option defines the time the dns command will wait
for a response. The \fItime\fR is defined in seconds with a default of
2 seconds.
.TP
.BI "-retries " number
The \fB-retries\fR option defines how many times a request is
retransmitted during the timeout interval. The default \fInumber\fR of
retries is 2.  Please note, that many resolver double the last timeout
after every retry.

.SH SEE ALSO
scotty(1), Tnm(n), Tcl(n)

.SH AUTHORS
Erik Schoenfelder <schoenfr@gaertner.de>
.br
Juergen Schoenwaelder <schoenw@ibr.cs.tu-bs.de>
.br
