/*
 * tnm.h --
 *
 *	Common definitions for the Tnm Tcl extension.
 *
 * Copyright (c) 1993-1996 Technical University of Braunschweig.
 * Copyright (c) 1996-1997 University of Twente.
 * Copyright (c) 1997-1998 Technical University of Braunschweig.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

#ifndef _TNM
#define _TNM

#if defined(_WIN32) && !defined(__WIN32__)
#   define __WIN32__
#endif

#ifdef __WIN32__
#   undef USE_PROTOTYPE
#   undef HAS_STDARG
#   define USE_PROTOTYPE
#   define HAS_STDARG
#endif

/*
 *----------------------------------------------------------------
 * Here start the common definitions for the Tnm extension:
 *----------------------------------------------------------------
 */

#define TNM_VERSION "3.0.0"
#ifndef TKI_VERSION
#define TKI_VERSION "1.5.0"
#endif

#ifndef TNM_URL
#define TNM_URL	"http://wwwsnmp.cs.utwente.nl/~schoenw/scotty"
#endif

#include <tcl.h>

/*
 *----------------------------------------------------------------
 * Tcl command procedures provided by the Tnm extension:
 *----------------------------------------------------------------
 */

EXTERN int
Tnm_MapObjCmd	_ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp,
			     int objc, Tcl_Obj *CONST objv[]));
EXTERN int
Tnm_JobObjCmd	_ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp, 
			     int objc, Tcl_Obj *CONST objv[]));
EXTERN int
Tnm_MibObjCmd	_ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp, 
			     int objc, Tcl_Obj *CONST objv[]));
EXTERN int
Tnm_NetdbObjCmd	_ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp, 
			     int objc, Tcl_Obj *CONST objv[]));
EXTERN int
Tnm_SnmpObjCmd	_ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp, 
			     int objc, Tcl_Obj *CONST objv[]));
EXTERN int
Tnm_SyslogCmd	_ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp, 
			     int argc, char **argv));
EXTERN int
Tnm_UdpCmd	_ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp, 
			     int argc, char **argv));
EXTERN int
Tnm_DnsCmd	_ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp, 
			     int argc, char **argv));
EXTERN int
Tnm_NtpCmd	_ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp, 
			     int argc, char **argv));
EXTERN int
Tnm_SunrpcCmd	_ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp, 
			     int argc, char **argv));
EXTERN int
Tnm_IcmpCmd	_ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp,
			     int argc, char **argv));
EXTERN int
Tnm_InedCmd	_ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp, 
			     int argc, char **argv));

#endif /* _TNM */
