# init.tcl --
#
# Tnm initialization file. At the end of this file, we source the file
# init.tcl in the site subdirectory of the Tnm library directory. This
# is the preferred way to do site specific initializations because this
# will work even after updating the Tnm installation.
#
# Copyright (c) 1994-1996 Technical University of Braunschweig.
# Copyright (c) 1996-1997 University of Twente.
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#
# @(#) $Id: init.tcl 887 1997-11-29 20:27:33Z schoenw $

# Extend the auto_path to include $tnm(library)/library.

lappend auto_path $tnm(library)/library

# Export procedures from the Tnm namespace. This is the set of public
# Tnm commands. Additional commands might be defined by packages
# contained in the Tnm namespace. They will provide their own export
# list definitions.

namespace eval Tnm {
    namespace export dns icmp ined job map mib netdb ntp snmp
    namespace export sunrpc syslog udp
}

# Alias definitions for SNMP sessions. You can add more local 
# definitions in the site/init.tcl file.

if {[info commands ::Tnm::snmp] == "::Tnm::snmp"} {
    ::Tnm::snmp alias localhost	 "-address 127.0.0.1"
    ::Tnm::snmp alias mcasttrap	 "-address 234.0.0.1 -port 162"
    ::Tnm::snmp alias $tnm(host) "-address $tnm(host)"
}

# The global variable tnm(mibs:core) is used to hold the minimum set
# of core SNMP definitions that should be always available in most
# cases. You normally do not need to modify this list. Expect some
# unexpected results if you remove this definition.

lappend tnm(mibs:core) rfc1155.smi rfc1902.smi rfc1903.tc compat.tc 
lappend tnm(mibs:core) rfc1906.mib rfc1907.mib rfc1573.mib
lappend tnm(mibs:core) rfc2233.mib rfc1213.mib rfc1910.mib
lappend tnm(mibs:core) rfc2011.mib rfc2012.mib rfc2013.mib

# The global variable tnm(mibs) is used to hold a list of mibs that
# are auto-loaded by the tnm Tcl extension. You can extend or
# redefine this list in your site/init.tcl file, which gets
# sourced at the end of this script.

lappend tnm(mibs) rfc1269.mib rfc1238.mib rfc1757.mib

lappend tnm(mibs) rfc1315.mib rfc1381.mib rfc1382.mib

lappend tnm(mibs) rfc1406.mib rfc1407.mib rfc1414.mib
lappend tnm(mibs) rfc1461.mib rfc1471.mib rfc1472.mib rfc1473.mib 
lappend tnm(mibs) rfc1474.mib rfc1493.mib

lappend tnm(mibs) rfc1512.mib rfc1513.mib rfc1514.mib
lappend tnm(mibs) rfc1525.mib rfc1559.mib rfc1565.mib
lappend tnm(mibs) rfc1566.mib rfc1567.mib
lappend tnm(mibs) rfc1595.mib

lappend tnm(mibs) rfc1604.mib rfc1611.mib rfc1612.mib rfc1628.mib
lappend tnm(mibs) rfc1650.mib rfc1657.mib rfc1658.mib
lappend tnm(mibs) rfc1659.mib rfc1660.mib rfc1666.mib rfc1694.mib
lappend tnm(mibs) rfc1695.mib rfc1696.mib rfc1697.mib

lappend tnm(mibs) rfc1724.mib rfc1742.mib rfc1747.mib rfc1748.mib
lappend tnm(mibs) rfc1749.mib rfc1759.mib rfc1792.mib 

lappend tnm(mibs) rfc1850.mib OSPF-TRAP-MIB

lappend tnm(mibs) rfc2006.mib rfc2020.mib rfc2024.mib rfc2037.mib 
lappend tnm(mibs) rfc2051.mib rfc2096.mib

lappend tnm(mibs) rfc2108.mib rfc2127.mib rfc2128.mib rfc2155.mib

lappend tnm(mibs) rfc2206.mib rfc2213.mib rfc2214.mib rfc2238.mib rfc2239.mib

# Some local MIB fun for experimentation...

lappend tnm(mibs) tubs.mib tubs-tnm.mib tubs-nfs.mib tubs-proc.mib
lappend tnm(mibs) tubs-linux.mib

# Define a proc to handle background errors if none exists. First try
# to auto_load a definition so that we don't overwrite a definition
# provided by another package.

catch {auto_load bgerror}
if {[info commands bgerror] == ""} {
    proc bgerror {msg} {
	global errorInfo
	puts stderr $errorInfo
    }
}

# This nice procedure allows us to use static variables. It was
# posted on the net by Karl Lehenbauer. There was another one
# which does not pollute the name space, but it fails on proc
# names or variable names with spaces in it...

proc static {args} {
    set procName [lindex [info level [expr [info level]-1]] 0]
    foreach varName $args {
        uplevel 1 "upvar #0 {$procName:$varName} $varName"
    }
}

# Allow for site specific initializations. Be careful to check if this
# interpreter has a file command before using it in order to deal with
# safe Tcl interpreters.

if {[info commands file] == "file"} {
    if [file exists [file join $tnm(library) site init.tcl]] {
	source [file join $tnm(library) site init.tcl]
    }
}
