'\"
'\" Copyright (c) 1994-1996 Technical University of Braunschweig.
'\" Copyright (c) 1996-1997 University of Twente.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
.so man.macros
.TH udp n "July 1997" Tnm "Tnm Tcl Extension"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
udp \- Send and receive UDP datagrams.
.BE

.SH DESCRIPTION

The \fBudp\fR command allows to send and receive datagrams using the
User Datagram Protocol (UDP) (RFC 768).

.SH UDP COMMAND
.TP
.B udp open \fR[\fIport\fR]
The \fBudp open\fR command opens a UDP datagram socket and returns a
handle. The socket is bound to a given \fIport\fR number or name. An
unused port number is used if the \fIport\fR argument is missing.
.TP
.B udp connect \fIhost\fR \fIport\fR
The \fBudp connect\fR command opens a UDP datagram socket and connects
it to a \fIport\fR on a remote \fIhost\fR. A connected UDP socket only
allows to send messages to a single destination. This usually allows
to shorten the code since there is no need to specify the destination
address for each \fBudp send\fR command on a connected UDP socket. The
command returns a udp handle.
.TP
.B udp send \fIhandle\fR [\fIhost port\fR] \fImessage\fR
The \fBudp send\fR command sends a datagram containing \fImessage\fR
to the destination specified by \fIhost\fR and \fIport\fR. The
\fIhost\fR and \fIport\fR arguments may not be used if the UDP
\fIhandle\fR is already connected to a transport endpoint. If the UDP
handle is not connected, you must use these optional arguments to
specify the destination of the datagram.
.TP
.B udp receive \fIhandle\fR
The \fBudp receive\fR command receives a datagram from the UDP socket
associated with \fIhandle\fR. This command blocks until a datagram is
ready to be received. In most cases, it might be a good idea to check
for pending datagrams using the \fBudp bind\fR command.
.TP
.B udp close \fIhandle\fR
The \fBudp close\fR command closes the UDP socket associated with
\fIhandle\fR.
.TP
.B udp bind \fIhandle\fR readable \fR[\fIscript\fR]
.ns
.TP
.B udp bind \fIhandle\fR writable \fR[\fIscript\fR]
The \fBudp bind\fR command allows to bind scripts to a UDP
\fIhandle\fR. A script is evaluated once the UDP handle becomes either
readable or writable, depending on the third argument of the \fBudp
bind\fR command. The script currently bound to a UDP handle can be
retrieved by calling the udp bind command without a \fIscript\fR
argument. Bindings are removed by binding an empty string.
.TP
.B udp info \fR[\fIhandle\fR]
The \fBudp info\fR command without the \fIhandle\fR argument returns a
list of all existing UDP handles. Information about the state of a UDP
handle can be obtained by supplying a valid UDP \fIhandle\fR. The
result is a list containing the source IP address, the source port,
the destination IP address and the destination port.

.SH SEE ALSO
scotty(1), Tnm(n), Tcl(n)

.SH AUTHORS
Juergen Schoenwaelder <schoenw@cs.utwente.nl>
.br
