'\"
'\" Copyright (c) 1996-1997 University of Twente.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" @(#) $Id: TnmMap.n 890 1997-12-04 12:35:12Z  $
'\" 
.so man.macros
.TH TnmMap n "September 1997" Tnm "Tnm Tcl Extension"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
TnmMap \- A Tcl/Tk package for manipulating network maps.
.BE

.SH DESCRIPTION

The Tnm map(n) command provides a common infrastructure used to build
simple but powerful network management tools which can easily exchange
their configuration databases. This package extends the map(n) command
with a library Tcl procedures that are used to implement common
functions used within different applications.

.SH USING THE PACKAGE

The TnmMap package is loaded into a Tcl interpreter by using the
following sequence of Tcl commands:

.CS
package require Tnm
.br
package require TnmInet $tnm(version)
.br
package require TnmMap $tnm(version)
.CE

All the TnmMap commands live in the TnmMap namespace. You can import
these commands into the current namespace by using the following Tcl
command:

.CS
namespace import TnmMap::*
.CE

It is however suggested to import commands explicitely or to use the
full name in scripts to avoid name clashes.

.SH COMMANDS

.TP
.B TnmMap::GetIpAddress \fInode\fR
The \fBTnmMap::GetIpAddress\fR procedure returns the IP address of a
map items. It first checks whether the first element of the value of
the -address option contains a valid IP address. If not, it tries to
lookup an IP address by using the value of the -address option as an
argument to TnmInet::GetIpAddress. The next attempt is to call
TnmInet::GetIpAddress with the value of the -name option. An error is
generated if all lookup attempts fail. The \fBTnmMap::GetIpAddress\fR
procedure saves the IP address in the -address option if the lookup
was successful and the option has been empty to ensure that future
lookups are faster.

.TP
.B TnmMap::GetIpName \fInode\fR
XXX not yet documented XXX

.TP
.B TnmMap::GetSnmpSession \fInode\fR
The \fBTnmMap::GetSnmpSession\fR procedure returns an SNMP session
handle which can be used to send SNMP requests to a map item. This
procedure first checks whether the Tnm:Snmp:Alias attribute is
defined. It tries to create an SNMP session using the value of
Tnm:Snmp:Alias as an alias name if it is not empty. The procedure
looks at the attribute Tnm:Snmp:Config if the attribute Tnm:Snmp:Alias
is not defined. It tries to create an SNMP session using the value of
Tnm:Snmp:Config as a list of configuration options if it is not empty.
Finally, the procedure tries to get the IP address using the
\fBTnmMap::GetIpAddress\fR procedure and it initializes an SNMP
session with this IP address and the default parameters. Errors are
generated if the attempts to create a session fail.

.TP
.B TnmMap::DescribeNode
XXX not yet implemented XXX

.TP
.B TnmMap::MapMenu path title
XXX not yet implemented XXX

.SH SEE ALSO
scotty(1), Tnm(n), Tcl(n), map(n)

.SH AUTHORS
Juergen Schoenwaelder <schoenw@cs.utwente.nl>
.br
