'\"
'\" Copyright (c) 1994-1996 Technical University of Braunschweig.
'\" Copyright (c) 1996-1997 University of Twente.
'\" Copyright (c) 1997      Gaertner Datensysteme.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
.so man.macros
.TH Tnm::map n "July 1997" Tnm "Tnm Tcl Extension"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
Tnm::map \- Manipulate network maps.
.BE

.SH DESCRIPTION
The \fBmap\fR command allows to manipulate network maps. Network maps
describe the topology of a network which is managed by applications
based on the Tnm Tcl extension. A map is composed out of several
items.  Each item is of a specific type (e.g. node, network, port or
link).  The type defines the operations a Tcl script can perform on an
item.

.SH ATTRIBUTES
Every map and every item can have arbitrary user-defined
attributes. These attributes can be used for different purposes:

.IP 1. 3
Attributes can be used to attach useful administrative information to
network maps or items, like contact information or registration
numbers.
.IP 2. 3 
Attributes can contain parameters that are needed in order to talk to
an item, like for example parameters for SNMP sessions.
.IP 3. 3
Attributes can specify parameters that control monitoring or testing
functions. A classic example is an attribute which allows to define
the interface speed in case the interface speed reported by an SNMP
agent does not match reality.
.IP 4. 3
Attributes can store temporary information that is needed by
monitoring or testing functions in order to complete their job.

.PP
An attribute naming convention is used to make sure that attributes
can be used for all these purposes without the risk to run into name
clashes. Attributes are grouped into persistent and non-persistent
attributes. (Persistent attributes are saved with a network map while
non-persistent attributes are ignored.)

Attribute names may only consist of uppercase and lowercase letters,
digits and the symbol `:'. Persistent attribute names use the
following naming scheme:

	[Scope]:Name[:Qualifier]*

A persistent attribute name usually starts with a scope name, which is
a capitalized string. An attribute name, which must be capitalized, is
said to be global if the scope name is missing. (This means that the
name starts with a colon.)  The name can be followed by multiple
qualifiers, where each qualifier is separated by a colon. Examples of
persistent attribute names are:

.CS
:Contact
Icmp:Timeout
Tnm:Monitor:ifSpeed:1
.CE

.PP 
Non-persistent attributes have no restriction, except that they are
not allowed to start with a capital letter or a colon. It is however
recommended to qualify non-persistent names with a common prefix in
order to avoid name clashes.

.SH EVENTS
Network maps support an event driven programming style where the
functions to test or monitor properties of map items are separated
from the code that handles the results. A test or monitoring function,
which might be running periodically in the background, generates
events that are either associated with a map item or with the map as a
whole. Events have an event tag which is used to describe the event
type (e.g. Tnm:Error:Snmp:noResponse). It is suggested to use the same
naming conventions for event tags which are described above in the
paragraph about persistent attribute names.

.SH BINDINGS
Events can trigger event bindings, which allow to execute arbitrary
Tcl commands. Event bindings are either associated with an item or
with a complete map. A binding is defined by a pattern, which is
matched against event tags. The match uses the same rules as described
for the Tcl string match command. The body of an event binding is a
Tcl script, which is executed in global context whenever an event tag
matches the binding pattern.

Events that are associated with a map item will first trigger all
event bindings for that particular item. Afterwards, the event will be
passed to the parent item (if any). Once the event has reached the
root item, the event will be passed to the network map. Events that
are associated with a network map will only trigger the event bindings
defined for that particular map.

The processing of event bindings can be controlled by returning a
break or continue return code from the script. A break return code
will stop event processing. A continue return code will stop event
processing for the current item and immediately start with the
bindings defined for the parent item (if any) or for the whole map.

Event details can be accessed in the script which is bound to an event
by means of % substitutions. These substitutions happen before the
script is passed to the Tcl interpreter. The following substitutions
are defined:

.IP \fB%%\fR 5
Replaced with a single percent.
.IP \fB%A\fR 5
Replaced with the event arguments.
.IP \fB%B\fR 5
Replaced with the handle for the binding that matched the event tag.
.IP \fB%E\fR 5
Replaced with the unique handle for the event.
.IP \fB%I\fR 5
Replaced with the handle for the item or an empty string if the
event is generated for a map.
.IP \fB%M\fR 5
Replaced with the handle for the map.
.IP \fB%N\fR 5
Replaced with the event name that triggered the binding.
.IP \fB%P\fR 5
Replaced with the pattern that matched the event tag.

.SH MESSAGES
Messages can be attached to maps or map items. A message consists of a
time-stamp, a time interval, a tag and a text string. Messages are
only kept for a short period in memory. Messages can also be saved in
files. Every message is prepended with the message time-stamp and the
message interval.

Messages are saved in files if two conditions are met. First, the
associated item or map must have a non-empty \fI-path\fR
option. Second, the message tag must match one of the pattern
contained in the value of the \fI-store\fR option. The \fI-store\fR
option is a convenient way to select which messages go to a file and
which not.

The file name is derived from the value of the \fI-path\fR option. It
is constructed from the \fI-path\fR value by appending a subdirectory
for the current day and the message tag as a file name. The message
text itself is prepended by the time-stamp (in seconds), a tab
character, the time interval, another tab character and appended to
the file. New directories are created on the fly if needed.

As an example, lets assume we have a map where the \fI-path\fR option
has the value /tmp/yourmap and the \fI-store\fR option contains the
list element "ifload*". A message is generated on May 27th, 1997 with
the tag ifload-3 and the text "52". This message will be appended to
the file /tmp/yourmap/1997-05-27/ifload-3.

Messages provide a convenient mechanism to collect statistics.
However, message files can consume quite a bit of disk space. No
attempts are made to compress raw message files and there are
currently no commands to read and process them later via Tcl in a
convenient way. Compression, data reduction or analysis of the
statistics should be done by specialized programs which are run
periodically.

.SH MAP COMMAND
.TP
.B map create \fR[\fIoption value\fR ...]
The \fBmap create\fR command is used to create network maps. The
command returns a handle which can be used to manipulate the new
map. A Tcl interpreter is able to control an arbitrary number of map
instances.
.TP
.B map info
The \fBmap info\fR command returns the list of all existing network
maps in the current interpreter.
.TP
.B map types
The \fBmap types\fR command returns the list of item types supported
by the network map. New item types can be added by loading modules
written in the C language.

.SH MAP INSTANCE COMMANDS
.TP
.B map# attribute \fR[\fIname\fR [\fIvalue\fR]]
The \fBmap# attribute\fR command allows to save map specific data in
map attributes. If called without any arguments, all existing
attribute names for this map will be returned. If called with a
\fIname\fR argument, the current value of the attribute will be
returned. Non-existing attributes do not produce an error. Instead, an
empty string is returned. Evaluating the \fBmap# attribute\fR command
with a \fIname\fR and a \fIvalue\fR argument causes the \fIvalue\fR to
be saved in the map attribute \fIname\fR.
.TP
.B map# bind \fIpattern script\fR 
The \fBmap# bind\fR command binds a Tcl script to an event.  A binding
is created by evaluating this command with a \fIpattern\fR which is
later matched against event tags. A successful match will trigger the
evaluation of the Tcl \fIscript\fR bound to the \fIpattern\fR. Pattern
matching is done as described in the documentation for the Tcl string
match command. It is possible to create multiple bindings for the same
pattern. The \fBmap# bind\fR command returns a handle for the new
binding.
.TP
.B map# cget \fIoption\fR
The \fBmap# cget\fR command retrieves the value of a map option given
by \fIoption\fR. See the description of map options below for more
details.
.TP
.B map# clear
The \fBmap# clear\fR command re-initializes the map into an empty
state. All data currently associated with the map is deleted.
.TP
.B map# configure \fR[\fIoption value\fR ...]
The \fBmap# configure\fR command allows to query or change the current
configuration options of a map instance. See the description of map 
options below for more details.
.TP
.B map# copy \fIitems\fR
The \fBmap copy\fR command copies a Tcl script on the internal
clipboard buffer which can be used to create a clone of the
\fIitems\fR. The internal clipboard buffer is shared between all maps
in the running process. It can therefore be used to copy objects
between maps.
.TP
.B map# create \fItype \fR[\fIoption value\fR ...]
The \fBmap# create\fR command allows to create a new item of the given
\fItype\fR. It returns a handle which can be used later to manipulate
the new item. Item type specific options can be passed as part of the
\fBmap# create\fR command in order to initialize the new item.
Consult the item type specific option description for a list of valid
options.
.TP
.B map# destroy
The \fBmap# destroy\fR command destroys the map. All data associated
with the map is deleted. No attempts are made to save the contents of
the map. It is the responsibility of the script to save the map before
destroying it.
.TP
.B map# dump
The \fBmap dump\fR command returns a Tcl script which can be evaluated
to create a copy of the current map.
.TP
.B map# find \fR[\fB-type \fItype\fR] \fR[\fB-name \fIname\fR] \fR[\fB-address \fIaddress\fR] \fR[\fB-tags \fIpatternList\fR] \fR[\fB-sort \fImode\fR] \fR[\fB-order \fIdirection\fR]
The \fBmap# find\fR command retrieves a list of item handles that
match the search options. If no options are present, a list of all
items on the network map is returned. The \fB-type\fR option restricts
this list to those items of a given \fItype\fR.  The \fB-name\fR and
\fB-address\fR options restrict the list to all those items, where the
name or address matches the given \fIname\fR or \fIaddress\fR
pattern. The \fB-tags\fR option matches the tag associated with an
item against the pattern contained in the \fIpatternList\fR.  Matching
is done according to the rules defined for the Tcl string match
command. The \fB-sort\fR option sorts the output according to a given
sort \fImode\fR. Valid sort modes are mtime and ctime. The sorting
order can be specified by setting the \fB-order\fR option to
increasing or decreasing. Increasing sort order is the default.
.TP
.B map# info \fIsubject ?pattern?\fR 
The \fBmap# info\fR command returns the list of handles that are
related to this map. The optional \fIpattern\fR is used to select a
subset. The subject \fIevents\fR returns the events associated with
the map. The \fIpattern\fR is matched against the event name. The
subject \fImessages\fR returns the message handles associated with the
map. The \fIpattern\fR is matched agains the message tag. The subject
\fIbindings\fR returns the list of binding handles for the map. The
\fIpattern\fR is matched agains the binding pattern.
.TP
.B map# load \fIchannel\fR
The \fBmap load\fR command loads a map from a Tcl \fIchannel\fR, which
might point to a previously opened file or a network connection. This
command actually merges the items since existing items are not
removed or overwritten. The use of a channel allows to load maps in safe 
Tcl interpreters by passing the channel from a trusted Tcl interpreter to
a safe Tcl interpreter.
.TP
.B map# message \fR[\fB-interval \fIsec\fR] \fR[\fB-health \fIvalue\fR] \fItag\fR \fItext\fR 
The \fBmap# message\fR command creates a message which contains the
given \fItext\fR. The message is kept in memory until it expires.
Messages might be appended to files if the message \fItag\fR matches
one of the patterns contained in the value of the \fI-store\fR map
option and if the value -f the \fI-path\fR map option is not empty.

Message are used to report statistics or events. Every message is
automatically augmented with a time-stamp. However, many statistics or
events are bound to a time interval. The \fB-interval\fR option allows
to specify such a time interval in seconds. The interval value is set
to 0 if this option is missing.

Messages can also be used to influence the health of the map. The
\fIvalue\fR of the \fB-health\fR option must be in the range of
-100..100 and indicates a negative or positive health change. The
exact computation of the health of the map uses these indications to
derive a new health value whenever the map ticks. The health value
is be set to 0 if this option is missing.
.TP
.B map# paste
The \fBmap paste\fR command evaluates the Tcl script found on the
internal clipboard buffer. This creates a clone of the items that have
been previously copied on the clipboard.
.TP
.B map# raise \fItag\fR \fR[\fIargs\fR] 
The \fBmap# raise\fR command raises an event on the map. The event
type is identified by the string \fItag\fR. Additional arguments,
which describe event details, can be supplied in the optional
\fIargs\fR parameter. The \fBmap# raise\fR command returns a handle
for the new event. This handle can be used later to retrieve
information about this specific event or to delete this event.
.TP
.B map# save \fIchannel\fR
The \fBmap save\fR command writes a Tcl script to the given
\fIchannel\fR, which, when evaluated, re-generates the current network
map. The save command makes it possible to write a map from a safe Tcl
interpreter to a channel provided by a trusted interpreter, if the
channel is shared between both interpreters.
.TP
.B map# update
The \fBmap update\fR command processes all pending updates. This
includes removal of events or messages that have expired.


.SH MAP OPTIONS
The following options control parameters of a network map object.

.TP
.BI "-expire " seconds
The \fB-expire\fR option defines the default lifetime for events and
messages in seconds.  Events and messages are removed from the event
history automatically if the \fB-tick\fR option is greater than zero
and the lifetime of the event or message has expired.
.TP
.BI "-height " height
The \fB-height\fR option defines the \fIheight\fR of the map
in terms of virtual pixels.
.TP
.BI "-name " name
The \fB-name\fR option defines the \fIname\fR of the map.
.TP
.BI "-path " path
The \fB-path\fR option defines the path in the file system, where map
statistics will be stored. All statistic files are maintained in a
sub-directory, which is used to group together all statistics of a
particular day.
.TP
.BI "-store " patternList
The \fB-store\fR option is used to maintain a list of message tag
pattern that are used to control whether a message is written to a
file or not. Each element of the \fIpatternList\fR is matched against
a message tag. A positive match will cause the message to be saved
in a file.
.TP
.BI "-tick " interval
The \fB-tick\fR option defines the tick interval in seconds. The map
implementation updates internal data every time the tick interval has
passed. Internal operations include the update of the health of all
map items or the expiration of events or messages. Setting the tick 
interval to 0 means that no internal updates will be performed.

A tick interval of 0 may result in a serious memory leak if events or
messages are generated frequently. The default value for the tick
interval is 60 seconds.
.TP
.BI "-width " width
The \fB-width\fR option defines the \fIwidth\fR of the map
in terms of virtual pixels.

.SH EVENT INSTANCE COMMANDS
The following commands can be used to query event objects for
event specific parameters. Note that event objects can disappear
automatically if their lifetime expires. These commands are read-only
in the sense that you can not modify an existing event other than
deleting it.

.TP
.B event# args
The \fBevent# args\fR command returns the argument string that was
passed to a \fBmap# raise\fR or \fBitem# raise\fR command when the
event was created.
.TP
.B event# destroy 
The \fBevent# destroy\fR command destroys the event object.
.TP
.B event# item
The \fBevent# item\fR command returns the item which is associated
with the event. An empty string is returned if the event is not
associated with an item.
.TP
.B event# map
The \fBevent# map\fR command returns the map which is associated with
the event. If the event is associated with an item, the map which owns
the item will be returned.
.TP
.B event# tag
The \fBevent# tag\fR command returns the string which is used to
identify the event type. This is the same string which has been used
when the event was created by a \fBmap# raise\fR or \fBitem# raise\fR
command.
.TP
.B event# time
The \fBevent# time\fR command returns the date and time when this
event was generated as a system-dependent integer value. The
resolution of the event timestamp is seconds.  The value has the same
properties as timestamps returned by the Tcl clock seconds command.
.TP
.B event# type
The \fBevent# type\fR command returns the type of the event object,
which is always the string "event".

.SH BINDING INSTANCE COMMANDS
The commands described in this section allow to query event bindings
for their parameters. These commands are read-only in the sense that
you can not modify an existing binding other than deleting it.

.TP
.B bind# destroy
The \fBbind# destroy\fR command destroys the binding object.
.TP
.B bind# item
The \fBbind# item\fR command returns the item which is associated
with the binding. An empty string is returned if the binding is not
associated with an item.
.TP
.B bind# map
The \fBbind# map\fR command returns the map which is associated with
the binding. If the binding is associated with an item, the map which
owns the item will be returned.
.TP
.B bind# pattern
The \fBbind# pattern\fR returns the pattern that is matched against
event tags. This is the same string that was passed to a \fBmap#
bind\fR or \fBitem# bind\fR command when the binding was created.
.TP
.B bind# script
The \fBbind# script\fR returns the script that is associated with the
event binding. This is the script parameter that was passed to a
\fBmap# bind\fR or \fBitem# bind\fR command when the binding was
created.
.TP
.B bind# type
The \fBbind# type\fR command returns the type of the binding object,
which is always the string "binding".

.SH MESSAGE INSTANCE COMMANDS
The following commands can be used to query message objects for
message specific parameters. Note that message objects can disappear
automatically if their lifetime expires. These commands are read-only
in the sense that you can not modify an existing message other than
deleting it.

.TP
.B message# destroy 
The \fBmessage# destroy\fR command destroys the message object.
.TP
.B message# health
The \fBmessage# health\fR command returns the health change value
of the message object in the range -100..100.
.TP
.B message# interval
The \fBmessage# interval\fR command returns the time interval associated
with the message object in seconds.
.TP
.B message# item
The \fBmessage# item\fR command returns the item which is associated
with the message. An empty string is returned if the message is not
associated with an item.
.TP
.B message# map
The \fBmessage# map\fR command returns the map which is associated with
the message. If the message is associated with an item, the map which owns
the item will be returned.
.TP
.B message# tag
The \fBmessage# tag\fR command returns the string which is used to
identify the message type. This is the same string which has been used
when the message was created.
.TP
.B message# text
The \fBmessage# text\fR command returns the argument string that was
passed when the message was created.
.TP
.B message# time
The \fBmessage# time\fR command returns the date and time when this
message was generated as a system-dependent integer value. The
resolution of the message timestamp is seconds.  The value has the
same properties as timestamps returned by the Tcl clock seconds
command.
.TP
.B message# type
The \fBmessage# type\fR command returns the type of the message object,
which is always the string "message".

.SH COMMON ITEM COMMANDS
This section describes commands that are common to most item
types. The sections that describe particular item types define the
subset of these common item commands applicable to a particular item
type.

.TP
.B item# attribute \fR[\fIname\fR [\fIvalue\fR]]
The \fBitem# attribute\fR command allows to save item specific data in
item attributes. If called without any arguments, all existing
attribute names for this item will be returned. If called with a
\fIname\fR argument, the current value of the attribute will be
returned. Non-existing attributes do not produce an error. Instead, an
empty string is returned. Evaluating the \fBitem# attribute\fR command
with a \fIname\fR and a \fIvalue\fR argument causes the \fIvalue\fR to
be saved in the item attribute \fIname\fR.
.TP
.B item# bind \fIpattern script\fR
The \fBitem# bind\fR command binds a Tcl script to an event.  A
binding is created by evaluating this command with a \fIpattern\fR
which is later matched against event tags. A successful match will
trigger the evaluation of the Tcl \fIscript\fR bound to the
\fIpattern\fR. Pattern matching is done as described in the
documentation for the Tcl string match command. It is possible to
create multiple bindings for the same pattern. The \fBitem# bind\fR
command returns a handle for the new binding.
.TP
.B item# cget \fIoption\fR
The \fBitem# cget\fR command retrieves the value of an item option
given by \fIoption\fR. See the description of item options below for
more details.
.TP
.B item# configure \fR[\fIoption value\fR ...]
The \fBitem# configure\fR command allows to query or change the current
configuration options of a item instance. See the description of item 
options below for more details.
.TP
.B item# destroy
The \fBitem# destroy\fR command destroys the item. All data associated
with the item is deleted.
.TP
.B item# dump
The \fBitem dump\fR command returns a Tcl script which can be
evaluated to create a copy of the current item.
.TP
.B item# info \fIsubject ?pattern?\fR
The \fBitem# info\fR command returns the list of handles that are
related to this item. The optional \fIpattern\fR is used to select a
subset. The subject \fIevents\fR returns the events associated with
the item. The \fIpattern\fR is matched against the event name. The
subject \fImessages\fR returns the message handles associated with the
item. The \fIpattern\fR is matched agains the message tag. The subject
\fIbindings\fR returns the list of binding handles for the item. The
\fIpattern\fR is matched agains the binding pattern. The subject
\fImember\fR, which is only supported by container objects, returns
the list of members of this item. The pattern is ignored in this
case.
.TP
.B item# map
The \fBitem# map\fR command returns the map which controls this
item. Items are always associated with a single map and items can
not move directly from one map to another.
.TP
.B item# message \fR[\fB-interval \fIsec\fR] \fR[\fB-health \fIvalue\fR] \fItag message\fR
The \fBitem# message\fR command creates a message which contains the
given \fItext\fR. The message is kept in memory until it expires.
Messages might be appended to files if the message \fItag\fR matches
one of the patterns contained in the value of the \fI-store\fR item
option and if the value -f the \fI-path\fR item option is not empty.

Message are used to report statistics or events. Every message is
automatically augmented with a time-stamp. However, many statistics or
events are bound to a time interval. The \fB-interval\fR option allows
to specify such a time interval in seconds. The interval value is set
to 0 if this option is missing.

Messages can also be used to influence the health of the item. The
\fIvalue\fR of the \fB-health\fR option must be in the range of
-100..100 and indicates a negative or positive health change. The
exact computation of the health of the item uses these indications to
derive a new health value whenever the item ticks. The health value
is be set to 0 if this option is missing.
.TP
.B item# move \fR[\fIx y\fR]
The \fBitem# move\fR command moves the item from the current position
on the virtual map by adding \fIx\fR and \fIy\fR to the current
position. The command returns the new position as a list containing
the x and the y position. The \fIitem# move\fR command only returns
the current position if the optional arguments are missing.
.TP
.B item# parent
The \fBitem# parent\fR command returns the item which contains the
current item. This command returns an empty string if the current item
is not contained in any other item.
.TP
.B item# raise \fItag\fR \fR[\fIargs\fR]
The \fBitem# raise\fR command raises an event on the item. The event
type is identified by the string \fItag\fR. Additional arguments,
which describe event details, can be supplied in the optional
\fIargs\fR parameter. The \fBitem# raise\fR command returns a handle
for the new event. This handle can be used later to retrieve
information about this specific event or to delete this event.
.TP
.B item# type
The \fBitem# type\fR command returns the type of an item. See below
for a description of item types.


.SH COMMON ITEM OPTIONS
This section describes common item options. The sections that describe
particular item types define the subset of these options applicable to
a particular item type.

.TP
.BI "-address " address
The \fB-address\fR option defines the \fIaddress\fR of the item. No
assumptions are made by the Tnm map implementation about the format
and the semantics of the address. Scripts that interpret the value of
a \fB-address\fR option should carefully check whether the format is
acceptable.
.TP
.BI "-color " color
The \fB-color\fR option gets or sets the color of the item. No
assumptions are made on the format of the \fIcolor\fR value. It is
however suggested to use Tk color names.
.TP
.BI "-ctime " time
The \fB-ctime\fR option gives access to the creation date and time as
a system-dependent integer value. The resolution of the creation time
is seconds. The value has the same properties as time-stamps returned
by the Tcl clock seconds command. This option is read-only because the
creation time-stamp is maintained entirely by the map implementation.
.TP
.BI "-expire " seconds
The \fB-expire\fR option defines the default lifetime for events and
messages in seconds.  Events and messages are removed from the event
history automatically if the \fB-tick\fR option is greater than zero
and the lifetime of the event or message has expired.
.TP
.BI "-font " font
The \fB-font\fR option gets or sets the font of the item. No
assumptions are made on the format of the \fIfont\fR value. It is
however suggested to use Tk font names.
.TP
.BI "-group " group
The \fB-group\fR option is used to make the item a member of the group
\fIgroup\fR. Setting this option to an empty string removes the
calling item from the \fIgroup\fR.
.TP
.BI "-icon " icon
The \fB-icon\fR option gets or sets the icon associated with an item.
No assumptions are made on the format of the \fIicon\fR value.
.TP
.BI "-mtime " time
The \fB-mtime\fR option gives access to the last modification date and
time as a system-dependent integer value. The resolution of the
modification time is seconds. The value has the same properties as
time-stamps returned by the Tcl clock seconds command. This option is
read-only because the modification time-stamp is maintained entirely
by the map implementation.
.TP
.BI "-name " name
The \fB-name\fR option defines the \fIname\fR of the item. No
assumptions are made by the Tnm map implementation about the format
and the semantics of the name. Scripts that interpret the value of a
\fB-name\fR option should carefully check whether the format is
acceptable.
.TP
.BI "-path " path
The \fB-path\fR option defines the path in the file system, where item
statistics will be stored. All statistic files are maintained in a
sub-directory, which is used to group together all statistics of a
particular day.
.TP
.BI "-store " patternList
The \fB-store\fR option is used to maintain a list of message tag
pattern that are used to control whether a message is written to a
file or not. Each element of the \fIpatternList\fR is matched against
a message tag. A positive match will cause the message to be saved in
a file.
.TP
.BI "-tags " tagList
The \fB-tags\fR option is used to tag items. Tags are a convenient way
to group items together to form target sets for management operations.
For example, one might want to tag all routers with the tag "router"
and all devices from vendor acme with "acme". The \fBmap# find\fR
command can later be used to retrieve all "routers" from vendor
"acme".


.SH NODE ITEMS

Node items are used to model network elements like bridges, router,
switches, or end-systems. Node systems can contain several port items
which interface to other objects.

.SH PORT ITEMS

Port items are always associated to a node item and represent an
interface to other objects. A common usage of port objects is to
represent interfaces on a router. Ports can also be used to represent
ends of ATM VPCs or ports on an Ethernet bridge. A port item can be
the source or destination of a link object which connects the port to
other ports or networks.

.SH NETWORK ITEMS

Network items represent transmission networks like e.g an Ethernet
segment, an X.25 or an ATM connection. A network object might also
represent a complex network if there is no need to have more detailed
information available. It is up to the application to determine the
required level of detail.

.SH LINK ITEMS

Node items are connected to other items by means of link items. A link
item connects a port item to another port item or a network item. It
is therefore not possible to connect to networks with a single link
item. It is also not possible to connect a node with another node or a
network without attaching a port object to the node.

.SH GROUP ITEMS

Group items are container items that can contain a set of other items,
including other group items. However, the containment structure must
form a hierarchy. It is not allowed to have a group which directly or
indirectly contains itself. It is however allowed, that a single item
is a member of several different groups.

.SH TODO

There are some item type specific options and commands that are not
yet documented. The current version also does a poor job to clearly
describe which option and command is supported by which item type.

.SH SEE ALSO
scotty(1), Tnm(n), Tcl(n)

.SH AUTHORS
Juergen Schoenwaelder <schoenw@cs.utwente.nl>
.br
