/*
 * Decompiled with CFR 0.152.
 */
package ua.co.k.strftime.formatters;

import java.time.DayOfWeek;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjusters;
import java.util.Locale;
import ua.co.k.strftime.formatters.HybridFormat;

class WeeksInYearFormat
extends HybridFormat {
    private final DayOfWeek firstDayOfWeek;
    private final DayOfWeek mustInclude;
    private final boolean preFirstAsZero;

    public WeeksInYearFormat(DayOfWeek dayOfWeek, DayOfWeek mustInclude, boolean preFirstAsZero) {
        super(false);
        this.firstDayOfWeek = dayOfWeek;
        this.mustInclude = mustInclude;
        this.preFirstAsZero = preFirstAsZero;
    }

    @Override
    protected String doFormat(Object obj, int padWidth, boolean strict, Locale locale) {
        long between;
        boolean actuallyPreFirst;
        if (!(obj instanceof Temporal)) {
            throw new IllegalArgumentException("given parameter is not a Temporal and cannot be adjusted to it");
        }
        if (!(obj instanceof Comparable)) {
            throw new IllegalArgumentException("given parameter cannot be compared, and so, it cannot be anything that contains week in it");
        }
        Temporal tObj = (Temporal)obj;
        Temporal firstDayOfThisYear = ((Temporal)this.cast(obj)).with(TemporalAdjusters.firstDayOfYear());
        Temporal startOfFirstWeekInMonth = this.getStartOfFirstWeekInYear(firstDayOfThisYear);
        boolean bl = actuallyPreFirst = ((Comparable)((Object)((Temporal)this.cast(startOfFirstWeekInMonth)))).compareTo(this.cast(obj)) > 0;
        if (actuallyPreFirst && this.preFirstAsZero) {
            between = 0L;
        } else {
            if (actuallyPreFirst) {
                int currentYear = firstDayOfThisYear.get(ChronoField.YEAR);
                firstDayOfThisYear = firstDayOfThisYear.with(ChronoField.YEAR, currentYear - 1).with(TemporalAdjusters.firstDayOfYear());
                startOfFirstWeekInMonth = this.getStartOfFirstWeekInYear(firstDayOfThisYear);
            }
            between = ChronoUnit.WEEKS.between(startOfFirstWeekInMonth, tObj) + 1L;
        }
        return HybridFormat.padWithZeros(String.valueOf(between), 2);
    }

    private Temporal getStartOfFirstWeekInYear(Temporal firstOfThisYear) {
        Temporal startOfFirstWeekInMonth;
        if (this.mustInclude == null) {
            startOfFirstWeekInMonth = firstOfThisYear.with(TemporalAdjusters.dayOfWeekInMonth(1, this.firstDayOfWeek));
        } else {
            Temporal firstRequiredDay = firstOfThisYear.with(TemporalAdjusters.dayOfWeekInMonth(1, this.mustInclude));
            startOfFirstWeekInMonth = firstRequiredDay.with(ChronoField.DAY_OF_WEEK, 1L);
        }
        return startOfFirstWeekInMonth;
    }

    private <T extends Comparable & Temporal> T cast(Object obj) {
        return (T)((Comparable)obj);
    }
}

