/*
 * Decompiled with CFR 0.152.
 */
package ua.co.k.strftime.formatters;

import java.time.DayOfWeek;
import java.time.temporal.ChronoField;
import java.util.HashMap;
import java.util.Map;
import ua.co.k.strftime.LiteralPattern;
import ua.co.k.strftime.formatters.CenturyDateFormat;
import ua.co.k.strftime.formatters.DayOfWeekFormat;
import ua.co.k.strftime.formatters.FractionalSecondsFormat;
import ua.co.k.strftime.formatters.FromTemporalFieldFormat;
import ua.co.k.strftime.formatters.FromTemporalFieldWithPaddingFormat;
import ua.co.k.strftime.formatters.HybridFormat;
import ua.co.k.strftime.formatters.ISO8601WeekInYearFormat;
import ua.co.k.strftime.formatters.PatternFormat;
import ua.co.k.strftime.formatters.SwitchCaseDateWrapperFormat;
import ua.co.k.strftime.formatters.WeeksInYearFormat;
import ua.co.k.strftime.formatters.ZoneOffsetFormat;

public class DateTimeFormatterFactory {
    static final Map<Character, HybridFormat> translate = new HashMap<Character, HybridFormat>();

    public HybridFormat getFormatter(int strftimePatternCodepoint) {
        return translate.get(Character.valueOf((char)strftimePatternCodepoint));
    }

    public boolean isKnownConversion(int codepoint) {
        if (codepoint > 65535) {
            return false;
        }
        return translate.containsKey(Character.valueOf((char)codepoint));
    }

    public static void override(Character conversion, HybridFormat newFormat) {
        translate.put(conversion, newFormat);
    }

    public boolean needZoneFormatWithColumns(HybridFormat targetFormatter, int zoneColumns) {
        return targetFormatter instanceof ZoneOffsetFormat && zoneColumns > 0;
    }

    public HybridFormat zoneFormatWithColumns(int zoneColumns) {
        return new ZoneOffsetFormat(zoneColumns);
    }

    static {
        translate.put(Character.valueOf('a'), new PatternFormat("EEE", false));
        translate.put(Character.valueOf('A'), new PatternFormat("EEEE", false));
        translate.put(Character.valueOf('b'), new PatternFormat("MMM", false));
        translate.put(Character.valueOf('B'), new PatternFormat("MMMM", false));
        translate.put(Character.valueOf('c'), new PatternFormat("EEE MMM d HH:mm:ss yyyy", true));
        translate.put(Character.valueOf('C'), new CenturyDateFormat());
        translate.put(Character.valueOf('d'), new PatternFormat("dd", false));
        translate.put(Character.valueOf('D'), new PatternFormat("MM/dd/yy", true));
        translate.put(Character.valueOf('e'), new PatternFormat("d", false));
        translate.put(Character.valueOf('F'), new PatternFormat("yyyy-MM-dd", true));
        translate.put(Character.valueOf('g'), new PatternFormat("yy", false));
        translate.put(Character.valueOf('G'), new PatternFormat("yyyy", false));
        translate.put(Character.valueOf('h'), new PatternFormat("MMM", false));
        translate.put(Character.valueOf('H'), new PatternFormat("HH", false));
        translate.put(Character.valueOf('I'), new PatternFormat("hh", false));
        translate.put(Character.valueOf('j'), new FromTemporalFieldWithPaddingFormat(ChronoField.DAY_OF_YEAR, new FromTemporalFieldWithPaddingFormat.Padding('0', 3)));
        translate.put(Character.valueOf('k'), new FromTemporalFieldWithPaddingFormat(ChronoField.HOUR_OF_DAY, new FromTemporalFieldWithPaddingFormat.Padding(' ', 2)));
        translate.put(Character.valueOf('l'), new FromTemporalFieldWithPaddingFormat(ChronoField.CLOCK_HOUR_OF_AMPM, new FromTemporalFieldWithPaddingFormat.Padding(' ', 2)));
        translate.put(Character.valueOf('L'), new FromTemporalFieldWithPaddingFormat(ChronoField.MILLI_OF_SECOND, new FromTemporalFieldWithPaddingFormat.Padding('0', 3)));
        translate.put(Character.valueOf('m'), new PatternFormat("MM", false));
        translate.put(Character.valueOf('M'), new PatternFormat("mm", false));
        translate.put(Character.valueOf('n'), new LiteralPattern("\n"));
        translate.put(Character.valueOf('N'), new FractionalSecondsFormat());
        translate.put(Character.valueOf('p'), new PatternFormat("a", false));
        translate.put(Character.valueOf('P'), new SwitchCaseDateWrapperFormat(new PatternFormat("a", false), false));
        translate.put(Character.valueOf('r'), new PatternFormat("hh:mm:ss a", true));
        translate.put(Character.valueOf('R'), new PatternFormat("HH:mm", true));
        translate.put(Character.valueOf('s'), new FromTemporalFieldFormat(ChronoField.INSTANT_SECONDS));
        translate.put(Character.valueOf('S'), new PatternFormat("ss", false));
        translate.put(Character.valueOf('t'), new LiteralPattern("\t"));
        translate.put(Character.valueOf('T'), new PatternFormat("HH:mm:ss", true));
        translate.put(Character.valueOf('u'), new FromTemporalFieldFormat(ChronoField.DAY_OF_WEEK));
        translate.put(Character.valueOf('U'), new WeeksInYearFormat(DayOfWeek.SUNDAY, null, true));
        translate.put(Character.valueOf('v'), new SwitchCaseDateWrapperFormat(new PatternFormat("d-MMM-yyyy", true), true));
        translate.put(Character.valueOf('V'), new ISO8601WeekInYearFormat());
        translate.put(Character.valueOf('w'), new DayOfWeekFormat(DayOfWeek.SUNDAY, 0));
        translate.put(Character.valueOf('W'), new WeeksInYearFormat(DayOfWeek.MONDAY, null, true));
        translate.put(Character.valueOf('x'), new PatternFormat("MM/dd/yy", true));
        translate.put(Character.valueOf('X'), new PatternFormat("HH:mm:ss", true));
        translate.put(Character.valueOf('y'), new PatternFormat("yy", false));
        translate.put(Character.valueOf('Y'), new PatternFormat("yyyy", false));
        translate.put(Character.valueOf('z'), new ZoneOffsetFormat());
        translate.put(Character.valueOf('Z'), new PatternFormat("zzzz", false));
        translate.put(Character.valueOf('%'), new LiteralPattern("%"));
    }
}

