/*
 * Decompiled with CFR 0.152.
 */
package liqp.tags;

import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.Map;
import liqp.TemplateContext;
import liqp.nodes.LNode;
import liqp.tags.Tag;

class Tablerow
extends Tag {
    private static final String COLS = "cols";
    private static final String LIMIT = "limit";
    private static final String TABLEROWLOOP = "tablerowloop";
    private static final String LENGTH = "length";
    private static final String INDEX = "index";
    private static final String INDEX0 = "index0";
    private static final String RINDEX = "rindex";
    private static final String RINDEX0 = "rindex0";
    private static final String FIRST = "first";
    private static final String LAST = "last";
    private static final String COL = "col";
    private static final String COL0 = "col0";
    private static final String COL_FIRST = "col_first";
    private static final String COL_LAST = "col_last";

    Tablerow() {
    }

    @Override
    public Object render(TemplateContext context, LNode ... nodes) {
        String valueName = super.asString(nodes[0].render(context));
        Object[] collection = super.asArray(nodes[1].render(context));
        LNode block = nodes[2];
        Map<String, Integer> attributes = this.getAttributes(collection, 3, context, nodes);
        int cols = attributes.get(COLS);
        int limit = attributes.get(LIMIT);
        HashMap<String, Constable> tablerowloopContext = new HashMap<String, Constable>();
        tablerowloopContext.put(LENGTH, Integer.valueOf(collection.length));
        context.put(TABLEROWLOOP, tablerowloopContext);
        StringBuilder builder = new StringBuilder();
        int total = Math.min(collection.length, limit);
        if (total == 0) {
            builder.append("<tr class=\"row1\">\n</tr>\n");
        } else {
            int i = 0;
            int c = 1;
            int r = 0;
            while (i < total) {
                context.incrementIterations();
                context.put(valueName, collection[i]);
                tablerowloopContext.put(INDEX0, Integer.valueOf(i));
                tablerowloopContext.put(INDEX, Integer.valueOf(i + 1));
                tablerowloopContext.put(RINDEX0, Integer.valueOf(total - i - 1));
                tablerowloopContext.put(RINDEX, Integer.valueOf(total - i));
                tablerowloopContext.put(FIRST, Boolean.valueOf(i == 0));
                tablerowloopContext.put(LAST, Boolean.valueOf(i == total - 1));
                tablerowloopContext.put(COL0, Integer.valueOf(c - 1));
                tablerowloopContext.put(COL, Integer.valueOf(c));
                tablerowloopContext.put(COL_FIRST, Boolean.valueOf(c == 1));
                tablerowloopContext.put(COL_LAST, Boolean.valueOf(c == cols));
                if (c == 1) {
                    builder.append("<tr class=\"row").append(++r).append("\">").append(r == 1 ? "\n" : "");
                }
                builder.append("<td class=\"col").append(c).append("\">");
                builder.append(super.asString(block.render(context)));
                builder.append("</td>");
                if (c == cols || i == total - 1) {
                    builder.append("</tr>\n");
                    c = 0;
                }
                ++i;
                ++c;
            }
        }
        context.remove(TABLEROWLOOP);
        return builder.toString();
    }

    private Map<String, Integer> getAttributes(Object[] collection, int fromIndex, TemplateContext context, LNode ... tokens) {
        HashMap<String, Integer> attributes = new HashMap<String, Integer>();
        attributes.put(COLS, collection.length);
        attributes.put(LIMIT, Integer.MAX_VALUE);
        for (int i = fromIndex; i < tokens.length; ++i) {
            Object[] attribute = super.asArray(tokens[i].render(context));
            try {
                attributes.put(super.asString(attribute[0]), super.asNumber(attribute[1]).intValue());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return attributes;
    }
}

