/*
 * Decompiled with CFR 0.152.
 */
package liqp;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import liqp.ProtectionSettings;
import liqp.TemplateContext;
import liqp.filters.Filter;
import liqp.nodes.LNode;
import liqp.nodes.LiquidWalker;
import liqp.parser.Flavor;
import liqp.parser.LiquidLexer;
import liqp.parser.LiquidParser;
import liqp.tags.Tag;
import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeNodeStream;

public class Template {
    private final CommonTree root;
    private final Map<String, Tag> tags;
    private final Map<String, Filter> filters;
    private final Flavor flavor;
    private final long templateSize;
    private ProtectionSettings protectionSettings = new ProtectionSettings.Builder().build();

    private Template(String input, Map<String, Tag> tags, Map<String, Filter> filters) {
        this(input, tags, filters, Flavor.LIQUID);
    }

    private Template(String input, Map<String, Tag> tags, Map<String, Filter> filters, Flavor flavor) {
        this.tags = tags;
        this.filters = filters;
        this.flavor = flavor;
        ANTLRStringStream stream = new ANTLRStringStream(input);
        this.templateSize = stream.size();
        LiquidLexer lexer = new LiquidLexer((CharStream)stream);
        LiquidParser parser = new LiquidParser(flavor, (TokenStream)new CommonTokenStream((TokenSource)lexer));
        try {
            this.root = parser.parse().getTree();
        }
        catch (RecognitionException e) {
            throw new RuntimeException("could not parse input: " + input, e);
        }
    }

    private Template(File file, Map<String, Tag> tags, Map<String, Filter> filters) throws IOException {
        this(file, tags, filters, Flavor.LIQUID);
    }

    private Template(File file, Map<String, Tag> tags, Map<String, Filter> filters, Flavor flavor) throws IOException {
        this.tags = tags;
        this.filters = filters;
        this.flavor = flavor;
        try {
            ANTLRFileStream stream = new ANTLRFileStream(file.getAbsolutePath());
            this.templateSize = stream.size();
            LiquidLexer lexer = new LiquidLexer((CharStream)stream);
            LiquidParser parser = new LiquidParser(flavor, (TokenStream)new CommonTokenStream((TokenSource)lexer));
            this.root = parser.parse().getTree();
        }
        catch (RecognitionException e) {
            throw new RuntimeException("could not parse input from " + file, e);
        }
    }

    public CommonTree getAST() {
        return this.root;
    }

    public static Template parse(String input) {
        return new Template(input, Tag.getTags(), Filter.getFilters());
    }

    public static Template parse(File file) throws IOException {
        return Template.parse(file, Flavor.LIQUID);
    }

    public static Template parse(File file, Flavor flavor) throws IOException {
        return new Template(file, Tag.getTags(), Filter.getFilters(), flavor);
    }

    public static Template parse(String input, Flavor flavor) throws IOException {
        return new Template(input, Tag.getTags(), Filter.getFilters(), flavor);
    }

    public Template with(Tag tag) {
        this.tags.put(tag.name, tag);
        return this;
    }

    public Template with(Filter filter) {
        this.filters.put(filter.name, filter);
        return this;
    }

    public Template withProtectionSettings(ProtectionSettings protectionSettings) {
        this.protectionSettings = protectionSettings;
        return this;
    }

    public String render(String jsonMap) {
        Map map;
        try {
            map = (Map)new ObjectMapper().readValue(jsonMap, HashMap.class);
        }
        catch (Exception e) {
            throw new RuntimeException("invalid json map: '" + jsonMap + "'", e);
        }
        return this.render(map);
    }

    public String render() {
        return this.render(new HashMap<String, Object>());
    }

    public String render(Object key, Object value, Object ... keyValues) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.putStringKey(key, value, map);
        for (int i = 0; i < keyValues.length - 1; i += 2) {
            key = String.valueOf(keyValues[i]);
            value = keyValues[i + 1];
            this.putStringKey(key, value, map);
        }
        return this.render(map);
    }

    public String render(final Map<String, Object> variables) {
        if (this.templateSize > this.protectionSettings.maxTemplateSizeBytes) {
            throw new RuntimeException("template exceeds " + this.protectionSettings.maxTemplateSizeBytes + " bytes");
        }
        final LiquidWalker walker = new LiquidWalker((TreeNodeStream)new CommonTreeNodeStream((Object)this.root), this.tags, this.filters, this.flavor);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Callable<String> task = new Callable<String>(){

            @Override
            public String call() throws Exception {
                try {
                    LNode node = walker.walk();
                    Object rendered = node.render(new TemplateContext(Template.this.protectionSettings, Template.this.flavor, variables));
                    return rendered == null ? "" : String.valueOf(rendered);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        Future<String> future = executorService.submit(task);
        try {
            return future.get(this.protectionSettings.maxRenderTimeMillis, TimeUnit.MILLISECONDS);
        }
        catch (Throwable t) {
            throw new RuntimeException("exceeded the max amount of time (" + this.protectionSettings.maxRenderTimeMillis + " ms.)");
        }
    }

    public String toStringAST() {
        StringBuilder builder = new StringBuilder();
        this.walk(this.root, builder);
        return builder.toString();
    }

    private void walk(CommonTree tree, StringBuilder builder) {
        ArrayList<CommonTree> firstStack = new ArrayList<CommonTree>();
        firstStack.add(tree);
        ArrayList childListStack = new ArrayList();
        childListStack.add(firstStack);
        while (!childListStack.isEmpty()) {
            List childStack = (List)childListStack.get(childListStack.size() - 1);
            if (childStack.isEmpty()) {
                childListStack.remove(childListStack.size() - 1);
                continue;
            }
            tree = (CommonTree)childStack.remove(0);
            String indent = "";
            for (int i = 0; i < childListStack.size() - 1; ++i) {
                indent = indent + (((List)childListStack.get(i)).size() > 0 ? "|  " : "   ");
            }
            String tokenName = LiquidParser.tokenNames[tree.getType()];
            String tokenText = tree.getText().replaceAll("\\s+", " ").trim();
            builder.append(indent).append(childStack.isEmpty() ? "'- " : "|- ").append(tokenName).append(!tokenName.equals(tokenText) ? "='" + tokenText + "'" : "").append("\n");
            if (tree.getChildCount() <= 0) continue;
            childListStack.add(new ArrayList(tree.getChildren()));
        }
    }

    private void putStringKey(Object key, Object value, Map<String, Object> map) {
        if (key == null || key.getClass() != String.class) {
            throw new RuntimeException("invalid key: " + key);
        }
        map.put((String)key, value);
    }
}

