/* SBaz -- Scala Bazaar
 * Copyright 2005-2009 LAMP/EPFL
 * @author  Lex Spoon
 */

// $Id: KeyList.scala 16895 2009-01-13 13:12:14Z cunei $
package sbaz.messages

import sbaz.keys._
import scala.xml._

/** Return a list of available keys */
case class KeyList(keyList: List[Key]) extends AbstractKeyMessage {
  def toXML = <keylist>{keyList.map(_.toXML)}</keylist>
}

object KeyListUtil {
  def fromXML(node: Node) = {
    val keysXML = node \\ "key"
    val keys = keysXML.toList.map(KeyUtil.fromXML)
    new KeyList(keys)
  }
}
