/*
 * Decompiled with CFR 0.152.
 */
package sbaz.clui.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import sbaz.AvailablePackage;
import sbaz.Package;
import sbaz.PackageUtil$;
import sbaz.Version;
import sbaz.VersionUtil$;
import sbaz.clui.Command;
import sbaz.clui.Settings;
import sbaz.clui.commands.Pack;
import sbaz.clui.commands.Pack$;
import scala.;
import scala.Console$;
import scala.Function1;
import scala.Function2;
import scala.List;
import scala.MatchError;
import scala.Nil$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.StringBuilder;
import scala.collection.immutable.ListSet$;
import scala.collection.immutable.Set;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Pack$
extends Command
implements ScalaObject {
    public static final Pack$ MODULE$;
    private final String fullHelp;
    private final String oneLineHelp;
    private final String name;

    static {
        new Pack$();
    }

    public Pack$() {
        this.name = "pack";
        this.oneLineHelp = "create an sbaz package";
        this.fullHelp = "pack name directory [options]\n\nOptions (defaults):\n  --version version (0.0)\n  --description description (no description)\n  --descfile description-file (no description)\n  --depends dependencies seperated by a comma (none)\n  --outdir directory (current directory)\n  --linkbase url (none)\n\nCreate an sbaz package and, if a link base is specified, an\nadvertisement file.  The package file is named name-version.sbp.\nThe advertisement file is named name-version.advert.  The URL\nin the advertisement file is the URL base with the package\nfilename appended.\n";
        MODULE$ = this;
    }

    public final void lp$1(File file, String path$1, Function2 function2) {
        function2.apply((Object)file, (Object)path$1);
        if (file.isDirectory()) {
            new BoxedObjectArray((Object[])file.listFiles()).toList().foreach((Function1)new anonfun.lp.1.1(function2, path$1));
        }
    }

    @Override
    public void run(List<String> args, Settings sbazSettings) {
        Option<String> option;
        block8: {
            Option<String> option2;
            block11: {
                Pack.Settings packSettings;
                block10: {
                    block9: {
                        block7: {
                            block6: {
                                packSettings = this.parseArguments(args);
                                option = PackageUtil$.MODULE$.checkName(packSettings.name());
                                if (!(option instanceof Some)) break block6;
                                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Warning: ").append(((Some)option).x()).toString());
                                break block7;
                            }
                            None$ none$ = None$.MODULE$;
                            Option<String> option3 = option;
                            if (none$ != null ? !none$.equals(option3) : option3 != null) break block8;
                        }
                        option2 = VersionUtil$.MODULE$.check(packSettings.version().toString());
                        if (!(option2 instanceof Some)) break block9;
                        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Warning: ").append(((Some)option2).x()).toString());
                        break block10;
                    }
                    None$ none$ = None$.MODULE$;
                    Option<String> option4 = option2;
                    if (none$ != null ? !none$.equals(option4) : option4 != null) break block11;
                }
                try {
                    this.writeSBP(sbazSettings, packSettings);
                    if (!packSettings.linkBase().isEmpty()) {
                        this.writeAdvert(sbazSettings, packSettings);
                    }
                    return;
                }
                catch (IOException iOException) {
                    Predef$.MODULE$.println((Object)iOException);
                    throw Predef$.MODULE$.exit(2);
                }
            }
            throw new MatchError(option2);
        }
        throw new MatchError(option);
    }

    public void writeAdvert(Settings sbazSettings, Pack.Settings packSettings) {
        String link = new StringBuilder().append((Object)((String)packSettings.linkBase().get())).append((Object)packSettings.name()).append((Object)"-").append((Object)packSettings.version()).append((Object)".sbp").toString();
        File advertFile = new File(new StringBuilder().append((Object)packSettings.name()).append((Object)"-").append((Object)packSettings.version()).append((Object)".advert").toString());
        if (sbazSettings.verbose()) {
            Console$.MODULE$.println((Object)new StringBuilder().append((Object)"writing ").append((Object)advertFile).append((Object)"...").toString());
        }
        AvailablePackage advert = new AvailablePackage(this.packageFor(packSettings), new URL(link));
        FileWriter out = new FileWriter(advertFile);
        out.write(advert.toXML().toString());
        out.close();
    }

    public void writeSBP(Settings sbazSettings$1, Pack.Settings packSettings) {
        String sbpName = new StringBuilder().append((Object)packSettings.name()).append((Object)"-").append((Object)packSettings.version()).append((Object)".sbp").toString();
        File sbpFile = new File(packSettings.outdir(), sbpName);
        if (sbazSettings$1.verbose()) {
            Console$.MODULE$.println((Object)new StringBuilder().append((Object)"Writing ").append((Object)sbpFile).append((Object)"...").toString());
        }
        ZipOutputStream zip$1 = new ZipOutputStream(new FileOutputStream(sbpFile));
        this.withDirTree(packSettings.packdir(), new anonfun.writeSBP.1(sbazSettings$1, zip$1));
        if (sbazSettings$1.verbose()) {
            Predef$.MODULE$.println((Object)"Writing meta/description");
        }
        zip$1.putNextEntry(new ZipEntry("meta/description"));
        zip$1.write(this.packageFor(packSettings).toXML().toString().getBytes());
        zip$1.closeEntry();
        zip$1.close();
        if (sbazSettings$1.verbose()) {
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Finished with ").append((Object)sbpFile).append((Object)".").toString());
        }
    }

    public Package packageFor(Pack.Settings settings) {
        return new Package(settings.name(), settings.version(), (Set<String>)ListSet$.MODULE$.empty().$plus$plus(settings.depends()), settings.description());
    }

    public void copyFile(File file, OutputStream out) {
        FileInputStream in = new FileInputStream(file);
        byte[] buf = new byte[1024];
        int n = 0;
        while ((n = in.read(buf)) >= 0) {
            out.write(buf, 0, n);
        }
        return;
    }

    public void withDirTree(File root, Function2<File, String, Object> handler$1) {
        this.lp$1(root, "", handler$1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Pack.Settings parseArguments(List<String> args) {
        List argsLeft = args;
        ObjectRef nameArg$1 = new ObjectRef(null);
        ObjectRef packdirArg$1 = new ObjectRef(null);
        ObjectRef outdirArg$1 = new ObjectRef(null);
        ObjectRef linkBaseArg$1 = new ObjectRef((Object)None$.MODULE$);
        ObjectRef versionArg$1 = new ObjectRef((Object)new Version("0.0"));
        ObjectRef descriptionArg$1 = new ObjectRef((Object)"(no description)");
        ObjectRef dependsArg$1 = new ObjectRef((Object)Nil$.MODULE$);
        List list = args;
        if (!(list instanceof .colon.colon)) throw this.usageExit();
        .colon.colon colon2 = (.colon.colon)list;
        String string = (String)colon2.hd$1();
        List list2 = colon2.tl$1();
        if (!(list2 instanceof .colon.colon)) throw this.usageExit();
        .colon.colon colon3 = (.colon.colon)list2;
        nameArg$1.elem = string;
        packdirArg$1.elem = new File((String)colon3.hd$1());
        argsLeft = colon3.tl$1();
        while (true) {
            List list3 = argsLeft;
            Nil$ nil$ = Nil$.MODULE$;
            if (list3 == null) {
                if (nil$ == null) return new anon.1(nameArg$1, packdirArg$1, outdirArg$1, linkBaseArg$1, versionArg$1, descriptionArg$1, dependsArg$1);
            } else if (list3.equals(nil$)) {
                return new anon.1(nameArg$1, packdirArg$1, outdirArg$1, linkBaseArg$1, versionArg$1, descriptionArg$1, dependsArg$1);
            }
            List list4 = argsLeft;
            if (!(list4 instanceof .colon.colon)) throw this.usageExit();
            .colon.colon colon4 = (.colon.colon)list4;
            String string2 = (String)colon4.hd$1();
            List list5 = colon4.tl$1();
            String string3 = string2;
            String string4 = "--version";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                if (!(list5 instanceof .colon.colon)) throw this.usageExit();
                .colon.colon colon5 = (.colon.colon)list5;
                versionArg$1.elem = new Version((String)colon5.hd$1());
                argsLeft = colon5.tl$1();
                continue;
            }
            String string5 = string2;
            String string6 = "--description";
            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                if (!(list5 instanceof .colon.colon)) throw this.usageExit();
                .colon.colon colon6 = (.colon.colon)list5;
                descriptionArg$1.elem = (String)colon6.hd$1();
                argsLeft = colon6.tl$1();
                continue;
            }
            String string7 = string2;
            String string8 = "--descfile";
            if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                String string9;
                if (!(list5 instanceof .colon.colon)) throw this.usageExit();
                .colon.colon colon7 = (.colon.colon)list5;
                String df = string9 = (String)colon7.hd$1();
                BoxedUnit exceptionResult1 = null;
                try {
                    descriptionArg$1.elem = this.readFile(df);
                    BoxedUnit str = exceptionResult1 = BoxedUnit.UNIT;
                }
                catch (IOException iOException) {
                    Console$.MODULE$.println((Object)new StringBuilder().append((Object)"Error reading ").append((Object)df).append((Object)": ").append((Object)iOException).toString());
                    throw Predef$.MODULE$.exit(1);
                }
                argsLeft = colon7.tl$1();
                continue;
            }
            String string9 = string2;
            String string11 = "--depends";
            if (!(string9 != null ? !string9.equals(string11) : string11 != null)) {
                if (!(list5 instanceof .colon.colon)) throw this.usageExit();
                .colon.colon colon8 = (.colon.colon)list5;
                dependsArg$1.elem = new BoxedObjectArray((Object[])((String)colon8.hd$1()).split(",")).toList();
                argsLeft = colon8.tl$1();
                continue;
            }
            String string10 = string2;
            String string13 = "--outdir";
            if (!(string10 != null ? !string10.equals(string13) : string13 != null)) {
                if (!(list5 instanceof .colon.colon)) throw this.usageExit();
                .colon.colon colon9 = (.colon.colon)list5;
                outdirArg$1.elem = new File((String)colon9.hd$1());
                argsLeft = colon9.tl$1();
                continue;
            }
            String string12 = string2;
            String string15 = "--linkbase";
            if (string12 == null) {
                if (string15 != null) {
                    throw this.usageExit();
                }
            } else if (!string12.equals(string15)) throw this.usageExit();
            if (!(list5 instanceof .colon.colon)) throw this.usageExit();
            .colon.colon colon10 = (.colon.colon)list5;
            linkBaseArg$1.elem = new Some(colon10.hd$1());
            argsLeft = colon10.tl$1();
        }
    }

    public String readFile(String filename) {
        FileReader reader = new FileReader(filename);
        char[] rbuf = new char[1024];
        StringBuffer wbuf = new StringBuffer();
        int n = 0;
        while (true) {
            if ((n = reader.read(rbuf)) < 0) {
                reader.close();
                return wbuf.toString();
            }
            wbuf.append(rbuf, 0, n);
        }
    }

    @Override
    public String fullHelp() {
        return this.fullHelp;
    }

    @Override
    public String oneLineHelp() {
        return this.oneLineHelp;
    }

    @Override
    public String name() {
        return this.name;
    }
}

