/*
 * Decompiled with CFR 0.152.
 */
package sbaz.clui.commands;

import java.io.File;
import sbaz.AvailablePackage;
import sbaz.DependencyError;
import sbaz.FormatError;
import sbaz.PackageSpec;
import sbaz.ProposedChanges;
import sbaz.UserPackageSpecifier;
import sbaz.UserPackageSpecifierUtil$;
import sbaz.clui.Command;
import sbaz.clui.Settings;
import sbaz.clui.commands.Install$;
import scala.;
import scala.Console$;
import scala.Function1;
import scala.List;
import scala.MatchError;
import scala.Nil$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Seq;
import scala.Some;
import scala.StringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Install$
extends Command
implements ScalaObject {
    public static final Install$ MODULE$;
    private final String fullHelp;
    private final String oneLineHelp;
    private final String name;

    static {
        new Install$();
    }

    public Install$() {
        this.name = "install";
        this.oneLineHelp = "install a package";
        MODULE$ = this;
        this.fullHelp = Predef$.MODULE$.stringWrapper("install package\n    |\n    |Install a package, including any of its necessary dependencies.\n    |The package to install is specified in one of the following ways:\n    |\n    |    name         - Install the newest package with the specified name\n    |    name/version - Install a package with a specified name and version\n    |    -f filename  - Install the package located in the specified file\n    |").stripMargin();
    }

    @Override
    public void run(List<String> args, Settings settings$1) {
        block11: {
            block14: {
                List list;
                String string;
                block12: {
                    Option<AvailablePackage> option;
                    block13: {
                        List removals;
                        Seq<AvailablePackage> packages2;
                        Option<AvailablePackage> option2;
                        None$ none$;
                        List<String> list2 = args;
                        if (!(list2 instanceof .colon.colon)) break block11;
                        .colon.colon colon2 = (.colon.colon)list2;
                        string = (String)colon2.hd$1();
                        list = colon2.tl$1();
                        Nil$ nil$ = Nil$.MODULE$;
                        List list3 = list;
                        if (nil$ != null ? !nil$.equals(list3) : list3 != null) break block12;
                        String arg = string;
                        UserPackageSpecifier exceptionResult1 = null;
                        try {
                            UserPackageSpecifier userSpec = exceptionResult1 = UserPackageSpecifierUtil$.MODULE$.fromString(arg);
                            option = userSpec.chooseFrom(settings$1.dir().available());
                            none$ = None$.MODULE$;
                            option2 = option;
                        }
                        catch (FormatError formatError) {
                            boolean isFile = new File(arg).isFile();
                            Console$.MODULE$.println((Object)(isFile ? "Use option '-f filename' to specify file names" : formatError.getMessage()));
                            throw Predef$.MODULE$.exit(2);
                        }
                        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
                            throw new Error(new StringBuilder().append((Object)"No available package matches ").append((Object)arg).append((Object)"!").toString());
                        }
                        if (!(option instanceof Some)) break block13;
                        PackageSpec spec = ((AvailablePackage)((Some)option).x()).spec();
                        Seq<AvailablePackage> exceptionResult2 = null;
                        try {
                            packages2 = exceptionResult2 = settings$1.dir().available().choosePackagesFor(spec, settings$1.dir().installed().packageNames());
                        }
                        catch (DependencyError dependencyError) {
                            Predef$.MODULE$.println((Object)"Dependency error.");
                            throw Predef$.MODULE$.exit(2);
                        }
                        packages2.foreach((Function1)new anonfun.run.1());
                        List additions = packages2.toList().map((Function1)new anonfun.1());
                        List list4 = removals = packages2.toList().flatMap((Function1)new anonfun.2(settings$1));
                        List changes = additions.$colon$colon$colon(list4);
                        if (!settings$1.dryrun()) {
                            Predef$.MODULE$.println((Object)"Installing...");
                            settings$1.dir().makeChanges((Seq<ProposedChanges.ProposedChange>)changes);
                        }
                        break block14;
                    }
                    throw new MatchError(option);
                }
                if (!(list instanceof .colon.colon)) break block11;
                .colon.colon colon3 = (.colon.colon)list;
                String string2 = (String)colon3.hd$1();
                Nil$ nil$ = Nil$.MODULE$;
                List list5 = colon3.tl$1();
                if (nil$ != null ? !nil$.equals(list5) : list5 != null) break block11;
                String string3 = string;
                String string4 = "-f";
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block11;
                String filename = string2;
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Installing ").append((Object)filename).append((Object)"...").toString());
                if (!settings$1.dryrun()) {
                    settings$1.dir().install(new File(filename));
                }
            }
            return;
        }
        throw this.usageExit();
    }

    @Override
    public String fullHelp() {
        return this.fullHelp;
    }

    @Override
    public String oneLineHelp() {
        return this.oneLineHelp;
    }

    @Override
    public String name() {
        return this.name;
    }
}

