/*
 * Decompiled with CFR 0.152.
 */
package com.imageworks.migration;

import com.imageworks.migration.BigintType$;
import com.imageworks.migration.BlobType$;
import com.imageworks.migration.BooleanType$;
import com.imageworks.migration.CharType$;
import com.imageworks.migration.CharacterSet;
import com.imageworks.migration.CharacterSetName;
import com.imageworks.migration.ColumnDefinition;
import com.imageworks.migration.DatabaseAdapter;
import com.imageworks.migration.DecimalType$;
import com.imageworks.migration.DefaultBlobColumnDefinition;
import com.imageworks.migration.DefaultTimestampColumnDefinition;
import com.imageworks.migration.ForeignKeyConstraintAction;
import com.imageworks.migration.GrantPrivilegeType;
import com.imageworks.migration.IntegerType$;
import com.imageworks.migration.OnDelete;
import com.imageworks.migration.OracleBigintColumnDefinition;
import com.imageworks.migration.OracleCharColumnDefinition;
import com.imageworks.migration.OracleDatabaseAdapter$;
import com.imageworks.migration.OracleDecimalColumnDefinition;
import com.imageworks.migration.OracleIntegerColumnDefinition;
import com.imageworks.migration.OracleSmallintColumnDefinition;
import com.imageworks.migration.OracleVarbinaryColumnDefinition;
import com.imageworks.migration.OracleVarcharColumnDefinition;
import com.imageworks.migration.Restrict$;
import com.imageworks.migration.SmallintType$;
import com.imageworks.migration.SqlType;
import com.imageworks.migration.TimestampType$;
import com.imageworks.migration.Unicode$;
import com.imageworks.migration.UnsupportedColumnTypeException;
import com.imageworks.migration.UppercaseUnquotedNameConverter$;
import com.imageworks.migration.VarbinaryType$;
import com.imageworks.migration.VarcharType$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.ScalaObject;
import scala.Seq;
import scala.Some;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDatabaseAdapter
extends DatabaseAdapter
implements ScalaObject {
    private final boolean addingForeignKeyConstraintCreatesIndex;
    private final UppercaseUnquotedNameConverter$ unquotedNameConverter = UppercaseUnquotedNameConverter$.MODULE$;

    public OracleDatabaseAdapter(Option<String> schemaNameOpt) {
        this.addingForeignKeyConstraintCreatesIndex = false;
        super(schemaNameOpt);
    }

    @Override
    public String onDeleteSql(Option<OnDelete> on_delete_opt) {
        String string;
        block4: {
            Some opt;
            block2: {
                Some some;
                block0: {
                    Some some2;
                    block3: {
                        OnDelete onDelete;
                        block1: {
                            some = on_delete_opt;
                            if (!(some instanceof Some)) break block0;
                            some2 = some;
                            onDelete = (OnDelete)some2.x();
                            if (onDelete != null) break block1;
                            Some some3 = some2;
                            break block2;
                        }
                        Restrict$ restrict$ = Restrict$.MODULE$;
                        ForeignKeyConstraintAction foreignKeyConstraintAction = onDelete.action();
                        if (restrict$ != null ? !restrict$.equals(foreignKeyConstraintAction) : foreignKeyConstraintAction != null) break block3;
                        string = "";
                        break block4;
                    }
                    opt = some2;
                    break block2;
                }
                opt = some;
            }
            string = super.onDeleteSql((Option<OnDelete>)opt);
        }
        return string;
    }

    @Override
    public String revokeSql(Option<String> schema_name_opt, String table_name, String[] grantees, Seq<GrantPrivilegeType> privileges) {
        privileges.filter((Function1)new $anonfun$revokeSql$1(this)).filter((Function1)new $anonfun$revokeSql$2(this)).foreach((Function1)new $anonfun$revokeSql$3(this));
        return super.revokeSql(schema_name_opt, table_name, grantees, privileges);
    }

    @Override
    public String grantSql(Option<String> schema_name_opt, String table_name, String[] grantees, Seq<GrantPrivilegeType> privileges) {
        privileges.filter((Function1)new $anonfun$grantSql$1(this)).filter((Function1)new $anonfun$grantSql$2(this)).foreach((Function1)new $anonfun$grantSql$3(this));
        return super.grantSql(schema_name_opt, table_name, grantees, privileges);
    }

    @Override
    public String removeColumnSql(Option<String> schema_name_opt, String table_name, String column_name) {
        return new StringBuilder(512).append("ALTER TABLE ").append(this.quoteTableName(schema_name_opt, table_name)).append(" DROP COLUMN ").append(this.quoteColumnName(column_name)).toString();
    }

    @Override
    public String alterColumnSql(Option<String> schema_name_opt, ColumnDefinition column_definition) {
        return new StringBuilder(512).append("ALTER TABLE ").append(this.quoteTableName(schema_name_opt, column_definition.getTableName())).append(" MODIFY (").append(this.quoteColumnName(column_definition.getColumnName())).append(' ').append(column_definition.toSql()).append(')').toString();
    }

    @Override
    public ColumnDefinition columnDefinitionFactory(SqlType column_type, Option<CharacterSet> character_set_opt) {
        Option<CharacterSet> option;
        block9: {
            SqlType sqlType;
            block19: {
                ColumnDefinition columnDefinition;
                block11: {
                    boolean use_nchar_type;
                    block18: {
                        block17: {
                            block16: {
                                block15: {
                                    block14: {
                                        block13: {
                                            block12: {
                                                block10: {
                                                    boolean bl;
                                                    block8: {
                                                        block7: {
                                                            option = character_set_opt;
                                                            None$ none$ = None$.MODULE$;
                                                            Option<CharacterSet> option2 = option;
                                                            if (none$ != null ? !none$.equals(option2) : option2 != null) break block7;
                                                            bl = false;
                                                            break block8;
                                                        }
                                                        if (!(option instanceof Some)) break block9;
                                                        Some some = (Some)option;
                                                        CharacterSet characterSet = (CharacterSet)some.x();
                                                        if (characterSet == null) {
                                                            throw new MatchError(option);
                                                        }
                                                        CharacterSetName characterSetName = characterSet.name();
                                                        Unicode$ unicode$ = Unicode$.MODULE$;
                                                        CharacterSetName characterSetName2 = characterSetName;
                                                        if (!(unicode$ != null ? !unicode$.equals(characterSetName2) : characterSetName2 != null)) {
                                                            bl = true;
                                                        } else {
                                                            this.logger().warn("Ignoring '{}' as Oracle only supports specifying no explicit character set encoding, which defaults the column to use the database's character set, or Unicode.", (Object)characterSet);
                                                            bl = false;
                                                        }
                                                    }
                                                    use_nchar_type = bl;
                                                    sqlType = column_type;
                                                    BigintType$ bigintType$ = BigintType$.MODULE$;
                                                    SqlType sqlType2 = sqlType;
                                                    if (bigintType$ != null ? !bigintType$.equals(sqlType2) : sqlType2 != null) break block10;
                                                    columnDefinition = new OracleBigintColumnDefinition();
                                                    break block11;
                                                }
                                                BlobType$ blobType$ = BlobType$.MODULE$;
                                                SqlType sqlType3 = sqlType;
                                                if (blobType$ != null ? !blobType$.equals(sqlType3) : sqlType3 != null) break block12;
                                                columnDefinition = new DefaultBlobColumnDefinition();
                                                break block11;
                                            }
                                            BooleanType$ booleanType$ = BooleanType$.MODULE$;
                                            SqlType sqlType4 = sqlType;
                                            if (!(booleanType$ != null ? !booleanType$.equals(sqlType4) : sqlType4 != null)) {
                                                String message = "Oracle does not support a boolean type, you must choose a mapping your self.";
                                                throw new UnsupportedColumnTypeException(message);
                                            }
                                            CharType$ charType$ = CharType$.MODULE$;
                                            SqlType sqlType5 = sqlType;
                                            if (charType$ != null ? !charType$.equals(sqlType5) : sqlType5 != null) break block13;
                                            columnDefinition = new OracleCharColumnDefinition(use_nchar_type);
                                            break block11;
                                        }
                                        DecimalType$ decimalType$ = DecimalType$.MODULE$;
                                        SqlType sqlType6 = sqlType;
                                        if (decimalType$ != null ? !decimalType$.equals(sqlType6) : sqlType6 != null) break block14;
                                        columnDefinition = new OracleDecimalColumnDefinition();
                                        break block11;
                                    }
                                    IntegerType$ integerType$ = IntegerType$.MODULE$;
                                    SqlType sqlType7 = sqlType;
                                    if (integerType$ != null ? !integerType$.equals(sqlType7) : sqlType7 != null) break block15;
                                    columnDefinition = new OracleIntegerColumnDefinition();
                                    break block11;
                                }
                                SmallintType$ smallintType$ = SmallintType$.MODULE$;
                                SqlType sqlType8 = sqlType;
                                if (smallintType$ != null ? !smallintType$.equals(sqlType8) : sqlType8 != null) break block16;
                                columnDefinition = new OracleSmallintColumnDefinition();
                                break block11;
                            }
                            TimestampType$ timestampType$ = TimestampType$.MODULE$;
                            SqlType sqlType9 = sqlType;
                            if (timestampType$ != null ? !timestampType$.equals(sqlType9) : sqlType9 != null) break block17;
                            columnDefinition = new DefaultTimestampColumnDefinition();
                            break block11;
                        }
                        VarbinaryType$ varbinaryType$ = VarbinaryType$.MODULE$;
                        SqlType sqlType10 = sqlType;
                        if (varbinaryType$ != null ? !varbinaryType$.equals(sqlType10) : sqlType10 != null) break block18;
                        columnDefinition = new OracleVarbinaryColumnDefinition();
                        break block11;
                    }
                    VarcharType$ varcharType$ = VarcharType$.MODULE$;
                    SqlType sqlType11 = sqlType;
                    if (varcharType$ != null ? !varcharType$.equals(sqlType11) : sqlType11 != null) break block19;
                    columnDefinition = new OracleVarcharColumnDefinition(use_nchar_type);
                }
                return columnDefinition;
            }
            throw new MatchError((Object)sqlType);
        }
        throw new MatchError(option);
    }

    @Override
    public boolean addingForeignKeyConstraintCreatesIndex() {
        return this.addingForeignKeyConstraintCreatesIndex;
    }

    @Override
    public UppercaseUnquotedNameConverter$ unquotedNameConverter() {
        return this.unquotedNameConverter;
    }

    @Override
    public Option<String> schemaNameOpt() {
        return super.schemaNameOpt();
    }
}

