/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.report;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.ConfigurationResolveReport;
import org.apache.ivy.core.report.MetadataArtifactDownloadReport;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.IvyNodeEviction;
import org.apache.ivy.util.DateUtil;
import org.apache.ivy.util.StringUtils;
import org.apache.ivy.util.XMLHelper;
import org.apache.ivy.util.extendable.UnmodifiableExtendableItem;

public class XmlReportWriter {
    public void output(ConfigurationResolveReport configurationResolveReport, String[] object42, OutputStream closeable) {
        try {
            closeable = new OutputStreamWriter((OutputStream)closeable, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 is not known on your jvm", unsupportedEncodingException);
        }
        closeable = new PrintWriter(new BufferedWriter((Writer)closeable));
        Object object2 = configurationResolveReport.getModuleDescriptor().getModuleRevisionId();
        ((PrintWriter)closeable).println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        ((PrintWriter)closeable).println("<?xml-stylesheet type=\"text/xsl\" href=\"ivy-report.xsl\"?>");
        ((PrintWriter)closeable).println("<ivy-report version=\"1.0\">");
        ((PrintWriter)closeable).println("\t<info");
        ((PrintWriter)closeable).println("\t\torganisation=\"" + XMLHelper.escape(((ModuleRevisionId)object2).getOrganisation()) + "\"");
        ((PrintWriter)closeable).println("\t\tmodule=\"" + XMLHelper.escape(((ModuleRevisionId)object2).getName()) + "\"");
        ((PrintWriter)closeable).println("\t\trevision=\"" + XMLHelper.escape(((ModuleRevisionId)object2).getRevision()) + "\"");
        if (((ModuleRevisionId)object2).getBranch() != null) {
            ((PrintWriter)closeable).println("\t\tbranch=\"" + XMLHelper.escape(((ModuleRevisionId)object2).getBranch()) + "\"");
        }
        object2 = ((UnmodifiableExtendableItem)object2).getExtraAttributes();
        for (Map.Entry object3 : object2.entrySet()) {
            ((PrintWriter)closeable).println("\t\textra-" + object3.getKey() + "=\"" + XMLHelper.escape(object3.getValue().toString()) + "\"");
        }
        ((PrintWriter)closeable).println("\t\tconf=\"" + XMLHelper.escape(configurationResolveReport.getConfiguration()) + "\"");
        ((PrintWriter)closeable).println("\t\tconfs=\"" + XMLHelper.escape(StringUtils.join((Object[])object42, ", ")) + "\"");
        ((PrintWriter)closeable).println("\t\tdate=\"" + DateUtil.format(configurationResolveReport.getDate()) + "\"/>");
        ((PrintWriter)closeable).println("\t<dependencies>");
        object2 = new ArrayList(configurationResolveReport.getModuleRevisionIds());
        for (Object object42 : configurationResolveReport.getModuleIds()) {
            ((PrintWriter)closeable).println("\t\t<module organisation=\"" + XMLHelper.escape(((ModuleId)object42).getOrganisation()) + "\" name=\"" + XMLHelper.escape(((ModuleId)object42).getName()) + "\">");
            object42 = configurationResolveReport.getNodes((ModuleId)object42).iterator();
            while (object42.hasNext()) {
                IvyNode ivyNode = (IvyNode)object42.next();
                this.ouputRevision(configurationResolveReport, (PrintWriter)closeable, (List)object2, ivyNode);
            }
            ((PrintWriter)closeable).println("\t\t</module>");
        }
        ((PrintWriter)closeable).println("\t</dependencies>");
        ((PrintWriter)closeable).println("</ivy-report>");
        ((PrintWriter)closeable).flush();
    }

    private void ouputRevision(ConfigurationResolveReport configurationResolveReport, PrintWriter printWriter, List licenseArray, IvyNode ivyNode) {
        Object object;
        Object object2 = null;
        if (ivyNode.getModuleRevision() != null) {
            object2 = ivyNode.getModuleRevision().getDescriptor();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (ivyNode.isLoaded()) {
            stringBuffer.append(" status=\"");
            stringBuffer.append(XMLHelper.escape(ivyNode.getDescriptor().getStatus()));
            stringBuffer.append("\" pubdate=\"");
            stringBuffer.append(DateUtil.format(new Date(ivyNode.getPublication())));
            stringBuffer.append("\" resolver=\"");
            stringBuffer.append(XMLHelper.escape(ivyNode.getModuleRevision().getResolver().getName()));
            stringBuffer.append("\" artresolver=\"");
            stringBuffer.append(XMLHelper.escape(ivyNode.getModuleRevision().getArtifactResolver().getName()));
            stringBuffer.append("\"");
        }
        if (ivyNode.isEvicted(configurationResolveReport.getConfiguration())) {
            object = ivyNode.getEvictedData(configurationResolveReport.getConfiguration());
            if (((IvyNodeEviction.EvictionData)object).getConflictManager() != null) {
                stringBuffer.append(" evicted=\"").append(XMLHelper.escape(((IvyNodeEviction.EvictionData)object).getConflictManager().toString())).append("\"");
            } else {
                stringBuffer.append(" evicted=\"transitive\"");
            }
            stringBuffer.append(" evicted-reason=\"").append(XMLHelper.escape(((IvyNodeEviction.EvictionData)object).getDetail() == null ? "" : ((IvyNodeEviction.EvictionData)object).getDetail())).append("\"");
        }
        if (ivyNode.hasProblem()) {
            stringBuffer.append(" error=\"").append(XMLHelper.escape(ivyNode.getProblem().getMessage())).append("\"");
        }
        if (object2 != null && object2.getHomePage() != null) {
            stringBuffer.append(" homepage=\"").append(XMLHelper.escape(object2.getHomePage())).append("\"");
        }
        Map map = object2 != null ? object2.getExtraAttributes() : ivyNode.getResolvedId().getExtraAttributes();
        for (String string : map.keySet()) {
            stringBuffer.append(" extra-").append(string).append("=\"").append(XMLHelper.escape(map.get(string).toString())).append("\"");
        }
        object = ivyNode.getDescriptor() != null ? " default=\"" + ivyNode.getDescriptor().isDefault() + "\"" : "";
        int n = licenseArray.indexOf(ivyNode.getResolvedId());
        printWriter.println("\t\t\t<revision name=\"" + XMLHelper.escape(ivyNode.getResolvedId().getRevision()) + "\"" + (ivyNode.getResolvedId().getBranch() == null ? "" : " branch=\"" + XMLHelper.escape(ivyNode.getResolvedId().getBranch()) + "\"") + stringBuffer + " downloaded=\"" + ivyNode.isDownloaded() + "\" searched=\"" + ivyNode.isSearched() + "\"" + (String)object + " conf=\"" + this.toString(ivyNode.getConfigurations(configurationResolveReport.getConfiguration())) + "\" position=\"" + n + "\">");
        if (object2 != null) {
            licenseArray = object2.getLicenses();
            for (int i = 0; i < licenseArray.length; ++i) {
                object2 = licenseArray[i].getUrl() != null ? " url=\"" + XMLHelper.escape(licenseArray[i].getUrl()) + "\"" : "";
                printWriter.println("\t\t\t\t<license name=\"" + XMLHelper.escape(licenseArray[i].getName()) + "\"" + (String)object2 + "/>");
            }
        }
        this.outputMetadataArtifact(printWriter, ivyNode);
        this.outputEvictionInformation(configurationResolveReport, printWriter, ivyNode);
        this.outputCallers(configurationResolveReport, printWriter, ivyNode);
        this.outputArtifacts(configurationResolveReport, printWriter, ivyNode);
        printWriter.println("\t\t\t</revision>");
    }

    private void outputEvictionInformation(ConfigurationResolveReport iterator, PrintWriter printWriter, IvyNode ivyNode) {
        if (ivyNode.isEvicted(((ConfigurationResolveReport)((Object)iterator)).getConfiguration())) {
            iterator = ivyNode.getEvictedData(((ConfigurationResolveReport)((Object)iterator)).getConfiguration());
            if ((iterator = ((IvyNodeEviction.EvictionData)((Object)iterator)).getSelected()) != null) {
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    ivyNode = (IvyNode)iterator.next();
                    printWriter.println("\t\t\t\t<evicted-by rev=\"" + XMLHelper.escape(ivyNode.getResolvedId().getRevision()) + "\"/>");
                }
            }
        }
    }

    private void outputMetadataArtifact(PrintWriter printWriter, IvyNode object) {
        if (((IvyNode)object).getModuleRevision() != null) {
            object = ((IvyNode)object).getModuleRevision().getReport();
            printWriter.print("\t\t\t\t<metadata-artifact");
            printWriter.print(" status=\"" + XMLHelper.escape(((ArtifactDownloadReport)object).getDownloadStatus().toString()) + "\"");
            printWriter.print(" details=\"" + XMLHelper.escape(((ArtifactDownloadReport)object).getDownloadDetails()) + "\"");
            printWriter.print(" size=\"" + ((ArtifactDownloadReport)object).getSize() + "\"");
            printWriter.print(" time=\"" + ((ArtifactDownloadReport)object).getDownloadTimeMillis() + "\"");
            if (((ArtifactDownloadReport)object).getLocalFile() != null) {
                printWriter.print(" location=\"" + XMLHelper.escape(((ArtifactDownloadReport)object).getLocalFile().getAbsolutePath()) + "\"");
            }
            printWriter.print(" searched=\"" + ((MetadataArtifactDownloadReport)object).isSearched() + "\"");
            if (((MetadataArtifactDownloadReport)object).getOriginalLocalFile() != null) {
                printWriter.print(" original-local-location=\"" + XMLHelper.escape(((MetadataArtifactDownloadReport)object).getOriginalLocalFile().getAbsolutePath()) + "\"");
            }
            if ((object = ((ArtifactDownloadReport)object).getArtifactOrigin()) != null) {
                printWriter.print(" origin-is-local=\"" + String.valueOf(((ArtifactOrigin)object).isLocal()) + "\"");
                printWriter.print(" origin-location=\"" + XMLHelper.escape(((ArtifactOrigin)object).getLocation()) + "\"");
            }
            printWriter.println("/>");
        }
    }

    private void outputCallers(ConfigurationResolveReport callerArray, PrintWriter printWriter, IvyNode ivyNode) {
        callerArray = ivyNode.getCallers(callerArray.getConfiguration());
        for (int i = 0; i < callerArray.length; ++i) {
            StringBuffer stringBuffer = new StringBuffer();
            Map map = callerArray[i].getDependencyDescriptor().getExtraAttributes();
            for (String string : map.keySet()) {
                stringBuffer.append(" extra-").append(string).append("=\"").append(XMLHelper.escape(map.get(string).toString())).append("\"");
            }
            printWriter.println("\t\t\t\t<caller organisation=\"" + XMLHelper.escape(callerArray[i].getModuleRevisionId().getOrganisation()) + "\" name=\"" + XMLHelper.escape(callerArray[i].getModuleRevisionId().getName()) + "\" conf=\"" + XMLHelper.escape(this.toString(callerArray[i].getCallerConfigurations())) + "\" rev=\"" + XMLHelper.escape(callerArray[i].getAskedDependencyId(ivyNode.getData()).getRevision()) + "\" rev-constraint-default=\"" + XMLHelper.escape(callerArray[i].getDependencyDescriptor().getDependencyRevisionId().getRevision()) + "\" rev-constraint-dynamic=\"" + XMLHelper.escape(callerArray[i].getDependencyDescriptor().getDynamicConstraintDependencyRevisionId().getRevision()) + "\" callerrev=\"" + XMLHelper.escape(callerArray[i].getModuleRevisionId().getRevision()) + "\"" + stringBuffer + "/>");
        }
    }

    private void outputArtifacts(ConfigurationResolveReport object, PrintWriter printWriter, IvyNode artifactDownloadReportArray) {
        artifactDownloadReportArray = ((ConfigurationResolveReport)object).getDownloadReports(artifactDownloadReportArray.getResolvedId());
        printWriter.println("\t\t\t\t<artifacts>");
        for (int i = 0; i < artifactDownloadReportArray.length; ++i) {
            printWriter.print("\t\t\t\t\t<artifact name=\"" + XMLHelper.escape(artifactDownloadReportArray[i].getName()) + "\" type=\"" + XMLHelper.escape(artifactDownloadReportArray[i].getType()) + "\" ext=\"" + XMLHelper.escape(artifactDownloadReportArray[i].getExt()) + "\"");
            object = artifactDownloadReportArray[i].getArtifact().getExtraAttributes();
            Object object2 = object.keySet().iterator();
            while (object2.hasNext()) {
                String string = (String)object2.next();
                printWriter.print(" extra-" + string + "=\"" + XMLHelper.escape(object.get(string).toString()) + "\"");
            }
            printWriter.print(" status=\"" + XMLHelper.escape(artifactDownloadReportArray[i].getDownloadStatus().toString()) + "\"");
            printWriter.print(" details=\"" + XMLHelper.escape(artifactDownloadReportArray[i].getDownloadDetails()) + "\"");
            printWriter.print(" size=\"" + artifactDownloadReportArray[i].getSize() + "\"");
            printWriter.print(" time=\"" + artifactDownloadReportArray[i].getDownloadTimeMillis() + "\"");
            if (artifactDownloadReportArray[i].getLocalFile() != null) {
                printWriter.print(" location=\"" + XMLHelper.escape(artifactDownloadReportArray[i].getLocalFile().getAbsolutePath()) + "\"");
            }
            if ((object2 = artifactDownloadReportArray[i].getArtifactOrigin()) != null) {
                printWriter.println(">");
                printWriter.println("\t\t\t\t\t\t<origin-location is-local=\"" + String.valueOf(((ArtifactOrigin)object2).isLocal()) + "\" location=\"" + XMLHelper.escape(((ArtifactOrigin)object2).getLocation()) + "\"/>");
                printWriter.println("\t\t\t\t\t</artifact>");
                continue;
            }
            printWriter.println("/>");
        }
        printWriter.println("\t\t\t\t</artifacts>");
    }

    private String toString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i + 1 >= stringArray.length) continue;
            stringBuffer.append(", ");
        }
        return XMLHelper.escape(stringBuffer.toString());
    }
}

