;;;; tests of GCD with no side effects

;;;; This software is part of the SBCL system. See the README file for
;;;; more information.
;;;;
;;;; While most of SBCL is derived from the CMU CL system, the test
;;;; files (like this one) were written from scratch after the fork
;;;; from CMU CL.
;;;;
;;;; This software is in the public domain and is provided with
;;;; absolutely no warranty. See the COPYING and CREDITS files for
;;;; more information.

(cl:in-package :cl-user)

;;; note: the below were generated automatically from the following
;;; program:
#+nil
(progn
  (defun random-factor (n)
    (let ((accum 1))
      (dotimes (i n accum)
        (setf accum (* accum (nth (random 20)
                                  '(2 2 2 3 3
                                    5 7 11 13 17
                                    19 23 29 31 37
                                    41 43 47 53 59)))))))

  (with-open-file (s "tests/gcd.impure.lisp"
                     :direction :output :if-exists :supersede)
    (dotimes (i 40)
      (dotimes (j (ceiling i 2))
        (let ((x (random-factor i))
              (y (random-factor j)))
          (format s "~&~S~%" `(assert (= (gcd ,x ,y) ,(gcd x y)))))))))
;;; run from a different lisp implementation.  As such, if you get a
;;; failure, check (by hand!) who is right.  -- CSR, 2004-08-10

(ASSERT (= (GCD 3 1) 1))
(ASSERT (= (GCD 9 1) 1))
(ASSERT (= (GCD 1353 1) 1))
(ASSERT (= (GCD 2755 13) 1))
(ASSERT (= (GCD 3146 1) 1))
(ASSERT (= (GCD 56 2) 2))
(ASSERT (= (GCD 223706 1) 1))
(ASSERT (= (GCD 148665 2) 1))
(ASSERT (= (GCD 71862 203) 203))
(ASSERT (= (GCD 14464263 1) 1))
(ASSERT (= (GCD 21568911 41) 41))
(ASSERT (= (GCD 15295874 111) 37))
(ASSERT (= (GCD 167524732 1) 1))
(ASSERT (= (GCD 20430054 41) 41))
(ASSERT (= (GCD 248255254 767) 13))
(ASSERT (= (GCD 510104442 5453) 1))
(ASSERT (= (GCD 100809345 1) 1))
(ASSERT (= (GCD 242162410 41) 1))
(ASSERT (= (GCD 660070972 74) 74))
(ASSERT (= (GCD 6542405452 117) 1))
(ASSERT (= (GCD 4641925173847 1) 1))
(ASSERT (= (GCD 629448534 2) 2))
(ASSERT (= (GCD 163873565922 155) 31))
(ASSERT (= (GCD 1563464979842 442) 34))
(ASSERT (= (GCD 3712337724 576173) 23))
(ASSERT (= (GCD 4429248 1) 1))
(ASSERT (= (GCD 4380921044390 5) 5))
(ASSERT (= (GCD 4097970629150 86) 2))
(ASSERT (= (GCD 2090198664 1118) 2))
(ASSERT (= (GCD 5275411661289 31857) 21))
(ASSERT (= (GCD 17015415976168 1) 1))
(ASSERT (= (GCD 38602581835881 19) 1))
(ASSERT (= (GCD 82578867500655 319) 29))
(ASSERT (= (GCD 363169800 20) 20))
(ASSERT (= (GCD 2033404107084 23374) 2))
(ASSERT (= (GCD 7438317458260 31213) 13))
(ASSERT (= (GCD 20223947479736 1) 1))
(ASSERT (= (GCD 390609000 11) 1))
(ASSERT (= (GCD 406117800 57) 3))
(ASSERT (= (GCD 1008217762344 4403) 37))
(ASSERT (= (GCD 136581511784536 67022) 62))
(ASSERT (= (GCD 43293168048 1344610) 2))
(ASSERT (= (GCD 154378910321790 1) 1))
(ASSERT (= (GCD 608503422693864 47) 47))
(ASSERT (= (GCD 6945109296864 779) 19))
(ASSERT (= (GCD 1346702251365156 435) 87))
(ASSERT (= (GCD 1388225063690465 644) 7))
(ASSERT (= (GCD 1200780158492850 91686) 354))
(ASSERT (= (GCD 1551193257090906 2656731) 1749))
(ASSERT (= (GCD 2453369841000 1) 1))
(ASSERT (= (GCD 386512944051107445 17) 17))
(ASSERT (= (GCD 1111364125679340 6) 6))
(ASSERT (= (GCD 15858537083857314 21793) 21793))
(ASSERT (= (GCD 44179338013272 280645) 41))
(ASSERT (= (GCD 64149298745840 43808357) 35131))
(ASSERT (= (GCD 4412914630225794 515823) 46893))
(ASSERT (= (GCD 7518817068019302045 1) 1))
(ASSERT (= (GCD 169216424701305960 17) 1))
(ASSERT (= (GCD 178335507754891305 817) 817))
(ASSERT (= (GCD 460683358924445799142 518) 518))
(ASSERT (= (GCD 113021475230160 74635) 6785))
(ASSERT (= (GCD 74228340534140364 363909) 1677))
(ASSERT (= (GCD 69242022961311060 48305942) 60458))
(ASSERT (= (GCD 286967952870300 2273388) 156))
(ASSERT (= (GCD 10593379420837191160 1) 1))
(ASSERT (= (GCD 302822258393413362492399 29) 29))
(ASSERT (= (GCD 10491072879382200 133) 133))
(ASSERT (= (GCD 167206737423420464 609) 7))
(ASSERT (= (GCD 72212583812867784 4888799) 47))
(ASSERT (= (GCD 4170116471639397292390 1798025) 359605))
(ASSERT (= (GCD 83910330283522050 35224) 238))
(ASSERT (= (GCD 275373383775647594346 66884092) 104834))
(ASSERT (= (GCD 24798951106800092040 1) 1))
(ASSERT (= (GCD 14656657495570695990 37) 1))
(ASSERT (= (GCD 95470974177676509874110 1219) 1219))
(ASSERT (= (GCD 619506317623001424 5957) 7))
(ASSERT (= (GCD 11268171656665155960 9858) 186))
(ASSERT (= (GCD 6172860073826160 5167394) 3074))
(ASSERT (= (GCD 26457493095663264 1491412) 3956))
(ASSERT (= (GCD 8481384175941103284 313836405) 51))
(ASSERT (= (GCD 60356595775749199080 176098815946) 1716346))
(ASSERT (= (GCD 2062895192248935732930 1) 1))
(ASSERT (= (GCD 611492274956002440 37) 37))
(ASSERT (= (GCD 164614611843685080 1711) 59))
(ASSERT (= (GCD 93177516542679418720 62197) 37))
(ASSERT (= (GCD 938959746797519770440 127558) 127558))
(ASSERT (= (GCD 137670522526899326250 200) 50))
(ASSERT (= (GCD 852063402206742880 41643478) 58406))
(ASSERT (= (GCD 55947291202307909360 188546228) 6364))
(ASSERT (= (GCD 12877971214039423262680 9832253830) 121730))
(ASSERT (= (GCD 2217480094627700577948 1) 1))
(ASSERT (= (GCD 192158415774146059920 53) 53))
(ASSERT (= (GCD 902814024155808960 1829) 31))
(ASSERT (= (GCD 1265864304573235487120 4921) 259))
(ASSERT (= (GCD 14172662463567665400 95817) 57))
(ASSERT (= (GCD 32171996211745702482324 2368555) 259))
(ASSERT (= (GCD 971324258606045826300 4576748) 236))
(ASSERT (= (GCD 2400649320046378377000 1704690) 930))
(ASSERT (= (GCD 953233796456393760 18342152493) 574287))
(ASSERT (= (GCD 28906333140964843080 236206740) 823020))
(ASSERT (= (GCD 19478907070569571633008 1) 1))
(ASSERT (= (GCD 775403093708557121609032 41) 41))
(ASSERT (= (GCD 12587009808135760402860 2491) 47))
(ASSERT (= (GCD 510685807527370566909720 76) 4))
(ASSERT (= (GCD 9842598153710524682146590 10089) 3363))
(ASSERT (= (GCD 44936631038618189620242012 30740) 6148))
(ASSERT (= (GCD 934589372977008750144 373650) 282))
(ASSERT (= (GCD 33027125273398900134069150 840577803) 840577803))
(ASSERT (= (GCD 4428219127938822420288 1695783782) 12502))
(ASSERT (= (GCD 29316428815807608915440 560764380) 153340))
(ASSERT (= (GCD 2366157559867828791011766 1) 1))
(ASSERT (= (GCD 1364397376360544429904 19) 19))
(ASSERT (= (GCD 4991450791697293128313385277 329) 7))
(ASSERT (= (GCD 75448279792981695149550 3009) 3))
(ASSERT (= (GCD 181031604499464166188731133 3364) 1))
(ASSERT (= (GCD 405831142402606479845286 2746214) 161542))
(ASSERT (= (GCD 89170366469003867207160 25337230) 11470))
(ASSERT (= (GCD 13523725766340619200 1490114045) 28595))
(ASSERT (= (GCD 104705939487154940255412 192200052) 26196))
(ASSERT (= (GCD 7232591421499800642000 16584679460) 7820))
(ASSERT (= (GCD 14043796716396386984750160 33382708236) 358953852))
(ASSERT (= (GCD 11835771070979649489696 1) 1))
(ASSERT (= (GCD 13894638105872256412416 23) 23))
(ASSERT (= (GCD 147611447155643499428400 118) 2))
(ASSERT (= (GCD 13356594697070649024 4558) 106))
(ASSERT (= (GCD 15089731174706036171537760 90) 30))
(ASSERT (= (GCD 307230141273924828960 1971507) 1581))
(ASSERT (= (GCD 2582563944548247741930009096 22873474) 1759498))
(ASSERT (= (GCD 1074296602920111687342072 146235518) 21758))
(ASSERT (= (GCD 774058642832724262993980 407557010) 2531410))
(ASSERT (= (GCD 291091930213008490369569480 13412544348) 26508))
(ASSERT (= (GCD 2089068565149831833568 7302038455228) 68171356))
(ASSERT (= (GCD 15874791883700662031579460 1) 1))
(ASSERT (= (GCD 1064437567441124038217970656 5) 1))
(ASSERT (= (GCD 142557826750459447787460 1333) 31))
(ASSERT (= (GCD 311779340580033594160200 23693) 23693))
(ASSERT (= (GCD 29314187023691666530559664 110143) 110143))
(ASSERT (= (GCD 222003853016244177637944900 857463) 857463))
(ASSERT (= (GCD 6247776111945111006243552 77976501) 2515371))
(ASSERT (= (GCD 1140058514761397155259712 5530338) 502758))
(ASSERT (= (GCD 580962736822969724865449808 55686036) 1505028))
(ASSERT (= (GCD 4100502596989506786787500 45333475410) 563730))
(ASSERT (= (GCD 1497378750311599979536944 262630276090) 361046))
(ASSERT (= (GCD 105637634198318524045536 2633013240) 150072))
(ASSERT (= (GCD 70489308475051480717893899280 1) 1))
(ASSERT (= (GCD 11415822547029425161364106595632 7) 1))
(ASSERT (= (GCD 198305933339312916107438448 177) 3))
(ASSERT (= (GCD 3127415425979879537134790928 3335) 667))
(ASSERT (= (GCD 589703503861221139260034914750 13209) 357))
(ASSERT (= (GCD 3108579252052448504121792 14322) 462))
(ASSERT (= (GCD 636976201153021006473464400 66264077) 3487583))
(ASSERT (= (GCD 9544425315508129998909285900 1488396) 212628))
(ASSERT (= (GCD 458100280193857502802977376 260747103934) 6212554))
(ASSERT (= (GCD 114208186302155358124900650 22076867505) 6342105))
(ASSERT (= (GCD 90107067439719108194114160 28566806069714) 3408519994))
(ASSERT (= (GCD 2976572787365723002218245484 110104803958578) 2966904798))
(ASSERT (= (GCD 981298276658071427286000 1) 1))
(ASSERT (= (GCD 53453375725613238735360 17) 1))
(ASSERT (= (GCD 888822833524306124874229800 106) 106))
(ASSERT (= (GCD 21275338550698297089687698855820 3021) 3021))
(ASSERT (= (GCD 417525245705449941528380320750068 5828) 5828))
(ASSERT (= (GCD 1954871230146370370001829871352 22765249) 22765249))
(ASSERT (= (GCD 903057827710908645847577520 648545995) 520085))
(ASSERT (= (GCD 6002846634833433581621040 28493572159) 27869))
(ASSERT (= (GCD 26428903214964558277189300080 100428856) 3463064))
(ASSERT (= (GCD 470486531607553676511206181180 28495896) 2964))
(ASSERT (= (GCD 483599554429365539310928369206620 5577334078910) 105232718470))
(ASSERT (= (GCD 134511400157705323668887400 1285071093558916) 340069628))
(ASSERT (= (GCD 25897125642468049125349982599216 1183846707540) 26307704612))
(ASSERT (= (GCD 291543186498072665182448708000 1) 1))
(ASSERT (= (GCD 1118034209930460291955200 3) 3))
(ASSERT (= (GCD 16297594064835666104344589410644 413) 413))
(ASSERT (= (GCD 536762539932642345554192060100 1378) 1378))
(ASSERT (= (GCD 933250179448203335817687635834340 58029) 69))
(ASSERT (= (GCD 65573457048202714607131200 486115) 3655))
(ASSERT (= (GCD 85664559165674439863772868932 322014) 322014))
(ASSERT (= (GCD 7232817686074320060728552759760 11307940) 11307940))
(ASSERT (= (GCD 78400098291720425971762131120 5646921093) 5646921093))
(ASSERT (= (GCD 345445746644065669842240 19727989065) 2193705))
(ASSERT (= (GCD 627854758484491743169777558200 750371721805653) 156322329))
(ASSERT (= (GCD 788233263079483492974876830792850 7170146100) 5867550))
(ASSERT (= (GCD 18378856389802641496737518160 6247594493140) 824329660))
(ASSERT (= (GCD 24537811627839727524106800 1) 1))
(ASSERT (= (GCD 9620902642431357480148667659080 59) 59))
(ASSERT (= (GCD 16008524600631853118144316000 629) 1))
(ASSERT (= (GCD 4342138447708715023205684275423920 53041) 1711))
(ASSERT (= (GCD 2431833161592653384508687244500 47541) 47541))
(ASSERT (= (GCD 39424620224103957589082132160 1671734) 1671734))
(ASSERT (= (GCD 652830233576052788654372406432 552231327) 12842589))
(ASSERT (= (GCD 6892963340916411083970414000 3662431431) 77924073))
(ASSERT (= (GCD 29102758215190063506219566460000 10565720) 10565720))
(ASSERT (= (GCD 21253900104556838003127171970777418412 1182797770) 62698))
(ASSERT
 (= (GCD 3964268932242030284914943132662620 21244177854110) 18521515130))
(ASSERT (= (GCD 6070388091189460078138338240 40809131994181213) 274113073169))
(ASSERT (= (GCD 9685989954133695108793384134000 964113514382876) 169529367748))
(ASSERT
 (= (GCD 56468122001858834917195045500 429400787158167902) 2090772606538))
(ASSERT (= (GCD 329308642462818241932463312443600 1) 1))
(ASSERT (= (GCD 18843408973202596901221568364900 47) 47))
(ASSERT (= (GCD 7800980538292163259967028613764250 6) 6))
(ASSERT (= (GCD 270433907726619219545089642715200 3422) 58))
(ASSERT (= (GCD 45771666919597903071546708768 2342359) 2183))
(ASSERT (= (GCD 47198294949461301503537593835384892 314502) 5934))
(ASSERT (= (GCD 3165335901519110207943908102359110 14953473) 207))
(ASSERT (= (GCD 189219585097956261544520863361400 35605794) 35605794))
(ASSERT (= (GCD 38532137569034426600955256933810890813 1341358608707) 6436369))
(ASSERT (= (GCD 1396277868664090735481380981225896 312520860) 62504172))
(ASSERT (= (GCD 864038349500762576564773759109700 714136202724) 16607818668))
(ASSERT (= (GCD 12514185871591242579049167322464 10706997440178) 200614518))
(ASSERT (= (GCD 1981802660405609330969478067056636 33312289752) 14779188))
(ASSERT (= (GCD 979313401024175219420658240 125278417383795) 1551032145))
(ASSERT (= (GCD 1051433196834071287164549263315400 1) 1))
(ASSERT (= (GCD 4074026154111369481048033354344 29) 29))
(ASSERT (= (GCD 599666571180604695702511920885005100 129) 129))
(ASSERT (= (GCD 5703263639326551702474610108800 1978) 1978))
(ASSERT (= (GCD 134137932950214683609064669163440 190619) 143))
(ASSERT (= (GCD 344735091370772631136645455600 1048985) 1048985))
(ASSERT (= (GCD 6759508339299085316106145385400 4969610) 160310))
(ASSERT (= (GCD 700334422308861928135313594400 228529587) 432003))
(ASSERT (= (GCD 10277417891211405957191810814198480 2516552038) 228777458))
(ASSERT (= (GCD 490099971577877358878082782880 9282588354) 17547426))
(ASSERT (= (GCD 1954558750269048828645390249600 5575829490) 327989970))
(ASSERT (= (GCD 1360588454560018295496656378989200 7868178296420) 14873682980))
(ASSERT
 (= (GCD 4337552841738910859248770564912480 17722936528737830) 338114285990))
(ASSERT (= (GCD 215913068853045803981566931862756 7009479781500) 2930844))
(ASSERT
 (= (GCD 44890707654126305940250882318870941900 18329973480720) 1527497790060))
(ASSERT (= (GCD 811032943236714514667976787713600 1) 1))
(ASSERT (= (GCD 28579720891831355496720656680837200 3) 3))
(ASSERT (= (GCD 29332703209780553199747293473184160 1711) 29))
(ASSERT (= (GCD 3648979393315349438003046604440000 186) 186))
(ASSERT (= (GCD 1159760236369472473822068077011807878780 25714) 25714))
(ASSERT (= (GCD 158186359726371025615685433600 31395) 4485))
(ASSERT (= (GCD 331091450443070201468559735703944 28424) 28424))
(ASSERT (= (GCD 9734443639363161342241553023288200 1961348207) 63269297))
(ASSERT (= (GCD 701896612128009033011419603540080 51300) 3420))
(ASSERT (= (GCD 86169288128517384618860929451245320 5032162527446) 180164066))
(ASSERT (= (GCD 64828800524794653881296183831741773624 4645294472) 6354712))
(ASSERT (= (GCD 49068907706533938991402184550000 268183371225) 742890225))
(ASSERT (= (GCD 1708602980304476478496020543612288 4083128544) 131713824))
(ASSERT (= (GCD 17608179287674151740172985536160 980399424528) 91686096))
(ASSERT
 (= (GCD 43194437079731225735521919644800 178119261126453036) 80633436453804))
(ASSERT (= (GCD 25246290024325083695058170420074167420 1) 1))
(ASSERT (= (GCD 817555977437791699707628651571149344 59) 59))
(ASSERT (= (GCD 19062946261334997559157066059536 533) 41))
(ASSERT (= (GCD 6533849124840489114353090499099000 598) 26))
(ASSERT (= (GCD 427663965127849896842400211428345149025 234) 117))
(ASSERT (= (GCD 352395507261316174741530450071590608 154734) 3774))
(ASSERT (= (GCD 391579493632653867660919800000 9221565) 645))
(ASSERT (= (GCD 2618798923882923048581401148931738000 681876) 52452))
(ASSERT (= (GCD 174712575449141140214591110997980800 233260339838) 126154862))
(ASSERT (= (GCD 88598141227372995032227898284800 1929763976) 155288))
(ASSERT
 (= (GCD 210110141308655567793064872567302676320 720390430628) 468699044))
(ASSERT (= (GCD 668425085137718599277317523827419000 19898594339442) 58711254))
(ASSERT
 (= (GCD 89533471731097208414073727453200 4173840860670546) 2257350384354))
(ASSERT
 (= (GCD 113987439157802480362236410675251462620 21548296273949445)
  1134120856523655))
(ASSERT
 (= (GCD 48129335993995093308894209644253760 1009442888504820) 84891337020))
(ASSERT
 (= (GCD 3497836376962291922989777163497680 138736290091634664)
  3383811953454504))
(ASSERT (= (GCD 1969012592912798752707609058217540160 1) 1))
(ASSERT (= (GCD 11371924962562208722154622794880 3) 3))
(ASSERT (= (GCD 9451631862008339290824315653784000 703) 19))
(ASSERT (= (GCD 16869347753325980368094612370435598560 806) 806))
(ASSERT (= (GCD 4701845646467068759127854100132739552 3198) 6))
(ASSERT (= (GCD 1029865193584911347147121232800485280 1005771) 24531))
(ASSERT (= (GCD 10657125216930337802109861408000 2415138) 2838))
(ASSERT (= (GCD 14382707743772734802155022983680 247913634) 144894))
(ASSERT (= (GCD 60134748581470366378101904574533857248 54828228) 493948))
(ASSERT (= (GCD 214830664120540781167218700750596000 505665810) 11759670))
(ASSERT (= (GCD 48933004118344447687599112101802800 6263883444) 106167516))
(ASSERT (= (GCD 5498670161558110606435630054129739400 262699548132) 1346604))
(ASSERT
 (= (GCD 35941673649029587182509620977230062500 25622409466332) 525598668))
(ASSERT
 (= (GCD 1592802602494326390643157055239113248 736377633395508) 960075141324))
(ASSERT
 (= (GCD 4043816553144402557587143272522043028314 5011466158645380)
  366067652202))
(ASSERT
 (= (GCD 7171921165220830707276631005512550 1765284492289500) 176528449228950))
(ASSERT (= (GCD 1083389923993353036483083606295714771264 1) 1))
(ASSERT (= (GCD 2402189359210218692854826119405968750 23) 1))
(ASSERT (= (GCD 26149068753160488131648964110990162400 1147) 31))
(ASSERT (= (GCD 556184059176863945810376239306506311552 4089) 4089))
(ASSERT (= (GCD 67871323087036310486238021899264593800 13395) 13395))
(ASSERT (= (GCD 12750401179065252879838440979200 7177173) 7177173))
(ASSERT (= (GCD 278110245000092733617125071646080 17748) 17748))
(ASSERT (= (GCD 13408203364935178481017292708752000 50619404) 1368092))
(ASSERT (= (GCD 124271828931784534297423756437875067000 8839796595) 4068015))
(ASSERT
 (= (GCD 11893442806922081156953529319100769836176 972789007267) 983608703))
(ASSERT
 (= (GCD 352581052555284857902053030133344488264100 923561430099) 54327142947))
(ASSERT
 (= (GCD 6108908012714804315575319947340956346976 31944833628092) 97096758748))
(ASSERT (= (GCD 67475643422116264959949054821520228800 22515435540) 326310660))
(ASSERT (= (GCD 470601888939348535946408832 5135943991060962937) 36905011))
(ASSERT
 (= (GCD 110759232155568113345545635903016614000 30159198663300)
  30159198663300))
(ASSERT
 (= (GCD 146100914712024458707469587112300146320 26868173101560) 10304280))
(ASSERT
 (= (GCD 12173192708601511002951184416658091200 466645866900785428350)
  1496624001041650))
(ASSERT (= (GCD 9286427982337931754305327867454626688 1) 1))
(ASSERT (= (GCD 5784684831478746253226687170890240 13) 13))
(ASSERT (= (GCD 35042260655085685815432622412891903767500 667) 667))
(ASSERT (= (GCD 2903871349270676921837488659419545120987500 530) 530))
(ASSERT (= (GCD 630123969240840167098426767919876491188000 77691) 25897))
(ASSERT (= (GCD 33192703032132982013024959634241667249800 4684718) 126614))
(ASSERT (= (GCD 4731525733734729472809717145544850000 90706055) 90706055))
(ASSERT (= (GCD 214011009809686092216200126896120006823232 50400042) 258))
(ASSERT (= (GCD 5854250735296111435541950856160000 24357777002) 817622))
(ASSERT
 (= (GCD 35348208247612761916374738259136697649608 156806713508) 8596388))
(ASSERT
 (= (GCD 612558317420289618714916924536521515286100 2377007388) 125105652))
(ASSERT
 (= (GCD 181857299802925368992522029882739454720 21606337755618)
  21606337755618))
(ASSERT
 (= (GCD 4731635341196946327443020710970699860000 58092526675092) 776108892))
(ASSERT
 (= (GCD 22081740554432638182773611616166588288192 61419768950540)
  12283953790108))
(ASSERT (= (GCD 125627844706077784535328068665849312000 30482033400) 32200))
(ASSERT
 (= (GCD 1225504716872819103560254268197955520 510813364186125) 168863922045))
(ASSERT
 (= (GCD 5209185280578468690281136425214396728400 2327880739319250103818)
  829166238))
(ASSERT (= (GCD 73754161795015038015868615941656064 1) 1))
(ASSERT (= (GCD 230425011604643097634961294406535254400 31) 31))
(ASSERT (= (GCD 13222608481676137093434201748083744000 893) 893))
(ASSERT (= (GCD 13348198818240350339028224064019716678960 651) 3))
(ASSERT (= (GCD 7236172685650198160266777676385295337308176 23426) 442))
(ASSERT (= (GCD 756264162229440667711265021676693350760 28899) 28899))
(ASSERT (= (GCD 40915062421030872924283823601517905600 36345062) 36345062))
(ASSERT (= (GCD 1174590526522170015825602834292923520 4991486258) 145114))
(ASSERT
 (= (GCD 2891892862328155581145450075391651333218020 35138529818) 35138529818))
(ASSERT
 (= (GCD 1993335355070485984559797658834121810059400 535644500) 2612900))
(ASSERT
 (= (GCD 6324295450641455215591954662726515160 367472693133) 8962748613))
(ASSERT
 (= (GCD 6576388154814679090356195121505112000 15901952377630) 969690370))
(ASSERT
 (= (GCD 117828556355409428513249595788296238400 565992666495795) 33126555))
(ASSERT
 (= (GCD 592831716700236607285748949860604000 139641978135660) 343100683380))
(ASSERT
 (= (GCD 106766839071170184723986891291602032000 1584924526628112)
  1983635202288))
(ASSERT
 (= (GCD 21677148858122146832326483307664860804937400 247815827510760)
  9178363981880))
(ASSERT
 (= (GCD 14079549844487257384278196623697173813600 160967604100961853832)
  42959600534344))
(ASSERT
 (= (GCD 2696480372014145687016224877963234647656980 2219319031453896088860)
  1258830987778727220))
(ASSERT (= (GCD 307212139856834093867812684883625600 1) 1))
(ASSERT (= (GCD 13545431257849875145060979241270859310160 29) 29))
(ASSERT (= (GCD 137485634482479300158725199474868559498162500 329) 47))
(ASSERT (= (GCD 529252417743761759027305009539254400 3243) 3243))
(ASSERT (= (GCD 133897419738958073238580385894509887148800 330455) 330455))
(ASSERT
 (= (GCD 3896215507210178905244623173635584334007288624 1005238) 1005238))
(ASSERT (= (GCD 17654511984514518592175290794029073043800 1060530) 36570))
(ASSERT (= (GCD 16470780256339082688310222474503880382858400 913836) 913836))
(ASSERT
 (= (GCD 57267105834722825210001789897760395576000 2958974018) 62956894))
(ASSERT
 (= (GCD 521977833444747522001426544601807810543216 1066521690) 4960566))
(ASSERT
 (= (GCD 1699559962174727325529414216960251941390400 25883611479) 30924267))
(ASSERT
 (= (GCD 10654036597801063717295948399628964800 317449894126222) 19212606314))
(ASSERT
 (= (GCD 381902381115592200811990304316262139150724960 4640335440216)
  4640335440216))
(ASSERT
 (= (GCD 425968526187959807410151867411382902838703889232 1882826315615025)
  4430179566153))
(ASSERT
 (= (GCD 174609167728518272531601927200939868792000 1712923655178450) 6189150))
(ASSERT
 (= (GCD 3325168366561555458817274989681612518000 1699726139891780)
  130748164607060))
(ASSERT (= (GCD 11429650426242566426919762928176000 7414967839104) 5416338816))
(ASSERT
 (= (GCD 2104794191230056678355480848036599377844400 16946684823025584)
  182222417451888))
(ASSERT (= (GCD 5188454261655149422618327055938033890000 1) 1))
(ASSERT (= (GCD 11894522530167763519415142641640874994880 7) 7))
(ASSERT (= (GCD 5906329981690378696996009087718418780000 185) 185))
(ASSERT (= (GCD 3056294774178096513474941936265025440000 658) 658))
(ASSERT (= (GCD 10491907660880423349353457742257185280 123369) 123369))
(ASSERT (= (GCD 673239479595593149777212259021965839229225628776 15470) 3094))
(ASSERT (= (GCD 1506608574369860432616005754109397877696 1474070) 294814))
(ASSERT
 (= (GCD 4849814041048623250005708880379694793905000 2172220582) 2172220582))
(ASSERT
 (= (GCD 21154344928580705924176101470087564940000 5023204186) 5023204186))
(ASSERT
 (= (GCD 346448039376394135288065831861806112294000 776147372) 25037012))
(ASSERT
 (= (GCD 2339009760844587560470606952218133142645504 194201967414) 5248701822))
(ASSERT
 (= (GCD 2242982161480922111384667548175169152 21419749763490) 2316901002))
(ASSERT
 (= (GCD 4717315265246821759830981157482117120 45609714193992) 26227552728))
(ASSERT
 (= (GCD 16628111321698075419789804224660024289936 4643626415880804)
  1653124391556))
(ASSERT
 (= (GCD 115557531507210992033160068979962880 88406536976058378)
  36546728803662))
(ASSERT
 (= (GCD 21059511907771200155093927745003762840000 180298981648603620)
  191197223381340))
(ASSERT
 (= (GCD 2124921015128697258800067298086064536000 2282525112298516782924)
  15103625661372))
(ASSERT
 (= (GCD 16015671538624533047089928322348864000 49817926936366875)
  69075001125))
(ASSERT
 (= (GCD 166517667014186289390514558017250969134523800 43413708621878528404068)
  1188862957578074004))
(ASSERT (= (GCD 2321860177398622617128885988647241763878824640 1) 1))
(ASSERT (= (GCD 2780796292789128359666429021610464935722000 47) 47))
(ASSERT (= (GCD 21297913114430245153455383503409684916193317960 58) 58))
(ASSERT (= (GCD 1516745257039775143654568869485529015398000 6293) 6293))
(ASSERT (= (GCD 8447692776411453120390905608381515479808 2030) 14))
(ASSERT (= (GCD 958876033949638283967045624731391031146081240 9834415) 166685))
(ASSERT (= (GCD 4731349833403602529573388098680617532624192 14868) 14868))
(ASSERT
 (= (GCD 6375001358038970462026761077388061675464000 430513678) 430513678))
(ASSERT
 (= (GCD 254088526608579040642428151389718385042344800 4799428101) 255411))
(ASSERT
 (= (GCD 21140490542258031885408065086507444825621023648 164778747198)
  13189686))
(ASSERT (= (GCD 34214837305812460226811046733375808000 4312787868) 746028))
(ASSERT
 (= (GCD 11450197571956515037245443769386989035470896800 75585518430279)
  5814270648483))
(ASSERT
 (= (GCD 1211397915863796187148880114197307052796506376580 538601201880)
  11708721780))
(ASSERT
 (= (GCD 5454139401260819402160859765169199667337088 30452838731872)
  48414687968))
(ASSERT
 (= (GCD 744935981632690384026127091216926530879171660 1032747922358460)
  60868033380))
(ASSERT
 (= (GCD 324574326062026951443376280715122947502400 103751223626207988025)
  3334229637375325))
(ASSERT
 (= (GCD 15272163751269260921486082393684080908800 6484309049057400)
  341279423634600))
(ASSERT
 (= (GCD 386527546655781220813671331401971490218262720 3481571963427119100)
  1915440648660))
(ASSERT
 (= (GCD 3189682029126430413458911948222943640000 6724598925622907976570)
  829921474949490))
(ASSERT (= (GCD 133126055001116059223314464992298215523836640 1) 1))
(ASSERT (= (GCD 709403542855323660533377490060722241678400 7) 7))
(ASSERT (= (GCD 139803787314578422635552652090095842837312147438904 123) 123))
(ASSERT
 (= (GCD 171985399350431759069945935900956183322827030835560 18241) 18241))
(ASSERT (= (GCD 33090522521924986387051477884789600000 26187) 609))
(ASSERT (= (GCD 1733723010009930088165729903139785699319986530 372945) 7935))
(ASSERT (= (GCD 56408303994570817306318494803635460247582000 5761730) 10810))
(ASSERT
 (= (GCD 25845509336769185412951159262424903513866295760 64371378271)
  64371378271))
(ASSERT
 (= (GCD 624970361450506104794172455132584603069611058500 108222780)
  108222780))
(ASSERT
 (= (GCD 82823962548382643645255524843049561752323600 135325929794)
  12302357254))
(ASSERT
 (= (GCD 170620453449723034746079844571491973300000 9460614789626)
  230746702186))
(ASSERT
 (= (GCD 125144597811313015929871740675462711600000 12764411911636)
  12726233212))
(ASSERT
 (= (GCD 257193319319332344553297882967977761077115600 6510126541380)
  158783574180))
(ASSERT
 (= (GCD 879624546681838385457288074812140664728758550 10045784120501316)
  80757786714))
(ASSERT
 (= (GCD 18300938860777100857669855248554588369659200 118088077425391892)
  1433647093268))
(ASSERT
 (= (GCD 8394780474625841647581984803260010511075000 746584618179400)
  11198041400))
(ASSERT
 (= (GCD 146802334713757872619395774222116859916800 718775571956687400)
  854667743111400))
(ASSERT
 (= (GCD 240155883351717999820072393833707008014911556000 1350921510529331832)
  10157304590446104))
(ASSERT
 (= (GCD 918942437243241528855354123800826649596480 74343962238703160850)
  3476056267530))
(ASSERT
 (= (GCD 1361069299753299783990135442290762165844800 8281085446358585640)
  8546011812547560))
