/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import org.apache.tools.ant.BuildException;

public class ExecuteWatchdog
implements Runnable {
    private Process process;
    private int timeout;
    private boolean watch = false;
    private Exception caught = null;
    private boolean killedProcess = false;

    public ExecuteWatchdog(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("timeout lesser than 1.");
        }
        this.timeout = n;
    }

    public synchronized void start(Process process) {
        if (process == null) {
            throw new NullPointerException("process is null.");
        }
        if (this.process != null) {
            throw new IllegalStateException("Already running.");
        }
        this.caught = null;
        this.killedProcess = false;
        this.watch = true;
        this.process = process;
        Thread thread = new Thread((Runnable)this, "WATCHDOG");
        thread.setDaemon(true);
        thread.start();
    }

    public synchronized void stop() {
        this.watch = false;
        this.notifyAll();
    }

    public synchronized void run() {
        try {
            try {
                block9: {
                    long l;
                    long l2 = System.currentTimeMillis() + (long)this.timeout;
                    while (this.watch && l2 > (l = System.currentTimeMillis())) {
                        try {
                            this.wait(l2 - l);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    try {
                        this.process.exitValue();
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        if (!this.watch) break block9;
                        this.killedProcess = true;
                        this.process.destroy();
                    }
                }
                Object var7_6 = null;
                this.cleanUp();
            }
            catch (Exception exception) {
                this.caught = exception;
                Object var7_7 = null;
                this.cleanUp();
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.cleanUp();
            throw throwable;
        }
    }

    protected void cleanUp() {
        this.watch = false;
        this.process = null;
    }

    public void checkException() throws BuildException {
        if (this.caught != null) {
            throw new BuildException("Exception in ExecuteWatchdog.run: " + this.caught.getMessage(), this.caught);
        }
    }

    public boolean isWatching() {
        return this.watch;
    }

    public boolean killedProcess() {
        return this.killedProcess;
    }
}

