/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.dotnet;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.optional.dotnet.NetCommand;

public class Ilasm
extends MatchingTask {
    protected static final String exe_name = "ilasm";
    protected static final String file_ext = "il";
    protected static final String file_pattern = "**/*.il";
    protected static final String exe_title = "ilasm";
    private File _srcDir;
    protected String _targetType;
    protected String _owner;
    protected boolean _verbose;
    protected boolean _listing;
    protected String _outputFile;
    protected File _resourceFile;
    protected boolean _failOnError;
    protected boolean _debug;
    protected String _extraOptions;

    public Ilasm() {
        this.Clear();
        this.setIncludes(file_pattern);
    }

    public void Clear() {
        this._targetType = null;
        this._srcDir = null;
        this._listing = false;
        this._verbose = false;
        this._debug = true;
        this._owner = null;
        this._outputFile = null;
        this._failOnError = true;
        this._resourceFile = null;
        this._owner = null;
        this._extraOptions = null;
    }

    public void setSrcDir(String string) {
        this._srcDir = ((Task)this).project.resolveFile(string);
    }

    public void setTargetType(String string) throws BuildException {
        if (!(string = string.toLowerCase()).equals("exe") && !string.equals("library")) {
            throw new BuildException("targetType " + string + " is not a valid type");
        }
        this._targetType = string;
    }

    public String getTargetType() {
        return this._targetType;
    }

    protected String getTargetTypeParameter() {
        if (!this.notEmpty(this._targetType)) {
            return null;
        }
        if (this._targetType.equals("exe")) {
            return "/exe";
        }
        if (this._targetType.equals("library")) {
            return "/dll";
        }
        return null;
    }

    public void setOwner(String string) {
        this._owner = string;
    }

    protected String getOwnerParameter() {
        if (this.notEmpty(this._owner)) {
            return "/owner=" + this._owner;
        }
        return null;
    }

    protected boolean notEmpty(String string) {
        return string != null && string.length() != 0;
    }

    public void setVerbose(boolean bl) {
        this._verbose = bl;
    }

    protected String getVerboseParameter() {
        return this._verbose ? null : "/quiet";
    }

    public void setListing(boolean bl) {
        this._listing = bl;
    }

    protected String getListingParameter() {
        return this._listing ? "/listing" : "/nolisting";
    }

    public void setOutputFile(String string) {
        this._outputFile = string;
    }

    protected String getOutputFileParameter() {
        if (this._outputFile == null || this._outputFile.length() == 0) {
            return null;
        }
        File file = ((Task)this).project.resolveFile(this._outputFile);
        return "/output=" + file.toString();
    }

    public void setResourceFile(String string) {
        this._resourceFile = ((Task)this).project.resolveFile(string);
    }

    protected String getResourceFileParameter() {
        if (this._resourceFile != null) {
            return "/resource=" + this._resourceFile.toString();
        }
        return null;
    }

    public void setFailOnError(boolean bl) {
        this._failOnError = bl;
    }

    public boolean getFailFailOnError() {
        return this._failOnError;
    }

    public void setDebug(boolean bl) {
        this._debug = bl;
    }

    public boolean getDebug() {
        return this._debug;
    }

    protected String getDebugParameter() {
        return this._debug ? "/debug" : null;
    }

    public void setExtraOptions(String string) {
        this._extraOptions = string;
    }

    public String getExtraOptions() {
        return this._extraOptions;
    }

    protected String getExtraOptionsParameter() {
        if (this._extraOptions != null && this._extraOptions.length() != 0) {
            return this._extraOptions;
        }
        return null;
    }

    public void execute() throws BuildException {
        if (this._srcDir == null) {
            this._srcDir = ((Task)this).project.resolveFile(".");
        }
        DirectoryScanner directoryScanner = super.getDirectoryScanner(this._srcDir);
        String[] stringArray = directoryScanner.getIncludedFiles();
        this.log("assembling " + stringArray.length + " file" + (stringArray.length == 1 ? "" : "s"));
        String string = directoryScanner.getBasedir().toString();
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            string2 = string + File.separator + string2;
            this.executeOneFile(string2);
            ++n;
        }
    }

    public void executeOneFile(String string) throws BuildException {
        NetCommand netCommand = new NetCommand((Task)this, "ilasm", "ilasm");
        netCommand.setFailOnError(this.getFailFailOnError());
        netCommand.setTraceCommandLine(true);
        netCommand.addArgument(this.getDebugParameter());
        netCommand.addArgument(this.getTargetTypeParameter());
        netCommand.addArgument(this.getListingParameter());
        netCommand.addArgument(this.getOutputFileParameter());
        netCommand.addArgument(this.getOwnerParameter());
        netCommand.addArgument(this.getResourceFileParameter());
        netCommand.addArgument(this.getVerboseParameter());
        netCommand.addArgument(this.getExtraOptionsParameter());
        netCommand.addArgument(string);
        netCommand.runCommand();
    }
}

