/* 
   getline.c - Replacement for getline 

   Copyright (C) 2001 Per Jonsson

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
*/

#include <stdio.h>
#include "repl_func.h"

char *xmalloc ();
char *xrealloc ();
char *xstrdup ();

ssize_t
getline_fgetln (char **lineptr, size_t *n, FILE *stream)
{
  char *line;
  size_t len;
  
  line = fgetln(stream, &len);
  if (!line)
    return -1;
  if (len >= *n) {
    char *tmp;
    
    /* XXX some realloc() implementations don`t set errno */
    tmp = realloc(*lineptr, len + 1);
    if (!tmp)
      return -1;
    *lineptr = tmp;
    *n = len + 1;
  }
  memcpy(*lineptr, line, len);
  (*lineptr)[len] = 0;
  return len;
}
