/* 
   sand - helps you keep your diary

   extra.c - some extra bits and pieces

   Copyright (C) 2001 Per Jonsson

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
*/
#include <stdio.h>
#include <sys/types.h>
#include <getopt.h>
#include <string.h>
#include "system.h"
#include "ddecode.h"
#include "output.h"
#include "cli.h"
#include "sand.h"




/* Handles printing of messages in verbose mode */
void
message_ver (char *msg, int flags)
{
  if (want_verbose == 1 & flags == 1)
    printf("%s", msg);
  else if ( flags != 1)
    printf("%s", msg);
    
  return;
}

/* and errors */
void
message_err(char *msg)
{
  fprintf(stderr, msg);
}


/* Get the home directory of the current user */
char *
get_home_dir()
{
  if (program_home == NULL)
    {
      program_home = getenv ("HOME"); /* Check for the HOME environment
					 variable */
  
      if (program_home == NULL)
	{
	  message_err("HOME is not set\n");
	  exit(EXIT_FAILURE);
	}
    }
  
  return program_home;
}

void
get_create_rc_dir()
{
  int size;
  int homelen;
  int r;

  char * rc_dir = (char *)NULL;
  char * home_dir = (char *)NULL;

  /* get the directory */
  home_dir = xstrdup(get_home_dir());
  homelen = strlen(home_dir);

  /* Calculate the size needed */
  size = homelen + strlen(RC_DIR) + 2;
  
  rc_dir = xrealloc(home_dir, size);
  home_dir = (char *)NULL;

  if ((char)rc_dir[homelen] != '/')
    {
      rc_dir[homelen] = '/';
      rc_dir[homelen+1] = '\000';
    }

  strncat((rc_dir + homelen), RC_DIR, strlen(RC_DIR)+1);
  
  r = mkdir (rc_dir, S_IRWXU);
  if ( r == -1)
    {
      if (errno == EACCES){
	perror(program_name);
	exit(EXIT_FAILURE_NO_RC); }
      if (errno == EEXIST)
	message_ver("configuration directory already exists\n", 1);
    }

  program_rc_dir =  rc_dir;
}
